% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychReportData.R
\name{summaryMSDSE}
\alias{summaryMSDSE}
\title{summaryMSDSE}
\usage{
summaryMSDSE(data, factors, dvs, withinCorrection = NULL)
}
\arguments{
\item{data}{A dataframe}

\item{factors}{List of factors over which to aggregate}

\item{dvs}{List of numeric data columns to aggregate}

\item{withinCorrection}{List of dvs which to apply within-subjects correction
to the calculation of the standard deviation and standard error. Within-subject correction
calculated according to Morey (2008). NB Data should be normed first (see normData).}
}
\value{
dataframe
}
\description{
Aggregate data returning the mean, standard deviation, and standard error
}
\examples{
# Example 1:
library(dplyr)
dat <- createDF(nVP = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
  RT = list(
    "Comp comp" = c(500, 80, 100),
    "Comp incomp" = c(550, 80, 140)
  ),
  Error = list(
    "Comp comp" = 5,
    "Comp incomp" = 10
  )
)
datAggVP <- dat \%>\%
  group_by(VP, Comp) \%>\%
  summarize(
    N  = n(),
    RT = mean(RT[Error == 0]),
    ER = (sum(Error) / N) * 100
  )
datAgg <- summaryMSDSE(datAggVP, "Comp", c("RT", "ER"))

# Example 2:
dat <- createDF(nVP = 50, nTrl = 50, design = list("Comp" = c("comp", "incomp")))
dat <- addDataDF(dat,
  RT = list(
    "Comp comp" = c(500, 80, 100),
    "Comp incomp" = c(550, 80, 140)
  ),
  Error = list(
    "Comp comp" = 5,
    "Comp incomp" = 10
  )
)
datAggVP <- dat \%>\%
  group_by(VP, Comp) \%>\%
  summarize(
    N = n(),
    RT = mean(RT[Error == 0]),
    ER = (sum(Error) / N) * 100
  )
datAggVP <- normData(datAggVP, "VP", c("RT", "ER"))
datAgg <- summaryMSDSE(
  datAggVP, "Comp", c("RT", "ER", "RT_norm", "ER_norm"),
  c("RT_norm", "ER_norm")
)
}
