% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_r_matrix}
\alias{composite_r_matrix}
\title{Matrix formula to estimate the correlation between two weighted or unweighted composite variables}
\usage{
composite_r_matrix(r_mat, x_col, y_col, wt_vec_x = rep(1, length(x_col)),
  wt_vec_y = rep(1, length(y_col)))
}
\arguments{
\item{r_mat}{Correlation matrix from which composite correlations are to be computed.}

\item{x_col}{Column indices of variables from 'r_mat' in the X composite (specify a single variable if Y is an observed variable rather than a composite).}

\item{y_col}{Column indices of variables from 'r_mat' in the Y composite (specify a single variable if Y is an observed variable rather than a composite).}

\item{wt_vec_x}{Weights to be used in forming the X composite (by default, all variables receive equal weight).}

\item{wt_vec_y}{Weights to be used in forming the Y composite (by default, all variables receive equal weight).}
}
\value{
A composite correlation
}
\description{
This function computes the weighted (or unweighted, by default) composite correlation between a set of X variables and a set of Y variables.
}
\details{
This is computed as:

\deqn{\rho_{XY}\frac{\mathbf{w}_{X}^{T}\mathbf{R}_{XY}\mathbf{w}_{Y}}{\sqrt{\left(\mathbf{w}_{X}^{T}\mathbf{R}_{XX}\mathbf{w}_{X}\right)\left(\mathbf{w}_{Y}^{T}\mathbf{R}_{YY}\mathbf{w}_{Y}\right)}}}{r_composite = (t(wt_x)  Rxy  wt_y) / (sqrt(t(wt_x)  Rxx  wt_x) * sqrt(t(wt_y) Ryy wt_y))}

where \eqn{\rho_{XY}}{r_composite} is the composite correlation, \eqn{\mathbf{w}}{wt} is a vector of weights, and \eqn{\mathbf{R}}{R} is a correlation matrix. The subscripts of \eqn{\mathbf{w}}{wt} and \eqn{\mathbf{R}}{R} indicate the variables indexed within the vector or matrix.
}
\examples{
composite_r_scalar(mean_rxy = .3, k_vars_x = 4, mean_intercor_x = .4)
R <- reshape_vec2mat(.4, order = 5)
R[-1,1] <- R[1,-1] <- .3
composite_r_matrix(r_mat = R, x_col = 2:5, y_col = 1)
}
\references{
Mulaik, S. A. (2010). \emph{Foundations of factor analysis}.
Boca Raton, FL: CRC Press. pp. 83–84.
}
