% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_r_scalar}
\alias{composite_r_scalar}
\title{Scalar formula to estimate the correlation between a composite and another variable or between two composite variables}
\usage{
composite_r_scalar(
  mean_rxy,
  k_vars_x = NULL,
  mean_intercor_x = NULL,
  k_vars_y = NULL,
  mean_intercor_y = NULL
)
}
\arguments{
\item{mean_rxy}{Mean correlation between sets of X and Y variables.}

\item{k_vars_x}{Number of X variables.}

\item{mean_intercor_x}{Mean correlation among X variables.}

\item{k_vars_y}{Number of Y variables.}

\item{mean_intercor_y}{Mean correlation among Y variables.}
}
\value{
A vector of composite correlations
}
\description{
This function estimates the correlation between a set of X variables and a set of Y variables using a scalar formula.
}
\details{
The formula to estimate a correlation between one composite variable and one external variable is:

\deqn{\rho_{Xy}=\frac{\bar{\rho}_{x_{i}y}}{\sqrt{\frac{1}{k_{x}}+\frac{k_{x}-1}{k_{x}}\bar{\rho}_{x_{i}x_{j}}}}}{r_composite = mean_rxy / sqrt(((1 / k_vars_x) + ((k_vars_x - 1) / k_vars_x) * mean_intercor_x))}

and the formula to estimate the correlation between two composite variables is:

\deqn{\rho_{XY}=\frac{\bar{\rho}_{x_{i}y_{j}}}{\sqrt{\frac{1}{k_{x}}+\frac{k-1}{k_{x}}\bar{\rho}_{x_{i}x_{j}}}\sqrt{\frac{1}{k_{y}}+\frac{k_{y}-1}{k_{y}}\bar{\rho}_{y_{i}y_{j}}}}}{r_composite = mean_rxy / sqrt(((1 / k_vars_x) + ((k_vars_x - 1) / k_vars_x) * mean_intercor_x) * ((1 / k_vars_y) + ((k_vars_y - 1) / k_vars_y) * mean_intercor_y))}

where \eqn{\bar{\rho}_{x_{i}y}}{mean_r} and \eqn{\bar{\rho}_{x_{i}y{j}}}{mean_r} are mean correlations between the x variables and the y variable(s),
\eqn{\bar{\rho}_{x_{i}x_{j}}}{mean_intercor_x} is the mean correlation among x variables,
\eqn{\bar{\rho}_{y_{i}y_{j}}}{mean_intercor_y} is the mean correlation among y variables,
\eqn{{k}_{x}}{k_vars_x} is the number of x variables, and \eqn{{k}_{y}}{k_vars_y} is the number of y variables.
}
\examples{
## Composite correlation between 4 variables and an outside variable with which
## the four variables correlate .3 on average:
composite_r_scalar(mean_rxy = .3, k_vars_x = 4, mean_intercor_x = .4)

## Correlation between two composites:
composite_r_scalar(mean_rxy = .3, k_vars_x = 2, mean_intercor_x = .5,
                   k_vars_y = 2, mean_intercor_y = .2)
}
\references{
Ghiselli, E. E., Campbell, J. P., & Zedeck, S. (1981).
\emph{Measurement theory for the behavioral sciences}.
San Francisco, CA: Freeman. p. 163-164.

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \url{https://doi.org/10/b6mg}. pp. 441 - 447.
}
