% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.htest.R
\name{analyze.htest}
\alias{analyze.htest}
\title{Analyze htest (correlation, t-test...) objects.}
\usage{
\method{analyze}{htest}(x, effsize_rules = "cohen1988", ...)
}
\arguments{
\item{x}{htest object.}

\item{effsize_rules}{Grid for effect size interpretation. See \link[=interpret_r]{interpret_r}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze htest (correlation, t-test...) objects.
}
\examples{
library(psycho)

df <- psycho::affective
x <- t.test(df$Tolerating, df$Adjusting)
x <- t.test(df$Tolerating ~ df$Sex)
x <- cor.test(df$Tolerating, df$Adjusting)

results <- analyze(x)
summary(results)
print(results)

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
