% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{waic_diff}
\alias{waic_diff}
\title{Compute difference (WAIC1 - WAIC2) in WAIC and its SE for two models.}
\usage{
waic_diff(l_pred1, l_pred2)
}
\arguments{
\item{l_pred1}{A m1 x D matrix of predictive likelihoods (NOT log-likelihoods) from model 1.}

\item{l_pred2}{A m2 x D matrix of predictive likelihoods (NOT log-likelihoods) from model 2.}
}
\value{
A vector of (1) the difference in WAIC (on the deviance scale)
between models and (2) the standard error of the difference in WAIC.
}
\description{
Compute difference (WAIC1 - WAIC2) in WAIC and its SE for two models.
}
\examples{
data(teacher_rate)
fit_mlr <- gibbs_mlr(rating ~ grade, data = teacher_rate, m = 100)
fit_mlr2 <- gibbs_mlr(rating ~ grade + I(grade^2), data = teacher_rate, m = 100)
# Returns (1) D = WAIC(fit_mlr2) - WAIC(fit_mlr) and (2) SE(D)
#   Suggests that a linear relationship is preferable
waic_diff(t(lpd(fit_mlr2)), t(lpd(fit_mlr)))
}
