% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_from_spreadsheet.R
\name{dct_from_spreadsheet}
\alias{dct_from_spreadsheet}
\title{Import a DCT specification from a spreadsheet}
\usage{
dct_from_spreadsheet(
  x,
  path = NULL,
  sheet = NULL,
  localBackup = NULL,
  exportGoogleSheet = TRUE,
  xlsxPkg = c("rw_xl", "openxlsx", "XLConnect"),
  preventOverwriting = psyverse::opts$get("preventOverwriting"),
  encoding = psyverse::opts$get("encoding"),
  silent = psyverse::opts$get("silent")
)
}
\arguments{
\item{x}{The URL or path to a file.}

\item{path}{The path to save the DCT specifications.}

\item{sheet}{Optionally, the name(s) of the worksheet(s) to select.}

\item{localBackup}{If not \code{NULL}, a valid filename to write a local
backup to.}

\item{exportGoogleSheet}{If \code{x} is a URL to a Google Sheet, instead of using
the \code{googlesheets4} package to download the data, by passing
\code{exportGoogleSheet=TRUE}, an export link will be produced and the data
will be downloaded as Excel spreadsheet.}

\item{xlsxPkg}{Which package to use to work with Excel spreadsheets.}

\item{preventOverwriting}{Whether to prevent overwriting.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
Invisibly, an object with the worksheets and the DCT objects.
}
\description{
This function reads a spreadsheet (from a Google sheet URL or a local file
in \code{.xlsx}, \code{.csv}, or \code{.sav} format) and imports the DCT specifications
in it.
}
