# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

negative_check <- function(dat) {
    invisible(.Call('_ptsuite_negative_check', PACKAGE = 'ptsuite', dat))
}

#' Estimating the Shape Parameter by Method of Maximum Likelihood (MLE)
#'
#' This function can be used to estimate the \code{shape} parameter using the 
#' Maximum Likelihood Estimator method (Newman 2005). It can be used to 
#' obtain biased and unbiased estimates of the shape and scale parameters as 
#' well as the confidence interval for the shape parameter for the biased estimates.
#'
#' @param dat vector of observations
#' @param biased TRUE/FALSE to indicate biased or unbiased estimates
#' @param significance level of significance
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{lower_bound}{Upper error bound of the estimate of shape}
#'   \item{upper_bound}{Lower error bound of the estimate of shape}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Newman MEJ (2005). "Power Laws, Pareto Distributions And Zipf's Law." 
#' Contemporary Physics, 46, 323-351.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_mle(x, TRUE, 0.05)
#'
#' x <- generate_pareto(10000, 5, 2)
#' alpha_mle(x, FALSE)
#' 
#' @export
alpha_mle <- function(dat, biased = TRUE, significance = NULL) {
    .Call('_ptsuite_alpha_mle', PACKAGE = 'ptsuite', dat, biased, significance)
}

#' Estimating the Shape Parameter by Weighted Least Squares Method (WLS)
#'
#' This function uses the Weighted Least Squares Method (WLS) to estimate the
#' \code{shape} parameter of a given set of data. (Nair et al. 2019)
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
#' Properties, Emergence, And Identification." 
#' http://users.cms.caltech.edu/ adamw/heavytails.html.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_percentile(x)
#' 
#' @export
alpha_wls <- function(dat) {
    .Call('_ptsuite_alpha_wls', PACKAGE = 'ptsuite', dat)
}

#' Estimating the Shape Parameter by Hill's Estimator
#'
#' This function uses the Hill's Estimator to estimate the shape parameter
#' of a given set of data. (Nair et al. 2019; Pokorna 2016; Hill 1975)
#' It is especially useful when the data is known not to follow an exact 
#' Pareto distribution but the tail of the data does. Thus, the specification 
#' of \code{k}, the \code{k}th largest observation, allows to specify the 
#' point from where Pareto-like behavior may be seen. It is also possible to 
#' specify the value at which the tail begins.
#' When \code{k=n}, the Hill's Estimator returns the same estimate as 
#' \code{alpha_mle} with a warning notifying the user.
#' 
#'
#' @param dat vector of observations
#' @param k number of observations / value equal to or greater than to
#' consider for tail
#' @param value (TRUE/FALSE) indicating if the value which is specified
#' in "k" (TRUE)
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
#' Properties, Emergence, And Identification."
#' http://users.cms.caltech.edu/ adamw/heavytails.html.
#' 
#' Pokorna M (2016). Estimation and Application of the Tail Index. 
#' Bachelor's thesis, Charles University in Prague, Faculty of Social 
#' Sciences, Institute of Economic Studies.
#' 
#' Hill B (1975). "A Simple General Approach To Inference About The Tail 
#' Of A Distribution."The Annals of Statistics, 3(5), 1163-1174.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_hills(x, 400)
#' 
#' @export
alpha_hills <- function(dat, k, value = FALSE) {
    .Call('_ptsuite_alpha_hills', PACKAGE = 'ptsuite', dat, k, value)
}

#' Estimating the Shape Parameter by Method of Moments
#'
#' This function uses the Method of Moments to estimate the shape parameter
#' of a given set of data. (Rytgaard 1990) The method of moments is only 
#' accurate if \eqn{\alpha} (\code{shape parameter}) is greater than or equal 
#' to 1 (Brazauskas and Serfling 2000). This function issues a warning if it 
#' detects that \eqn{\alpha} may be less than 1.
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Rytgaard M (1990). "Estimation In The Pareto Distribution." ASTIN
#'  Bulletin: The Journal Of The IAA, 20(2), 201-216.
#'  
#'  Brazauskas V, Serfling R (2000). "Robust and Efficient Estimation Of 
#'  The Tail Index Of A Single-Parameter Pareto Distribution." North 
#'  American Actuarial Journal, 4, 12-27.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_moment(x)
#' @export
alpha_moment <- function(dat) {
    .Call('_ptsuite_alpha_moment', PACKAGE = 'ptsuite', dat)
}

get_Percentiles <- function(x, p) {
    .Call('_ptsuite_get_Percentiles', PACKAGE = 'ptsuite', x, p)
}

#' Estimating the Shape Parameter by Method of Percentiles
#'
#' This function uses the Method of Percentiles to estimate the \code{shape}
#' parameter of a given set of data. (Bhatti et al. 2018)
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Bhatti SH, Hussain S, Ahmad T, Aslam M, Aftab M, Raza MA (2018). "Efficient
#' estimation of Pareto model: Some modified percentile estimators." 
#' PLoS ONE, 13(5), 1-15.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_percentile(x)
#' @export
alpha_percentile <- function(dat) {
    .Call('_ptsuite_alpha_percentile', PACKAGE = 'ptsuite', dat)
}

#' Estimating the Shape Parameter by Method of Modified Percentiles
#'
#' This function uses the Method of Modified Percentiles to estimate the 
#' \code{shape} parameter of a given set of data. (Bhatti et al. 2018)
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Bhatti SH, Hussain S, Ahmad T, Aslam M, Aftab M, Raza MA (2018). "Efficient
#' estimation of Pareto model: Some modified percentile estimators." 
#' PLoS ONE, 13(5), 1-15.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_modified_percentile(x)
#' @export
alpha_modified_percentile <- function(dat) {
    .Call('_ptsuite_alpha_modified_percentile', PACKAGE = 'ptsuite', dat)
}

GeoMean <- function(x) {
    .Call('_ptsuite_GeoMean', PACKAGE = 'ptsuite', x)
}

#' Estimating the Shape Parameter by Geometric Method of Percentiles
#'
#' This function uses the Geometric Method of Percentiles to estimate the
#' \code{shape} parameter of a given set of data. (Bhatti et al. 2018)
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Bhatti SH, Hussain S, Ahmad T, Aslam M, Aftab M, Raza MA (2018). "Efficient
#' estimation of Pareto model: Some modified percentile estimators." 
#' PLoS ONE, 13(5), 1-15.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_geometric_percentile(x)
#' 
#' @export
alpha_geometric_percentile <- function(dat) {
    .Call('_ptsuite_alpha_geometric_percentile', PACKAGE = 'ptsuite', dat)
}

#' Estimating the Shape Parameter by Method of Least Squares
#'
#' This function uses the Method of Least Squares to estimate the \code{shape}
#' parameter of a given set of data. (Zaher et al. 2014; Nair et al. 2019)
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{shape}{Estimate of the shape parameter of the data}
#'   \item{scale}{Estimate of the scale parameter of the data (which is taken
#'   to be the minimum of the data)}
#' }
#' 
#' @references
#' Zaher HM, El-Sheik AA, El-Magd NATA (2014). "Estimation of Pareto 
#' Parameters Using a Fuzzy Least-Squares Method and Other Known Techniques 
#' with a Comparison." British Journal of Mathematics & Computer Science, 
#' 4(14), 2067-2088.
#' 
#' Nair J, Wierman A, Zwart B (2019). "The Fundamentals Of Heavy Tails: 
#' Properties, Emergence, And Identification."
#' http://users.cms.caltech.edu/ adamw/heavytails.html.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' alpha_ls(x)
#' 
#' @export
alpha_ls <- function(dat) {
    .Call('_ptsuite_alpha_ls', PACKAGE = 'ptsuite', dat)
}

#' Goodness of Fit Test for Pareto Distribution
#'
#' The pareto_test function can be used to identify whether the data is 
#' Pareto distributed (Gulati and Shapiro 2008). The test generates a p-value 
#' corresponding to the actual distribution of the data and is tested for 
#' significance. In the case of Pareto data, the p-value should be greater 
#' than the pre-determined significance level (generally taken as 0.05). 
#'
#' @param dat vector of observations
#'
#' @return A list of the following form:
#' \describe{
#'   \item{p-value}{p-value indicating significance of the test}
#' }
#' 
#' @references
#' Gulati S, Shapiro S (2008). "Goodness-of-Fit Tests for Pareto 
#' Distribution." In F Vonta (ed.), Statistical Models and Methods for 
#' Biomedical and Technical Systems, chapter 19, pp. 259-274. Birkhauser 
#' Basel. ISBN 978-0-8176-4619-6. doi:10.1007/978-0-8176-4619-6.
#' 
#' @examples
#' x <- generate_pareto(10000, 5, 2)
#' pareto_test(x)
#' @export
pareto_test <- function(dat) {
    .Call('_ptsuite_pareto_test', PACKAGE = 'ptsuite', dat)
}

