% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{run_information}
\alias{run_information}
\title{Information for a given run}
\usage{
run_information(
  run_ref,
  route_type = NULL,
  include_geopath = FALSE,
  geopath_utc = NULL,
  date_utc = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{run_ref}{A character run reference. This supersedes the integer
\code{run_id}. For backwards compatibility and since most run references are
integers, this function will attempt to convert an the argument to a
character. Run references may be retrieved from the
\code{\link{departures}} or \code{\link{runs_on_route}} functions.}

\item{route_type}{Optionally filter results by a route type. A route type can
be provided either as a non-negative integer code, or as a character:
"Tram", "Train", "Bus", "Vline" or "Night Bus". Character inputs are not
case-sensitive. Use the \code{\link{route_types}} function to extract a
vector of all route types.}

\item{include_geopath}{Logical. Whether to populate the \code{geopath} column.
Defaults to FALSE.}

\item{geopath_utc}{Date, or character that can be converted to a date. The
UTC date for which the geopaths are effective. Defaults to the current
date. Has no effect if \code{include_geopath = FALSE}. It's uncertain how much
historical or future-dated data is available.}

\item{date_utc}{Date, or character that can be converted to a date. The
UTC date for which the results are effective. Defaults to the current date.
It's uncertain how much historical or future-dated data is available. This
argument is experimental and seems to not be functioning.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item \code{run_id} (deprecated, use \code{run_ref} instead)
\item \code{run_ref}
\item \code{route_id}
\item \code{route_type}
\item \code{route_type_description}
\item \code{direction_id}
\item \code{run_sequence}
\item \code{final_stop_id}
\item \code{destination_name}
\item \code{status}
\item \code{express_stop_count}
\item \code{vehicle_position}
\item \code{vehicle_descriptor}
\item \code{geopath}
}
}
\description{
Run IDs are not unique across the network. If you are interested in a
specific run, consider supplying a value to the optional \code{route_type}
argument.
}
\examples{
\dontrun{
run_information("100")
run_information("100", include_geopath = TRUE)
run_information("100", include_geopath = TRUE, geopath_utc = "2020-07-01")
run_information("100", date_utc = "2020-07-01")
}

}
