% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{gen_bst_df}
\alias{gen_bst_df}
\title{Generate a data frame with estimate and bootstrap CIs.}
\usage{
gen_bst_df(formula, data, stat = "mean", ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{stat}{Statistic used for \link{bst}.}

\item{...}{Passes optional arguments to \link{bst}.}
}
\value{
A data frame with the confidence intervals by level.
}
\description{
\code{gen_bst_df} is an internal function called by \link{bar_error} that generates a data frame with
confidence intervals of a continuous variable by levels of one or two categorical ones (factors).
}
\examples{
data(kfm, package = "ISwR")
gen_bst_df(dl.milk ~ sex, data = kfm)
bar_error(dl.milk ~ sex, data = kfm, ylim = c(0,9), ylab  = "Breast-milk intake (dl/day)")

data(birthwt, package = "MASS")
birthwt$smoke <- factor(birthwt$smoke, labels=c("Non-smoker", "Smoker"))
birthwt$Race <- 0
birthwt$Race[birthwt$race>1] <- 1
birthwt$Race <- factor(birthwt$Race, labels=c("White", "Non-white"))
gen_bst_df(bwt ~ smoke|Race, data = birthwt)
bar_error(bwt ~ smoke|Race, data = birthwt, ylim = c(0, 3800), ylab  = "Birth weight (g)")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
