% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{cross_tab}
\alias{cross_tab}
\title{Cross-tabulation.}
\usage{
cross_tab(object = NULL, formula = NULL, data = NULL, label = NULL, ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{y ~ x}, where \code{y} is a categorical outcome and \code{x} is the explanatory variable or a set of explanatory variables (see Details and Examples).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{label}{A character, label used to name the first column of the data frame.}

\item{...}{Additional arguments passed to \code{\link[finalfit]{summary_factorlist}}.}
}
\value{
A data frame with descriptive statistics stratified by levels of the outcome.
}
\description{
\code{cross_tab} is a wrapper to functions from package \code{finalfit} to construct tables of descriptive statistics stratified by levels of a categorical outcome.
}
\details{
Function \code{cross_tab} is a relatively simple wrapper to functions of package \code{finalfit}. Its main purpose is to construct contingency tables but it can also be used to report a table with descriptives for all variables as long as they are still stratified by the outcome. Please see examples to see how to list explanatory variables. For categorical explanatory variables, the function reports column percentages by default; row proportions can be obtained with additional argument: \code{column = FALSE}. If data is labelled with \code{sjlabelled}, the label of the outcome (dependent) variable is used to name the first column of the resulting data frame; this name can be changed with argument \code{label}.

Relevant default arguments passed to \code{\link[finalfit]{summary_factorlist}} include: \code{cont = "mean"} (other option: \code{cont = "median"}); \code{column = TRUE}; \code{na_include = FALSE} and \code{p = FALSE}.
}
\examples{
data(Oncho)

## A two by two contingency table:
Oncho \%>\%
  cross_tab(mf ~ area)

## Reporting row proportions (risks) instead of column proportions:
Oncho \%>\%
  cross_tab(mf ~ area, column = FALSE)

## Removing the name of the first column:
Oncho \%>\%
  cross_tab(mf ~ area, label = "")

## Contingency table for both sex and area of residence:
Oncho \%>\%
  cross_tab(mf ~ sex + area, p = TRUE)

## Descriptive statistics for all variables in the \code{Oncho} data set except \code{id}.
require(dplyr)
Oncho \%>\%
  select(- id) \%>\%
  cross_tab(mf ~ ., label = "Parameter")
}
\seealso{
\code{\link[finalfit]{summary_factorlist}}, \code{\link[moonBook]{mytable}}.
}
