% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.cor.test}
\alias{style.apa.cor.test}
\title{Formats a Correlation Between Paired Samples}
\usage{
style.apa.cor.test(x, print.statistic = FALSE)
}
\arguments{
\item{x}{a list. First item must be a correlation test (htest class) from
\code{\link[stats]{cor.test}}. All other list items will be ignored.}

\item{print.statistic}{a logical, indicating whether test statistic is
printed as well. Corresponding p value is always printed.}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes a correlation test (htest class) from
\code{\link[stats]{cor.test}} and transforms it into a formatted character
vector, including p value.  Statistics are printed optionally (not by
default).
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
a <- rnorm(100)
b <- rnorm(100) * .75 + a * .25

pprint(cor.test(a, b), format = "cor.test")
pprint(cor.test(a, b, method = "kendall"), format = "cor.test")
pprint(cor.test(a, b, method = "spearman"), format = "cor.test")
pprint(cor.test(a, b), 
       format = "cor.test", 
       print.statistic = TRUE)
pprint(cor.test(a, b, method = "kendall"), 
       format = "cor.test", 
       print.statistic = TRUE)
pprint(cor.test(a, b, method = "spearman"), 
       format = "cor.test", 
       print.statistic = TRUE)
}
\seealso{
\code{\link[stats]{cor.test}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

