% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/purge.R
\name{purge}
\alias{purge}
\alias{purge.default}
\alias{purge.glm}
\alias{purge.glmerMod}
\alias{purge.lm}
\alias{purge.merMod}
\alias{purge.randomForest}
\alias{purge.rpart}
\title{Purge training data from a model}
\usage{
purge(model)

\method{purge}{default}(model)

\method{purge}{glm}(model)

\method{purge}{lm}(model)

\method{purge}{merMod}(model)

\method{purge}{glmerMod}(model)

\method{purge}{rpart}(model)

\method{purge}{randomForest}(model)
}
\arguments{
\item{model}{A fitted R model object}
}
\value{
A fitted R model object, purged of its training data,
        but retaining its predict functionality on new data
}
\description{
Most R model implementations store the training data
within the fitted object, often many times. It can be useful
to remove the embedded data for portability, especially
if the only required functionality is to predict on new data.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default purge returns a copy of the model

\item \code{glm}: Purges a glm model

\item \code{lm}: Purges an lm model

\item \code{merMod}: Purges a merMod, linear mixed-effects model

\item \code{glmerMod}: Purges a glmerMod, generalized linear mixed-effects model

\item \code{rpart}: Purges an rpart model

\item \code{randomForest}: Purges a random forest model
}}
\examples{
x <- rnorm(1000)
y <- x + rnorm(1000)
unpurged.model <- lm(y ~ x)
purged.model <- purge(unpurged.model)
object.size(unpurged.model)
object.size(purged.model)
}

