#' Darwin/Wedgwood pedigree
#'
#' This data set contains the pedigree of the Darwin/Wedgwood dynasty.
#' It is composed by a total of 63 individuals,
#' including Charles R. Darwin and Francis Galton.
#'
#' @format A data frame with with records from 63 individuals (in rows), and 3 variables:
#' \itemize{
#'   \item{\emph{Individual} - } Individual identity.
#'   \item{\emph{Mother} - } Mother's identity.
#'   \item{\emph{Father} - } Father's identity.
#' }
#' @source The pedigree is adapted from Berra et al. (2010)
#' @references
#' \itemize{
#'   \item{Berra TM et al. 2010. Was the Darwin/Wedgwood dynasty adversely affected by consanguinity?. BioScience 60(5): 376-383.}
#' }
"darwin"

#' Cuvier's gazelle pedigree
#'
#' This data set contains the pedigree of Cuvier's gazelle (\emph{Gazella atlas}).
#' A total of 948 individuals is included, as well as measurements of biological fitness
#' and other factors (see reference below for details).
#'
#' @format A data frame with with records from 948 individuals (in rows), and 10 variables:
#' \itemize{
#'   \item{\emph{id} - } Individual identity.
#'   \item{\emph{dam} - } Maternal identity.
#'   \item{\emph{sire} - } Paternal identity.
#'   \item{\emph{survival15} - } 15-days survival.
#'   \item{\emph{prod} - } Female productivity.
#'   \item{\emph{sex} - } Individual sex.
#'   \item{\emph{yob} - } Year of birth.
#'   \item{\emph{pom} - } Period of management.
#'   \item{\emph{target} - } Individual in the target population.
#'   \item{\emph{eeza_id} - } Individual identity (as recorded in the original studbook)
#' }
#' @source The original studbook containing the complete and updated pedigree can be found at: \url{http://www.eeza.csic.es/en/programadecria.aspx}.
#' @references
#' \itemize{
#'   \item{López-Cortegano E et al. 2021. Genetic purging in captive endangered ungulates with extremely low effective population sizes. *Pending revision*.}
#' }
"atlas"

#' Arrui pedigree
#'
#' This data set contains the pedigree of the arrui (\emph{Ammotragus lervia}),
#' also known as barbary sheep.
#' A total of 380 individuals is included, as well as measurements of biological fitness
#' and other factors (see reference below for details).
#'
#' @format A data frame with with records from 380 individuals (in rows), and 10 variables:
#' \itemize{
#'   \item{\emph{id} - } Individual identity.
#'   \item{\emph{dam} - } Maternal identity.
#'   \item{\emph{sire} - } Paternal identity.
#'   \item{\emph{survival15} - } 15-days survival.
#'   \item{\emph{prod} - } Female productivity.
#'   \item{\emph{sex} - } Individual sex.
#'   \item{\emph{yob} - } Year of birth.
#'   \item{\emph{pom} - } Period of management.
#'   \item{\emph{target} - } Individual in the target population.
#'   \item{\emph{eeza_id} - } Individual identity (as recorded in the original studbook)
#' }
#' @source The original studbook containing the complete and updated pedigree can be found at: \url{http://www.eeza.csic.es/en/programadecria.aspx}.
#' @references
#' \itemize{
#'   \item{López-Cortegano E et al. 2021. Genetic purging in captive endangered ungulates with extremely low effective population sizes. *Pending revision*.}
#' }
"arrui"

#' Dama gazelle pedigree
#'
#' This data set contains the pedigree of the dama gazelle (\emph{Nanger dama}).
#' A total of 1316 individuals is included, as well as measurements of biological fitness
#' and other factors (see reference below for details).
#'
#' @format A data frame with with records from 1316 individuals (in rows), and 10 variables:
#' \itemize{
#'   \item{\emph{id} - } Individual identity.
#'   \item{\emph{dam} - } Maternal identity.
#'   \item{\emph{sire} - } Paternal identity.
#'   \item{\emph{survival15} - } 15-days survival.
#'   \item{\emph{prod} - } Female productivity.
#'   \item{\emph{sex} - } Individual sex.
#'   \item{\emph{yob} - } Year of birth.
#'   \item{\emph{pom} - } Period of management.
#'   \item{\emph{target} - } Individual in the target population.
#'   \item{\emph{eeza_id} - } Individual identity (as recorded in the original studbook)
#' }
#' @source The original studbook containing the complete and updated pedigree can be found at: \url{http://www.eeza.csic.es/en/programadecria.aspx}.
#' @references
#' \itemize{
#'   \item{López-Cortegano E et al. 2021. Genetic purging in captive endangered ungulates with extremely low effective population sizes. *Pending revision*.}
#' }
"dama"

#' Dorcas gazelle pedigree
#'
#' This data set contains the pedigree of dorcas gazelle (\emph{Gazella dorcas}).
#' A total of 1279 individuals is included, as well as measurements of biological fitness
#' and other factors (see reference below for details).
#'
#' @format A data frame with with records from 1279 individuals (in rows), and 10 variables:
#' \itemize{
#'   \item{\emph{id} - } Individual identity.
#'   \item{\emph{dam} - } Maternal identity.
#'   \item{\emph{sire} - } Paternal identity.
#'   \item{\emph{survival15} - } 15-days survival.
#'   \item{\emph{prod} - } Female productivity.
#'   \item{\emph{sex} - } Individual sex.
#'   \item{\emph{yob} - } Year of birth.
#'   \item{\emph{pom} - } Period of management.
#'   \item{\emph{target} - } Individual in the target population.
#'   \item{\emph{eeza_id} - } Individual identity (as recorded in the original studbook)
#' }
#' @source The original studbook containing the complete and updated pedigree can be found at: \url{http://www.eeza.csic.es/en/programadecria.aspx}.
#' @references
#' \itemize{
#'   \item{López-Cortegano E et al. 2021. Genetic purging in captive endangered ungulates with extremely low effective population sizes. *Pending revision*.}
#' }
"dorcas"
