% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_level_disprop_analysis.R
\name{ci_for_ic}
\alias{ci_for_ic}
\title{Confidence intervals for Information Component (IC)}
\usage{
ci_for_ic(obs, exp, conf_lvl_probs, shrinkage)
}
\arguments{
\item{obs}{A numeric vector with observed counts, i.e. number of reports
for the selected drug-event-combination. Note that shrinkage (e.g. +0.5) is added
inside the function and should not be included here.}

\item{exp}{A numeric vector with expected counts, i.e. number of reports
to be expected given a comparator or \emph{background}. Note that shrinkage
(e.g. +0.5) is added inside the function and should not be included here.}

\item{conf_lvl_probs}{The probabilities of the posterior, based on
a passed confidence level (\code{conf_lvl}) in \code{\link{ic}}. For
instance, if \code{sgn_lvl = .95} in \code{ic} is used, quantiles will be
extracted at \code{sgn_lvl_probs} 0.025 and 0.975.}

\item{shrinkage}{A non-negative numeric value, to be added to
observed and expected count. Default is 0.5.}
}
\value{
The credibility interval specified by input parameters.
}
\description{
Mainly used in function \code{\link{ic}}. Produces quantiles of the
posterior gamma distribution. Called twice in \code{ic} to create
credibility intervals.
}
\seealso{
\code{\link{ic}}
}
