% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/med.R
\name{med}
\alias{med}
\title{Compute Power for Mediated (Indirect) Effects
Requires correlations between all variables as sample size.}
\usage{
med(rxm1, rxm2 = 0, rxm3 = 0, rxm4 = 0, rxy, rym1, rym2 = 0,
  rym3 = 0, rym4 = 0, rm1m2 = 0, rm1m3 = 0, rm1m4 = 0,
  rm2m3 = 0, rm2m4 = 0, rm3m4 = 0, alpha = 0.05, mvars, n)
}
\arguments{
\item{rxm1}{Correlation between predictor (x) and first mediator (m1)}

\item{rxm2}{Correlation between predictor (x) and second mediator (m2)}

\item{rxm3}{Correlation between predictor (x) and third mediator (m3)}

\item{rxm4}{Correlation between predictor (x) and fourth mediator (m4)}

\item{rxy}{Correlation between DV (y) and predictor (x)}

\item{rym1}{Correlation between DV (y) and first mediator (m1)}

\item{rym2}{Correlation between DV (y) and second mediator (m2)}

\item{rym3}{Correlation DV (y) and third mediator (m3)}

\item{rym4}{Correlation DV (y) and fourth mediator (m4)}

\item{rm1m2}{Correlation first mediator (m1) and second mediator (m2)}

\item{rm1m3}{Correlation first mediator (m1) and third mediator (m3)}

\item{rm1m4}{Correlation first mediator (m1) and fourth mediator (m4)}

\item{rm2m3}{Correlation second mediator (m2) and third mediator (m3)}

\item{rm2m4}{Correlation second mediator (m2) and fourth mediator (m4)}

\item{rm3m4}{Correlation third mediator (m3) and fourth mediator (m4)}

\item{alpha}{Type I error (default is .05)}

\item{mvars}{Number of Mediators}

\item{n}{Sample size}
}
\value{
Power for Mediated (Indirect) Effects
}
\description{
Compute Power for Mediated (Indirect) Effects
Requires correlations between all variables as sample size.
}
\examples{
med(rxm1=.25, rxy=-.35, rym1=-.5,mvars=1, n=150)
med(rxm1=.3, rxm2=.3, rxm3=.25, rxy=-.35, rym1=-.5,rym2=-.5, rym3 = -.5,
rm1m2=.7, rm1m3=.4,rm2m3=.4, mvars=3, n=150)
}
