% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_totals.R
\name{px_add_totals}
\alias{px_add_totals}
\alias{px_add_totals.px}
\title{Add total levels to variables}
\usage{
px_add_totals(x, value, na.rm = TRUE, validate)

\method{px_add_totals}{px}(x, value, na.rm = TRUE, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{A character vector of variables to add total levels to.}

\item{na.rm}{Optional. Logical. If TRUE, NAs are removed before summing.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object
}
\description{
Adds a total level, which is the sum of the figures for all other levels of
the variable. NA values are ignored when calculating the sum.

The default name of the total level is 'Total', unless \link{px_elimination}
is set, in which case the elimination value becomes the name of the total
level.
}
\examples{
# Create small px object example
x0 <- px(subset(population_gl, age == "65+"))
x0$data

# Add total level to one variable
x1 <- px_add_totals(x0, "gender")
x1$data

# Add total level to multiple variables
x2 <- px_add_totals(x0, c("gender", "age"))
x2$data

# The name of the total level can be changed with px_elimination()
x3 <-
  x0 |>
  px_elimination("T") |>
  px_add_totals("gender")

x3$data

}
\seealso{
\link{px_elimination}
}
