% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_find.R
\name{pystr_find}
\alias{pystr_find}
\title{Find the lowest index of a substring.}
\usage{
pystr_find(str, sub, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A character vector.}

\item{sub}{A character vector.}

\item{start}{A numeric vector.}

\item{end}{A numeric vector.}
}
\value{
A numeric vector. \code{-1} indicates \code{sub} was not found.
}
\description{
Return the lowest index in the string where substring \code{sub} is found,
such that \code{sub} is contained in the slice \code{substr(str, start, end)}.
}
\examples{
pystr_find("abcdxyzabc", "abc")
pystr_find("abc", "xy")
pystr_find("abcxyzabc", "abc", 4)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.find}
}
\seealso{
\code{\link{pystr_rfind}}
}

