/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.AttributeValueAnnotation;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.RuleMultiItemAnnotation;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtendRuleAnnotation {
    private static final Logger LOGGER = Logger.getLogger(Antecedent.class.getName());
    private final HashMap<RuleMultiItem, RuleMultiItemAnnotation> annotations = new HashMap();

    public RuleMultiItemAnnotation getAnnotation(RuleMultiItem rmi) {
        return this.annotations.get(rmi);
    }

    public void generate(ExtendRule r, ArrayList<Consequent> consequents) {
        int total_combinations = r.getAntecedent().getItems().stream().mapToInt(x -> x.getAttributeValues().size()).sum() * consequents.size();
        LOGGER.log(Level.INFO, "There are {0} narrow rules to be generated to annotate the current rule", total_combinations);
        AtomicInteger processedCombinations = new AtomicInteger(0);
        r.getAntecedent().getItems().stream().forEach(ruleConstituent -> {
            RuleMultiItemAnnotation annot = this.generateRuleMultiItemAnnotation(r, (RuleMultiItem)ruleConstituent, consequents);
            processedCombinations.addAndGet(ruleConstituent.getAttributeValues().size() * consequents.size());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Processed {0} combinations out of {1}", new Object[]{processedCombinations, total_combinations});
            }
            this.annotations.put((RuleMultiItem)ruleConstituent, annot);
        });
    }

    public String toString() {
        if (this.annotations == null) {
            return "No items - not annotations";
        }
        StringBuilder sb = new StringBuilder();
        this.annotations.forEach((item, annotation) -> {
            sb.append("Annotations of multiitem'").append(item).append("'\n");
            sb.append(annotation);
        });
        return sb.toString();
    }

    private ExtendRule deriveNarrowRule(ExtendRule seedRule, RuleMultiItem toReplace, AttributeValue replacementAntConstituent, Consequent consequent) {
        ArrayList<AttributeValue> replacementItemWrapped = new ArrayList<AttributeValue>();
        replacementItemWrapped.add(replacementAntConstituent);
        ValueOrigin val = toReplace.getValueOrigin(replacementAntConstituent);
        if (val == null) {
            LOGGER.severe("Something is wrong, the value origin should be known");
        }
        ArrayList<ValueOrigin> valOriginAsArray = new ArrayList<ValueOrigin>();
        valOriginAsArray.add(val);
        RuleMultiItem replacement = seedRule.getRule().getData().makeRuleItem(replacementItemWrapped, valOriginAsArray, toReplace.getAttribute(), ValueOrigin.narrow);
        ArrayList<RuleMultiItem> itemsForAntecedent = new ArrayList<RuleMultiItem>();
        seedRule.getAntecedent().getItems().stream().forEach(rmi -> {
            if (rmi == toReplace) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Replacing {0} with {1}", new Object[]{toReplace, replacement});
                }
                itemsForAntecedent.add(replacement);
            } else {
                itemsForAntecedent.add((RuleMultiItem)rmi);
            }
        });
        Antecedent newAnt = new Antecedent(itemsForAntecedent);
        Rule r = new Rule(newAnt, consequent, null, null, seedRule.getRID(), null, seedRule.getRule().getData());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating new Extend rule within narrow rule procedure");
        }
        ExtendRule extRule = new ExtendRule(r, seedRule.copyHistory(), seedRule.getExtendType(), seedRule.getExtendRuleConfig());
        return extRule;
    }

    private RuleMultiItemAnnotation generateRuleMultiItemAnnotation(ExtendRule r, RuleMultiItem rmi, ArrayList<Consequent> consequents) {
        RuleMultiItemAnnotation rmiAnnot = new RuleMultiItemAnnotation();
        rmi.getAttributeValues().stream().map(val -> {
            AttributeValueAnnotation annot = new AttributeValueAnnotation((AttributeValue)val, rmi.getValueOrigin((AttributeValue)val));
            consequents.stream().forEach(cons -> {
                ExtendRule narrowRule = this.deriveNarrowRule(r, rmi, (AttributeValue)val, (Consequent)cons);
                RuleQuality quality = narrowRule.getRuleQuality();
                annot.add((Consequent)cons, quality);
            });
            return annot;
        }).forEach(annot -> rmiAnnot.add((AttributeValueAnnotation)annot));
        return rmiAnnot;
    }
}

