% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.cp.r
\name{qcs.cp}
\alias{qcs.cp}
\title{Process capability indices (parametric)}
\usage{
qcs.cp(
  object,
  parameters = c(u = 0, v = 0),
  limits = c(lsl = -3, usl = 3),
  target = NULL,
  mu = 0,
  std.dev = 1,
  nsigmas = 3,
  k = 1,
  contour = TRUE,
  ylim = NULL,
  ...
)
}
\arguments{
\item{object}{qcs object of type \code{"qcs.xbar"} or \code{"qcs.one"}.}

\item{parameters}{A vector specifying the \code{u} and \code{v} parameters values. 
If parameters = c(u=0, v=0), the cp indice is calculed; If parameters = c(u=1, v=0), the cpk indice is calculed;
If parameters = c(u=0, v=1), the cpm indice is calculed; If parameters = c(u=1, v=1), the cpmk indice is calculed.}

\item{limits}{A vector specifying the lower and upper specification limits.}

\item{target}{A value specifying the target of the process. 
If is \code{NULL}, the target is set at the middle value bewteen specification limits.}

\item{mu}{A value specifying the mean of data.}

\item{std.dev}{A value specifying the within-group standard deviation.}

\item{nsigmas}{A numeric value specifying the number of sigmas to use.}

\item{k}{A numeric value. If the capacity index exceeds the \code{k} value, then the process is capable.}

\item{contour}{Logical value indicating whether contour graph should be plotted.}

\item{ylim}{The y limits of the plot.}

\item{...}{Arguments to be passed to or from methods.}
}
\description{
Calculates \eqn{Cp}{Cpk}, \eqn{Cpm}{Cpmk} using the formulation described by Kerstin Vannman(1995).
}
\examples{
library(qcr)
data(pistonrings) 
xbar <- qcs.xbar(pistonrings[1:125,],plot = TRUE)
mu <-xbar$center
std.dev <-xbar$std.dev
LSL=73.99; USL=74.01
qcs.cp(parameters = c(0,0),limits = c(LSL,USL),
      mu = mu,std.dev = std.dev,ylim=c(0,1))
#calculating all the indices
qcs.cp(object = xbar,parameters = c(0,0), limits = c(LSL,USL),ylim=c(0,1))
qcs.cp(object = xbar,parameters = c(1,0), limits = c(LSL,USL),ylim=c(0,1))
qcs.cp(object = xbar,parameters = c(0,1), limits = c(LSL,USL),ylim=c(0,1))
qcs.cp(object = xbar,parameters = c(1,1), limits = c(LSL,USL),ylim=c(0,1))
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical Quality Control}, 2nd
ed, New York, John Wiley & Sons. \cr
Vannman, K (1995) \emph{A Unified Approach to Capability Indices}. Statitica Sinica,5,805-820.\cr
}
