% Generated by roxygen2 (4.0.2): do not edit by hand
\name{colSplit}
\alias{colSplit}
\title{Separate a Column Pasted by paste2}
\usage{
colSplit(column, col.sep = ".", name.sep = "&")
}
\arguments{
\item{column}{The pasted vector.}

\item{col.sep}{The column separator used in \code{paste2}.}

\item{name.sep}{Name separator used in the column (generally for internal use
with \code{\link[qdap]{colsplit2df}}).}
}
\value{
Returns a dataframe of split columns.
}
\description{
Separates a \code{\link[qdap]{paste2}} column into separate columns.
}
\examples{
\dontrun{
foo1 <- paste2(CO2[, 1:3])
head(foo1, 12)
bar1 <- colSplit(foo1)
head(bar1, 10)

foo2  <- paste2(mtcars[, 1:3], sep="|")
head(foo2, 12)
bar2 <- colSplit(foo2, col.sep = "|")
head(bar2, 10)
}
}
\seealso{
\code{\link[qdap]{colsplit2df}},
\code{\link[qdap]{paste2}}
}
\keyword{column-split}

