# -- Datasets of R package qfa: Quantile-Frequency Analysis (QFA) --

#' Engel food expenditure data
#'
#' The Engel food expenditure data from the R package \code{quantreg}.
#' @docType data
#' @usage data(engel)
#' @keywords datasets
#' @references Koenker, R. (2005). Quantile Regression. Cambridge University Press. 
"engel"


#' Yearly sunspot numbers
#'
#' Sunspot numbers from 1700 to 2007.
#' @docType data
#' @usage data(yearssn)
#' @keywords datasets
#' @references Li, T.-H. (2014). Time Series with Mixed Spectra. CRC Press. 
"yearssn"


#' Birthweight data 
#'
#' Infant birth weight data. \code{Precare} and \code{Education} should be treated as factors.
#' @docType data
#' @usage data(birthweight)
#' @keywords datasets
#' @references Koenker, R. (2005). Quantile Regression. Cambridge University Press. 
#' @source natality2022us.csv, <https://www.nber.org/research/data/vital-statistics-natality-birth-data>
"birthweight"

