% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_fun.R
\name{qfmrm}
\alias{qfmrm}
\alias{qfmrm_ApBIqr_int}
\alias{qfmrm_ApBIqr_npi}
\alias{qfmrm_IpBDqr_gen}
\alias{qfmrm_ApBDqr_int}
\alias{qfmrm_ApBDqr_npi}
\title{Moment of multiple ratio of quadratic forms in normal variables}
\usage{
qfmrm(
  A,
  B,
  D,
  p = 1,
  q = p/2,
  r = q,
  m = 100L,
  mu = rep.int(0, n),
  Sigma = diag(n),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  ...
)

qfmrm_ApBIqr_int(
  A,
  B,
  p = 1,
  q = 1,
  r = 1,
  m = 100L,
  mu = rep.int(0, n),
  error_bound = TRUE,
  check_convergence = c("relative", "strict_relative", "absolute", "none"),
  use_cpp = TRUE,
  cpp_method = c("double", "long_double", "coef_wise"),
  nthreads = 0,
  alphaB = 1,
  tol_conv = .Machine$double.eps^(1/4),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  thr_margin = 100
)

qfmrm_ApBIqr_npi(
  A,
  B,
  p = 1,
  q = 1,
  r = 1,
  m = 100L,
  mu = rep.int(0, n),
  check_convergence = c("relative", "strict_relative", "absolute", "none"),
  use_cpp = TRUE,
  cpp_method = c("double", "long_double", "coef_wise"),
  nthreads = 0,
  alphaA = 1,
  alphaB = 1,
  tol_conv = .Machine$double.eps^(1/4),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  thr_margin = 100
)

qfmrm_IpBDqr_gen(
  B,
  D,
  p = 1,
  q = 1,
  r = 1,
  mu = rep.int(0, n),
  m = 100L,
  check_convergence = c("relative", "strict_relative", "absolute", "none"),
  use_cpp = TRUE,
  cpp_method = c("double", "long_double", "coef_wise"),
  nthreads = 0,
  alphaB = 1,
  alphaD = 1,
  tol_conv = .Machine$double.eps^(1/4),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  thr_margin = 100
)

qfmrm_ApBDqr_int(
  A,
  B,
  D,
  p = 1,
  q = 1,
  r = 1,
  m = 100L,
  mu = rep.int(0, n),
  check_convergence = c("relative", "strict_relative", "absolute", "none"),
  use_cpp = TRUE,
  cpp_method = c("double", "long_double", "coef_wise"),
  nthreads = 0,
  alphaB = 1,
  alphaD = 1,
  tol_conv = .Machine$double.eps^(1/4),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  thr_margin = 100
)

qfmrm_ApBDqr_npi(
  A,
  B,
  D,
  p = 1,
  q = 1,
  r = 1,
  m = 100L,
  mu = rep.int(0, n),
  check_convergence = c("relative", "strict_relative", "absolute", "none"),
  use_cpp = TRUE,
  cpp_method = c("double", "long_double", "coef_wise"),
  nthreads = 0,
  alphaA = 1,
  alphaB = 1,
  alphaD = 1,
  tol_conv = .Machine$double.eps^(1/4),
  tol_zero = .Machine$double.eps * 100,
  tol_sing = tol_zero,
  thr_margin = 100
)
}
\arguments{
\item{A, B, D}{Argument matrices.  Should be square.  Will be automatically symmetrized.}

\item{p, q, r}{Exponents for \eqn{\mathbf{A}}{A}, \eqn{\mathbf{B}}{B}, and
\eqn{\mathbf{D}}{D}, respectively.  By default, \code{q} equals \code{p/2}
and \code{r} equals \code{q}.  If unsure, specify all explicitly.}

\item{m}{Order of polynomials at which the series expression is truncated.  \eqn{M}
in Hillier et al. (2009, 2014).}

\item{mu}{Mean vector \eqn{\bm{\mu}}{\mu} for \eqn{\mathbf{x}}{x}}

\item{Sigma}{Covariance matrix \eqn{\mathbf{\Sigma}}{\Sigma} for
\eqn{\mathbf{x}}{x}.  Accommodated only by the front-end
\code{qfmrm()}.  See \dQuote{Details} in \code{\link{qfrm}}.}

\item{tol_zero}{Tolerance against which numerical zero is determined.  Used to determine,
e.g., whether \code{mu} is a zero vector, \code{A} or \code{B} equals
the identity matrix, etc.}

\item{tol_sing}{Tolerance against which matrix singularity and rank are determined.  The
eigenvalues smaller than this are considered zero.}

\item{...}{Additional arguments in the front-end \code{qfmrm()} will be passed to
the appropriate \dQuote{internal} function.}

\item{error_bound}{Logical to specify whether an error bound is returned (if available).}

\item{check_convergence}{Specifies how numerical convergence is checked (see \dQuote{Details}).
Options:
\itemize{
\item{\code{"relative"}: }{default; magnitude of the last term of
the series relative to the sum is compared with \code{tol_conv}}
\item{\code{"strict_relative"} or \code{TRUE}: }{same, but stricter than
default by setting \code{tol_conv = .Machine$double.eps}
(unless a smaller value is specified by the user)}
\item{\code{"absolute"}: }{absolute magnitude of the last term is
compared with \code{tol_conv}}
\item{\code{"none"} or \code{FALSE}: }{skips convergence check}
}}

\item{use_cpp}{Logical to specify whether the calculation is done with \proglang{C++}
functions via \code{Rcpp}.  \code{TRUE} by default.}

\item{cpp_method}{Method used in \proglang{C++} calculations to avoid numerical
overflow/underflow (see \dQuote{Details}).  Options:
\itemize{
\item{\code{"double"}: }{default; fastest but prone to underflow in
some conditions}
\item{\code{"long_double"}: }{same algorithm but using the
\code{long double} variable type; robust but slow and
memory-inefficient}
\item{\code{"coef_wise"}: }{coefficient-wise scaling algorithm;
most robust but variably slow}
}}

\item{nthreads}{Number of threads used in OpenMP-enabled \proglang{C++} functions.  See
\dQuote{Multithreading} in \code{\link{qfrm}}.}

\item{tol_conv}{Tolerance against which numerical convergence of series is checked.  Used
with \code{check_convergence}.}

\item{thr_margin}{Optional argument to adjust the threshold for scaling (see \dQuote{Scaling}
in \code{\link{d1_i}}).  Passed to internal functions (\code{\link{d1_i}},
\code{\link{d2_ij}}, \code{\link{d3_ijk}}) or their \proglang{C++} equivalents.}

\item{alphaA, alphaB, alphaD}{Factors for the scaling constants for \eqn{\mathbf{A}}{A},
\eqn{\mathbf{B}}{B}, and \eqn{\mathbf{D}}{D}, respectively.  See
\dQuote{Details} in \code{\link{qfrm}}.}
}
\value{
A \code{\link[=new_qfrm]{qfrm}} object, as in \code{\link{qfrm}()} functions.
}
\description{
\code{qfmrm()} is a front-end function to obtain the (compound) moment
of a multiple ratio of quadratic forms in normal variables in the following
special form:
\eqn{ \mathrm{E} \left(
  \frac{(\mathbf{x^\mathit{T} A x})^p }
       {(\mathbf{x^\mathit{T} B x})^q (\mathbf{x^\mathit{T} D x})^r}
  \right) }{E( (x^T A x)^p / ( (x^T B x)^q (x^T D x)^r ) )}, where
\eqn{\mathbf{x} \sim N_n(\bm{\mu}, \mathbf{\Sigma})}{x ~
     N_n(\mu, \Sigma)}.  Like \code{qfrm()}, this function calls one of
the following \dQuote{internal} functions for actual calculation,
as appropriate.

\code{qfmrm_ApBIqr_int()}: For \eqn{\mathbf{D} = \mathbf{I}_n}{D = I_n} and
positive-integral \eqn{p}

\code{qfmrm_ApBIqr_npi()}: For \eqn{\mathbf{D} = \mathbf{I}_n}{D = I_n} and
non-integral \eqn{p}

\code{qfmrm_IpBDqr_gen()}: For \eqn{\mathbf{A} = \mathbf{I}_n}{A = I_n}

\code{qfmrm_ApBDqr_int()}: For general \eqn{\mathbf{A}}{A},
\eqn{\mathbf{B}}{B}, and \eqn{\mathbf{D}}{D}, and positive-integral \eqn{p}

\code{qfmrm_ApBDqr_npi()}: For general \eqn{\mathbf{A}}{A}, \eqn{\mathbf{B}}{B},
and \eqn{\mathbf{D}}{D}, and non-integral \eqn{p}
}
\details{
The usage of these functions is similar to \code{\link{qfrm}}, to which
the user is referred for documentation.  It is assumed that
\eqn{\mathbf{B} \neq \mathbf{D}}{B != D}
(otherwise, the problem reduces to a simple ratio).

When \code{B} is identity or missing, this and its exponent \code{q} will
be swapped with \code{D} and \code{r}, respectively, before
\code{qfmrm_ApBIqr_***()} is called.

The existence conditions for the moments of this multiple ratio can be
reduced to those for a simple ratio, provided that one of the null spaces
of \eqn{\mathbf{B}}{B} and \eqn{\mathbf{D}}{D} is a subspace of the other
(including the case they are null).  The conditions of Bao and Kan
(2013: proposition 1) can then be
applied by replacing \eqn{q} and \eqn{m} there by \eqn{q + r} and
\eqn{\min{( \mathrm{rank}(\mathbf{B}), \mathrm{rank}(\mathbf{D}) )}
     }{min(rank B, rank D)},
respectively (see also Smith 1989: p. 258 for
nonsingular \eqn{\mathbf{B}}{B}, \eqn{\mathbf{D}}{D}).  An error is
thrown if these conditions are not met in this case.  Otherwise
(i.e., \eqn{\mathbf{B}}{B} and \eqn{\mathbf{D}}{D} are both
singular and neither of their null spaces is a subspace of the other), it
seems difficult to define general moment existence conditions.  A sufficient
condition can be obtained by applying the same proposition with a new
denominator matrix whose null space is union of those of \eqn{\mathbf{B}}{B}
and \eqn{\mathbf{D}}{D} (Watanabe, 2023).  A warning is thrown if that
condition is not met in this case.

Most of these functions, excepting \code{qfmrm_ApBIqr_int()} with zero
\code{mu}, involve evaluation of multiple series, which can suffer
from numerical overflow and underflow (see \dQuote{Scaling} in
\code{\link{d1_i}} and \dQuote{Details} in \code{\link{qfrm}}).  To avoid
this, \code{cpp_method = "long_double"} or \code{"coef_wise"} options can be
used (see \dQuote{Details} in \code{\link{qfrm}}).
}
\examples{
## Some symmetric matrices and parameters
nv <- 4
A <- diag(nv:1)
B <- diag(sqrt(1:nv))
D <- diag((1:nv)^2 / nv)
mu <- nv:1 / nv
Sigma <- matrix(0.5, nv, nv)
diag(Sigma) <- 1

## Expectation of (x^T A x)^2 / (x^T B x) (x^T x) where x ~ N(0, I)
(res1 <- qfmrm(A, B, p = 2, q = 1, r = 1))
plot(res1)

# The above internally calls the following:
qfmrm_ApBIqr_int(A, B, p = 2, q = 1, r = 1) ## The same

# Similar result with different expression
# This is a suboptimal option and throws a warning
qfmrm_ApBIqr_npi(A, B, p = 2, q = 1, r = 1)

## Expectation of (x^T A x) / (x^T B x)^(1/2) (x^T D x)^(1/2) where x ~ N(0, I)
(res2 <- qfmrm(A, B, D, p = 1, q = 1/2, r = 1/2))
plot(res2)

# The above internally calls the following:
qfmrm_ApBDqr_int(A, B, D, p = 1, q = 1/2, r = 1/2) ## The same

## Average response correlation between A and B
(res3 <- qfmrm(crossprod(A, B), crossprod(A), crossprod(B),
               p = 1, q = 1/2, r = 1/2))
plot(res3)

## Same, but with x ~ N(mu, Sigma)
(res4 <- qfmrm(crossprod(A, B), crossprod(A), crossprod(B),
               p = 1, q = 1/2, r = 1/2, mu = mu, Sigma = Sigma))
plot(res4)

## Average autonomy of D
(res5 <- qfmrm(B = D, D = solve(D), p = 2, q = 1, r = 1))
plot(res5)

}
\references{
Bao, Y. and Kan, R. (2013) On the moments of ratios of quadratic forms in
normal random variables. \emph{Journal of Multivariate Analysis}, \strong{117},
229--245.
\doi{10.1016/j.jmva.2013.03.002}.

Smith, M. D. (1989). On the expectation of a ratio of quadratic forms
in normal variables. \emph{Journal of Multivariate Analysis}, \strong{31}, 244--257.
\doi{10.1016/0047-259X(89)90065-1}.

Watanabe, J. (2023) Exact expressions and numerical evaluation of average
evolvability measures for characterizing and comparing \strong{G} matrices.
\emph{Journal of Mathematical Biology}, \strong{86}, 95.
\doi{10.1007/s00285-023-01930-8}.
}
\seealso{
\code{\link{qfrm}} for simple ratio
}
