% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{getG}
\alias{getG}
\title{Extract elements from genotype matrix stored on disk}
\usage{
getG(
  Glist = NULL,
  chr = NULL,
  bedfiles = NULL,
  bimfiles = NULL,
  famfiles = NULL,
  ids = NULL,
  rsids = NULL,
  rws = NULL,
  cls = NULL,
  impute = TRUE,
  scale = FALSE
)
}
\arguments{
\item{Glist}{list structure with information about genotypes stored on disk}

\item{chr}{chromosome for which W is to be extracted}

\item{bedfiles}{vector of name for the PLINK bed-file}

\item{bimfiles}{vector of name for the PLINK bim-file}

\item{famfiles}{vector of name for the PLINK fam-file}

\item{ids}{vector of ids in W to be extracted}

\item{rsids}{vector of rsids in W to be extracted}

\item{rws}{vector of rows in W to be extracted}

\item{cls}{vector of columns in W to be extracted}

\item{impute}{logical if TRUE missing genotypes are set to its expected value (2*af where af is allele frequency)}

\item{scale}{logical if TRUE the genotype markers have been scale to mean zero and variance one}
}
\description{
Extract elements from genotype matrix (rows/columns, ids/rsids) stored on disk.
}
