% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgg_utility_functions.R
\name{plotForest}
\alias{plotForest}
\title{Forest plot}
\usage{
plotForest(
  x = NULL,
  sd = NULL,
  cex = 1,
  mar = NULL,
  mai = NULL,
  xlim = NULL,
  pos = NULL,
  reorder = TRUE,
  xaxis = TRUE,
  main = NULL,
  xlab = "x"
)
}
\arguments{
\item{x}{A vector of point estimates or effect sizes.}

\item{sd}{A vector of standard deviations corresponding to the values in `x`.}

\item{cex}{A numerical value indicating the amount by which plotting text and symbols should be scaled. Default is 1.}

\item{mar}{A numerical vector of the form `c(bottom, left, top, right)` which gives the number of lines of margin to be specified on the four sides of the plot. Default is `c(5,12,3,1)`.}

\item{mai}{A numerical vector indicating the margins in inches.}

\item{xlim}{The x limits (x1, x2) of the plot.}

\item{pos}{Position of y-axis labels.}

\item{reorder}{A logical value. If `TRUE`, data points are reordered based on the values in `x`. Default is `TRUE`.}

\item{xaxis}{A logical value. If `TRUE`, x-axis is drawn. Default is `TRUE`.}

\item{main}{An overall title for the plot.}

\item{xlab}{A label for the x-axis. Default is "x".}
}
\description{
This function generates a forest plot, which is commonly used to visualize
effect sizes and their confidence intervals.
}
\keyword{internal}
