% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_score.R
\name{gscore}
\alias{gscore}
\title{Genomic scoring based on single marker summary statistics}
\usage{
gscore(
  Glist = NULL,
  chr = NULL,
  bedfiles = NULL,
  bimfiles = NULL,
  famfiles = NULL,
  stat = NULL,
  fit = NULL,
  ids = NULL,
  scaleMarker = TRUE,
  scaleGRS = TRUE,
  impute = TRUE,
  msize = 100,
  ncores = 1,
  verbose = FALSE
)
}
\arguments{
\item{Glist}{List of information about genotype matrix. Default is NULL.}

\item{chr}{Chromosome for which genomic scores is computed. Default is NULL.}

\item{bedfiles}{Names of the PLINK bed-files. Default is NULL.}

\item{bimfiles}{Names of the PLINK bim-files. Default is NULL.}

\item{famfiles}{Names of the PLINK fam-files. Default is NULL.}

\item{stat}{Matrix of single marker effects. Default is NULL.}

\item{fit}{Fit object output from gbayes. Default is NULL.}

\item{ids}{Vector of individuals used in the analysis. Default is NULL.}

\item{scaleMarker}{Logical; if TRUE the genotype markers are scaled to mean zero and variance one. Default is TRUE.}

\item{scaleGRS}{Logical; if TRUE the GRS are scaled to mean zero and variance one. Default is TRUE.}

\item{impute}{Logical; if TRUE, missing genotypes are set to its expected value (2*af where af is allele frequency). Default is TRUE.}

\item{msize}{Number of genotype markers used for batch processing. Default is 100.}

\item{ncores}{Number of cores used in the analysis. Default is 1.}

\item{verbose}{Logical; if TRUE, more details are printed during optimization. Default is FALSE.}
}
\value{
Returns the genomic scores based on the provided parameters.
}
\description{
Computes genomic predictions using single marker summary statistics and observed genotypes.
}
\examples{

 ## Plink bed/bim/fam files
 bedfiles <- system.file("extdata", paste0("sample_chr",1:2,".bed"), package = "qgg")
 bimfiles <- system.file("extdata", paste0("sample_chr",1:2,".bim"), package = "qgg")
 famfiles <- system.file("extdata", paste0("sample_chr",1:2,".fam"), package = "qgg")
 
 # Summarize bed/bim/fam files
 Glist <- gprep(study="Example", bedfiles=bedfiles, bimfiles=bimfiles, famfiles=famfiles)
 
 # Simulate phenotype
 sim <- gsim(Glist=Glist, chr=1, nt=1)
 
 # Compute single marker summary statistics
 stat <- glma(y=sim$y, Glist=Glist, scale=FALSE)
 
 # Compute genomic scores
 gsc <- gscore(Glist = Glist, stat = stat)
 
}
\author{
Peter Soerensen
}
