% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretochart.R
\name{paretochart}
\alias{paretochart}
\title{Paretochart}
\usage{
paretochart(x, title = "", subtitle = NULL, caption = NULL,
  ylab = NULL, xlab = NULL, x.angle = NULL, useNA = FALSE,
  print.data = FALSE)
}
\arguments{
\item{x}{Categorical variable to plot.}

\item{title}{Chart title.}

\item{subtitle}{Chart subtitle.}

\item{caption}{Chart caption.}

\item{ylab}{Y axis label.}

\item{xlab}{X axis label.}

\item{x.angle}{Number indicating the angle of x axis labels.}

\item{useNA}{If TRUE, NA values will be included in the analysis.}

\item{print.data}{If TRUE, prints data frame with results.}
}
\value{
An object of class ggplot.
}
\description{
Creates a pareto chart from a categorical variable
}
\examples{
# Generate categorical vector
x <- rep(LETTERS[1:9], c(256, 128, 64, 32, 16, 8, 4, 2, 1))

# Make paretochart
paretochart(x)

# Save paretochart object to variable
p <- paretochart(x)

# Print data frame
p$data

}
