% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crude_mx.R
\name{crude_mx}
\alias{crude_mx}
\title{Data frame(s) of crude estimates of quarterly (and annual) central rates of mortality estimated from quarterly summary statistics.}
\usage{
crude_mx(
  time.stock,
  events.death,
  time.death = NULL,
  time.outs = NULL,
  time.ins = NULL,
  time.birth = NULL,
  type = "forward",
  annual = FALSE
)
}
\arguments{
\item{time.stock}{A data frame containing the total exposure-at-risk times for the stock of
the population/portfolio, measured either since the start of the year (`type = "forward"`)
or from the end of the year (`type = "backward"`) throughout the target period (typically a year).
This data frame must contain the times for a set of consecutive integer ages
for each combination of age and season/calendar quarter. Typically, this data
frame is an output of the function \code{\link{time_exposed_stock}} or a data frame
with the same structure. The set of consecutive integer ages in this object determines the
range of ages for which crude rates of mortality are estimated by the function.}

\item{events.death}{A data frame with the number of deaths recorded in the population/portfolio
during the target period (typically a year) in a set of integer ages for each combination of age
and season/calendar quarter. Typically, this is an output of the function
\code{\link{count_events_quarter}} or a data frame with the same structure.
If the range of ages does not cover the range of ages in `time.stock`,
zeros are imputed  for the missing ages.}

\item{time.death}{A data frame containing either the total non-exposure-at-risk times (when
`type = "forward"`) or the total exposure-at-risk times (when `type = "backward"`)
during the target period of the deaths recorded in the population/portfolio.
Typically, this data frame is an output of the function \code{\link{time_exposed_ins}}
when `type = "forward"` or an output of the function \code{\link{time_exposed_outs}}
when `type = "backward"` or a data frame with the same structure. Default, `NULL`.
If no `time.death` data.frame is provided the total (non-) exposure-at-risk times
are computed using the information in `events.death` under the hypothesis of
uniform distribution of deaths within each age-calendar quarter.}

\item{time.outs}{A data frame containing either the total non-exposure-at-risk times (when
`type = "forward"`) or the total exposure-at-risk times (when `type = "backward"`)
during the target period of the emigrants/exits recorded in the population/portfolio.
Typically, this data frame is an output of the function \code{\link{time_exposed_ins}}
when `type = "forward"` or an output of the function \code{\link{time_exposed_outs}}
when `type = "backward"` or a data frame with the same structure. Default, `NULL`.}

\item{time.ins}{A data frame containing either the total exposure-at-risk times (when
`type = "forward"`) or the total non-exposure-at-risk times (when `type = "backward"`)
during the target period (typically a year) of the immigrants/new policies recorded in the population/portfolio.
Typically, this data frame is an output of the function \code{\link{time_exposed_ins}}
when `type = "forward"` and an output of the function \code{\link{time_exposed_outs}}
when `type = "backward"` or a data frame with the same structure. Default, `NULL`.}

\item{time.birth}{A data frame containing the total exposure-at-risk times of the newborns recorded in
the population during the target period. Typically, this data frame is an output of the
function \code{\link{time_exposed_newborns}} or a data frame with the same structure.
Default, `NULL`.}

\item{type}{A character string informing if the total time exposed to risk of the stock of
population/portfolio has been computed since the beginning of the year (`"forward"`) or
from the end of the year (`"backward"`). Default, `"forward"`.}

\item{annual}{A character string informing whether the annual crude central rates of mortality
should also be computed. Default, `FALSE`.}
}
\value{
When `annual = FALSE` a data frame with estimated crude central rates of mortality for the set
of integer ages determined by `time.stock` for each combination of age and
calendar quarter. The data frame has the following components:
   \item{age}{ Integer age to which the crude central rate of mortality corresponds.}
   \item{quarter.age}{ Age quarter to which the crude central rate of mortality corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the crude central rate of mortality corresponds.}
   \item{exposed}{ Total exposure-at-risk times in the target population for each combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{deaths}{ Number of deaths in the target population for each  combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{mx}{ Estimated crude central rate of mortality corresponding to the combination of `age`, `quarter.age` and `quarter.calendar`.}
When `annual = TRUE` the output is a list with two data frames `mx.quarterly` and `mx.annual`.
`mx.quarterly` is a data frame with the estimated quarterly crude central rates of mortality as just described and
`mx.annual` is the corresponding data frame with the estimated annual crude central rates of mortality.
}
\description{
Computes for a general/insured population crude estimates of quarterly (and annual)
              central rates of mortality by age (in a set of integer ages) for each combination
              of age and calendar quarter, given data sets of times exposed-at-risk of
              stocks of population and of number of deaths by each integer age for
              each combination of age and seasonal quarter, along with data sets of times
              exposed-at-risk (or non-exposed) of immigrants/new policies, emigrants/exits/deaths
              and/or newborns.
}
\note{
First, it is the responsibility of the user to assure that all the times exposed-at-risk and number of events
correspond to the same target period (typically, the same year).
Second, If the date of reference of the stock of population/portfolio is the beginning of the year (`type = "forward"`),
the total time exposed at risk for each integer age in each age and calendar quarter is computed through:
time_exposed_stock(P) + time_exposed_ins(I) - time_exposed_ins(E) - time_exposed_ins(D) + time_exposed_newborns(B).
On the other hand, if the stock of population/portfolio is referenced at the end of the target year
(`type = "backward"`), the total time exposed at risk for each age in each age and seasonal quarter is
computed slightly different: time_exposed_stock(P) - time_exposed_outs(I) + time_exposed_outs(E) + time_exposed_outs(D).
In the above expressions P, I, E, D and B represent, respectively, stocks of population/portfolio,
immigrants/new policies, emigrants/exits, deaths and births after being transformed using the
function \code{\link{quarterly_variables}}.
}
\examples{
\dontrun{
# Do not run, it can take a while
 t.stock <- time_exposed_stock(pop_2006$date.birth, 2006, "forward")
 t.stock <- t.stock[t.stock$age <= 100, ]
 temp <- quarterly_variables(death_2006$date.birth, death_2006$date.death)
 e.death <- count_events_quarter(temp)
 e.death <- e.death[e.death$age <= 100, ]
 t.birth <- time_exposed_newborns(birth_2006$date.birth)
 out <- crude_mx(t.stock, e.death, time.birth = t.birth)
}
dates.b <- c("2017-05-13", "2018-04-12", "2018-12-01")
t.stock <- time_exposed_stock(dates.b, year = 2020, type = "backward")
dates.bd <- c("2018-04-12")
dates.d <- c("2020-05-23")
x <- quarterly_variables(dates.bd, dates.d)
e.death <- count_events_quarter(x)
t.death <- time_exposed_outs(x)
out <- crude_mx(t.stock, e.death, t.death)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\seealso{
\code{\link{crude_mx_sh2}}, \code{\link{crude_mx_sh2}}.
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
