% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sxtMap.R
\name{sxtMap}
\alias{sxtMap}
\title{sxtMap}
\usage{
sxtMap(x)
}
\arguments{
\item{x}{(character or numeric) A vector of encoding characters, bit-patterns
or indices. Note: indices are vector indices, not interpreted bit-patterns,
i.e \code{sxtMap("000000") == sxtMap(1)}}
}
\value{
(character) A vector of Base 64 characters or their corresponding
  bit-patterns.
}
\description{
\code{sxtMap} maps 6-character bit patterns to their corresponding Base64
characters (an "sextet"), or characters back to bit patterns.
}
\section{Description}{
 If the input is a vector of 6-character bit patterns,
  \code{sxtMap} returns the corresponding character from the Base64
  binary-to-text encoding. If the input is a vector of 1-character strings
  \code{sxtMap} returns the corresponding bit pattern. If the input is
  numeric, it is interpreted as indices into the sxt vector. The returned
  vector has the same length as the input but no checking for valid input is
  done.
}

\section{Base64}{
 Base64 is a binary to text encoding specified in
  \href{https://tools.ietf.org/html/rfc4648}{RFC 1738}; we use the URL and
  filename-safe alphabet version with the following encoding from
  \code{000000} to \code{111111}:
  \code{"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"}
  This is safe for most applications; one exception is Microsoft Excel where
  strings that begin with a \code{"-"} are silently convert to formulas.
  (QQIDs are not affected by this problem since they always begin with
  a lowercase alphabetic character.)
}

\examples{
# sxtMap three bit patterns
sxtMap(c("101101", "011011", "010110"))   # "t"    "b"    "W"

# sxtMap three encoding characters
sxtMap(c("a", "b", "c"))  # "011010" "011011" "011100"

# print the entire r64 vector as one string
paste0(sxtMap(1:64), collapse = "")

}
\author{
(c) 2019 \href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe},
licensed under MIT (see file \code{LICENSE} in this package).
}
