/* C function for computing a Sobol sequence **********************************/

#include "sobol.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* Primitive polynomials (one for each dimension) */
static int poly[sobolMaxDim] =
{1, 3, 7, 11, 13, 19, 25, 31, 37,
                           41, 47, 61, 55, 59, 67, 97, 73, 87,
                           117, 91, 109, 103, 115, 131, 193, 137, 145,
                           143, 241, 157, 185, 167, 229, 171, 213, 191,
                           253, 203, 211, 239, 247, 283, 433, 285, 369,
                           299, 425, 301, 361, 313, 319, 505, 333, 357,
                           351, 501, 355, 397, 375, 477, 379, 445, 391,
                           451, 395, 419, 415, 499, 463, 487, 471, 515,
                           769, 529, 545, 535, 929, 539, 865, 557, 721,
                           563, 817, 587, 841, 601, 617, 607, 1001, 613,
                           665, 623, 985, 631, 953, 637, 761, 647, 901,
                           661, 677, 675, 789, 687, 981, 695, 949, 701,
                           757, 719, 973, 731, 877, 787, 803, 799, 995,
                           827, 883, 847, 971, 859, 875, 895, 1019, 911,
                           967, 1033, 1153, 1039, 1921, 1051, 1729, 1053, 1473,
                           1063, 1825, 1069, 1441, 1077, 1377, 1095, 1809, 1107,
                           1617, 1123, 1585, 1125, 1329, 1135, 1969, 1163, 1673,
                           1177, 1225, 1193, 1199, 1961, 1221, 1305, 1239, 1881,
                           1255, 1849, 1261, 1465, 1267, 1657, 1279, 2041, 1291,
                           1669, 1293, 1413, 1311, 1989, 1315, 1573, 1341, 1509,
                           1347, 1557, 1367, 1877, 1383, 1845, 1387, 1717, 1423,
                           1933, 1431, 1869, 1435, 1741, 1451, 1709, 1479, 1821,
                           1527, 1917, 1531, 1789, 1555, 1603, 1571, 1591, 1891,
                           1615, 1939, 1627, 1747, 1663, 2035, 1703, 1835, 1727,
                           2027, 1759, 2011, 1783, 1915, 1807, 1927, 1815, 1863,
                           2047, 2053, 2561, 2071, 3713, 2091, 3393, 2093, 2881,
                           2119, 3617, 2147, 3169, 2149, 2657, 2161, 2273, 2171,
                           3553, 2189, 2833, 2197, 2705, 2207, 3985, 2217, 2385,
                           2225, 2257, 2243, 3121, 2255, 3889, 2279, 3697, 2283,
                           3441, 2293, 2801, 2317, 2825, 2323, 3209, 2341, 2633,
                           2345, 2377, 2359, 3785, 2363, 3529, 2365, 3017, 2373,
                           2601, 2395, 3497, 2419, 3305, 2421, 2793, 2431, 4073,
                           2435, 3097, 2447, 3865, 2475, 3417, 2477, 2905, 2489,
                           2521, 2503, 3641, 2533, 2681, 2543, 3961, 2551, 3833,
                           2567, 3589, 2579, 3205, 2581, 2693, 2669, 2917, 2687,
                           4069, 2717, 2965, 2727, 3669, 2731, 3413, 2739, 3285,
                           2741, 2773, 2783, 4021, 2787, 3189, 2799, 3957, 2811,
                           3573, 2819, 3085, 2867, 3277, 2879, 4045, 2891, 3373,
                           2911, 4013, 2927, 3949, 2941, 3053, 2951, 3613, 2955,
                           3357, 2963, 3229, 2991, 3933, 2999, 3805, 3005, 3037,
                           3035, 3517, 3047, 3709, 3083, 3331, 3103, 3971, 3159,
                           3747, 3179, 3427, 3187, 3299, 3223, 3731, 3227, 3475,
                           3251, 3283, 3263, 4051, 3271, 3635, 3319, 3827, 3343,
                           3851, 3367, 3659, 3399, 3627, 3439, 3947, 3487, 3995,
                           3515, 3547, 3543, 3771, 3559, 3707, 3583, 4091, 3623,
                           3655, 3679, 4007, 3743, 3991, 3791, 3895, 4105, 4609,
                           4119, 7425, 4129, 4225, 4147, 6529, 4149, 5505, 4159,
                           8065, 4173, 5697, 4179, 6465, 4201, 4801, 4215, 7617,
                           4219, 7105, 4221, 6081, 4235, 6689, 4249, 4897, 4259,
                           6305, 4261, 5281, 4303, 7777, 4305, 4449, 4331, 6881,
                           4333, 5857, 4351, 8161, 4359, 7185, 4383, 7953, 4387,
                           6289, 4401, 4497, 4407, 7569, 4411, 7057, 4431, 7761,
                           4439, 7505, 4459, 6865, 4461, 5841, 4473, 5073, 4483,
                           6193, 4485, 5169, 4523, 6833, 4531, 6577, 4569, 4977,
                           4575, 8049, 4579, 6385, 4591, 7921, 4593, 4621, 5641,
                           4627, 6409, 4633, 4873, 4645, 5257, 4663, 7561, 4667,
                           7049, 4669, 6025, 4675, 6217, 4677, 5193, 4711, 7369,
                           4717, 5833, 4723, 6601, 4735, 8137, 4789, 5545, 4793,
                           5033, 4811, 6761, 4879, 7705, 4891, 6937, 4893, 5913,
                           4915, 6553, 4921, 5017, 4927, 8089, 4941, 5721, 4965,
                           5337, 5023, 7993, 5027, 6329, 5039, 7865, 5051, 7097,
                           5059, 6265, 5079, 7545, 5085, 6009, 5107, 6649, 5109,
                           5625, 5127, 7173, 5139, 6405, 5175, 7557, 5199, 7749,
                           5211, 6981, 5213, 5957, 5223, 7365, 5227, 6853, 5237,
                           5573, 5247, 8133, 5287, 7333, 5293, 5797, 5301, 5541,
                           5325, 5733, 5331, 6501, 5343, 8037, 5349, 5391, 7701,
                           5405, 5909, 5451, 6741, 5453, 5717, 5523, 6453, 5563,
                           7093, 5591, 7541, 5597, 6005, 5611, 6901, 5635, 6157,
                           5659, 6925, 5695, 8077, 5703, 7245, 5707, 6733, 5731,
                           6349, 5743, 7885, 5779, 6445, 5821, 6061, 5827, 6253,
                           5863, 7405, 5875, 6637, 5887, 8173, 5899, 6685, 5949,
                           6045, 5955, 6237, 5967, 7773, 5975, 7517, 5981, 6003,
                           6621, 6031, 7741, 6039, 7485, 6067, 6589, 6079, 8125,
                           6111, 8061, 6139, 7165, 6151, 7171, 6175, 7939, 6179,
                           6275, 6199, 7555, 6231, 7491, 6271, 8131, 6295, 7459,
                           6347, 6755, 6383, 7907, 6395, 7139, 6427, 6931, 6475,
                           6739, 6495, 8019, 6511, 7891, 6523, 7123, 6539, 6707,
                           6583, 7603, 6607, 7795, 6631, 7411, 6683, 6923, 6699,
                           6795, 6751, 8011, 6779, 7115, 6887, 7403, 6891, 6943,
                           7963, 6959, 7835, 6999, 7515, 7055, 7739, 7079, 7355,
                           7103, 8123, 7183, 7687, 7191, 7431, 7207, 7303, 7263,
                           8007, 7327, 7975, 7351, 7591, 7375, 7783, 7383, 7527,
                           7471, 7831, 7663, 7927, 7727, 7823, 7871, 8111, 8191,
                           8219, 13825, 8231, 14593, 8245, 11009, 8275, 12929, 8293,
                           10625, 8303, 15745, 8331, 13377, 8333, 11329, 8351, 15937,
                           8357, 10561, 8367, 15681, 8379, 14145, 8381, 12097, 8387,
                           12481, 8393, 9409, 8417, 8641, 8435, 13249, 8461, 11297,
                           8469, 10785, 8489, 9505, 8495, 15649, 8507, 14113, 8515,
                           12449, 8551, 14753, 8555, 13729, 8569, 10145, 8585, 9313,
                           8599, 14945, 8605, 11873, 8639, 16225, 8647, 14561, 8653,
                           11489, 8671, 16097, 8675, 12769, 8689, 9185, 8699, 14305,
                           8729, 9745, 8741, 10513, 8759, 15121, 8765, 12049, 8771,
                           12433, 8795, 13969, 8797, 11921, 8825, 10129, 8831, 16273,
                           8841, 9297, 8855, 14929, 8859, 13905, 8883, 13137, 8895,
                           16209, 8909, 11473, 8943, 15825, 8951, 15313, 8955, 14289,
                           8965, 10289, 8999, 14641, 9003, 13617, 9031, 14513, 9045,
                           10929, 9049, 9905, 9071, 15793, 9073, 9137, 9085, 12209,
                           9095, 14449, 9101, 11377, 9109, 10865, 9123, 12657, 9129,
                           9585, 9143, 15217, 9147, 14193, 9197, 11761, 9209, 10225,
                           9227, 13321, 9235, 12809, 9247, 15881, 9253, 10505, 9257,
                           9481, 9277, 12041, 9303, 14985, 9325, 11657, 9343, 16265,
                           9347, 12361, 9371, 13897, 9373, 11849, 9397, 11081, 9407,
                           16201, 9415, 14537, 9419, 13513, 9443, 12745, 9495, 14889,
                           9501, 11817, 9517, 11561, 9529, 10025, 9555, 12969, 9557,
                           10921, 9571, 12713, 9591, 15273, 9607, 14441, 9611, 13417,
                           9621, 10857, 9625, 9833, 9631, 15977, 9647, 15721, 9661,
                           12137, 9669, 10473, 9679, 15593, 9687, 15081, 9707, 13801,
                           9731, 12313, 9733, 10265, 9773, 11545, 9791, 16153, 9803,
                           13465, 9811, 12953, 9817, 9881, 9847, 15257, 9851, 14233,
                           9863, 14425, 9875, 12889, 9911, 15193, 9917, 12121, 9923,
                           12505, 9963, 13785, 9973, 11225, 10003, 12857, 10043, 14137,
                           10063, 15545, 10071, 15033, 10077, 11961, 10091, 13753, 10099,
                           13241, 10105, 10169, 10115, 12409, 10183, 14585, 10187, 13561,
                           10207, 16121, 10223, 15865, 10247, 14341, 10271, 15877, 10275,
                           12549, 10299, 14085, 10301, 12037, 10309, 10373, 10343, 14725,
                           10357, 11141, 10411, 13637, 10413, 11589, 10431, 16197, 10445,
                           11461, 10453, 10949, 10463, 16069, 10467, 12741, 10491, 14277,
                           10511, 15397, 10523, 13861, 10539, 13605, 10549, 11045, 10559,
                           16165, 10571, 13477, 10581, 10917, 10615, 15269, 10621, 12197,
                           10643, 12901, 10655, 15973, 10671, 15717, 10679, 15205, 10685,
                           12133, 10691, 12517, 10711, 15077, 10739, 13285, 10741, 11237,
                           10755, 12309, 10767, 15381, 10781, 11797, 10803, 13077, 10805,
                           11029, 10829, 11413, 10863, 15765, 10875, 14229, 10877, 12181,
                           10967, 15061, 10971, 14037, 10987, 13781, 10995, 13269, 11043,
                           12597, 11055, 15669, 11063, 15157, 11075, 12469, 11117, 11701,
                           11135, 16309, 11159, 14965, 11163, 13941, 11181, 11637, 11187,
                           13173, 11261, 12277, 11279, 15373, 11307, 13581, 11309, 11533,
                           11327, 16141, 11341, 11405, 11403, 13389, 11427, 12621, 11439,
                           15693, 11453, 12109, 11479, 15053, 11495, 14797, 11499, 13773,
                           11567, 15661, 11575, 15149, 11579, 14125, 11611, 13997, 11623,
                           14765, 11663, 15469, 11687, 14701, 11691, 13677, 11747, 12781,
                           11773, 12269, 11783, 14365, 11795, 12829, 11855, 15517, 11867,
                           13981, 11869, 11933, 11883, 13725, 11919, 15453, 11927, 14941,
                           11947, 13661, 11955, 13149, 11999, 16093, 12027, 14301, 12029,
                           12253, 12055, 14909, 12095, 16189, 12107, 13501, 12127, 16061,
                           12207, 15741, 12239, 15613, 12263, 14845, 12287, 16381, 12295,
                           14339, 12335, 15619, 12367, 15491, 12391, 14723, 12415, 16259,
                           12479, 16195, 12499, 12995, 12527, 15811, 12559, 15395, 12615,
                           14499, 12639, 16035, 12643, 12707, 12667, 14243, 12727, 15203,
                           12763, 14051, 12779, 13795, 12787, 13283, 12799, 16355, 12815,
                           15379, 12839, 14611, 12875, 13459, 12883, 12947, 12959, 15955,
                           12983, 15187, 12987, 14163, 13015, 15059, 13019, 14035, 13031,
                           14803, 13063, 14387, 13103, 15667, 13207, 14963, 13211, 13939,
                           13227, 13683, 13255, 14579, 13303, 15347, 13307, 14323, 13339,
                           13835, 13351, 14603, 13407, 16011, 13431, 15243, 13435, 14219,
                           13447, 14411, 13531, 14027, 13543, 14795, 13599, 15915, 13623,
                           15147, 13647, 15531, 13695, 16299, 13807, 15851, 13855, 15899,
                           13871, 15643, 13883, 14107, 13915, 13979, 14063, 15835, 14095,
                           15419, 14151, 14523, 14199, 15291, 14287, 15611, 14295, 15099,
                           14359, 14855, 14375, 14599, 14543, 15559, 14671, 15527, 14695,
                           14759, 14743, 14951, 14831, 15847, 14839, 15335, 14895, 15639,
                           15039, 16215, 15071, 16087, 15167, 16183, 15215, 15799, 15223,
                           15287, 15359, 16375, 15391, 15887, 15439, 15503, 15935, 16159,
                           16417, 16897, 16427, 27137, 16435, 26113, 16441, 19969, 16447,
                           32257, 16467, 25857, 16479, 32001, 16485, 21249, 16507, 28417,
                           16519, 28801, 16553, 19073, 16559, 31361, 16571, 28289, 16573,
                           24193, 16591, 31105, 16599, 30081, 16619, 27521, 16627, 26497,
                           16633, 20353, 16651, 26689, 16653, 22593, 16659, 25665, 16699,
                           28225, 16707, 24897, 16713, 18753, 16727, 30017, 16743, 29505,
                           16749, 23361, 16785, 17601, 16795, 27841, 16797, 23745, 16807,
                           29377, 16811, 27329, 16813, 23233, 16821, 22209, 16853, 21953,
                           16857, 19905, 16881, 18369, 16909, 22561, 16965, 20769, 16969,
                           18721, 16983, 29985, 16993, 17185, 17011, 26401, 17017, 20257,
                           17023, 32545, 17027, 24737, 17029, 20641, 17053, 23713, 17057,
                           17095, 29089, 17099, 27041, 17101, 22945, 17123, 25505, 17129,
                           19361, 17135, 31649, 17155, 24673, 17161, 18529, 17179, 27745,
                           17191, 29281, 17215, 32353, 17257, 19297, 17275, 28513, 17277,
                           24417, 17287, 28897, 17301, 21729, 17327, 31457, 17353, 18913,
                           17373, 24033, 17387, 27617, 17389, 23521, 17407, 32737, 17419,
                           26641, 17421, 22545, 17475, 24849, 17501, 23825, 17523, 26385,
                           17545, 18577, 17619, 26001, 17621, 21905, 17631, 32145, 17635,
                           25489, 17649, 18321, 17659, 28561, 17667, 24657, 17673, 18513,
                           17679, 30801, 17707, 27217, 17721, 20049, 17753, 19793, 17775,
                           31569, 17783, 30545, 17789, 24401, 17805, 22737, 17817, 19665,
                           17823, 31953, 17829, 21201, 17847, 30417, 17861, 20945, 17865,
                           18897, 17873, 17879, 30161, 17895, 29649, 17907, 26577, 17919,
                           32721, 17935, 30769, 17949, 23601, 17959, 29233, 17973, 22065,
                           17991, 28977, 18009, 19761, 18019, 25393, 18033, 18225, 18043,
                           28465, 18061, 22705, 18067, 25777, 18069, 21681, 18083, 25265,
                           18085, 21169, 18117, 20913, 18127, 31153, 18139, 28081, 18155,
                           27569, 18175, 32689, 18213, 21105, 18243, 24945, 18255, 31089,
                           18303, 32625, 18313, 18673, 18331, 27889, 18343, 29425, 18357,
                           22257, 18387, 26097, 18393, 19953, 18405, 21489, 18409, 19441,
                           18415, 31729, 18429, 24561, 18451, 25609, 18457, 19465, 18463,
                           31753, 18491, 28169, 18499, 24841, 18523, 27913, 18535, 29449,
                           18559, 32521, 18563, 24713, 18623, 32393, 18631, 29065, 18659,
                           25481, 18679, 30601, 18685, 24457, 18717, 23625, 18733, 23113,
                           18745, 20041, 18771, 25929, 18783, 32073, 18789, 21321, 18793,
                           19273, 18807, 30537, 18823, 28873, 18827, 26825, 18857, 19145,
                           18895, 31177, 18909, 24009, 18919, 29641, 18967, 29737, 18997,
                           22057, 19033, 19753, 19045, 21289, 19067, 28457, 19079, 28841,
                           19083, 26793, 19091, 25769, 19107, 25257, 19119, 31401, 19133,
                           24233, 19165, 23977, 19181, 23465, 19193, 20393, 19231, 31849,
                           19255, 30313, 19291, 28009, 19307, 27497, 19309, 23401, 19315,
                           26473, 19321, 20329, 19333, 20713, 19343, 30953, 19351, 29929,
                           19371, 27369, 19379, 26345, 19385, 20201, 19403, 27113, 19405,
                           23017, 19413, 21993, 19423, 32233, 19451, 28649, 19483, 27673,
                           19485, 23577, 19495, 29209, 19499, 27161, 19519, 32281, 19527,
                           28953, 19531, 26905, 19539, 25881, 19541, 21785, 19557, 21273,
                           19581, 24345, 19597, 22681, 19621, 21145, 19645, 24217, 19653,
                           20889, 19671, 30105, 19693, 23449, 19711, 32665, 19733, 21593,
                           19743, 31833, 19781, 20825, 19791, 31065, 19829, 22361, 19845,
                           20697, 19855, 30937, 19885, 23257, 19891, 26329, 19923, 26073,
                           19963, 28633, 19989, 21561, 20003, 25145, 20023, 30265, 20035,
                           24889, 20075, 27449, 20077, 23353, 20099, 24761, 20123, 27833,
                           20147, 26297, 20179, 26041, 20197, 21433, 20207, 31673, 20253,
                           23673, 20299, 27001, 20309, 21881, 20319, 32121, 20335, 31609,
                           20365, 22777, 20383, 31993, 20389, 21241, 20407, 30457, 20411,
                           28409, 20439, 30201, 20459, 27641, 20461, 23545, 20473, 20487,
                           28677, 20511, 31749, 20517, 20997, 20571, 27909, 20573, 23813,
                           20683, 27013, 20693, 21893, 20707, 25477, 20719, 31621, 20731,
                           28549, 20763, 27717, 20781, 23109, 20799, 32325, 20819, 25925,
                           20831, 32069, 20847, 31557, 20861, 24389, 20875, 26821, 20901,
                           21189, 20919, 30405, 20943, 31173, 20955, 28101, 20971, 27589,
                           20973, 23493, 20981, 22469, 20991, 32709, 21007, 30757, 21037,
                           23077, 21093, 21285, 21131, 26789, 21155, 25253, 21181, 24229,
                           21187, 24997, 21199, 31141, 21223, 29605, 21227, 27557, 21303,
                           30309, 21339, 28005, 21351, 29541, 21365, 22373, 21403, 27877,
                           21405, 23781, 21415, 29413, 21439, 32485, 21447, 29157, 21459,
                           26085, 21477, 21501, 24549, 21507, 24597, 21519, 30741, 21527,
                           29717, 21557, 22037, 21575, 28949, 21599, 32021, 21627, 28437,
                           21645, 22677, 21651, 25749, 21653, 21663, 31893, 21687, 30357,
                           21691, 28309, 21725, 23957, 21739, 27541, 21779, 25685, 21807,
                           31317, 21815, 30293, 21863, 29525, 21867, 27477, 21877, 22357,
                           21887, 32597, 21891, 24789, 21911, 29909, 21933, 23253, 21971,
                           26069, 21983, 32213, 22007, 30677, 22023, 28725, 22029, 22581,
                           22051, 25141, 22063, 31285, 22103, 30005, 22109, 23861, 22171,
                           27829, 22187, 27317, 22189, 23221, 22195, 26293, 22215, 29109,
                           22221, 22965, 22263, 30645, 22267, 28597, 22315, 27253, 22317,
                           23157, 22335, 32373, 22347, 26997, 22371, 25461, 22397, 24437,
                           22419, 25845, 22447, 31477, 22461, 24309, 22467, 25077, 22487,
                           30197, 22503, 29685, 22515, 26613, 22531, 24589, 22573, 23053,
                           22579, 26125, 22591, 32269, 22653, 24333, 22663, 28813, 22667,
                           26765, 22691, 25229, 22703, 31373, 22749, 23949, 22759, 29581,
                           22763, 27533, 22783, 32653, 22803, 25677, 22819, 25165, 22843,
                           28237, 22863, 31053, 22911, 32589, 22927, 30925, 22935, 29901,
                           22941, 23757, 22951, 29389, 22955, 27341, 22987, 27085, 23007,
                           32205, 23037, 24525, 23059, 25645, 23071, 31789, 23099, 28205,
                           23101, 24109, 23107, 24877, 23183, 30893, 23207, 29357, 23251,
                           26029, 23287, 30637, 23311, 30829, 23319, 29805, 23325, 23661,
                           23339, 27245, 23347, 26221, 23395, 25453, 23415, 30573, 23459,
                           25325, 23491, 25069, 23531, 27629, 23559, 28701, 23563, 26653,
                           23607, 30237, 23645, 23837, 23683, 24733, 23743, 32413, 23755,
                           27037, 23859, 26205, 23879, 29021, 23919, 31581, 23943, 28893,
                           23967, 31965, 23971, 25309, 23995, 28381, 24015, 31197, 24027,
                           28125, 24067, 24637, 24079, 30781, 24091, 27709, 24135, 28989,
                           24139, 26941, 24163, 25405, 24189, 24381, 24279, 30141, 24283,
                           28093, 24295, 29629, 24327, 28797, 24351, 31869, 24355, 25213,
                           24387, 24957, 24427, 27517, 24471, 29949, 24491, 27389, 24543,
                           32253, 24547, 25597, 24587, 26627, 24623, 31235, 24655, 30979,
                           24679, 29443, 24683, 27395, 24727, 29827, 24747, 27267, 24755,
                           26243, 24787, 25987, 24823, 30595, 24915, 25923, 24991, 31939,
                           25007, 31427, 25019, 28355, 25051, 28099, 25087, 32707, 25131,
                           27171, 25139, 26147, 25159, 28963, 25187, 25379, 25199, 31523,
                           25247, 31907, 25271, 30371, 25303, 30115, 25307, 28067, 25323,
                           27555, 25331, 26531, 25343, 32675, 25399, 30307, 25435, 28003,
                           25535, 32483, 25583, 31715, 25623, 29715, 25671, 28947, 25739,
                           26771, 25759, 31891, 25831, 29587, 25867, 26707, 25911, 30291,
                           25915, 28243, 25947, 27987, 26023, 29395, 26047, 32467, 26067,
                           26095, 31699, 26103, 30675, 26119, 28723, 26171, 28211, 26191,
                           31027, 26219, 27443, 26227, 26419, 26255, 30899, 26263, 29875,
                           26279, 29363, 26283, 27315, 26335, 32179, 26395, 27763, 26443,
                           26995, 26463, 32115, 26487, 30579, 26543, 31475, 26551, 30451,
                           26599, 29683, 26603, 27635, 26651, 27659, 26667, 27147, 26735,
                           31499, 26743, 30475, 26763, 26783, 31883, 26879, 32651, 26887,
                           28747, 26927, 31307, 26967, 30027, 26987, 27467, 27023, 30923,
                           27035, 27851, 27051, 27339, 27079, 29131, 27143, 28715, 27183,
                           31275, 27227, 27947, 27239, 29483, 27243, 27435, 27287, 29867,
                           27327, 32427, 27375, 31659, 27387, 28587, 27415, 29803, 27463,
                           29035, 27551, 31979, 27575, 30443, 27607, 30187, 27695, 31259,
                           27735, 29979, 27839, 32411, 27847, 29083, 27919, 30811, 27927,
                           29787, 28027, 28507, 28091, 28379, 28199, 29243, 28271, 31547,
                           28283, 28475, 28295, 28859, 28335, 31419, 28343, 30395, 28495,
                           31099, 28503, 30075, 28567, 29947, 28615, 29179, 28639, 32251,
                           28855, 30343, 28879, 31111, 28983, 30279, 29079, 29895, 29119,
                           32455, 29151, 32199, 29175, 30663, 29215, 31783, 29231, 31271,
                           29263, 31015, 29287, 29479, 29327, 30887, 29407, 32167, 29431,
                           30631, 29551, 31591, 29671, 29695, 32743, 29775, 30999, 29783,
                           29975, 29919, 32151, 30071, 30551, 30159, 31191, 30207, 32727,
                           30303, 32055, 30367, 31927, 30383, 31415, 30511, 31351, 30703,
                           31735, 30799, 30991, 30911, 32399, 30943, 32143, 30959, 31631,
                           31087, 31567, 31295, 32303, 31999, 32671, 32383, 32575, 32447,
                           32771, 49153, 32785, 34817, 32791, 59393, 32813, 46081, 32821,
                           44033, 32863, 64001, 32879, 62977, 32887, 60929, 32897, 33025,
                           32903, 57601, 32915, 51457, 32933, 42241, 32945, 36097, 32957,
                           48385, 32963, 49921, 32975, 62209, 32989, 47873, 32999, 59137,
                           33013, 44801, 33023, 65281, 33045, 43137, 33061, 42113, 33111,
                           60033, 33117, 47745, 33121, 34433, 33133, 46721, 33145, 40577,
                           33157, 41345, 33185, 34177, 33191, 58753, 33209, 40321, 33227,
                           54145, 33229, 45953, 33237, 43905, 33247, 64385, 33277, 49025,
                           33299, 51265, 33339, 56385, 33349, 41537, 33407, 65089, 33417,
                           37185, 33423, 61761, 33435, 55617, 33483, 54081, 33497, 39745,
                           33507, 51009, 33521, 36673, 33559, 59585, 33563, 55489, 33579,
                           54465, 33587, 52417, 33607, 58049, 33613, 45761, 33631, 64193,
                           33635, 50881, 33641, 38593, 33649, 36545, 33675, 53697, 33685,
                           43457, 33689, 39361, 33711, 62913, 33723, 56769, 33725, 48577,
                           33733, 41921, 33745, 35777, 33781, 44993, 33817, 38945, 33827,
                           50209, 33839, 62497, 33841, 35873, 33847, 60449, 33865, 37409,
                           33895, 58913, 33901, 46625, 33913, 40481, 33923, 49441, 33925,
                           41249, 33943, 59681, 33953, 34081, 33973, 44321, 34015, 64289,
                           34031, 63265, 34039, 61217, 34043, 57121, 34045, 48929, 34077,
                           47265, 34087, 58529, 34099, 52385, 34119, 58017, 34123, 53921,
                           34143, 64161, 34161, 36513, 34171, 56993, 34189, 45473, 34211,
                           50593, 34225, 36257, 34231, 60833, 34245, 41889, 34249, 37793,
                           34267, 56225, 34285, 47009, 34291, 53153, 34313, 36961, 34321,
                           34913, 34333, 47201, 34347, 54369, 34389, 43617, 34393, 39521,
                           34405, 42593, 34429, 48737, 34451, 51553, 34473, 38241, 34479,
                           62817, 34487, 60769, 34499, 50017, 34523, 56161, 34547, 53089,
                           34559, 65377, 34571, 53473, 34573, 45281, 34581, 43233, 34591,
                           63713, 34601, 38113, 34609, 36065, 34667, 55009, 34693, 41441,
                           34697, 37345, 34703, 61921, 34717, 47585, 34731, 54753, 34733,
                           46561, 34739, 52705, 34751, 64993, 34783, 64481, 34793, 38881,
                           34801, 36833, 34807, 61409, 34823, 57361, 34853, 42001, 34871,
                           60433, 34875, 56337, 34889, 37393, 34909, 47633, 34931, 52753,
                           34937, 40465, 34947, 49425, 34959, 61713, 34961, 35089, 34995,
                           52497, 34997, 44305, 35015, 58129, 35033, 39697, 35075, 49297,
                           35077, 41105, 35081, 37009, 35095, 59537, 35111, 58513, 35173,
                           42641, 35197, 48785, 35221, 43409, 35225, 39313, 35247, 62865,
                           35279, 62353, 35281, 35729, 35291, 56209, 35293, 48017, 35309,
                           46993, 35327, 65425, 35351, 59473, 35385, 40017, 35413, 43601,
                           35427, 50769, 35429, 42577, 35441, 36433, 35451, 56913, 35463,
                           57681, 35467, 53585, 35487, 63825, 35503, 62801, 35505, 36177,
                           35549, 47953, 35595, 53457, 35597, 45265, 35643, 56529, 35645,
                           48337, 35651, 49873, 35693, 46801, 35699, 52945, 35741, 47569,
                           35787, 54225, 35797, 43985, 35801, 39889, 35813, 42961, 35825,
                           36817, 35879, 58417, 35911, 57905, 35925, 43569, 35929, 39473,
                           35939, 50737, 35945, 38449, 35975, 57649, 35987, 51505, 36003,
                           50481, 36009, 38193, 36027, 56625, 36041, 37681, 36075, 55089,
                           36103, 57521, 36107, 53425, 36133, 42161, 36143, 62641, 36163,
                           49841, 36187, 55985, 36205, 46769, 36223, 65201, 36229, 41393,
                           36233, 37297, 36251, 55729, 36287, 64945, 36299, 54193, 36301,
                           46001, 36325, 42929, 36329, 38833, 36335, 63409, 36343, 61361,
                           36363, 53361, 36383, 63601, 36411, 56433, 36439, 60017, 36467,
                           52849, 36469, 44657, 36495, 61809, 36503, 59761, 36507, 55665,
                           36543, 64881, 36563, 52081, 36575, 64369, 36581, 42865, 36603,
                           57201, 36623, 61681, 36647, 58609, 36651, 54513, 36665, 40177,
                           36691, 51953, 36693, 43761, 36709, 42737, 36727, 61169, 36733,
                           48881, 36773, 42481, 36791, 60913, 36797, 48625, 36809, 37873,
                           36839, 59377, 36875, 53257, 36889, 38921, 36895, 63497, 36901,
                           41993, 36919, 60425, 36925, 48137, 36931, 49673, 36951, 59913,
                           36973, 46601, 36981, 44553, 37001, 37129, 37019, 55561, 37021,
                           47369, 37037, 46345, 37091, 50953, 37125, 41097, 37135, 61577,
                           37143, 59529, 37147, 55433, 37149, 47241, 37197, 45705, 37239,
                           61065, 37243, 56969, 37273, 39305, 37283, 50569, 37289, 38281,
                           37309, 48521, 37327, 62345, 37379, 49225, 37403, 55369, 37415,
                           58441, 37427, 52297, 37439, 64585, 37453, 45641, 37459, 51785,
                           37471, 64073, 37499, 56905, 37511, 57673, 37525, 43337, 37539,
                           50505, 37559, 60745, 37577, 37705, 37597, 47945, 37621, 44873,
                           37625, 40777, 37651, 51401, 37687, 60617, 37701, 41673, 37719,
                           60105, 37747, 52937, 37759, 65225, 37763, 49609, 37789, 47561,
                           37813, 44489, 37835, 54217, 37855, 64457, 37871, 63433, 37883,
                           57289, 37903, 61481, 37931, 54313, 37933, 46121, 37941, 44073,
                           37963, 53801, 37971, 51753, 38007, 60969, 38013, 48681, 38027,
                           53545, 38035, 51497, 38041, 39209, 38053, 42281, 38057, 38185,
                           38075, 56617, 38085, 41769, 38103, 60201, 38107, 56105, 38119,
                           59177, 38133, 44841, 38143, 65321, 38151, 57513, 38165, 43177,
                           38205, 48297, 38213, 41641, 38251, 54953, 38299, 55721, 38317,
                           46505, 38349, 45993, 38367, 64425, 38371, 51113, 38377, 38825,
                           38419, 51305, 38421, 43113, 38447, 62569, 38455, 60521, 38461,
                           48233, 38467, 49769, 38493, 47721, 38503, 58985, 38521, 40553,
                           38551, 59753, 38573, 46441, 38603, 54121, 38611, 52073, 38623,
                           64361, 38639, 63337, 38651, 57193, 38661, 41193, 38699, 54505,
                           38709, 44265, 38713, 40169, 38733, 45801, 38755, 50921, 38805,
                           43497, 38815, 63977, 38819, 50665, 38821, 42473, 38875, 56297,
                           38877, 48105, 38899, 53225, 38911, 65513, 38957, 46105, 38983,
                           57881, 39061, 43289, 39065, 39193, 39087, 62745, 39099, 56601,
                           39107, 49945, 39109, 41753, 39127, 60185, 39133, 47897, 39143,
                           59161, 39155, 53017, 39161, 40729, 39179, 53401, 39205, 42137,
                           39215, 62617, 39223, 60569, 39235, 49817, 39237, 41625, 39259,
                           55961, 39277, 46745, 39295, 65177, 39323, 55705, 39353, 40345,
                           39359, 64921, 39371, 54169, 39381, 43929, 39395, 51097, 39397,
                           42905, 39461, 42073, 39503, 62041, 39511, 59993, 39515, 55897,
                           39517, 47705, 39533, 46681, 39545, 40537, 39551, 65113, 39557,
                           41305, 39575, 59737, 39581, 47449, 39595, 54617, 39609, 40281,
                           39623, 58201, 39627, 54105, 39651, 51033, 39675, 57177, 39707,
                           55513, 39725, 46297, 39731, 52441, 39763, 51929, 39775, 64217,
                           39791, 63193, 39799, 61145, 39805, 48857, 39815, 57817, 39819,
                           53721, 39827, 51673, 39863, 60889, 39869, 48601, 39915, 55257,
                           39929, 40921, 39935, 65497, 39957, 43065, 39967, 63545, 39983,
                           62521, 39995, 56377, 39997, 48185, 40029, 47673, 40039, 58937,
                           40051, 52793, 40053, 44601, 40057, 40505, 40069, 41273, 40127,
                           64825, 40135, 58169, 40149, 43833, 40165, 42809, 40183, 61241,
                           40195, 49337, 40277, 43705, 40291, 50873, 40311, 61113, 40331,
                           53689, 40351, 63929, 40357, 42425, 40381, 48569, 40451, 49273,
                           40471, 59513, 40487, 58489, 40519, 57977, 40533, 43641, 40543,
                           64121, 40547, 50809, 40607, 63865, 40611, 50553, 40685, 46969,
                           40691, 53113, 40715, 53497, 40723, 51449, 40739, 50425, 40751,
                           62713, 40783, 62201, 40807, 59129, 40859, 55801, 40877, 46585,
                           40883, 52729, 40885, 44537, 40909, 46073, 40951, 61433, 40971,
                           53253, 40981, 43013, 40995, 50181, 40997, 41989, 41007, 62469,
                           41027, 49669, 41051, 55813, 41053, 47621, 41063, 58885, 41067,
                           54789, 41069, 46597, 41087, 65029, 41127, 58629, 41141, 44293,
                           41165, 45829, 41183, 64261, 41211, 57093, 41219, 49285, 41231,
                           61573, 41245, 47237, 41255, 58501, 41267, 52357, 41269, 44165,
                           41287, 57989, 41327, 63109, 41339, 56965, 41375, 63877, 41413,
                           41861, 41423, 62341, 41487, 61509, 41501, 47173, 41517, 46149,
                           41525, 44101, 41543, 57925, 41557, 43589, 41571, 50757, 41583,
                           63045, 41659, 56645, 41661, 48453, 41669, 41797, 41687, 60229,
                           41691, 56133, 41709, 46917, 41735, 57541, 41739, 53445, 41741,
                           45253, 41759, 63685, 41763, 50373, 41835, 54981, 41843, 52933,
                           41871, 61893, 41879, 59845, 41907, 52677, 41933, 46021, 41941,
                           43973, 41987, 49189, 42067, 51749, 42085, 42533, 42119, 57637,
                           42123, 53541, 42133, 43301, 42149, 42277, 42159, 62757, 42173,
                           48421, 42179, 49957, 42203, 56101, 42219, 55077, 42221, 46885,
                           42275, 50341, 42319, 62117, 42355, 52901, 42371, 49573, 42407,
                           58789, 42439, 58277, 42445, 45989, 42491, 57253, 42515, 51301,
                           42543, 62565, 42551, 60517, 42557, 48229, 42611, 52837, 42651,
                           55653, 42653, 47461, 42695, 58213, 42749, 48997, 42779, 55525,
                           42795, 54501, 42847, 64229, 42893, 45541, 42939, 56805, 42941,
                           48613, 42959, 62437, 42973, 48101, 42983, 59365, 43051, 54293,
                           43059, 52245, 43083, 53781, 43085, 45589, 43093, 43541, 43119,
                           62997, 43133, 48661, 43155, 51477, 43167, 63765, 43171, 50453,
                           43191, 60693, 43215, 62229, 43229, 47893, 43243, 55061, 43275,
                           53397, 43283, 51349, 43381, 44693, 43431, 58773, 43437, 46485,
                           43455, 64917, 43503, 63381, 43511, 61333, 43533, 45141, 43567,
                           62549, 43587, 49749, 43599, 62037, 43677, 47445, 43691, 54613,
                           43693, 46421, 43699, 52565, 43731, 52053, 43743, 64341, 43779,
                           49365, 43791, 61653, 43805, 47317, 43829, 44245, 43847, 58069,
                           43875, 50901, 43901, 48853, 43915, 53717, 43963, 56789, 43991,
                           60373, 43995, 56277, 44007, 59349, 44019, 53205, 44039, 57397,
                           44045, 45109, 44051, 51253, 44087, 60469, 44091, 56373, 44123,
                           55861, 44141, 46645, 44147, 52789, 44159, 65077, 44175, 61749,
                           44183, 59701, 44231, 58165, 44255, 64309, 44285, 48949, 44315,
                           55477, 44363, 53941, 44365, 45749, 44399, 63157, 44451, 50613,
                           44463, 62901, 44509, 48053, 44519, 59317, 44523, 55221, 44573,
                           47221, 44589, 46197, 44607, 64629, 44621, 45685, 44639, 64117,
                           44643, 50805, 44663, 61045, 44667, 56949, 44685, 45429, 44707,
                           50549, 44731, 56693, 44759, 60277, 44765, 47989, 44775, 59253,
                           44789, 44917, 44819, 51445, 44831, 63733, 44847, 62709, 44859,
                           56565, 44867, 49909, 44903, 59125, 44943, 61941, 44957, 47605,
                           44971, 54773, 45011, 52213, 45027, 51189, 45047, 61429, 45053,
                           49141, 45071, 61453, 45083, 55309, 45101, 46093, 45119, 64525,
                           45175, 60941, 45197, 45325, 45203, 51469, 45231, 62733, 45251,
                           49933, 45299, 53005, 45319, 57485, 45323, 53389, 45373, 48269,
                           45399, 60045, 45405, 47757, 45455, 61837, 45463, 59789, 45469,
                           47501, 45511, 58253, 45535, 64397, 45579, 53325, 45587, 51277,
                           45635, 49741, 45647, 62029, 45695, 65101, 45723, 55629, 45791,
                           64333, 45807, 63309, 45815, 61261, 45847, 59597, 45863, 58573,
                           45923, 50893, 45947, 57037, 45971, 51661, 46007, 60877, 46039,
                           60365, 46043, 56269, 46045, 48077, 46111, 63533, 46147, 49709,
                           46167, 59949, 46189, 46637, 46207, 65069, 46247, 58669, 46271,
                           64813, 46319, 63277, 46327, 61229, 46365, 47277, 46387, 52397,
                           46399, 64685, 46407, 58029, 46419, 51885, 46455, 61101, 46459,
                           57005, 46523, 56749, 46531, 50093, 46551, 60333, 46567, 59309,
                           46571, 55213, 46615, 59501, 46619, 55405, 46631, 58477, 46643,
                           52333, 46667, 53869, 46715, 56941, 46731, 53613, 46767, 62829,
                           46823, 59245, 46827, 55149, 46855, 57581, 46879, 63725, 46935,
                           60141, 46939, 56045, 46955, 55021, 46979, 49645, 46999, 59885,
                           47005, 47597, 47027, 52717, 47051, 54253, 47101, 49133, 47135,
                           63517, 47183, 61981, 47261, 47389, 47295, 64797, 47315, 51997,
                           47355, 57117, 47363, 49309, 47399, 58525, 47403, 54429, 47431,
                           58013, 47479, 61085, 47535, 62877, 47547, 56733, 47555, 50077,
                           47603, 53149, 47631, 61533, 47659, 54365, 47727, 63069, 47751,
                           57693, 47763, 51549, 47799, 60765, 47831, 60253, 47859, 53085,
                           47871, 65373, 47879, 57565, 47907, 50397, 47933, 48349, 47939,
                           49885, 47951, 62173, 47963, 56029, 47975, 59101, 48063, 64989,
                           48075, 54237, 48179, 52285, 48227, 50749, 48251, 56893, 48267,
                           53565, 48287, 63805, 48323, 49981, 48403, 51389, 48431, 62653,
                           48439, 60605, 48487, 59069, 48511, 65213, 48515, 49597, 48595,
                           52157, 48647, 57469, 48675, 50301, 48695, 60541, 48727, 60029,
                           48731, 55933, 48747, 54909, 48767, 65149, 48771, 49533, 48811,
                           54653, 48919, 59645, 48935, 58621, 48947, 52477, 48979, 51965,
                           49035, 53757, 49059, 50685, 49079, 60925, 49091, 50173, 49115,
                           56317, 49151, 65533, 49159, 57347, 49171, 51203, 49183, 63491,
                           49267, 52739, 49303, 59651, 49319, 58627, 49355, 54019, 49379,
                           50947, 49403, 57091, 49459, 52355, 49471, 64643, 49483, 53891,
                           49503, 64131, 49519, 63107, 49527, 61059, 49531, 56963, 49555,
                           51587, 49603, 50051, 49627, 56195, 49639, 59267, 49687, 59459,
                           49747, 51779, 49871, 62275, 49967, 62659, 50007, 60099, 50011,
                           56003, 50035, 52931, 50075, 55747, 50091, 54723, 50111, 64963,
                           50119, 58307, 50147, 51139, 50159, 63427, 50227, 52259, 50247,
                           57891, 50251, 53795, 50271, 64035, 50287, 63011, 50323, 51491,
                           50335, 63779, 50359, 60707, 50391, 60195, 50411, 55075, 50431,
                           65315, 50443, 53411, 50479, 62627, 50523, 55971, 50587, 55715,
                           50611, 52643, 50623, 64931, 50635, 54179, 50655, 64419, 50671,
                           63395, 50735, 62563, 50795, 54883, 50831, 61795, 50839, 59747,
                           50859, 54627, 50867, 52579, 50887, 58211, 50915, 51043, 50939,
                           57187, 51027, 51939, 51063, 61155, 51103, 63971, 51159, 60387,
                           51163, 56291, 51227, 55315, 51295, 64019, 51455, 65299, 51487,
                           63635, 51511, 60563, 51515, 56467, 51547, 55955, 51583, 65171,
                           51599, 61843, 51627, 54675, 51655, 58259, 51659, 54163, 51759,
                           62547, 51815, 58963, 51855, 61779, 51903, 64851, 51951, 63315,
                           51991, 59603, 51995, 55507, 52011, 54483, 52031, 64723, 52091,
                           57043, 52103, 57811, 52183, 60371, 52199, 59347, 52231, 57395,
                           52315, 55859, 52351, 65075, 52379, 55603, 52391, 58675, 52403,
                           52531, 52471, 61235, 52475, 57139, 52523, 54451, 52591, 63155,
                           52615, 57779, 52639, 63923, 52663, 60851, 52687, 62387, 52695,
                           60339, 52715, 55219, 52735, 65459, 52775, 58483, 52847, 63091,
                           52895, 63859, 52923, 56691, 52951, 60275, 52979, 53107, 52991,
                           65395, 53023, 63731, 53039, 62707, 53099, 55027, 53135, 61939,
                           53147, 55795, 53163, 54771, 53191, 58355, 53239, 61427, 53311,
                           64523, 53319, 57867, 53367, 60939, 53383, 57611, 53387, 53515,
                           53455, 62219, 53463, 60171, 53551, 62603, 53595, 55947, 53659,
                           55691, 53695, 64907, 53743, 63371, 53767, 57419, 53791, 63563,
                           53815, 60491, 53847, 59979, 53867, 54859, 53903, 61771, 53963,
                           54091, 54039, 59595, 54055, 58571, 54111, 64203, 54135, 61131,
                           54139, 57035, 54247, 59339, 54331, 56363, 54379, 54827, 54423,
                           59691, 54443, 54571, 54463, 64811, 54543, 61611, 54555, 55467,
                           54567, 58539, 54599, 58027, 54711, 60843, 54759, 59307, 54823,
                           58475, 54879, 64107, 54895, 63083, 54919, 57707, 54967, 60779,
                           54999, 60267, 55143, 59115, 55167, 65259, 55231, 65003, 55287,
                           61419, 55291, 57323, 55383, 59931, 55439, 61723, 55451, 55579,
                           55463, 58651, 55495, 58139, 55623, 58011, 55647, 64155, 55711,
                           63899, 55767, 60315, 55831, 59483, 55847, 58459, 55871, 64603,
                           56071, 57563, 56095, 63707, 56123, 56539, 56143, 62171, 56263,
                           58331, 56287, 64475, 56303, 63451, 56315, 57307, 56431, 63035,
                           56479, 63803, 56495, 62779, 56535, 60219, 56663, 60091, 56679,
                           59067, 56823, 61371, 56827, 57275, 56839, 57467, 56879, 62587,
                           56911, 62075, 57111, 59643, 57199, 63227, 57359, 61447, 57415,
                           57863, 57439, 64007, 57503, 63751, 57527, 60679, 57559, 60167,
                           57599, 65287, 57679, 62087, 57703, 59015, 57727, 65159, 57839,
                           63367, 57935, 62023, 57959, 58951, 57999, 61767, 58047, 64839,
                           58127, 61639, 58231, 61127, 58271, 63943, 58287, 62919, 58295,
                           60871, 58367, 65479, 58399, 63527, 58519, 59687, 58591, 64295,
                           58647, 59559, 58799, 62887, 58855, 59303, 58943, 64615, 59095,
                           60263, 59279, 61927, 59383, 61415, 59439, 62487, 59471, 61975,
                           59583, 64791, 59663, 61591, 59743, 64151, 59831, 60823, 59855,
                           62359, 59863, 60311, 60119, 60247, 60159, 65367, 60511, 64055,
                           60591, 62775, 60599, 60727, 60623, 62263, 60671, 65335, 60895,
                           64439, 60911, 63415, 60959, 63607, 61175, 61303, 61199, 61687,
                           61343, 63991, 61471, 63503, 61487, 62479, 61631, 64783, 61663,
                           64271, 61951, 65423, 62063, 63055, 62111, 63823, 62207, 65359,
                           62255, 62671, 62431, 64463, 62911, 64943, 63007, 63599, 63215,
                           63343, 63295, 64751, 63487, 65519, 63551, 64543, 64127, 65119,
                           64223, 64351, 65279, 65407, 65579, 108545, 65581, 92161, 65593,
                           79873, 65599, 129025, 65607, 115713, 65619, 103425, 65677, 90625,
                           65725, 96769, 65751, 120321, 65781, 89601, 65833, 76033, 65839,
                           125185, 65851, 112897, 65853, 96513, 65871, 124161, 65885, 95489,
                           65907, 105729, 65909, 89345, 65935, 123649, 65943, 119553, 65953,
                           68353, 65965, 92929, 65983, 129793, 65991, 116481, 65997, 91905,
                           66005, 87809, 66025, 77569, 66039, 122625, 66069, 86145, 66073,
                           77953, 66085, 84097, 66095, 125057, 66139, 111745, 66141, 95361,
                           66155, 109697, 66157, 93313, 66165, 89217, 66181, 82561, 66193,
                           70273, 66209, 68225, 66227, 105089, 66253, 91777, 66259, 104065,
                           66277, 85633, 66295, 122497, 66299, 114305, 66327, 119169, 66333,
                           94593, 66357, 88449, 66361, 80257, 66379, 107905, 66381, 91521,
                           66409, 77185, 66415, 126337, 66417, 73089, 66439, 115585, 66445,
                           91009, 66463, 127873, 66467, 101249, 66491, 113537, 66511, 124801,
                           66525, 96129, 66541, 94081, 66553, 81793, 66571, 106561, 66597,
                           84033, 66601, 75841, 66647, 119873, 66657, 68673, 66663, 117825,
                           66669, 93249, 66691, 98881, 66697, 74305, 66705, 70209, 66727,
                           117313, 66733, 92737, 66741, 88641, 66751, 129601, 66753, 67137,
                           66813, 97857, 66825, 74049, 66867, 104769, 66873, 80193, 66887,
                           116033, 66915, 101697, 66917, 85313, 66921, 77121, 66951, 115521,
                           66991, 125761, 67011, 100161, 67023, 124737, 67025, 71489, 67037,
                           96065, 67051, 110401, 67061, 89921, 67065, 81729, 67147, 107713,
                           67155, 103617, 67167, 128193, 67195, 113857, 67197, 97473, 67207,
                           115393, 67211, 107201, 67235, 101057, 67247, 125633, 67267, 100033,
                           67273, 75457, 67317, 89793, 67327, 130753, 67435, 110017, 67437,
                           93633, 67449, 81345, 67455, 130497, 67459, 99265, 67471, 123841,
                           67479, 119745, 67567, 126913, 67569, 73665, 67579, 114625, 67591,
                           114721, 67595, 106529, 67597, 90145, 67605, 86049, 67643, 112673,
                           67681, 68641, 67705, 80929, 67735, 119329, 67741, 94753, 67755,
                           109089, 67775, 129569, 67797, 87585, 67807, 128545, 67811, 101921,
                           67817, 77345, 67825, 73249, 67835, 114209, 67897, 80161, 67929,
                           79137, 67959, 122145, 67965, 97569, 67979, 107297, 68005, 84769,
                           68015, 125729, 68035, 100129, 68037, 83745, 68065, 69409, 68071,
                           118561, 68077, 93985, 68083, 106273, 68099, 98465, 68113, 69793,
                           68149, 88225, 68153, 80033, 68191, 128161, 68195, 101537, 68209,
                           72865, 68221, 97441, 68255, 127649, 68283, 113313, 68293, 83617,
                           68303, 124577, 68317, 95905, 68321, 69281, 68351, 130721, 68371,
                           102817, 68373, 86433, 68433, 71073, 68445, 95649, 68497, 70561,
                           68503, 119713, 68531, 105377, 68557, 92065, 68563, 104353, 68581,
                           85921, 68591, 126881, 68599, 122785, 68605, 98209, 68623, 122977,
                           68637, 94305, 68651, 108641, 68713, 76897, 68721, 72801, 68731,
                           113761, 68749, 90721, 68757, 86625, 68771, 100961, 68783, 125537,
                           68797, 96865, 68829, 95841, 68843, 110177, 68851, 106081, 68877,
                           90465, 68889, 78177, 68895, 127329, 68931, 99681, 68937, 75105,
                           68995, 99169, 69007, 123745, 69009, 70497, 69021, 95073, 69037,
                           93025, 69045, 88929, 69075, 104289, 69091, 102241, 69093, 85857,
                           69155, 100577, 69189, 83169, 69235, 105697, 69247, 130273, 69253,
                           82657, 69265, 70369, 69271, 119521, 69277, 94945, 69287, 117473,
                           69319, 116449, 69323, 108257, 69373, 98017, 69379, 98785, 69381,
                           82401, 69385, 74209, 69403, 111073, 69481, 77281, 69495, 122337,
                           69511, 115681, 69515, 107489, 69525, 87009, 69529, 78817, 69553,
                           72673, 69565, 97249, 69583, 124897, 69595, 112609, 69607, 118753,
                           69611, 110561, 69643, 106513, 69669, 83985, 69693, 96273, 69699,
                           99345, 69711, 123921, 69725, 95249, 69759, 130065, 69763, 98833,
                           69765, 82449, 69783, 119313, 69787, 111121, 69799, 117265, 69813,
                           88593, 69917, 94481, 69927, 117009, 69945, 80145, 69959, 115985,
                           69965, 91409, 69983, 128273, 69999, 126225, 70089, 75537, 70107,
                           112401, 70109, 96017, 70123, 110353, 70125, 93969, 70131, 106257,
                           70137, 81681, 70215, 115857, 70227, 103569, 70229, 87185, 70243,
                           101521, 70263, 122001, 70283, 107153, 70291, 103057, 70297, 78481,
                           70309, 84625, 70319, 125585, 70333, 96913, 70341, 83601, 70359,
                           120465, 70363, 112273, 70381, 93841, 70387, 106129, 70399, 130705,
                           70459, 113041, 70461, 96657, 70481, 71057, 70487, 120209, 70507,
                           109969, 70517, 89489, 70521, 81297, 70557, 95121, 70623, 128913,
                           70647, 122769, 70665, 73809, 70683, 110673, 70707, 104529, 70709,
                           88145, 70731, 107601, 70733, 91217, 70745, 78929, 70751, 128081,
                           70791, 115281, 70803, 102993, 70831, 125521, 70833, 72273, 70857,
                           75345, 70865, 71249, 70893, 93777, 70905, 81489, 70919, 115025,
                           70931, 102737, 71055, 123729, 71079, 117585, 71083, 109393, 71125,
                           87889, 71129, 79697, 71135, 128849, 71139, 102225, 71163, 114513,
                           71199, 127185, 71215, 125137, 71223, 121041, 71229, 96465, 71235,
                           99537, 71237, 83153, 71241, 74961, 71285, 89297, 71299, 99025,
                           71323, 111313, 71339, 109265, 71381, 87761, 71385, 79569, 71415,
                           122577, 71421, 98001, 71439, 123345, 71469, 92625, 71475, 104913,
                           71487, 129489, 71495, 116177, 71501, 91601, 71507, 103889, 71525,
                           85457, 71573, 86993, 71577, 78801, 71587, 101329, 71593, 76753,
                           71639, 120785, 71659, 110545, 71669, 90065, 71723, 108593, 71731,
                           104497, 71765, 87089, 71779, 101425, 71791, 126001, 71815, 115249,
                           71821, 90673, 71827, 102961, 71849, 76337, 71857, 72241, 71863,
                           121393, 71867, 113201, 71887, 124465, 71899, 112177, 71929, 81457,
                           71935, 130609, 71947, 106801, 71971, 100657, 71973, 84273, 71985,
                           71991, 121137, 72027, 111921, 72043, 109873, 72045, 93489, 72053,
                           89393, 72057, 81201, 72115, 105265, 72139, 108337, 72141, 91953,
                           72165, 85809, 72187, 114481, 72189, 98097, 72199, 114865, 72205,
                           90289, 72227, 100529, 72259, 99505, 72279, 119985, 72285, 95409,
                           72299, 109745, 72307, 105649, 72313, 81073, 72329, 74417, 72347,
                           111281, 72383, 129713, 72419, 102065, 72421, 85681, 72457, 74161,
                           72477, 94641, 72487, 117169, 72491, 108977, 72519, 116145, 72523,
                           107953, 72533, 87473, 72537, 79281, 72549, 85425, 72573, 97713,
                           72587, 107441, 72589, 91057, 72595, 103345, 72623, 125873, 72635,
                           113585, 72637, 97201, 72643, 100273, 72663, 120753, 72703, 130993,
                           72711, 114801, 72723, 102513, 72739, 100465, 72745, 75889, 72773,
                           83057, 72783, 124017, 72791, 119921, 72797, 95345, 72831, 130161,
                           72837, 82545, 72861, 94833, 72885, 88689, 72907, 108145, 72909,
                           91761, 72921, 79473, 72937, 77425, 72943, 126577, 72945, 73329,
                           72983, 119153, 72987, 110961, 73005, 92529, 73023, 129393, 73035,
                           107889, 73043, 103793, 73049, 79217, 73055, 128369, 73061, 85361,
                           73065, 77169, 73079, 122225, 73095, 115569, 73161, 75633, 73197,
                           94065, 73215, 130929, 73279, 129265, 73311, 128241, 73339, 113905,
                           73369, 78577, 73375, 127729, 73385, 76529, 73405, 97009, 73411,
                           100081, 73413, 83697, 73423, 124657, 73437, 95985, 73447, 118513,
                           73451, 110321, 73459, 106225, 73491, 102897, 73513, 76273, 73519,
                           125425, 73531, 113137, 73533, 96753, 73559, 120305, 73575, 118257,
                           73581, 93681, 73587, 105969, 73589, 89585, 73603, 99313, 73627,
                           111601, 73629, 95217, 73657, 80881, 73663, 130033, 73741, 90121,
                           73759, 126985, 73765, 83977, 73789, 96265, 73843, 105481, 73871,
                           123401, 73883, 111113, 73899, 109065, 73909, 88585, 73913, 80393,
                           73927, 116233, 73955, 101897, 73989, 82185, 73993, 74011, 110857,
                           74067, 103689, 74083, 101641, 74089, 77065, 74107, 113929, 74119,
                           115465, 74133, 86793, 74153, 76553, 74181, 83721, 74191, 124681,
                           74215, 118537, 74233, 81673, 74263, 118921, 74279, 116873, 74293,
                           88201, 74323, 103561, 74329, 78985, 74335, 128137, 74345, 76937,
                           74363, 113801, 74379, 107145, 74387, 103049, 74389, 86665, 74405,
                           84617, 74415, 125577, 74447, 124553, 74461, 95881, 74471, 118409,
                           74489, 81545, 74517, 86409, 74527, 127369, 74533, 84361, 74537,
                           76169, 74565, 83337, 74583, 120201, 74605, 93577, 74627, 99209,
                           74647, 119689, 74663, 117641, 74681, 80777, 74723, 102281, 74729,
                           77705, 74755, 98377, 74767, 122953, 74797, 92233, 74809, 79945,
                           74815, 129097, 74827, 107593, 74835, 103497, 74893, 90697, 74905,
                           78409, 74911, 127561, 74935, 121417, 74949, 83529, 74983, 118345,
                           75007, 130633, 75029, 86345, 75043, 100681, 75049, 76105, 75067,
                           112969, 75095, 120137, 75101, 95561, 75123, 105801, 75129, 81225,
                           75141, 82761, 75163, 111433, 75199, 129865, 75213, 91977, 75237,
                           85833, 75255, 122697, 75271, 114889, 75285, 86217, 75299, 100553,
                           75325, 96457, 75355, 111817, 75373, 93385, 75381, 89289, 75391,
                           130249, 75395, 99017, 75419, 111305, 75437, 92873, 75497, 77513,
                           75515, 114377, 75563, 109001, 75571, 104905, 75577, 80329, 75609,
                           79305, 75619, 101833, 75655, 115657, 75685, 84937, 75717, 83913,
                           75735, 120777, 75757, 94153, 75763, 106441, 75803, 110633, 75805,
                           94249, 75821, 92201, 75847, 115753, 75899, 113705, 75935, 127529,
                           75939, 100905, 75945, 76329, 75951, 125481, 75973, 83497, 76021,
                           89641, 76043, 106793, 76057, 78121, 76079, 125225, 76091, 112937,
                           76099, 99625, 76101, 83241, 76147, 105769, 76159, 130345, 76163,
                           99113, 76189, 95017, 76205, 92969, 76217, 80681, 76231, 116521,
                           76245, 87849, 76279, 122665, 76325, 84137, 76347, 112809, 76415,
                           130217, 76421, 82601, 76445, 94889, 76455, 117417, 76493, 91817,
                           76501, 87721, 76505, 79529, 76515, 102057, 76521, 77481, 76549,
                           82345, 76583, 117161, 76595, 104873, 76597, 88489, 76627, 103849,
                           76649, 77225, 76655, 126377, 76667, 114089, 76669, 97705, 76691,
                           103337, 76697, 78761, 76719, 125865, 76733, 97193, 76763, 112553,
                           76765, 96169, 76793, 81833, 76807, 114793, 76811, 106601, 76831,
                           127081, 76859, 112745, 76861, 96361, 76867, 99433, 76879, 124009,
                           76893, 95337, 76907, 109673, 76915, 105577, 76921, 81001, 76973,
                           92777, 76985, 80489, 77005, 91753, 77011, 104041, 77027, 101993,
                           77047, 122473, 77051, 114281, 77095, 117097, 77101, 92521, 77109,
                           88425, 77155, 101737, 77157, 85353, 77175, 122217, 77195, 107369,
                           77197, 90985, 77215, 127849, 77275, 112489, 77327, 123113, 77335,
                           119017, 77363, 104681, 77365, 88297, 77383, 115945, 77387, 107753,
                           77389, 91369, 77407, 128233, 77423, 126185, 77453, 90857, 77477,
                           84713, 77509, 83689, 77547, 110313, 77561, 81641, 77567, 130793,
                           77575, 115177, 77587, 102889, 77629, 96745, 77635, 99817, 77659,
                           112105, 77671, 118249, 77695, 130537, 77719, 119785, 77723, 111593,
                           77735, 117737, 77749, 89065, 77759, 130025, 77771, 108521, 77779,
                           104425, 77791, 129001, 77829, 81945, 77847, 118809, 77863, 116761,
                           77899, 107545, 77913, 78873, 77925, 85017, 77943, 121881, 77947,
                           113689, 77949, 97305, 77971, 102937, 77999, 125465, 78007, 121369,
                           78019, 99865, 78043, 112153, 78045, 95769, 78061, 93721, 78069,
                           89625, 78073, 81433, 78087, 114969, 78093, 90393, 78117, 84249,
                           78173, 95513, 78195, 105753, 78247, 117529, 78251, 109337, 78285,
                           91929, 78297, 79641, 78307, 102169, 78331, 114457, 78383, 125081,
                           78391, 120985, 78397, 96409, 78423, 119961, 78427, 111769, 78439,
                           117913, 78453, 89241, 78493, 94873, 78507, 109209, 78509, 92825,
                           78517, 88729, 78539, 108185, 78553, 79513, 78575, 126617, 78597,
                           82329, 78619, 111001, 78635, 108953, 78649, 80281, 78663, 116121,
                           78711, 122265, 78751, 127897, 78789, 83865, 78827, 110489, 78835,
                           106393, 78859, 106585, 78869, 86105, 78885, 84057, 78915, 99417,
                           78975, 130137, 79003, 111193, 79015, 117337, 79039, 129625, 79053,
                           91737, 79101, 97881, 79109, 82265, 79133, 94553, 79155, 104793,
                           79175, 116057, 79179, 107865, 79193, 79229, 97625, 79263, 127833,
                           79267, 101209, 79319, 120665, 79347, 106329, 79375, 123097, 79387,
                           110809, 79389, 94425, 79413, 88281, 79423, 129241, 79471, 126169,
                           79501, 90841, 79543, 121561, 79555, 100057, 79575, 120537, 79597,
                           93913, 79623, 115161, 79627, 106969, 79651, 100825, 79683, 99801,
                           79695, 124377, 79733, 89561, 79737, 81369, 79767, 119769, 79787,
                           109529, 79801, 80857, 79821, 92121, 79829, 88025, 79843, 102361,
                           79885, 90169, 79903, 127033, 79927, 120889, 79951, 123961, 79963,
                           111673, 79965, 95289, 79981, 93241, 80015, 123449, 80071, 116281,
                           80075, 108089, 80077, 91705, 80095, 128569, 80123, 114233, 80151,
                           119097, 80181, 88377, 80191, 129337, 80205, 91449, 80211, 103737,
                           80223, 128313, 80229, 85305, 80239, 126265, 80247, 122169, 80291,
                           101177, 80311, 121657, 80317, 97081, 80363, 110393, 80383, 130873,
                           80411, 110777, 80413, 94393, 80429, 92345, 80435, 104633, 80461,
                           91321, 80469, 87225, 80483, 101561, 80485, 85177, 80503, 122041,
                           80533, 86713, 80543, 127673, 80559, 125625, 80571, 113337, 80573,
                           96953, 80591, 124601, 80627, 106169, 80633, 81593, 80659, 102841,
                           80699, 113081, 80701, 96697, 80709, 83385, 80731, 112057, 80749,
                           93625, 80755, 105913, 80771, 99257, 80797, 95161, 80843, 108473,
                           80851, 104377, 80867, 102329, 80879, 126905, 80901, 82041, 80935,
                           116857, 80967, 115833, 80971, 107641, 81007, 126073, 81043, 103033,
                           81115, 112249, 81139, 106105, 81145, 81529, 81151, 130681, 81159,
                           115065, 81171, 102777, 81187, 100729, 81213, 96633, 81219, 99705,
                           81255, 118137, 81259, 109945, 81261, 93561, 81283, 99193, 81331,
                           105337, 81333, 88953, 81357, 92025, 81391, 126841, 81403, 114553,
                           81419, 106745, 81439, 127225, 81467, 112889, 81475, 99577, 81477,
                           83193, 81495, 120057, 81541, 82681, 81551, 123641, 81619, 104185,
                           81631, 128761, 81659, 114425, 81667, 98809, 81693, 94713, 81803,
                           107513, 81823, 127993, 81829, 84985, 81847, 121849, 81861, 83961,
                           81883, 112633, 81909, 90105, 82037, 89093, 82053, 82437, 82075,
                           111109, 82077, 94725, 82093, 92677, 82125, 91653, 82131, 103941,
                           82147, 101893, 82167, 122373, 82179, 98565, 82239, 129285, 82251,
                           107781, 82259, 103685, 82275, 101637, 82323, 103173, 82351, 125701,
                           82363, 113413, 82365, 97029, 82407, 118533, 82419, 106245, 82431,
                           130821, 82435, 98437, 82507, 107653, 82517, 87173, 82555, 113797,
                           82557, 97413, 82567, 115333, 82597, 84613, 82615, 121477, 82619,
                           113285, 82639, 124549, 82669, 93829, 82695, 115077, 82699, 106885,
                           82723, 100741, 82755, 99717, 82815, 130437, 82819, 99205, 82855,
                           117637, 82879, 129925, 82927, 126853, 82935, 122757, 82939, 114565,
                           82959, 122949, 83015, 115781, 83021, 91205, 83063, 121925, 83067,
                           113733, 83085, 90693, 83093, 86597, 83103, 127557, 83107, 100933,
                           83131, 113221, 83141, 83525, 83211, 106821, 83231, 127301, 83255,
                           121157, 83267, 99653, 83315, 105797, 83343, 123717, 83355, 111429,
                           83357, 95045, 83381, 88901, 83429, 85829, 83447, 122693, 83453,
                           98117, 83491, 100549, 83511, 121029, 83549, 95429, 83571, 105669,
                           83599, 123589, 83659, 108229, 83669, 87749, 83679, 128709, 83709,
                           97989, 83735, 119237, 83757, 92613, 83787, 107973, 83807, 128453,
                           83837, 97733, 83859, 103365, 83861, 86981, 83887, 125893, 83895,
                           121797, 83907, 100293, 83947, 110533, 83997, 94245, 84007, 116773,
                           84021, 88101, 84031, 129061, 84039, 115749, 84115, 102949, 84163,
                           99877, 84183, 120357, 84187, 112165, 84213, 89637, 84223, 130597,
                           84235, 106789, 84245, 86309, 84271, 125221, 84291, 99621, 84317,
                           95525, 84327, 118053, 84367, 123685, 84447, 128805, 84453, 85797,
                           84475, 114469, 84499, 102565, 84501, 86181, 84515, 100517, 84527,
                           125093, 84583, 117925, 84589, 93349, 84597, 89253, 84647, 117413,
                           84653, 92837, 84661, 88741, 84671, 129701, 84683, 108197, 84703,
                           128677, 84727, 122533, 84731, 114341, 84739, 98725, 84751, 123301,
                           84813, 91557, 84835, 101797, 84861, 97701, 84871, 115621, 84885,
                           86949, 84919, 121765, 84923, 113573, 84943, 124837, 84955, 112549,
                           84957, 96165, 84979, 106405, 84991, 130981, 85005, 90213, 85023,
                           127077, 85095, 117861, 85107, 105573, 85123, 98917, 85147, 111205,
                           85159, 117349, 85191, 116325, 85195, 108133, 85239, 122469, 85245,
                           97893, 85263, 123237, 85293, 92517, 85325, 91493, 85331, 103781,
                           85343, 128357, 85371, 114021, 85387, 107365, 85389, 90981, 85479,
                           118629, 85483, 110437, 85491, 106341, 85527, 119013, 85579, 107749,
                           85615, 126181, 85623, 122085, 85639, 115429, 85667, 101093, 85679,
                           125669, 85693, 96997, 85723, 112357, 85739, 110309, 85749, 89829,
                           85759, 130789, 85779, 102885, 85839, 124389, 85847, 120293, 85851,
                           112101, 85867, 110053, 85869, 93669, 85903, 123877, 85959, 116709,
                           85965, 92133, 85987, 102373, 86011, 114661, 86013, 98277, 86019,
                           98325, 86031, 122901, 86055, 116757, 86059, 108565, 86175, 127509,
                           86199, 121365, 86203, 113173, 86231, 120341, 86251, 110101, 86271,
                           130581, 86279, 114965, 86365, 95509, 86381, 93461, 86389, 89365,
                           86403, 99093, 86439, 117525, 86451, 105237, 86453, 88853, 86477,
                           91925, 86483, 104213, 86495, 128789, 86539, 106645, 86559, 127125,
                           86575, 125077, 86621, 95381, 86635, 109717, 86679, 119445, 86707,
                           105109, 86719, 129685, 86727, 116373, 86741, 87701, 86775, 122517,
                           86779, 114325, 86787, 98709, 86813, 94613, 86823, 117141, 86883,
                           101781, 86895, 126357, 86903, 122261, 86943, 127893, 86973, 97173,
                           87003, 112533, 87021, 94101, 87029, 90005, 87053, 90197, 87059,
                           102485, 87071, 127061, 87127, 119893, 87131, 111701, 87167, 130133,
                           87171, 98901, 87191, 119381, 87221, 88661, 87243, 108117, 87245,
                           91733, 87253, 87637, 87263, 128597, 87335, 117077, 87341, 92501,
                           87371, 107861, 87443, 103253, 87471, 125781, 87479, 121685, 87503,
                           124757, 87515, 112469, 87533, 94037, 87541, 89941, 87567, 123093,
                           87575, 118997, 87595, 108757, 87597, 92373, 87623, 115925, 87635,
                           103637, 87687, 115413, 87693, 90837, 87711, 127701, 87727, 125653,
                           87759, 124629, 87797, 89813, 87821, 90581, 87899, 112085, 87911,
                           118229, 87939, 99285, 87965, 95189, 87979, 109525, 88007, 116693,
                           88019, 104405, 88071, 114741, 88125, 96309, 88155, 111669, 88171,
                           109621, 88195, 98869, 88243, 105013, 88275, 103989, 88287, 128565,
                           88303, 126517, 88315, 114229, 88317, 97845, 88363, 108853, 88373,
                           88395, 107829, 88397, 91445, 88419, 101685, 88461, 90933, 88467,
                           103221, 88479, 127797, 88483, 101173, 88503, 121653, 88527, 124725,
                           88535, 120629, 88541, 96053, 88555, 110389, 88575, 130869, 88591,
                           123061, 88651, 107701, 88687, 126133, 88701, 97461, 88759, 121525,
                           88791, 120501, 88795, 112309, 88807, 118453, 88813, 93877, 88819,
                           106165, 88845, 90549, 88891, 113077, 88911, 124341, 88919, 120245,
                           89003, 109493, 89005, 93109, 89031, 116661, 89055, 128949, 89133,
                           92277, 89139, 104565, 89163, 107637, 89227, 107125, 89235, 103029,
                           89251, 100981, 89309, 95861, 89323, 110197, 89351, 115061, 89357,
                           90485, 89375, 127349, 89399, 121205, 89403, 113013, 89423, 124277,
                           89451, 109941, 89471, 130421, 89515, 109429, 89543, 116597, 89567,
                           128885, 89597, 98165, 89611, 106741, 89619, 102645, 89655, 121077,
                           89687, 120053, 89703, 118005, 89715, 105717, 89731, 99061, 89771,
                           109301, 89773, 92917, 89803, 108277, 89899, 109045, 89919, 129525,
                           89927, 116213, 89997, 91125, 90019, 101365, 90045, 97269, 90077,
                           96245, 90099, 106485, 90135, 118797, 90155, 108557, 90189, 91149,
                           90211, 101389, 90231, 121869, 90271, 127501, 90275, 100877, 90333,
                           95757, 90379, 106765, 90423, 121101, 90427, 112909, 90429, 96525,
                           90435, 99597, 90459, 111885, 90471, 118029, 90495, 130317, 90541,
                           92941, 90567, 116493, 90579, 104205, 90607, 126733, 90621, 98061,
                           90643, 102541, 90683, 112781, 90703, 124045, 90717, 95373, 90731,
                           109709, 90739, 105613, 90751, 130189, 90767, 123533, 90775, 119437,
                           90781, 94861, 90795, 109197, 90803, 105101, 90877, 97933, 90919,
                           117133, 90925, 92557, 90931, 104845, 90957, 91533, 90963, 103821,
                           91003, 114061, 91019, 107405, 91043, 101261, 91117, 94093, 91143,
                           114765, 91167, 127053, 91171, 100429, 91195, 112717, 91203, 99405,
                           91229, 95309, 91287, 119373, 91291, 111181, 91307, 109133, 91383,
                           122445, 91395, 98637, 91407, 123213, 91419, 110925, 91435, 108877,
                           91455, 129357, 91463, 116045, 91467, 107853, 91511, 122189, 91539,
                           103245, 91579, 113485, 91611, 112461, 91623, 118605, 91635, 106317,
                           91651, 98509, 91671, 118989, 91687, 116941, 91723, 107725, 91835,
                           113357, 91863, 120525, 91911, 115149, 91951, 125389, 91971, 99789,
                           91983, 124365, 92011, 110029, 92095, 129997, 92107, 108493, 92127,
                           128973, 92151, 122829, 92171, 106541, 92191, 127021, 92219, 112685,
                           92287, 130093, 92303, 123437, 92317, 94765, 92333, 92717, 92359,
                           116269, 92363, 108077, 92371, 103981, 92439, 119085, 92443, 110893,
                           92467, 104749, 92487, 116013, 92575, 127789, 92591, 125741, 92603,
                           113453, 92623, 124717, 92631, 120621, 92675, 98477, 92699, 110765,
                           92735, 129197, 92755, 103597, 92783, 126125, 92791, 122029, 92811,
                           107181, 92835, 101037, 92861, 96941, 92867, 100013, 92879, 124589,
                           92903, 118445, 92963, 100781, 93015, 120237, 93019, 112045, 93035,
                           109997, 93071, 123821, 93085, 95149, 93099, 109485, 93107, 105389,
                           93127, 116653, 93167, 126893, 93179, 114605, 93187, 98413, 93213,
                           94317, 93295, 126061, 93303, 121965, 93331, 103021, 93367, 121453,
                           93415, 118381, 93427, 106093, 93499, 113005, 93507, 99693, 93519,
                           124269, 93597, 95085, 93619, 105325, 93631, 129901, 93639, 116589,
                           93743, 125165, 93757, 96493, 93789, 95469, 93799, 117997, 93823,
                           130285, 93847, 119533, 93851, 111341, 93899, 108269, 93935, 126701,
                           93949, 98029, 93967, 123373, 93995, 109037, 94023, 116205, 94087,
                           115693, 94135, 121837, 94171, 112621, 94189, 94207, 131053, 94295,
                           119837, 94299, 111645, 94315, 109597, 94339, 98845, 94351, 123421,
                           94365, 94749, 94379, 109085, 94387, 104989, 94461, 97821, 94467,
                           98589, 94487, 119069, 94503, 117021, 94515, 104733, 94559, 128285,
                           94575, 126237, 94583, 122141, 94587, 113949, 94653, 97053, 94659,
                           100125, 94685, 96029, 94735, 123037, 94747, 110749, 94815, 128157,
                           94819, 101533, 94855, 115357, 94859, 107165, 94883, 101021, 94895,
                           125597, 94927, 124573, 94941, 95901, 94951, 118429, 95037, 96669,
                           95043, 99741, 95079, 118173, 95091, 105885, 95119, 123805, 95131,
                           111517, 95167, 129949, 95235, 98397, 95303, 115805, 95343, 126045,
                           95357, 97373, 95367, 115293, 95415, 121437, 95419, 113245, 95447,
                           120413, 95467, 110173, 95507, 102749, 95523, 100701, 95581, 95619,
                           99165, 95639, 119645, 95643, 111453, 95655, 117597, 95667, 105309,
                           95691, 108381, 95741, 98141, 95751, 114909, 95803, 112861, 95805,
                           96477, 95811, 99549, 95831, 120029, 95847, 117981, 95915, 109277,
                           95943, 116445, 95967, 128733, 96027, 111069, 96063, 129501, 96075,
                           107997, 96139, 107485, 96147, 103389, 96183, 121821, 96195, 100317,
                           96319, 129085, 96339, 103485, 96351, 128061, 96375, 121917, 96451,
                           99901, 96463, 124477, 96475, 112189, 96487, 118333, 96491, 110141,
                           96519, 115005, 96627, 105789, 96639, 130365, 96663, 119613, 96683,
                           109373, 96751, 126781, 96799, 127165, 96855, 119997, 96859, 111805,
                           96895, 130237, 96935, 117437, 96939, 109245, 96995, 102077, 97007,
                           126653, 97015, 122557, 97075, 104893, 97123, 101821, 97147, 114109,
                           97211, 113597, 97213, 97255, 118717, 97259, 110525, 97267, 106429,
                           97287, 114813, 97327, 125053, 97335, 120957, 97359, 124029, 97407,
                           130173, 97471, 129661, 97483, 108157, 97491, 104061, 97539, 98685,
                           97587, 104829, 97607, 116093, 97635, 101757, 97659, 114045, 97671,
                           115581, 97751, 120701, 97755, 112509, 97831, 116989, 97835, 108797,
                           97867, 107773, 97931, 107261, 97939, 103165, 97967, 125693, 97979,
                           113405, 97987, 100093, 98007, 120573, 98023, 118525, 98047, 130813,
                           98059, 107005, 98095, 125437, 98163, 105981, 98227, 105469, 98247,
                           116733, 98259, 104445, 98275, 102397, 98299, 114685, 98323, 102403,
                           98471, 117251, 98551, 122371, 98563, 98583, 119043, 98603, 108803,
                           98671, 126211, 98723, 101123, 98743, 121603, 98779, 112387, 98843,
                           110723, 98855, 116867, 98935, 121987, 98955, 107139, 98963, 103043,
                           98975, 127619, 99003, 113283, 99011, 99971, 99047, 118403, 99059,
                           106115, 99071, 130691, 99079, 115075, 99131, 113027, 99159, 120195,
                           99179, 109955, 99243, 109443, 99251, 105347, 99263, 129923, 99295,
                           128899, 99319, 122755, 99355, 110659, 99379, 104515, 99439, 126019,
                           99447, 121923, 99475, 102979, 99503, 125507, 99511, 121411, 99535,
                           124483, 99603, 102723, 99619, 100675, 99639, 121155, 99663, 124227,
                           99711, 130371, 99783, 116547, 99807, 128835, 99835, 114499, 99851,
                           106691, 99895, 121027, 99927, 120003, 100011, 109251, 100087, 122563,
                           100111, 123331, 100147, 104899, 100179, 103875, 100231, 115651, 100271,
                           125891, 100339, 106435, 100367, 122915, 100403, 104483, 100447, 128035,
                           100451, 101411, 100487, 115235, 100567, 120355, 100587, 110115, 100627,
                           102691, 100655, 125219, 100735, 130339, 100763, 111395, 100775, 117539,
                           100811, 108323, 100847, 126755, 100859, 114467, 100943, 124067, 100967,
                           117923, 100971, 109731, 100979, 105635, 101043, 105123, 101091, 102051,
                           101191, 116131, 101195, 107939, 101219, 101795, 101239, 122275, 101279,
                           127907, 101303, 121763, 101339, 112547, 101503, 130147, 101527, 119395,
                           101579, 108131, 101603, 101987, 101615, 126563, 101627, 114275, 101659,
                           110947, 101671, 117091, 101755, 114019, 101815, 121699, 101839, 124771,
                           101863, 118627, 101915, 110819, 101951, 129251, 101959, 115939, 102007,
                           122083, 102023, 115427, 102075, 113379, 102095, 124643, 102155, 106979,
                           102175, 127459, 102191, 125411, 102231, 120291, 102235, 112099, 102259,
                           105955, 102299, 111587, 102347, 108515, 102355, 104419, 102383, 126947,
                           102415, 122899, 102427, 110611, 102439, 116755, 102471, 115731, 102475,
                           107539, 102575, 125459, 102583, 121363, 102615, 120339, 102631, 118291,
                           102667, 106771, 102687, 127251, 102715, 112915, 102735, 124179, 102743,
                           120083, 102763, 109843, 102811, 111379, 102827, 109331, 102867, 104211,
                           103079, 117395, 103103, 129683, 103135, 128659, 103183, 123283, 103191,
                           119187, 103207, 117139, 103243, 107923, 103291, 114067, 103327, 127891,
                           103375, 124819, 103387, 112531, 103403, 110483, 103411, 106387, 103423,
                           130963, 103479, 120915, 103483, 112723, 103511, 119891, 103539, 105555,
                           103591, 117331, 103595, 109139, 103663, 126547, 103703, 119123, 103707,
                           110931, 103723, 108883, 103743, 129363, 103751, 116051, 103775, 128339,
                           103803, 114003, 103815, 115539, 103819, 107347, 103923, 106323, 104031,
                           128211, 104055, 122067, 104119, 121555, 104155, 112339, 104167, 118483,
                           104171, 110291, 104199, 115155, 104223, 127443, 104247, 121299, 104319,
                           130515, 104343, 119763, 104359, 117715, 104363, 109523, 104459, 106547,
                           104495, 124979, 104591, 123443, 104647, 116275, 104699, 114227, 104719,
                           123187, 104743, 117043, 104747, 108851, 104775, 116019, 104843, 107315,
                           104935, 118579, 104959, 130867, 104975, 123059, 105071, 126131, 105143,
                           121523, 105147, 113331, 105175, 120499, 105223, 115123, 105271, 121267,
                           105307, 112051, 105343, 130483, 105371, 111539, 105419, 108467, 105439,
                           128947, 105455, 126899, 105495, 118899, 105515, 108659, 105535, 129139,
                           105707, 110195, 105715, 106099, 105775, 125299, 105855, 130419, 105871,
                           123763, 105931, 108403, 105967, 126835, 105975, 122739, 105991, 114931,
                           106063, 124147, 106071, 120051, 106075, 111859, 106151, 117491, 106183,
                           116467, 106187, 108275, 106207, 128755, 106223, 126707, 106235, 114419,
                           106263, 119283, 106351, 126451, 106359, 122355, 106363, 114163, 106423,
                           121843, 106607, 125963, 106619, 113675, 106703, 124427, 106715, 112139,
                           106759, 114955, 106783, 127243, 106807, 121099, 106903, 119563, 106923,
                           109323, 107067, 112779, 107175, 117387, 107199, 129675, 107207, 116363,
                           107291, 110987, 107307, 108939, 107335, 116107, 107359, 128395, 107383,
                           122251, 107387, 114059, 107403, 107471, 124811, 107599, 123979, 107623,
                           117835, 107711, 129611, 107723, 108107, 107767, 122443, 107799, 119115,
                           107815, 117067, 107819, 108875, 107959, 121675, 107963, 113483, 107983,
                           124747, 108095, 129227, 108143, 126155, 108215, 121547, 108319, 127435,
                           108375, 120267, 108391, 118219, 108439, 119755, 108479, 129995, 108603,
                           112683, 108623, 123947, 108631, 119851, 108711, 117291, 108767, 128555,
                           108783, 126507, 108823, 119083, 108827, 110891, 108975, 125739, 109031,
                           118571, 109071, 123051, 109083, 110763, 109175, 122027, 109179, 113835,
                           109215, 127659, 109271, 120491, 109343, 127403, 109399, 120235, 109455,
                           123819, 109479, 117675, 109503, 129963, 109551, 126891, 109607, 116843,
                           109639, 115819, 109663, 128107, 109775, 124523, 109783, 120427, 109871,
                           125291, 109903, 124267, 109915, 111979, 109931, 109991, 117611, 110047,
                           128875, 110075, 114539, 110159, 124139, 110223, 123627, 110231, 119531,
                           110235, 111339, 110271, 129771, 110303, 128747, 110331, 114411, 110511,
                           125931, 110551, 120811, 110591, 131051, 110651, 112667, 110683, 111643,
                           110719, 130075, 110747, 111131, 110791, 116251, 110831, 126491, 110943,
                           128283, 110967, 122139, 111023, 125723, 111035, 113435, 111055, 124699,
                           111079, 118555, 111223, 122011, 111227, 113819, 111239, 115355, 111287,
                           121499, 111323, 112283, 111439, 124315, 111487, 130459, 111503, 123803,
                           111511, 119707, 111559, 116635, 111631, 122971, 111727, 126043, 111931,
                           112987, 112023, 119643, 112063, 129883, 112071, 116571, 112135, 114907,
                           112207, 124123, 112255, 130267, 112319, 129755, 112367, 126683, 112375,
                           122587, 112399, 123355, 112423, 117211, 112495, 126427, 112599, 120795,
                           112603, 112735, 128059, 112855, 120379, 112871, 118331, 112927, 127291,
                           112943, 125243, 113095, 116539, 113143, 122683, 113159, 114875, 113239,
                           119995, 113303, 119483, 113447, 117179, 113471, 129467, 113519, 126395,
                           113615, 124859, 113671, 114811, 113767, 117883, 113863, 116347, 113911,
                           122491, 113983, 129403, 114095, 125819, 114135, 120699, 114191, 123131,
                           114199, 119035, 114271, 128251, 114287, 126203, 114431, 130811, 114479,
                           125435, 114487, 121339, 114511, 124411, 114535, 118267, 114559, 130555,
                           114599, 117755, 114655, 129019, 114711, 118791, 114727, 116743, 114823,
                           115207, 114847, 127495, 114895, 124423, 114951, 114999, 121095, 115071,
                           130311, 115167, 128775, 115231, 127111, 115279, 124039, 115303, 117895,
                           115423, 128647, 115615, 127879, 115639, 121735, 115671, 120711, 115839,
                           130119, 115879, 117319, 116007, 117063, 116087, 122183, 116151, 121671,
                           116399, 125639, 116583, 118215, 116623, 123847, 116671, 129991, 116791,
                           120871, 116839, 117799, 116887, 119335, 116927, 129575, 116959, 128551,
                           116975, 126503, 116983, 122407, 117087, 128295, 117103, 126247, 117207,
                           120615, 117423, 125607, 117431, 121511, 117479, 118439, 117535, 127399,
                           117695, 129959, 117871, 126055, 117943, 121447, 118015, 130663, 118071,
                           121191, 118095, 124263, 118103, 120167, 118239, 128871, 118255, 126823,
                           118359, 120039, 118399, 130279, 118463, 129767, 118511, 126695, 118591,
                           129511, 118831, 124951, 118927, 123415, 118975, 129559, 119055, 123159,
                           119199, 127767, 119255, 120599, 119407, 126103, 119455, 127639, 119503,
                           124567, 119599, 125335, 119679, 130455, 119743, 129943, 119791, 126871,
                           119871, 129111, 119903, 128087, 120095, 127319, 120111, 125271, 120151,
                           120191, 130391, 120255, 129879, 120303, 126807, 120311, 122711, 120671,
                           128471, 120759, 121815, 120847, 122935, 121015, 121399, 121087, 130615,
                           121119, 127287, 121167, 124215, 121335, 122679, 121583, 126647, 121615,
                           123319, 121903, 125047, 121983, 130167, 122127, 123255, 122175, 129399,
                           122319, 124791, 122543, 125687, 122575, 124663, 122767, 123895, 122863,
                           126967, 123007, 130063, 123103, 128527, 123487, 128143, 123679, 127375,
                           123695, 125327, 123791, 124015, 126031, 124111, 124495, 124287, 130383,
                           124351, 129871, 124383, 128847, 124463, 125135, 124735, 129487, 124783,
                           126415, 124831, 127951, 124847, 125903, 125023, 128047, 125039, 125999,
                           125311, 130351, 125423, 126767, 125471, 127151, 125679, 126639, 125855,
                           127919, 126303, 128367, 126319, 126367, 127855, 126943, 129007, 127071,
                           128031, 127423, 129823, 127615, 130207, 127711, 128671, 128511, 130911,
                           128959, 130015, 129215, 129599, 129343, 129919, 130495, 131081, 147457,
                           131087, 245761, 131105, 135169, 131117, 184321, 131123, 208897, 131135,
                           258049, 131137, 133121, 131157, 174081, 131177, 153601, 131195, 227329,
                           131213, 181249, 131225, 156673, 131235, 201729, 131247, 250881, 131259,
                           226305, 131269, 166913, 131317, 179201, 131339, 213505, 131341, 180737,
                           131353, 156161, 131365, 168449, 131389, 193025, 131415, 240129, 131425,
                           137729, 131431, 236033, 131437, 186881, 131455, 260609, 131459, 198145,
                           131521, 134657, 131527, 232961, 131531, 216577, 131545, 159233, 131569,
                           146945, 131597, 180481, 131619, 200961, 131625, 151809, 131633, 143617,
                           131639, 241921, 131653, 166145, 131691, 219393, 131705, 162049, 131711,
                           260353, 131715, 197889, 131729, 140545, 131765, 177409, 131783, 232705,
                           131807, 257281, 131811, 204033, 131817, 154881, 131837, 195841, 131849,
                           148225, 131857, 140033, 131863, 238337, 131867, 221953, 131879, 234241,
                           131891, 209665, 131893, 176897, 131923, 207617, 131959, 244481, 132017,
                           145153, 132023, 243457, 132035, 200449, 132049, 143105, 132059, 225025,
                           132075, 220929, 132103, 229505, 132117, 172161, 132121, 155777, 132127,
                           254081, 132143, 249985, 132157, 192641, 132163, 198785, 132183, 239745,
                           132189, 190593, 132193, 137345, 132199, 235649, 132213, 178305, 132229,
                           164993, 132239, 246913, 132253, 189569, 132267, 218241, 132281, 160897,
                           132289, 134273, 132301, 183425, 132343, 244865, 132347, 228481, 132379,
                           221825, 132381, 189057, 132391, 234113, 132405, 176769, 132415, 258689,
                           132451, 203393, 132453, 170625, 132463, 252545, 132499, 206465, 132517,
                           169601, 132539, 226945, 132589, 188033, 132613, 164225, 132637, 188801,
                           132641, 135553, 132659, 209281, 132679, 231809, 132683, 215425, 132697,
                           158081, 132749, 181633, 132771, 202113, 132823, 241025, 132827, 224641,
                           132833, 138625, 132857, 163201, 132863, 261505, 132871, 230273, 132911,
                           250753, 132913, 144257, 132937, 150401, 132943, 248705, 132945, 142209,
                           132955, 224129, 132973, 187265, 132995, 198529, 132997, 165761, 133015,
                           239489, 133037, 186241, 133045, 178049, 133097, 155521, 133115, 229249,
                           133131, 213057, 133133, 180289, 133175, 241729, 133181, 192577, 133201,
                           141377, 133207, 239681, 133237, 178241, 133265, 140353, 133305, 160833,
                           133311, 259137, 133331, 207937, 133333, 175169, 133337, 158785, 133347,
                           203841, 133367, 244801, 133373, 195649, 133381, 164417, 133403, 221761,
                           133405, 188993, 133421, 184897, 133427, 209473, 133441, 133697, 133461,
                           174657, 133481, 154177, 133489, 145985, 133499, 227905, 133511, 230977,
                           133539, 202305, 133601, 138817, 133607, 237121, 133635, 196929, 133715,
                           207169, 133733, 170305, 133737, 153921, 133743, 252225, 133755, 227649,
                           133785, 156993, 133815, 243009, 133827, 200001, 133833, 150849, 133841,
                           142657, 133863, 236865, 133867, 220481, 133895, 230209, 133901, 181057,
                           133925, 168769, 133937, 144193, 133943, 242497, 133947, 226113, 133957,
                           166721, 133981, 191297, 134009, 162625, 134019, 198465, 134049, 137025,
                           134055, 235329, 134091, 216897, 134121, 155457, 134139, 229185, 134183,
                           233665, 134207, 258241, 134215, 231617, 134245, 170177, 134257, 145601,
                           134263, 243905, 134285, 181441, 134327, 242881, 134369, 138433, 134375,
                           236737, 134381, 187585, 134407, 230081, 134411, 213697, 134421, 172737,
                           134447, 250561, 134469, 166593, 134493, 191169, 134507, 219841, 134517,
                           178881, 134543, 247489, 134555, 222913, 134571, 218817, 134573, 186049,
                           134611, 208577, 134623, 257729, 134627, 204481, 134629, 171713, 134667,
                           213441, 134677, 172481, 134717, 192961, 134723, 199105, 134735, 248257,
                           134749, 190913, 134777, 162241, 134783, 260545, 134793, 148929, 134807,
                           239041, 134811, 222657, 134823, 234945, 134837, 177601, 134879, 257473,
                           134889, 155073, 134907, 228801, 134927, 246721, 134955, 218049, 134963,
                           209857, 134969, 160705, 134997, 175041, 135023, 252865, 135025, 146369,
                           135047, 231361, 135059, 206785, 135081, 153537, 135113, 151489, 135131,
                           225217, 135133, 192449, 135149, 188353, 135155, 212929, 135181, 180257,
                           135187, 204833, 135189, 172065, 135209, 151585, 135217, 143393, 135223,
                           241697, 135227, 225313, 135237, 165921, 135241, 149537, 135247, 247841,
                           135275, 219169, 135295, 260129, 135299, 197665, 135311, 246817, 135367,
                           232481, 135381, 175137, 135395, 203809, 135401, 154657, 135427, 197153,
                           135429, 164385, 135441, 139809, 135469, 184865, 135475, 209441, 135499,
                           215585, 135507, 207393, 135529, 154145, 135563, 214561, 135573, 173601,
                           135599, 251425, 135607, 243233, 135643, 224801, 135645, 192033, 135655,
                           237089, 135669, 179745, 135685, 164129, 135723, 217377, 135731, 209185,
                           135737, 160033, 135743, 258337, 135751, 231713, 135765, 174369, 135775,
                           256289, 135779, 203041, 135799, 244001, 135829, 173345, 135839, 255265,
                           135855, 251169, 135875, 199969, 135889, 142625, 135901, 191777, 135911,
                           236833, 135929, 163105, 135955, 205601, 135961, 156449, 135995, 226081,
                           136033, 138017, 136039, 236321, 136045, 187169, 136051, 211745, 136053,
                           178977, 136109, 186145, 136127, 259873, 136153, 159521, 136189, 196385,
                           136207, 245921, 136215, 237729, 136221, 188577, 136231, 233633, 136243,
                           209057, 136303, 252065, 136351, 255137, 136355, 201889, 136361, 152737,
                           136399, 248993, 136407, 240801, 136411, 224417, 136417, 138401, 136447,
                           261281, 136473, 156321, 136483, 201377, 136521, 150177, 136529, 141985,
                           136539, 223905, 136555, 219809, 136569, 162465, 136575, 260769, 136585,
                           149153, 136615, 235169, 136621, 186017, 136659, 208545, 136665, 159393,
                           136681, 155297, 136701, 196257, 136717, 180641, 136763, 225697, 136765,
                           192929, 136773, 166305, 136783, 248225, 136785, 141729, 136807, 235937,
                           136855, 239009, 136861, 189857, 136877, 185761, 136889, 161185, 136975,
                           246689, 137013, 177057, 137017, 160673, 137023, 258977, 137035, 215969,
                           137045, 175009, 137071, 252833, 137073, 146337, 137085, 195489, 137101,
                           182177, 137129, 153505, 137135, 251809, 137143, 243617, 137147, 227233,
                           137179, 225185, 137191, 237473, 137203, 212897, 137233, 139361, 137255,
                           233569, 137261, 184417, 137291, 215137, 137293, 182369, 137299, 206945,
                           137305, 157793, 137351, 230497, 137355, 214113, 137381, 169057, 137393,
                           144481, 137411, 199777, 137437, 191585, 137447, 236641, 137451, 220257,
                           137453, 187489, 137479, 229985, 137507, 201313, 137531, 225889, 137545,
                           150113, 137569, 137825, 137587, 211553, 137629, 190049, 137639, 235105,
                           137651, 210529, 137657, 161377, 137677, 183905, 137705, 155233, 137739,
                           213345, 137747, 205153, 137753, 156001, 137809, 141665, 137815, 239969,
                           137843, 211297, 137845, 178529, 137859, 197985, 137871, 247137, 137883,
                           222561, 137901, 185697, 137939, 208225, 137945, 159073, 137969, 146785,
                           138007, 238433, 138011, 222049, 138027, 217953, 138041, 160609, 138061,
                           183137, 138083, 203617, 138103, 244577, 138119, 231265, 138133, 173921,
                           138159, 251745, 138191, 249697, 138209, 139105, 138227, 212833, 138229,
                           180065, 138261, 172257, 138275, 200929, 138287, 250081, 138289, 143585,
                           138313, 149729, 138331, 223457, 138361, 162017, 138385, 140513, 138413,
                           185569, 138443, 216289, 138445, 183521, 138463, 257249, 138469, 171233,
                           138479, 253153, 138493, 195809, 138501, 164577, 138525, 189153, 138535,
                           234209, 138539, 217825, 138547, 209633, 138585, 158433, 138591, 256737,
                           138607, 252641, 138643, 206561, 138659, 202465, 138697, 151265, 138703,
                           249569, 138721, 138977, 138761, 147937, 138791, 233953, 138805, 176609,
                           138841, 158177, 138851, 203233, 138871, 244193, 138877, 195041, 138891,
                           214497, 138899, 206305, 138939, 226785, 138949, 167393, 138971, 224737,
                           139033, 156641, 139055, 250849, 139057, 144353, 139077, 166881, 139089,
                           142305, 139095, 240609, 139141, 165857, 139145, 149473, 139199, 260065,
                           139207, 233441, 139219, 208865, 139237, 172001, 139255, 245729, 139259,
                           229345, 139275, 213009, 139299, 200721, 139313, 143377, 139323, 225297,
                           139325, 192529, 139351, 239633, 139357, 190481, 139367, 235537, 139379,
                           210961, 139381, 178193, 139401, 148497, 139421, 189457, 139437, 185361,
                           139443, 209937, 139449, 160785, 139455, 259089, 139463, 232465, 139511,
                           244753, 139523, 197137, 139529, 147985, 139537, 139793, 139565, 184849,
                           139583, 258577, 139621, 170513, 139639, 244241, 139645, 195089, 139685,
                           169489, 139695, 251409, 139707, 226833, 139715, 200209, 139721, 151057,
                           139735, 241169, 139739, 224785, 139791, 246033, 139819, 217361, 139851,
                           215313, 139861, 174353, 139899, 227601, 139917, 181521, 139935, 255249,
                           139945, 152849, 139953, 144657, 139963, 226577, 139977, 150801, 139997,
                           191761, 140011, 220433, 140013, 187665, 140019, 212241, 140031, 261393,
                           140039, 230161, 140051, 205585, 140079, 250641, 140111, 248593, 140113,
                           142097, 140123, 224017, 140125, 191249, 140139, 219921, 140177, 141073,
                           140235, 216849, 140243, 208657, 140255, 257809, 140261, 171793, 140265,
                           155409, 140271, 253713, 140297, 147601, 140315, 221329, 140333, 184465,
                           140345, 159889, 140371, 206993, 140373, 174225, 140393, 153745, 140427,
                           214161, 140447, 255121, 140465, 144529, 140475, 226449, 140483, 199825,
                           140485, 167057, 140495, 248977, 140519, 236689, 140537, 162961, 140557,
                           180881, 140569, 156305, 140581, 168593, 140591, 250513, 140611, 199313,
                           140647, 236177, 140687, 247441, 140701, 190097, 140747, 216721, 140807,
                           229777, 140819, 205201, 140831, 254353, 140841, 151953, 140869, 166289,
                           140887, 240017, 140893, 190865, 140909, 186769, 140921, 162193, 140979,
                           210321, 140985, 161169, 141003, 216465, 141005, 183697, 141013, 175505,
                           141017, 159121, 141039, 253329, 141051, 228753, 141061, 164753, 141083,
                           222097, 141101, 185233, 141109, 177041, 141119, 258961, 141151, 256913,
                           141179, 228241, 141181, 195473, 141195, 214929, 141203, 206737, 141233,
                           145297, 141239, 243601, 141287, 237457, 141311, 262033, 141365, 176209,
                           141375, 258129, 141383, 231505, 141411, 202833, 141413, 170065, 141425,
                           145489, 141431, 243793, 141437, 194641, 141451, 214097, 141459, 205905,
                           141465, 156753, 141481, 152657, 141487, 250961, 141495, 242769, 141513,
                           150609, 141589, 172625, 141603, 201297, 141615, 250449, 141627, 225873,
                           141629, 193105, 141637, 166481, 141671, 236113, 141711, 247377, 141759,
                           259665, 141779, 208465, 141801, 155217, 141809, 147025, 141831, 229713,
                           141835, 213329, 141871, 250193, 141903, 248145, 141917, 190801, 141955,
                           197969, 141975, 238929, 141997, 185681, 142053, 171345, 142063, 253265,
                           142075, 228689, 142077, 195921, 142083, 197457, 142119, 234321, 142131,
                           209745, 142169, 158545, 142175, 256849, 142179, 203601, 142203, 228177,
                           142227, 206673, 142229, 173905, 142239, 255825, 142243, 202577, 142249,
                           153425, 142299, 225105, 142301, 192337, 142317, 188241, 142335, 261969,
                           142347, 213201, 142349, 180433, 142409, 149713, 142423, 239825, 142439,
                           235729, 142463, 260305, 142479, 246993, 142493, 189649, 142503, 234705,
                           142527, 259281, 142549, 175313, 142577, 146641, 142607, 246481, 142619,
                           221905, 142635, 217809, 142655, 258769, 142663, 232145, 142669, 182993,
                           142675, 207569, 142693, 170705, 142697, 154321, 142745, 157393, 142751,
                           255697, 142755, 202449, 142807, 241361, 142813, 192209, 142827, 220881,
                           142835, 212689, 142871, 238033, 142901, 176593, 142923, 215505, 142931,
                           207313, 142959, 252369, 142971, 227793, 142997, 173521, 143011, 202193,
                           143025, 144849, 143049, 150993, 143067, 224721, 143085, 187857, 143093,
                           179665, 143117, 181201, 143125, 173009, 143135, 254929, 143153, 144337,
                           143159, 242641, 143173, 166865, 143191, 240593, 143231, 261073, 143271,
                           235473, 143275, 219089, 143283, 210897, 143289, 161745, 143321, 159697,
                           143337, 155601, 143363, 196657, 143365, 163889, 143375, 245809, 143389,
                           188465, 143399, 233521, 143403, 217137, 143413, 176177, 143437, 182321,
                           143465, 153649, 143471, 251953, 143473, 145457, 143483, 227377, 143525,
                           169009, 143529, 152625, 143547, 226353, 143567, 248881, 143575, 240689,
                           143579, 224305, 143609, 162865, 143623, 229937, 143635, 205361, 143651,
                           201265, 143743, 260657, 143749, 165425, 143783, 235057, 143797, 177713,
                           143819, 216625, 143845, 171569, 143849, 155185, 143855, 253489, 143867,
                           228913, 143883, 213297, 143885, 180529, 143893, 172337, 143907, 201009,
                           143959, 239921, 143987, 211249, 144009, 148785, 144023, 238897, 144045,
                           185649, 144051, 210225, 144063, 259377, 144071, 232753, 144083, 208177,
                           144095, 257329, 144113, 146737, 144131, 197425, 144157, 189233, 144167,
                           234289, 144173, 185137, 144181, 176945, 144185, 160561, 144211, 207665,
                           144217, 158513, 144253, 195377, 144275, 206641, 144293, 169777, 144343,
                           241457, 144359, 237361, 144371, 212785, 144391, 229553, 144397, 180401,
                           144405, 172209, 144453, 166065, 144457, 149681, 144499, 211121, 144535,
                           238769, 144541, 189617, 144565, 177329, 144583, 232625, 144587, 216241,
                           144601, 158897, 144617, 154801, 144667, 221873, 144715, 215729, 144717,
                           182961, 144735, 256689, 144741, 170673, 144775, 231089, 144789, 173745,
                           144793, 157361, 144815, 251569, 144823, 243377, 144841, 151217, 144861,
                           192177, 144911, 246193, 144953, 160177, 144973, 182705, 144991, 256433,
                           145009, 145841, 145035, 214449, 145049, 157105, 145065, 153009, 145071,
                           251313, 145103, 249265, 145111, 241073, 145117, 191921, 145163, 213937,
                           145171, 205745, 145183, 254897, 145219, 199601, 145225, 150449, 145243,
                           224177, 145255, 236465, 145279, 261041, 145307, 223153, 145309, 190385,
                           145319, 235441, 145325, 186289, 145381, 171953, 145433, 155761, 145463,
                           241777, 145487, 247921, 145501, 190577, 145517, 186481, 145541, 164977,
                           145581, 185457, 145589, 177265, 145631, 257137, 145637, 171121, 145659,
                           228465, 145667, 197233, 145717, 176753, 145721, 160369, 145775, 252529,
                           145799, 231025, 145833, 153201, 145851, 226929, 145865, 151153, 145899,
                           220785, 145907, 212593, 145935, 246129, 145959, 233841, 145963, 217457,
                           145973, 176497, 146005, 174449, 146009, 158065, 146021, 170353, 146031,
                           252273, 146045, 194929, 146067, 206193, 146089, 152945, 146103, 243057,
                           146139, 224625, 146157, 187761, 146165, 179569, 146175, 261489, 146211,
                           201585, 146217, 152433, 146263, 240497, 146279, 236401, 146283, 220017,
                           146331, 223089, 146349, 186225, 146381, 184177, 146399, 257905, 146423,
                           245617, 146459, 221425, 146483, 209137, 146507, 215281, 146521, 157937,
                           146527, 256241, 146543, 252145, 146595, 201969, 146607, 251121, 146639,
                           249073, 146669, 187633, 146677, 179441, 146695, 230129, 146707, 205553,
                           146719, 254705, 146747, 226033, 146757, 166641, 146779, 223985, 146781,
                           191217, 146795, 219889, 146797, 187121, 146819, 198385, 146821, 165617,
                           146845, 190193, 146901, 175857, 146927, 253681, 146975, 254449, 146999,
                           242161, 147005, 193009, 147059, 211441, 147075, 198129, 147081, 148977,
                           147099, 222705, 147115, 218609, 147125, 177649, 147129, 161265, 147135,
                           259569, 147143, 232945, 147157, 175601, 147215, 246769, 147243, 218097,
                           147257, 160753, 147277, 183281, 147283, 207857, 147301, 170993, 147319,
                           244721, 147335, 231409, 147353, 157681, 147363, 202737, 147387, 227313,
                           147389, 194545, 147443, 212977, 147445, 180209, 147449, 163825, 147497,
                           151561, 147511, 241673, 147515, 225289, 147543, 239625, 147547, 223241,
                           147571, 210953, 147593, 148489, 147613, 189449, 147637, 177161, 147655,
                           232457, 147659, 216073, 147667, 207881, 147669, 175113, 147683, 203785,
                           147685, 171017, 147695, 252937, 147709, 195593, 147727, 246281, 147763,
                           209417, 147831, 244233, 147853, 181769, 147861, 173577, 147901, 194057,
                           147907, 200201, 147947, 220681, 147955, 212489, 147971, 196873, 148019,
                           209161, 148051, 207113, 148063, 256265, 148117, 173321, 148121, 156937,
                           148131, 201993, 148163, 199945, 148187, 224521, 148203, 220425, 148217,
                           163081, 148237, 181001, 148261, 168713, 148331, 219913, 148345, 162569,
                           148409, 161545, 148429, 184073, 148475, 229129, 148477, 196361, 148563,
                           206985, 148581, 170121, 148591, 252041, 148599, 243849, 148605, 194697,
                           148633, 156809, 148639, 255113, 148645, 169097, 148669, 193673, 148681,
                           150665, 148711, 236681, 148725, 179337, 148743, 230025, 148749, 180873,
                           148797, 193161, 148815, 248457, 148823, 240265, 148853, 178825, 148857,
                           162441, 148869, 165513, 148927, 259721, 148963, 204425, 148983, 245385,
                           149003, 213385, 149017, 156041, 149027, 201097, 149053, 192905, 149065,
                           149897, 149123, 198025, 149147, 222601, 149171, 210313, 149197, 183689,
                           149209, 159113, 149225, 155017, 149231, 253321, 149271, 238473, 149287,
                           234377, 149301, 177033, 149319, 232329, 149325, 183177, 149347, 203657,
                           149371, 228233, 149373, 195465, 149383, 231305, 149395, 206729, 149397,
                           173961, 149407, 255881, 149417, 153481, 149445, 167817, 149449, 151433,
                           149455, 249737, 149469, 192393, 149483, 221065, 149485, 188297, 149503,
                           262025, 149527, 237641, 149555, 208969, 149561, 159817, 149575, 231497,
                           149581, 182345, 149623, 243785, 149639, 230473, 149643, 214089, 149679,
                           250953, 149699, 199753, 149701, 166985, 149739, 220233, 149747, 212041,
                           149749, 179273, 149753, 162889, 149779, 205385, 149785, 156233, 149801,
                           152137, 149819, 225865, 149821, 193097, 149829, 166473, 149833, 150089,
                           149851, 223817, 149863, 236105, 149917, 190025, 149951, 259657, 149973,
                           175689, 149977, 159305, 150037, 172361, 150047, 254281, 150051, 201033,
                           150071, 241993, 150075, 225609, 150103, 239945, 150109, 190793, 150125,
                           186697, 150147, 197961, 150215, 232777, 150249, 154953, 150299, 222025,
                           150311, 234313, 150317, 185161, 150347, 215881, 150377, 154441, 150383,
                           252745, 150395, 228169, 150411, 214857, 150435, 202569, 150437, 169801,
                           150467, 200521, 150473, 151369, 150503, 237385, 150517, 180041, 150527,
                           261961, 150541, 180425, 150553, 155849, 150559, 254153, 150563, 200905,
                           150587, 225481, 150595, 198857, 150597, 166089, 150607, 248009, 150621,
                           190665, 150645, 178377, 150713, 160969, 150719, 259273, 150751, 257225,
                           150761, 154825, 150775, 244937, 150779, 228553, 150799, 246473, 150827,
                           217801, 150841, 160457, 150867, 207561, 150903, 244425, 150923, 214729,
                           150971, 227017, 150981, 167625, 151003, 224969, 151029, 179913, 151045,
                           164297, 151063, 238025, 151083, 217545, 151125, 174537, 151135, 256457,
                           151175, 230857, 151187, 206281, 151277, 187849, 151283, 212425, 151303,
                           230345, 151321, 156617, 151351, 242633, 151363, 199625, 151387, 224201,
                           151389, 191433, 151399, 236489, 151447, 239561, 151469, 186313, 151501,
                           184265, 151513, 159689, 151547, 229321, 151549, 196553, 151555, 196649,
                           151575, 237609, 151579, 221225, 151591, 233513, 151605, 176169, 151641,
                           157737, 151653, 170025, 151735, 242729, 151741, 193577, 151773, 191529,
                           151783, 236585, 151787, 220201, 151807, 261161, 151827, 205353, 151849,
                           152105, 151887, 248361, 151915, 219689, 151941, 165417, 151951, 247337,
                           151959, 239145, 151965, 189993, 151987, 210473, 152011, 216617, 152025,
                           159273, 152031, 257577, 152035, 204329, 152061, 196137, 152075, 213289,
                           152083, 205097, 152155, 223529, 152167, 235817, 152173, 186665, 152255,
                           259369, 152267, 216361, 152277, 175401, 152293, 171305, 152311, 245033,
                           152335, 246569, 152365, 185129, 152383, 258857, 152403, 207657, 152419,
                           203561, 152421, 170793, 152459, 214825, 152473, 157481, 152515, 200489,
                           152527, 249641, 152565, 180009, 152569, 163625, 152587, 213161, 152595,
                           204969, 152613, 168105, 152637, 192681, 152655, 247977, 152683, 219305,
                           152693, 178345, 152743, 234665, 152755, 210089, 152757, 177321, 152767,
                           259241, 152779, 216233, 152793, 158889, 152815, 253097, 152829, 195753,
                           152835, 197289, 152861, 189097, 152875, 217769, 152903, 232105, 152909,
                           182953, 152917, 174761, 152981, 173737, 153015, 243369, 153019, 226985,
                           153029, 167593, 153069, 188073, 153091, 197033, 153115, 221609, 153131,
                           217513, 153133, 184745, 153141, 176553, 153173, 174505, 153199, 252329,
                           153227, 214441, 153229, 181673, 153283, 200105, 153285, 167337, 153325,
                           187817, 153331, 212393, 153343, 261545, 153375, 254889, 153391, 250793,
                           153403, 226217, 153431, 240553, 153437, 191401, 153451, 220073, 153543,
                           233385, 153557, 176041, 153573, 171945, 153619, 204905, 153637, 168041,
                           153655, 241769, 153659, 225385, 153709, 186473, 153715, 211049, 153731,
                           197737, 153751, 238697, 153757, 189545, 153785, 160873, 153839, 253033,
                           153851, 228457, 153883, 221801, 153895, 234089, 153919, 258665, 153933,
                           182889, 153961, 154217, 153967, 252521, 153991, 231017, 154003, 206441,
                           154019, 202345, 154031, 251497, 154075, 224873, 154093, 188009, 154101,
                           179817, 154117, 164201, 154127, 246121, 154139, 221545, 154169, 160105,
                           154175, 258409, 154183, 231785, 154247, 230761, 154275, 202089, 154299,
                           226665, 154301, 193897, 154309, 167273, 154333, 191849, 154399, 254825,
                           154437, 166761, 154477, 187241, 154483, 211817, 154499, 198505, 154535,
                           235369, 154541, 186217, 154553, 161641, 154567, 233321, 154581, 175977,
                           154595, 204649, 154597, 171881, 154647, 237801, 154701, 182505, 154719,
                           256233, 154723, 202985, 154747, 227561, 154749, 194793, 154765, 181481,
                           154783, 255209, 154843, 224489, 154891, 213737, 154899, 205545, 154905,
                           156393, 154959, 248553, 155035, 222953, 155053, 186089, 155059, 210665,
                           155083, 216809, 155103, 257769, 155113, 155369, 155149, 180713, 155157,
                           172521, 155203, 199145, 155205, 166377, 155239, 236009, 155253, 178665,
                           155257, 162281, 155279, 247273, 155291, 222697, 155307, 218601, 155315,
                           210409, 155347, 208361, 155359, 257513, 155363, 204265, 155421, 189417,
                           155449, 160745, 155455, 259049, 155475, 207849, 155533, 182249, 155551,
                           255977, 155557, 169961, 155575, 243689, 155589, 167913, 155693, 184345,
                           155711, 258073, 155719, 231449, 155723, 215065, 155737, 157721, 155759,
                           251929, 155813, 168985, 155863, 240665, 155879, 236569, 155891, 211993,
                           155893, 179225, 155903, 261145, 155911, 229913, 155925, 172569, 155951,
                           250393, 155963, 225817, 155991, 240153, 156021, 178713, 156055, 239129,
                           156075, 218649, 156083, 210457, 156089, 161305, 156095, 259609, 156115,
                           208409, 156117, 175641, 156133, 171545, 156167, 229657, 156195, 200985,
                           156215, 241945, 156267, 219417, 156287, 260377, 156291, 197913, 156293,
                           165145, 156315, 222489, 156351, 259353, 156363, 216345, 156377, 159001,
                           156383, 257305, 156407, 245017, 156445, 189209, 156467, 209689, 156473,
                           160537, 156487, 232217, 156493, 183065, 156511, 256793, 156551, 231193,
                           156557, 182041, 156565, 173849, 156581, 169753, 156603, 227097, 156651,
                           220953, 156683, 213145, 156691, 204953, 156703, 254105, 156727, 241817,
                           156733, 192665, 156739, 198809, 156775, 235673, 156815, 246937, 156845,
                           185497, 156871, 232601, 156919, 244889, 156925, 195737, 156943, 246425,
                           156951, 238233, 156957, 189081, 156979, 209561, 156991, 258713, 157077,
                           173721, 157081, 157337, 157115, 226969, 157143, 241305, 157149, 192153,
                           157177, 163481, 157189, 164249, 157211, 221593, 157237, 176537, 157259,
                           215449, 157261, 182681, 157273, 158105, 157303, 244121, 157323, 214425,
                           157359, 251289, 157379, 200089, 157403, 224665, 157419, 220569, 157421,
                           187801, 157447, 230297, 157453, 181145, 157509, 166809, 157567, 261017,
                           157573, 165785, 157597, 190361, 157607, 235417, 157621, 178073, 157691,
                           229273, 157703, 229465, 157707, 213081, 157757, 192601, 157765, 165977,
                           157783, 239705, 157789, 190553, 157811, 211033, 157817, 161881, 157869,
                           185433, 157881, 160857, 157887, 259161, 157901, 183385, 157925, 171097,
                           158005, 176729, 158035, 207449, 158053, 170585, 158127, 251481, 158139,
                           226905, 158147, 200281, 158195, 212569, 158207, 261721, 158237, 188761,
                           158247, 233817, 158251, 217433, 158259, 209241, 158265, 160089, 158303,
                           256345, 158307, 203097, 158319, 252249, 158355, 206169, 158367, 255321,
                           158373, 169305, 158391, 243033, 158415, 249177, 158427, 224601, 158429,
                           191833, 158443, 220505, 158451, 212313, 158475, 213849, 158485, 172889,
                           158531, 199513, 158543, 248665, 158585, 162649, 158591, 260953, 158595,
                           198489, 158615, 239449, 158637, 186201, 158645, 178009, 158669, 184153,
                           158693, 171865, 158711, 245593, 158725, 164057, 158735, 245977, 158747,
                           221401, 158765, 184537, 158797, 182489, 158805, 174297, 158843, 227545,
                           158855, 230617, 158859, 214233, 158883, 201945, 158907, 226521, 158909,
                           193753, 158965, 179417, 158969, 163033, 159013, 168665, 159023, 250585,
                           159031, 242393, 159067, 223961, 159085, 187097, 159119, 247513, 159131,
                           222937, 159143, 235225, 159161, 161497, 159167, 259801, 159189, 175833,
                           159205, 171737, 159223, 245465, 159263, 254425, 159301, 166361, 159319,
                           240089, 159341, 186841, 159359, 260569, 159375, 247257, 159399, 234969,
                           159431, 232921, 159435, 216537, 159459, 204249, 159491, 197593, 159493,
                           164825, 159563, 216025, 159571, 207833, 159583, 256985, 159607, 244697,
                           159613, 195545, 159627, 215001, 159683, 200665, 159723, 221145, 159737,
                           163801, 159763, 204857, 159781, 167993, 159847, 235577, 159853, 186425,
                           159877, 164921, 159899, 222265, 159935, 259129, 159949, 183353, 159967,
                           257081, 159983, 252985, 159995, 228409, 160005, 164409, 160053, 176697,
                           160057, 160313, 160099, 203321, 160111, 252473, 160123, 227897, 160141,
                           181817, 160147, 206393, 160159, 255545, 160163, 202297, 160197, 167481,
                           160215, 241209, 160221, 192057, 160237, 187961, 160295, 233785, 160301,
                           184633, 160339, 207161, 160355, 203065, 160415, 255289, 160421, 169273,
                           160451, 199993, 160453, 167225, 160471, 240953, 160493, 187705, 160511,
                           261433, 160533, 172857, 160559, 250681, 160573, 193337, 160591, 248633,
                           160599, 240441, 160619, 219961, 160627, 211769, 160645, 165689, 160663,
                           239417, 160697, 161593, 160791, 237753, 160813, 184505, 160819, 209081,
                           160831, 258233, 160851, 207033, 160863, 256185, 160879, 252089, 160893,
                           194745, 160957, 193721, 160987, 224441, 160999, 236729, 161023, 261305,
                           161043, 205497, 161059, 201401, 161079, 242361, 161093, 166585, 161117,
                           191161, 161151, 260793, 161155, 198329, 161167, 247481, 161205, 177849,
                           161209, 161465, 161223, 233145, 161227, 216761, 161237, 175801, 161277,
                           196281, 161317, 168377, 161327, 250297, 161339, 225721, 161347, 199097,
                           161349, 166329, 161371, 223673, 161383, 235961, 161389, 186809, 161447,
                           234937, 161451, 218553, 161453, 185785, 161471, 259513, 161483, 216505,
                           161559, 238521, 161565, 189369, 161607, 232377, 161621, 175033, 161631,
                           256953, 161635, 203705, 161637, 170937, 161655, 244665, 161659, 228281,
                           161677, 182201, 161711, 251833, 161731, 200633, 161767, 237497, 161779,
                           212921, 161795, 196729, 161815, 237689, 161867, 215161, 161887, 256121,
                           161915, 227449, 161939, 205945, 161955, 201849, 161957, 169081, 161999,
                           248953, 162029, 187513, 162059, 213625, 162069, 172665, 162095, 250489,
                           162115, 199289, 162141, 191097, 162151, 236153, 162155, 219769, 162199,
                           239225, 162221, 185977, 162229, 177785, 162259, 208505, 162301, 196217,
                           162311, 229753, 162317, 180601, 162339, 201081, 162351, 250233, 162365,
                           192889, 162419, 211321, 162421, 178553, 162455, 238969, 162461, 189817,
                           162475, 218489, 162483, 210297, 162503, 232825, 162531, 204153, 162533,
                           171385, 162555, 228729, 162563, 197497, 162587, 222073, 162603, 217977,
                           162605, 185209, 162623, 258937, 162631, 232313, 162645, 174969, 162699,
                           214905, 162701, 182137, 162757, 167801, 162775, 241529, 162797, 188281,
                           162823, 229625, 162829, 180473, 162851, 200953, 162875, 225529, 162895,
                           248057, 162903, 239865, 162949, 165113, 162973, 189689, 162983, 234745,
                           163021, 183545, 163029, 175353, 163039, 257273, 163055, 253177, 163095,
                           238329, 163111, 234233, 163123, 209657, 163155, 207609, 163207, 231161,
                           163221, 173817, 163237, 169721, 163279, 249593, 163291, 225017, 163317,
                           179961, 163371, 217593, 163413, 174585, 163423, 256505, 163429, 170489,
                           163451, 227833, 163477, 173561, 163517, 194041, 163535, 249337, 163549,
                           191993, 163597, 181241, 163603, 205817, 163643, 226297, 163699, 211961,
                           163701, 179193, 163715, 198649, 163727, 247801, 163739, 223225, 163741,
                           190457, 163811, 204793, 163813, 172025, 163823, 253945, 163831, 245753,
                           163859, 204805, 163877, 167941, 163909, 165893, 163949, 186373, 163955,
                           210949, 163967, 260101, 163973, 164869, 163983, 246789, 163991, 238597,
                           164039, 232453, 164053, 175109, 164063, 257029, 164119, 238085, 164159,
                           258565, 164179, 207365, 164197, 170501, 164333, 187909, 164381, 188677,
                           164423, 231685, 164429, 182533, 164435, 207109, 164451, 203013, 164471,
                           243973, 164511, 255237, 164541, 193797, 164547, 199941, 164573, 191749,
                           164587, 220421, 164595, 212229, 164619, 213765, 164621, 180997, 164675,
                           199429, 164677, 166661, 164717, 187141, 164735, 260869, 164781, 186117,
                           164789, 177925, 164799, 259845, 164807, 233221, 164855, 245509, 164861,
                           196357, 164887, 237701, 164903, 233605, 164907, 217221, 164917, 176261,
                           164939, 215173, 164949, 174213, 164999, 230533, 165011, 205957, 165029,
                           169093, 165101, 187525, 165141, 172677, 165157, 168581, 165167, 250501,
                           165175, 242309, 165181, 193157, 165199, 248453, 165211, 223877, 165223,
                           236165, 165227, 219781, 165251, 198277, 165253, 165509, 165287, 235141,
                           165325, 183941, 165343, 257669, 165373, 196229, 165397, 172421, 165411,
                           201093, 165423, 250245, 165455, 248197, 165491, 211333, 165527, 238981,
                           165531, 222597, 165549, 185733, 165575, 232837, 165587, 208261, 165589,
                           175493, 165627, 228741, 165695, 258949, 165715, 207749, 165731, 203653,
                           165757, 195461, 165773, 182149, 165815, 243589, 165821, 194437, 165877,
                           180101, 165915, 221253, 165927, 233541, 165941, 176197, 165971, 206917,
                           165999, 251973, 166013, 194629, 166027, 214085, 166037, 173125, 166053,
                           169029, 166095, 248901, 166199, 242245, 166213, 166469, 166235, 223813,
                           166253, 186949, 166315, 218693, 166371, 204357, 166431, 254277, 166455,
                           241989, 166459, 225605, 166467, 198981, 166487, 239941, 166503, 235845,
                           166509, 186693, 166515, 211269, 166517, 178501, 166527, 260421, 166531,
                           197957, 166567, 234821, 166581, 177477, 166603, 216389, 166629, 171333,
                           166683, 222021, 166685, 189253, 166707, 209733, 166751, 256837, 166757,
                           170821, 166775, 244549, 166797, 182085, 166815, 255813, 166819, 202565,
                           166891, 220997, 166919, 229573, 166967, 241861, 166973, 192709, 166991,
                           248005, 167005, 190661, 167015, 235717, 167019, 219333, 167085, 185541,
                           167091, 210117, 167093, 177349, 167117, 183493, 167151, 253125, 167165,
                           195781, 167211, 217797, 167221, 176837, 167243, 215749, 167245, 182981,
                           167263, 256709, 167291, 228037, 167315, 206533, 167327, 255685, 167331,
                           202437, 167355, 227013, 167365, 167621, 167375, 249541, 167387, 224965,
                           167439, 246213, 167509, 174533, 167525, 170437, 167549, 195013, 167563,
                           214469, 167571, 206277, 167607, 243141, 167613, 193989, 167619, 200133,
                           167639, 241093, 167687, 230341, 167701, 172997, 167715, 201669, 167741,
                           193477, 167783, 236485, 167853, 186309, 167871, 260037, 167903, 257989,
                           167959, 237605, 167965, 188453, 168007, 231461, 168037, 170021, 168075,
                           214053, 168085, 173093, 168111, 250917, 168167, 236581, 168211, 205349,
                           168223, 254501, 168251, 225829, 168253, 193061, 168283, 223781, 168295,
                           236069, 168323, 198181, 168403, 208421, 168419, 204325, 168421, 171557,
                           168439, 245285, 168455, 229669, 168469, 172325, 168507, 225573, 168539,
                           223525, 168591, 247077, 168615, 234789, 168627, 210213, 168671, 257317,
                           168687, 253221, 168699, 228645, 168707, 197413, 168727, 238373, 168731,
                           221989, 168749, 185125, 168757, 176933, 168779, 215845, 168843, 214821,
                           168853, 173861, 168869, 169765, 168879, 251685, 168893, 194341, 168899,
                           200485, 168935, 237349, 168941, 188197, 168995, 200869, 169039, 247973,
                           169047, 239781, 169067, 219301, 169077, 178341, 169133, 185509, 169159,
                           232613, 169171, 208037, 169231, 246437, 169245, 189093, 169279, 258725,
                           169287, 232101, 169291, 215717, 169299, 207525, 169327, 252581, 169341,
                           195237, 169355, 214693, 169431, 241317, 169459, 212645, 169461, 179877,
                           169475, 197029, 169501, 188837, 169523, 209317, 169525, 176549, 169543,
                           231845, 169557, 174501, 169607, 230821, 169659, 226725, 169691, 224677,
                           169709, 187813, 169747, 205733, 169763, 201637, 169837, 187301, 169855,
                           261029, 169883, 223141, 169895, 235429, 169951, 257957, 169957, 171941,
                           169975, 245669, 170003, 204901, 170015, 254053, 170031, 249957, 170043,
                           225381, 170051, 198757, 170087, 235621, 170099, 211045, 170101, 178277,
                           170115, 197733, 170165, 177253, 170183, 232549, 170187, 216165, 170223,
                           253029, 170231, 244837, 170255, 246373, 170263, 238181, 170283, 217701,
                           170303, 258661, 170325, 174693, 170335, 256613, 170341, 170597, 170363,
                           227941, 170429, 194149, 170435, 200293, 170485, 179813, 170499, 196965,
                           170523, 221541, 170559, 258405, 170579, 207205, 170591, 256357, 170645,
                           173413, 170671, 251237, 170679, 243045, 170685, 193893, 170703, 249189,
                           170787, 201573, 170839, 240485, 170843, 224101, 170845, 191333, 170859,
                           220005, 171023, 245989, 171083, 215269, 171091, 207077, 171093, 174309,
                           171119, 252133, 171133, 194789, 171149, 181477, 171155, 206053, 171183,
                           251109, 171191, 242917, 171195, 226533, 171245, 187621, 171251, 212197,
                           171263, 261349, 171295, 254693, 171367, 236261, 171379, 211685, 171407,
                           247525, 171419, 222949, 171437, 186085, 171443, 210661, 171477, 175845,
                           171491, 204517, 171531, 213477, 171539, 205285, 171555, 201189, 171629,
                           186853, 171637, 178661, 171671, 239077, 171687, 234981, 171699, 210405,
                           171701, 177637, 171725, 183781, 171773, 196069, 171815, 234469, 171819,
                           218085, 171827, 209893, 171853, 183269, 171899, 228325, 171959, 243685,
                           171963, 227301, 172061, 188437, 172075, 217109, 172109, 182293, 172127,
                           256021, 172131, 202773, 172143, 251925, 172251, 224277, 172275, 211989,
                           172307, 205333, 172323, 201237, 172349, 193045, 172367, 248341, 172397,
                           186901, 172415, 260629, 172439, 239125, 172557, 180501, 172603, 225557,
                           172651, 219413, 172687, 247061, 172701, 189717, 172715, 218389, 172743,
                           232725, 172767, 257301, 172791, 245013, 172815, 246549, 172839, 234261,
                           172845, 185109, 172885, 174869, 172987, 227093, 173031, 237333, 173055,
                           261909, 173069, 180373, 173087, 254101, 173147, 223381, 173149, 190613,
                           173163, 219285, 173187, 197781, 173237, 177301, 173259, 216213, 173261,
                           183445, 173283, 203925, 173307, 228501, 173315, 197269, 173351, 234133,
                           173357, 184981, 173363, 209557, 173407, 256661, 173423, 252565, 173431,
                           244373, 173437, 195221, 173459, 206485, 173461, 173717, 173487, 251541,
                           173507, 200341, 173567, 261781, 173619, 209301, 173651, 207253, 173653,
                           174485, 173663, 256405, 173667, 203157, 173691, 227733, 173709, 181653,
                           173731, 202133, 173757, 193941, 173775, 249237, 173783, 241045, 173799,
                           236949, 173837, 181141, 173879, 242581, 173891, 199573, 173915, 224149,
                           173979, 223125, 174005, 178069, 174015, 259989, 174063, 253845, 174071,
                           245653, 174087, 229461, 174115, 200789, 174127, 249941, 174183, 235605,
                           174189, 186453, 174197, 178261, 174231, 238677, 174235, 222293, 174247,
                           234581, 174253, 185429, 174271, 259157, 174283, 216149, 174333, 195669,
                           174351, 246357, 174359, 238165, 174411, 215637, 174431, 256597, 174435,
                           203349, 174447, 252501, 174499, 202325, 174571, 220757, 174621, 188757,
                           174631, 233813, 174635, 217429, 174645, 176469, 174711, 244053, 174731,
                           214357, 174733, 181589, 174779, 226645, 174807, 240981, 174811, 224597,
                           174837, 179541, 174855, 230229, 174907, 226133, 174941, 191317, 174965,
                           179029, 174999, 239445, 175005, 190293, 175019, 218965, 175027, 210773,
                           175061, 175957, 175071, 257877, 175131, 221397, 175155, 209109, 175167,
                           258261, 175215, 252117, 175223, 243925, 175229, 194773, 175239, 230613,
                           175251, 206037, 175267, 201941, 175293, 193749, 175299, 199893, 175311,
                           249045, 175325, 191701, 175339, 220373, 175341, 187605, 175367, 230101,
                           175395, 201429, 175419, 226005, 175467, 219861, 175487, 260821, 175541,
                           177877, 175587, 204501, 175629, 180693, 175647, 254421, 175671, 242133,
                           175675, 225749, 175747, 198101, 175771, 222677, 175773, 189909, 175787,
                           218581, 175819, 216533, 175827, 208341, 175855, 253397, 175895, 238549,
                           175917, 185301, 175923, 209877, 175935, 259029, 175949, 183253, 175955,
                           207829, 175971, 203733, 175995, 228309, 176007, 231381, 176031, 255957,
                           176047, 251861, 176059, 227285, 176093, 192469, 176115, 212949, 176139,
                           213045, 176141, 180277, 176159, 254005, 176189, 192565, 176195, 198709,
                           176215, 239669, 176221, 190517, 176235, 219189, 176279, 238645, 176283,
                           222261, 176285, 189493, 176319, 259125, 176333, 183349, 176375, 244789,
                           176387, 197173, 176411, 221749, 176413, 188981, 176427, 217653, 176437,
                           176693, 176503, 244277, 176531, 206389, 176543, 255541, 176573, 194101,
                           176579, 200245, 176603, 224821, 176629, 179765, 176643, 196917, 176691,
                           209205, 176763, 227637, 176787, 206133, 176827, 226613, 176847, 249141,
                           176861, 191797, 176951, 242485, 176987, 224053, 177013, 178997, 177069,
                           186165, 177075, 210741, 177195, 217269, 177197, 184501, 177215, 258229,
                           177223, 231605, 177251, 202933, 177275, 227509, 177315, 201909, 177327,
                           251061, 177347, 199861, 177373, 191669, 177383, 236725, 177419, 213685,
                           177421, 180917, 177463, 242357, 177523, 211637, 177525, 178869, 177551,
                           247477, 177579, 218805, 177599, 259765, 177635, 204469, 177661, 196277,
                           177677, 180661, 177695, 254389, 177723, 225717, 177821, 189877, 177903,
                           253365, 177915, 228789, 177959, 234421, 177965, 185269, 177983, 258997,
                           177995, 215989, 178015, 256949, 178043, 228277, 178045, 195509, 178103,
                           243637, 178115, 200629, 178127, 249781, 178141, 192437, 178165, 180149,
                           178191, 245877, 178205, 188533, 178247, 231541, 178287, 252021, 178315,
                           214133, 178335, 255093, 178371, 199797, 178431, 261237, 178445, 180853,
                           178467, 201333, 178479, 250485, 178511, 248437, 178519, 240245, 178525,
                           191093, 178539, 219765, 178575, 247413, 178583, 239221, 178603, 218741,
                           178605, 185973, 178611, 210549, 178631, 233077, 178679, 245365, 178699,
                           213365, 178755, 199029, 178779, 223605, 178795, 219509, 178797, 186741,
                           178819, 198005, 178867, 210293, 178879, 259445, 178893, 183669, 178935,
                           245109, 178939, 228725, 178941, 195957, 178959, 246645, 178983, 234357,
                           179015, 232309, 179069, 195445, 179079, 231285, 179091, 206709, 179107,
                           202613, 179163, 225141, 179165, 192373, 179231, 254197, 179247, 250101,
                           179261, 192757, 179309, 186613, 179315, 211189, 179367, 234741, 179403,
                           216309, 179427, 204021, 179447, 244981, 179499, 217845, 179507, 209653,
                           179519, 258805, 179533, 183029, 179555, 203509, 179591, 231157, 179597,
                           182005, 179615, 255733, 179631, 251637, 179645, 194293, 179651, 200437,
                           179663, 249589, 179671, 241397, 179701, 179957, 179757, 184821, 179787,
                           215541, 179807, 256501, 179847, 230901, 179851, 214517, 179901, 194037,
                           179943, 237045, 179947, 220661, 179967, 261621, 180023, 242677, 180059,
                           224245, 180061, 191477, 180111, 247797, 180139, 219125, 180191, 258037,
                           180219, 229365, 180227, 196621, 180247, 237581, 180275, 208909, 180363,
                           214029, 180387, 201741, 180413, 193549, 180419, 199693, 180445, 191501,
                           180535, 242189, 180539, 225805, 180567, 240141, 180571, 223757, 180573,
                           190989, 180637, 189965, 180659, 210445, 180707, 204301, 180719, 253453,
                           180783, 250125, 180791, 241933, 180797, 192781, 180827, 223501, 180891,
                           222477, 180893, 189709, 180903, 234765, 180947, 208141, 180963, 204045,
                           181055, 258829, 181063, 232205, 181075, 207629, 181091, 203533, 181111,
                           244493, 181115, 228109, 181131, 214797, 181151, 255757, 181187, 200461,
                           181199, 249613, 181223, 237325, 181227, 220941, 181255, 229517, 181283,
                           200845, 181341, 190605, 181403, 222349, 181439, 259213, 181495, 244877,
                           181519, 246413, 181543, 234125, 181555, 209549, 181579, 215693, 181627,
                           227981, 181629, 195213, 181663, 255629, 181687, 243341, 181711, 249485,
                           181719, 241293, 181725, 192141, 181739, 220813, 181741, 188045, 181747,
                           212621, 181775, 246157, 181835, 215437, 181879, 244109, 181885, 194957,
                           181935, 251277, 181947, 226701, 181979, 224653, 181991, 236941, 181997,
                           187789, 182027, 213901, 182063, 250765, 182075, 226189, 182095, 248717,
                           182103, 240525, 182123, 220045, 182131, 211853, 182171, 223117, 182207,
                           259981, 182221, 184205, 182227, 208781, 182239, 257933, 182279, 229453,
                           182303, 254029, 182351, 247885, 182359, 239693, 182363, 223309, 182415,
                           246861, 182429, 189517, 182451, 209997, 182523, 228429, 182551, 238157,
                           182567, 234061, 182579, 209485, 182653, 195149, 182667, 214605, 182691,
                           202317, 182723, 200269, 182735, 249421, 182763, 220749, 182765, 187981,
                           182807, 237901, 182813, 188749, 182867, 207181, 182947, 202061, 182971,
                           226637, 182999, 240973, 183005, 191821, 183087, 250701, 183095, 242509,
                           183127, 240461, 183149, 187213, 183171, 198477, 183183, 247629, 183243,
                           216909, 183251, 208717, 183293, 196429, 183299, 196813, 183325, 188621,
                           183339, 217293, 183391, 256205, 183479, 242893, 183517, 191693, 183531,
                           220365, 183539, 212173, 183551, 261325, 183607, 242381, 183655, 236237,
                           183659, 219853, 183679, 260813, 183703, 239309, 183757, 184013, 183799,
                           245453, 183803, 229069, 183839, 254413, 183855, 250317, 183869, 192973,
                           183915, 219597, 183923, 211405, 183951, 247245, 183979, 218573, 183981,
                           185805, 184055, 245197, 184059, 228813, 184091, 222157, 184109, 185293,
                           184135, 232397, 184139, 216013, 184211, 206797, 184239, 251853, 184253,
                           194509, 184407, 239661, 184411, 223277, 184423, 235565, 184447, 260141,
                           184451, 197677, 184477, 189485, 184531, 207917, 184547, 203821, 184567,
                           244781, 184619, 217645, 184675, 203309, 184695, 244269, 184699, 227885,
                           184735, 255533, 184751, 251437, 184771, 200237, 184797, 192045, 184811,
                           220717, 184819, 212525, 184855, 237869, 184871, 233773, 184915, 207149,
                           184943, 252205, 184955, 227629, 184971, 214317, 185007, 251181, 185027,
                           199981, 185095, 230189, 185179, 224045, 185197, 187181, 185203, 211757,
                           185239, 239405, 185259, 218925, 185287, 233261, 185315, 204589, 185327,
                           253741, 185347, 196781, 185383, 233645, 185415, 231597, 185443, 202925,
                           185455, 252077, 185463, 243885, 185503, 255149, 185533, 193709, 185563,
                           224429, 185599, 261293, 185631, 254637, 185661, 193197, 185679, 248493,
                           185755, 222893, 185757, 190125, 185779, 210605, 185811, 208557, 185827,
                           204461, 185847, 245421, 185891, 201133, 185947, 223661, 185959, 235949,
                           185965, 186797, 185987, 198061, 186023, 234925, 186047, 259501, 186059,
                           216493, 186115, 197549, 186127, 246701, 186151, 234413, 186155, 218029,
                           186187, 215981, 186295, 243629, 186327, 241581, 186333, 192429, 186347,
                           221101, 186349, 188333, 186355, 212909, 186367, 262061, 186439, 231533,
                           186463, 256109, 186491, 227437, 186503, 230509, 186527, 255085, 186563,
                           199789, 186599, 236653, 186611, 212077, 186767, 247405, 186835, 208493,
                           186863, 253549, 186911, 254317, 186915, 201069, 186935, 242029, 186939,
                           225645, 186959, 248173, 186971, 223597, 187083, 216429, 187107, 204141,
                           187133, 195949, 187163, 222061, 187199, 258925, 187211, 215917, 187219,
                           207725, 187325, 194413, 187355, 225133, 187371, 221037, 187403, 213229,
                           187427, 200941, 187451, 225517, 187453, 192749, 187479, 239853, 187485,
                           190701, 187535, 247021, 187571, 210157, 187591, 232685, 187603, 208109,
                           187615, 257261, 187711, 258797, 187759, 252653, 187787, 214765, 187831,
                           243437, 187863, 241389, 187885, 188141, 187919, 246253, 187943, 233965,
                           188027, 227821, 188029, 195053, 188051, 206317, 188087, 243181, 188111,
                           249325, 188119, 241133, 188167, 230381, 188171, 213997, 188215, 242669,
                           188239, 248813, 188263, 236525, 188267, 220141, 188287, 261101, 188291,
                           198637, 188411, 229357, 188427, 213021, 188463, 249885, 188507, 223261,
                           188547, 197661, 188595, 209949, 188639, 257053, 188655, 252957, 188675,
                           197149, 188701, 188957, 188747, 215581, 188771, 203293, 188807, 230941,
                           188835, 202269, 188859, 226845, 188879, 249373, 188887, 241181, 188891,
                           224797, 188915, 212509, 188927, 261661, 188931, 196893, 188943, 246045,
                           188955, 221469, 188991, 258333, 189053, 194845, 189115, 226589, 189143,
                           240925, 189191, 230173, 189245, 193309, 189251, 199453, 189263, 248605,
                           189299, 211741, 189327, 247581, 189335, 239389, 189395, 208669, 189431,
                           245533, 189463, 237725, 189503, 258205, 189515, 215197, 189565, 194717,
                           189579, 214173, 189659, 224413, 189661, 191645, 189715, 205469, 189751,
                           242333, 189803, 219805, 189811, 211613, 189827, 198301, 189875, 210589,
                           189947, 229021, 189963, 213405, 190007, 242077, 190019, 199069, 190095,
                           247197, 190107, 222621, 190119, 234909, 190143, 259485, 190151, 232861,
                           190163, 208285, 190191, 253341, 190251, 218013, 190259, 209821, 190271,
                           258973, 190279, 232349, 190331, 228253, 190397, 194461, 190423, 241565,
                           190487, 237661, 190503, 233565, 190507, 217181, 190535, 231517, 190559,
                           256093, 190707, 212061, 190731, 213597, 190755, 201309, 190775, 242269,
                           190811, 223837, 190813, 191069, 190851, 198237, 190875, 222813, 190899,
                           210525, 190911, 259677, 190967, 245341, 191023, 250205, 191035, 225629,
                           191043, 199005, 191175, 232797, 191199, 257373, 191203, 204125, 191227,
                           228701, 191247, 246621, 191275, 217949, 191315, 207709, 191343, 252765,
                           191351, 244573, 191357, 195421, 191407, 251741, 191495, 229597, 191507,
                           205021, 191519, 254173, 191543, 241885, 191603, 211165, 191659, 218333,
                           191727, 253149, 191739, 228573, 191741, 195805, 191747, 197341, 191771,
                           221917, 191855, 252637, 191863, 244445, 191879, 231133, 191891, 206557,
                           191927, 243421, 191933, 194269, 191975, 237277, 192023, 238045, 192043,
                           217565, 192051, 209373, 192071, 231901, 192095, 256477, 192139, 214493,
                           192163, 202205, 192187, 226781, 192189, 194013, 192207, 249309, 192235,
                           220637, 192267, 213981, 192287, 254941, 192315, 226269, 192383, 261085,
                           192387, 198621, 192411, 223197, 192423, 235485, 192447, 260061, 192495,
                           253917, 192539, 221245, 192555, 217149, 192611, 202813, 192671, 255037,
                           192695, 242749, 192701, 193597, 192727, 240701, 192799, 254525, 192803,
                           201277, 192827, 225853, 192835, 199229, 192847, 248381, 192911, 247357,
                           192923, 222781, 192967, 233021, 193015, 245309, 193019, 228925, 193059,
                           201021, 193131, 219453, 193151, 260413, 193155, 197949, 193179, 222525,
                           193191, 234813, 193227, 216381, 193263, 253245, 193275, 228669, 193283,
                           197437, 193331, 209725, 193355, 215869, 193391, 252733, 193439, 255805,
                           193443, 202557, 193463, 243517, 193499, 225085, 193555, 204989, 193603,
                           198845, 193663, 260285, 193679, 246973, 193707, 218301, 193763, 203965,
                           193783, 244925, 193815, 238269, 193819, 221885, 193835, 217789, 193855,
                           258749, 193891, 203453, 194007, 241341, 194023, 237245, 194035, 212669,
                           194087, 233917, 194167, 244157, 194171, 227773, 194183, 230845, 194187,
                           214461, 194267, 224701, 194323, 205757, 194359, 242621, 194363, 226237,
                           194391, 240573, 194411, 220093, 194507, 217021, 194531, 204733, 194557,
                           196541, 194571, 213117, 194619, 225405, 194627, 198781, 194675, 211069,
                           194715, 222333, 194783, 257149, 194855, 234109, 194891, 215677, 194935,
                           244349, 194941, 195197, 194955, 214653, 194963, 206461, 194975, 255613,
                           194991, 251517, 194999, 243325, 195047, 237181, 195075, 196989, 195087,
                           246141, 195123, 209277, 195143, 231805, 195167, 256381, 195171, 203133,
                           195207, 230781, 195219, 206205, 195231, 255357, 195235, 202109, 195287,
                           241021, 195327, 261501, 195363, 201597, 195375, 250749, 195419, 224125,
                           195599, 246013, 195703, 243965, 195791, 249085, 195827, 212221, 195871,
                           254717, 195907, 199421, 195927, 240381, 195931, 223997, 195967, 260861,
                           196011, 218877, 196031, 259837, 196039, 233213, 196079, 253693, 196087,
                           245501, 196115, 205309, 196151, 242173, 196175, 248317, 196227, 198141,
                           196247, 239101, 196299, 216573, 196323, 204285, 196335, 253437, 196355,
                           197629, 196435, 207869, 196475, 228349, 196499, 206845, 196515, 202749,
                           196527, 251901, 196535, 243709, 196619, 212995, 196643, 200707, 196667,
                           225283, 196675, 198659, 196695, 239619, 196715, 219139, 196751, 246787,
                           196807, 232451, 196819, 207875, 196835, 203779, 196855, 244739, 196879,
                           246275, 196907, 217603, 196963, 203267, 196975, 252419, 197003, 214531,
                           197039, 251395, 197047, 243203, 197119, 261635, 197135, 246019, 197143,
                           237827, 197159, 233731, 197191, 231683, 197303, 242947, 197307, 226563,
                           197339, 224515, 197387, 213763, 197411, 201475, 197483, 219907, 197503,
                           260867, 197507, 198403, 197527, 239363, 197531, 222979, 197555, 210691,
                           197615, 253699, 197659, 221315, 197683, 209027, 197731, 202883, 197839,
                           248963, 197847, 240771, 197867, 220291, 197907, 205443, 197919, 254595,
                           197935, 250499, 197991, 236163, 198019, 198275, 198055, 235139, 198087,
                           233091, 198115, 204419, 198175, 254339, 198199, 242051, 198223, 248195,
                           198231, 240003, 198323, 210307, 198347, 216451, 198439, 234371, 198463,
                           258947, 198495, 256899, 198547, 206723, 198595, 200579, 198655, 262019,
                           198695, 233539, 198699, 217155, 198731, 215107, 198831, 250947, 198843,
                           226371, 198887, 236611, 198899, 212035, 198919, 229955, 198923, 213571,
                           198943, 254531, 198947, 201283, 198999, 240195, 199027, 211523, 199055,
                           247363, 199123, 208451, 199139, 204355, 199163, 228931, 199203, 201027,
                           199259, 223555, 199275, 219459, 199295, 260419, 199319, 238915, 199323,
                           222531, 199379, 208195, 199415, 245059, 199439, 246595, 199475, 209731,
                           199495, 232259, 199523, 203587, 199547, 228163, 199571, 206659, 199611,
                           227139, 199631, 249667, 199659, 220995, 199679, 261955, 199771, 223427,
                           199783, 235715, 199835, 222403, 199847, 234691, 199851, 218307, 199919,
                           253123, 199979, 217795, 200031, 256707, 200055, 244419, 200075, 214723,
                           200131, 200387, 200179, 212675, 200215, 238019, 200311, 244163, 200315,
                           227779, 200339, 206275, 200455, 230339, 200527, 248771, 200575, 261059,
                           200591, 247747, 200599, 239555, 200627, 210883, 200671, 257987, 200675,
                           204739, 200727, 237603, 200747, 217123, 200755, 208931, 200779, 215075,
                           200827, 227363, 200863, 255011, 200867, 201763, 200919, 240675, 200967,
                           229923, 200979, 205347, 201007, 250403, 201015, 242211, 201039, 248355,
                           201151, 259619, 201199, 253475, 201263, 250147, 201275, 225571, 201359,
                           247075, 201367, 238883, 201387, 218403, 201463, 245027, 201467, 228643,
                           201487, 246563, 201535, 258851, 201571, 203555, 201591, 244515, 201619,
                           206627, 201687, 241443, 201759, 254115, 201783, 241827, 201871, 246947,
                           201879, 238755, 201899, 218275, 202023, 234147, 202067, 207523, 202079,
                           256675, 202095, 252579, 202147, 202403, 202159, 251555, 202215, 237219,
                           202291, 209315, 202303, 258467, 202339, 203171, 202363, 227747, 202379,
                           214435, 202399, 255395, 202447, 249251, 202455, 241059, 202527, 254883,
                           202555, 226211, 202695, 233379, 202707, 208803, 202799, 249955, 202831,
                           247907, 202855, 235619, 202859, 219235, 202879, 260195, 202955, 216163,
                           202999, 244835, 203083, 215651, 203103, 256611, 203143, 231011, 203167,
                           255587, 203191, 243299, 203215, 249443, 203243, 220771, 203303, 233827,
                           203347, 207203, 203383, 244067, 203451, 226659, 203479, 240995, 203495,
                           236899, 203579, 226147, 203675, 223075, 203691, 218979, 203699, 210787,
                           203711, 259939, 203743, 257891, 203767, 245603, 203827, 209123, 203887,
                           252131, 203899, 227555, 203911, 230627, 203923, 206051, 203995, 224483,
                           204007, 236771, 204051, 205539, 204063, 254691, 204123, 223971, 204139,
                           219875, 204183, 239331, 204199, 235235, 204203, 218851, 204259, 204515,
                           204375, 240099, 204379, 223715, 204431, 247267, 204527, 253411, 204571,
                           222179, 204595, 209891, 204615, 232419, 204667, 228323, 204683, 215011,
                           204751, 249827, 204759, 241635, 204815, 245779, 204823, 237587, 204827,
                           221203, 204895, 256019, 204919, 243731, 204959, 254995, 204987, 226323,
                           205007, 248851, 205035, 220179, 205075, 205331, 205103, 250387, 205111,
                           242195, 205143, 240147, 205199, 247315, 205211, 222739, 205227, 218643,
                           205259, 216595, 205267, 208403, 205303, 245267, 205319, 229651, 205343,
                           254227, 205371, 225555, 205391, 248083, 205399, 239891, 205403, 223507,
                           205439, 260371, 205463, 238867, 205479, 234771, 205607, 234259, 205619,
                           209683, 205663, 256787, 205703, 231187, 205751, 243475, 205787, 225043,
                           205803, 220947, 205835, 213139, 205871, 250003, 205931, 219283, 205975,
                           238739, 205979, 222355, 206023, 232595, 206119, 234131, 206123, 217747,
                           206143, 258707, 206151, 232083, 206191, 252563, 206267, 226963, 206407,
                           231827, 206459, 227731, 206495, 255379, 206543, 249235, 206591, 261523,
                           206639, 250771, 206719, 261011, 206771, 210835, 206795, 216979, 206859,
                           213075, 206903, 241747, 206951, 235603, 206963, 211027, 207015, 234579,
                           207087, 253011, 207155, 209491, 207175, 232019, 207227, 227923, 207291,
                           226899, 207311, 249427, 207319, 241235, 207383, 237907, 207435, 215379,
                           207471, 252243, 207479, 244051, 207535, 251219, 207591, 236883, 207615,
                           261459, 207767, 239443, 207819, 216915, 207867, 229203, 208011, 214227,
                           208059, 226515, 208087, 240851, 208115, 212179, 208127, 261331, 208139,
                           213715, 208235, 219859, 208243, 211667, 208299, 218835, 208307, 210643,
                           208375, 245459, 208395, 213459, 208463, 248275, 208487, 235987, 208539,
                           222675, 208575, 259539, 208623, 253395, 208631, 245203, 208711, 232403,
                           208751, 252883, 208775, 231379, 208799, 255955, 208847, 249811, 208875,
                           221139, 208955, 225331, 209003, 219187, 209011, 210995, 209047, 238643,
                           209063, 234547, 209075, 209971, 209095, 232499, 209135, 252979, 209203,
                           209459, 209263, 252467, 209271, 244275, 209275, 227891, 209291, 214579,
                           209327, 251443, 209435, 221491, 209471, 258355, 209543, 230707, 209695,
                           254771, 209751, 240435, 209779, 211763, 209791, 260915, 209855, 259891,
                           209903, 253747, 209911, 245555, 209935, 245939, 209959, 233651, 209963,
                           217267, 209995, 215219, 210043, 227507, 210103, 242867, 210139, 224435,
                           210155, 220339, 210187, 213683, 210223, 250547, 210255, 248499, 210267,
                           223923, 210279, 236211, 210327, 239283, 210343, 235187, 210355, 210611,
                           210491, 225715, 210547, 211379, 210583, 239027, 210587, 222643, 210603,
                           218547, 210631, 232883, 210703, 246707, 210731, 218035, 210751, 258995,
                           210983, 233587, 211055, 252019, 211079, 230515, 211083, 214131, 211119,
                           250995, 211163, 224371, 211255, 242291, 211291, 223859, 211423, 257651,
                           211439, 253555, 211487, 254323, 211503, 250227, 211543, 239987, 211583,
                           260467, 211599, 247155, 211627, 218483, 211703, 245107, 211739, 222067,
                           211783, 232307, 211835, 228211, 211887, 251763, 211943, 237427, 211947,
                           221043, 211955, 212851, 212047, 248051, 212059, 223475, 212075, 219379,
                           212123, 222451, 212191, 257267, 212219, 228595, 212239, 246515, 212247,
                           238323, 212267, 217843, 212319, 256755, 212335, 252659, 212359, 231155,
                           212407, 243443, 212459, 220915, 212467, 212723, 212543, 258547, 212551,
                           231923, 212599, 244211, 212619, 214515, 212655, 251379, 212695, 241139,
                           212699, 224755, 212735, 261619, 212743, 230387, 212795, 226291, 212927,
                           260083, 212987, 229363, 213151, 254987, 213255, 229899, 213279, 254475,
                           213327, 248331, 213355, 219659, 213391, 247307, 213399, 239115, 213403,
                           222731, 213495, 245259, 213551, 250123, 213559, 241931, 213607, 235787,
                           213631, 260363, 213707, 216331, 213743, 253195, 213775, 246539, 213803,
                           217867, 213871, 252683, 213883, 228107, 213995, 220939, 214015, 261899,
                           214107, 223371, 214215, 232587, 214263, 244875, 214299, 221835, 214343,
                           232075, 214395, 227979, 214447, 251531, 214567, 233867, 214639, 252299,
                           214711, 243083, 214759, 236939, 214815, 254859, 214871, 240523, 214987,
                           216971, 215035, 229259, 215071, 254027, 215119, 247883, 215127, 239691,
                           215143, 235595, 215195, 222283, 215291, 228427, 215323, 221771, 215335,
                           234059, 215359, 258635, 215479, 243275, 215511, 241227, 215527, 237131,
                           215575, 237899, 215591, 233803, 215687, 230731, 215771, 224587, 215807,
                           261451, 215899, 224075, 215911, 236363, 215915, 219979, 215935, 260939,
                           215963, 223051, 215975, 235339, 216091, 221387, 216159, 256203, 216199,
                           230603, 216251, 226507, 216351, 254667, 216367, 250571, 216375, 242379,
                           216411, 223947, 216463, 247499, 216567, 245451, 216631, 242123, 216667,
                           223691, 216703, 260555, 216747, 218571, 216827, 228811, 216855, 238539,
                           216927, 256971, 217007, 251851, 217051, 225227, 217063, 237515, 217067,
                           221131, 217087, 262091, 217135, 249899, 217243, 222251, 217311, 257067,
                           217335, 244779, 217359, 246315, 217387, 217643, 217467, 227883, 217479,
                           230955, 217563, 224811, 217615, 246059, 217671, 231723, 217719, 244011,
                           217783, 242987, 217787, 226603, 217855, 261419, 217935, 248619, 217999,
                           247595, 218055, 233259, 218151, 233643, 218207, 256171, 218231, 243883,
                           218319, 249003, 218367, 261291, 218399, 254635, 218455, 240299, 218475,
                           219819, 218511, 247467, 218535, 235179, 218567, 233131, 218607, 253611,
                           218619, 229035, 218711, 240043, 218779, 222635, 218815, 259499, 218943,
                           258987, 218975, 256939, 219015, 231339, 219095, 241579, 219207, 231531,
                           219247, 252011, 219271, 230507, 219351, 240747, 219355, 224363, 219391,
                           261227, 219447, 242283, 219471, 248427, 219499, 219755, 219519, 260715,
                           219543, 239211, 219559, 235115, 219639, 245355, 219655, 229739, 219727,
                           248171, 219871, 257387, 219895, 245099, 219975, 232299, 220023, 244587,
                           220135, 237419, 220191, 254187, 220239, 248043, 220251, 223467, 220327,
                           234731, 220359, 232683, 220439, 238315, 220479, 258795, 220539, 228075,
                           220591, 251627, 220599, 243435, 220635, 225003, 220651, 220907, 220671,
                           261867, 220699, 221675, 220847, 251371, 220903, 237035, 220975, 250859,
                           221015, 240619, 221071, 247787, 221167, 253931, 221243, 225307, 221287,
                           235547, 221311, 260123, 221351, 234523, 221375, 259099, 221431, 244763,
                           221535, 256539, 221575, 230939, 221627, 226843, 221671, 237083, 221807,
                           252187, 221815, 243995, 221819, 227611, 221927, 236827, 222007, 242459,
                           222103, 239387, 222119, 235291, 222191, 253723, 222279, 231579, 222367,
                           255131, 222383, 251035, 222391, 242843, 222463, 261275, 222551, 240283,
                           222567, 236187, 222619, 222875, 222767, 250267, 222775, 242075, 222799,
                           248219, 222959, 253339, 222971, 228763, 222999, 238491, 223015, 234395,
                           223071, 256923, 223159, 243611, 223163, 227227, 223195, 225179, 223407,
                           250971, 223419, 226395, 223519, 254555, 223547, 225883, 223575, 240219,
                           223591, 236123, 223679, 259675, 223735, 245339, 223751, 229723, 223831,
                           239963, 223887, 247131, 223967, 257371, 224023, 238427, 224063, 258907,
                           224175, 251739, 224231, 237403, 224303, 250075, 224315, 225499, 224343,
                           239835, 224359, 235739, 224407, 238811, 224447, 259291, 224551, 234203,
                           224671, 255707, 224699, 227035, 224863, 256475, 224879, 252379, 224927,
                           255451, 224983, 241115, 225071, 250843, 225079, 242651, 225191, 235483,
                           225271, 245723, 225303, 237627, 225343, 258107, 225375, 256059, 225415,
                           230459, 225463, 242747, 225567, 254523, 225595, 225851, 225703, 235067,
                           225735, 233019, 225823, 254267, 225847, 241979, 225895, 235835, 225935,
                           247099, 225959, 234811, 225991, 232763, 226031, 253243, 226063, 246587,
                           226111, 258875, 226183, 231227, 226207, 255803, 226255, 249659, 226263,
                           241467, 226383, 247995, 226495, 259259, 226527, 257211, 226551, 244923,
                           226655, 256699, 226719, 255675, 226747, 227003, 226815, 261819, 226831,
                           246203, 226879, 258491, 226887, 231867, 227047, 236987, 227119, 250811,
                           227175, 236475, 227215, 247739, 227223, 239547, 227271, 233403, 227383,
                           241787, 227479, 238715, 227695, 252539, 227703, 244347, 227707, 227963,
                           227911, 231803, 227959, 244091, 228055, 241019, 228223, 260987, 228263,
                           235387, 228447, 256251, 228487, 230651, 228535, 242939, 228687, 248571,
                           228831, 257787, 228847, 253691, 228871, 229883, 228895, 254459, 229015,
                           239099, 229087, 257531, 229135, 246779, 229231, 252923, 229239, 244731,
                           229279, 255995, 229351, 237563, 229415, 233479, 229447, 231431, 229487,
                           251911, 229511, 230407, 229711, 248327, 229759, 260615, 229799, 235015,
                           229823, 259591, 229855, 257543, 229935, 250119, 230031, 247047, 230159,
                           246535, 230359, 241415, 230399, 261895, 230479, 247943, 230527, 260231,
                           230543, 246919, 230551, 238727, 230567, 234631, 230751, 256647, 230775,
                           244359, 230839, 243335, 230863, 249479, 230935, 237959, 231007, 256391,
                           231031, 244103, 231071, 255367, 231223, 242567, 231255, 240519, 231271,
                           236423, 231479, 241735, 231575, 238663, 231647, 257095, 231663, 252999,
                           231695, 246343, 231719, 234055, 231751, 232007, 231895, 241223, 231975,
                           233799, 231999, 258375, 232047, 252231, 232167, 236871, 232239, 250695,
                           232271, 248647, 232383, 259911, 232439, 245575, 232511, 258247, 232679,
                           236743, 232783, 248519, 232831, 260807, 232871, 235207, 233087, 260551,
                           233199, 253383, 233207, 245191, 233231, 246727, 233239, 238535, 233335,
                           244679, 233375, 255943, 233423, 249799, 233447, 237511, 233551, 247847,
                           233575, 235559, 233663, 259111, 233695, 257063, 233839, 252455, 233887,
                           255527, 233943, 241191, 233999, 246055, 234007, 237863, 234167, 242983,
                           234191, 249127, 234239, 261415, 234287, 250663, 234391, 239399, 234487,
                           245543, 234655, 255143, 234711, 240807, 234727, 236711, 234783, 254631,
                           234991, 253607, 235039, 254375, 235135, 260519, 235231, 257447, 235327,
                           258983, 235383, 244647, 235471, 249767, 235679, 255079, 235775, 261223,
                           235863, 240231, 235879, 236135, 235919, 247399, 235927, 239207, 236223,
                           259431, 236303, 246631, 236311, 238439, 236399, 252775, 236447, 255847,
                           236495, 249703, 236591, 250087, 236687, 247015, 236791, 244967, 237031,
                           237287, 237239, 243175, 237263, 249319, 237399, 240615, 237439, 261095,
                           237463, 239591, 237623, 241687, 237711, 246807, 237807, 252951, 237887,
                           258583, 238199, 243991, 238255, 251159, 238295, 240919, 238383, 250647,
                           238423, 240407, 238607, 245911, 239039, 259735, 239087, 253591, 239135,
                           254359, 239295, 259479, 239519, 255895, 239679, 258135, 239791, 250967,
                           239823, 248919, 239871, 261207, 239951, 248407, 240015, 247383, 240175,
                           250199, 240255, 260439, 240271, 247127, 240319, 259415, 240447, 258903,
                           240503, 244567, 240767, 260311, 240863, 257239, 240887, 244951, 240911,
                           246487, 241111, 241367, 241151, 261847, 241167, 246231, 241215, 258519,
                           241263, 252375, 241271, 244183, 241487, 248791, 241679, 245815, 241823,
                           255031, 241951, 254519, 241967, 250423, 242111, 259639, 242255, 248119,
                           242415, 253239, 242551, 244535, 242615, 243511, 242639, 249655, 242719,
                           254135, 242767, 247991, 242911, 257207, 242935, 244919, 242959, 246455,
                           243359, 255415, 243503, 250807, 243839, 260215, 243855, 246903, 243951,
                           253047, 244143, 251511, 244175, 249463, 244319, 256375, 244703, 257911,
                           244751, 246007, 244799, 258295, 245135, 247543, 245215, 257783, 245239,
                           245495, 245439, 259575, 245487, 253431, 245599, 257015, 245615, 252919,
                           245663, 255991, 245839, 247823, 245887, 260111, 246031, 246287, 246383,
                           252175, 246447, 251151, 246575, 250639, 246847, 258191, 246959, 251023,
                           247039, 261263, 247119, 248463, 247167, 260751, 247263, 257679, 247423,
                           260495, 247535, 253327, 247615, 258959, 247647, 256911, 247727, 251791,
                           248063, 261199, 248143, 248399, 248351, 254287, 248735, 255823, 248751,
                           251727, 248831, 261967, 249343, 261839, 249727, 261071, 249919, 258095,
                           250031, 250927, 250159, 250415, 250303, 259631, 250335, 257583, 250559,
                           259375, 250719, 256815, 250783, 255791, 250911, 254127, 251071, 259247,
                           251119, 253103, 251231, 256687, 251295, 255663, 251503, 252335, 251647,
                           261551, 251679, 254895, 251887, 253871, 251935, 254063, 252095, 259183,
                           252415, 261743, 252991, 258287, 253087, 255215, 253311, 260847, 253567,
                           260591, 253663, 257519, 253951, 262127, 254239, 254495, 254431, 257567,
                           255103, 260255, 255167, 259231, 255391, 255647, 255487, 261791, 255551,
                           258463, 257407, 260831, 257727, 259551, 257855, 259039, 258047, 262111,
                           258367, 258623, 260479, 260735};

/* Direction numbers */
static int minit[sobolMaxDim-1][sobolMaxDegree] =
{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 0, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 1055, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 0, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 399, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 0, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 0, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 1419, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 1601, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 3311, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 3009, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 1985, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 3309, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 279, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 4057, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 3233, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 991, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 2807, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 3197, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 771, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 2403, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 3167, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 1907, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 1399, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 569, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 127, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 3285, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 143, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 927, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 2387, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 1097, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 3229, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 2889, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 943, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 373, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 4041, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 2859, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 2505, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 1383, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 1481, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 685, 2733, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 191, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 2363, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 1161, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 1789, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 79, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 3049, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 3557, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 3561, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 505, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 3671, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 345, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 3123, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 1113, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 2137, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 1421, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 1753, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 3289, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 121, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 4035, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 2525, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 2969, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 1077, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 3065, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 531, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 2297, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 2791, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 2873, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 3903, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 3641, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 2379, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 2745, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 0, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 1721, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 2213, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 2389, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 731, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 3157, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 213, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 1323, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 3861, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 1651, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 135, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 1557, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 1429, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 1851, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 917, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 1829, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 1685, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 2037, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 3573, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 3133, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 3829, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 309, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 623, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 2997, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 563, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 4061, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 1253, 1253, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 1255, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 1061, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 3917, 0, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 421, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 3063, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 511, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 1437, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 4039, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 2333, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 3779, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 1757, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 221, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 543, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 3165, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 211, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 2493, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 3375, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 1581, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 3647, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 4027, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 3331, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 3213, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 151, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 2317, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 4013, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 2765, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 3277, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 4045, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 4043, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 1485, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 335, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 2739, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 1453, 1453, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 2349, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 1005, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 1187, 0, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 3949, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 2983, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 1023, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 3327, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 3455, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 351, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 3275, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 831, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 2435, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 95, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 3851, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 3615, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 159, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 1107, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 415, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 3759, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 3823, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 983, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 4079, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 979, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 1831, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 3343, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 3755, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 0, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 3279, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 3223, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 1847, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 3543, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 3875, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 2295, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 711, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 2195, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 3463, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 2407, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 1715, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 2535, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 2043, 0, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 1767, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 1347, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 219, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 3891, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 2443, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 2139, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 1179, 1179, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 291, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 379, 379, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 739, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 2555, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 1339, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 3315, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 2619, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 2635, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 0, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 1259, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 2451, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 3603, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 0, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 1537, 5633, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 455, 4551, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 635, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 2817, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 1893, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 4737, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 3311, 3311, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 2433, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 1845, 5941, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 3795, 7891, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 1089, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 279, 279, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 1565, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 3649, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 3811, 3811, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 6465, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 3061, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 3393, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 3347, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 1857, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 5607, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 8001, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 45, 4141, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 193, 193, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 63, 4159, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 649, 4745, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 4545, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 5345, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 961, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 207, 207, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 8093, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 3617, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 69, 69, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 289, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 3945, 8041, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 6433, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 2707, 2707, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 4897, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 2663, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 5281, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 4031, 4031, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 7585, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 1595, 1595, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 4513, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 1399, 1399, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 929, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 569, 569, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 4193, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 969, 5065, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 3681, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 523, 523, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 6753, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 3853, 7949, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 1859, 5955, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 3297, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 27, 4123, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 4957, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 2785, 2785, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 6819, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 927, 927, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 6113, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 1265, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 993, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 1447, 5543, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 1809, 5905, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 3417, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 6161, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 373, 373, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 2577, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 2859, 6955, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 685, 2733, 6829, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 401, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 191, 4287, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 1937, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 3719, 3719, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 8081, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 205, 205, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 5777, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 313, 313, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 3729, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 2947, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 4297, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 6993, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 3339, 3339, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 5969, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 327, 4423, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 4689, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 3983, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 6211, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 3537, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 93, 93, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 7377, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 1619, 5715, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 6865, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 2283, 6379, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 2727, 2727, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 7473, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 1621, 1621, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 3121, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 3451, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 2615, 6711, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 3505, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 2203, 6299, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 8113, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 1541, 5637, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 5041, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 3097, 3097, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 2225, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 467, 4563, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 1649, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 6833, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 4077, 4077, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 7537, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 2907, 7003, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 2417, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 1309, 5405, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 3953, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 2757, 2757, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 3295, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 113, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 3561, 7657, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 7793, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 3243, 7339, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 4721, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 2791, 2791, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 3965, 0, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 185, 185, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 1609, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 3991, 8087, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 73, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 7599, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 3145, 3145, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 6243, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 2889, 6985, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 1909, 1909, 1909, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 1865, 5961, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 6761, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 3401, 7497, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 3245, 7341, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 2249, 2249, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 4299, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 4041, 8137, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 4349, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 3529, 3529, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 5507, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 521, 521, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 383, 383, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 1033, 1033, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 3911, 3911, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 3081, 7177, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 2573, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 2313, 6409, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 3045, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 3337, 3337, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 1603, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 2697, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 283, 283, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 1673, 1673, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 87, 87, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 905, 905, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 671, 671, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 1129, 1129, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 1163, 5259, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 105, 4201, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 5005, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 873, 4969, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 1469, 1469, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 2409, 6505, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 1657, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 3305, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 3567, 3567, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 1257, 5353, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4101, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 4073, 4073, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 3359, 7455, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 1513, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 363, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 1577, 1577, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 1371, 1371, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 2601, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 23, 23, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 5161, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 3269, 3269, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 2089, 6185, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 2777, 2777, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 41, 41, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 4067, 8163, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 809, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 3091, 7187, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 297, 4393, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 1325, 1325, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 1705, 5801, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 7317, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 681, 681, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 499, 4595, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 1193, 1193, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 5963, 0, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 2985, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 3063, 7159, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 3929, 8025, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 511, 511, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 1881, 1881, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 4949, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 601, 601, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 5821, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 4185, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 3779, 3779, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 7129, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 215, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 7641, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 751, 4847, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 2521, 2521, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 2329, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 1241, 5337, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 3691, 3691, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 2265, 6361, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 1063, 5159, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 1817, 5913, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 2651, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 3353, 7449, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 3375, 7471, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 1049, 5145, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 3499, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 25, 25, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 1581, 5677, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 3993, 8089, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 3647, 3647, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 6809, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 1271, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 1177, 1177, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 3493, 7589, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 377, 4473, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 687, 687, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 1145, 5241, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 1127, 5223, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 8185, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 6515, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 6649, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 4043, 8139, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 3577, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 1485, 5581, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 1785, 5881, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 7031, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 249, 4345, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 335, 335, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 1273, 1273, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 1081, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 825, 4921, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 7807, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 7097, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 3611, 3611, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 6073, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 3927, 8023, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 3513, 7609, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 1187, 1187, 0, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 3769, 7865, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 1875, 1875, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 3413, 3413, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 7899, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 2901, 2901, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 1123, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 1109, 5205, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 351, 4447, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 597, 4693, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 2645, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 173, 4269, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 1493, 5589, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 277, 2325, 2325, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 1237, 5333, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 2875, 2875, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 1749, 1749, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 2853, 6949, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 1045, 1045, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 1975, 1975, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 7189, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 4157, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 3605, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 1429, 1429, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 2653, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 917, 917, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 1413, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 6037, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 6051, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 2197, 2197, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 3743, 7839, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 3733, 3733, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 2215, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 1909, 3957, 8053, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 3635, 7731, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 1397, 5493, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 3271, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 1653, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 2103, 6199, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 2165, 6261, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 7781, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 3189, 3189, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 3523, 7619, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 4085, 8181, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 983, 983, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 501, 501, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1029, 3077, 7173, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 245, 245, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 7531, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 5365, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 1517, 1517, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 1333, 1333, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 3631, 7727, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 2357, 2357, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 995, 995, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 6709, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 19, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 3125, 7221, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 3755, 7851, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 2101, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 2349, 2349, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 1973, 4021, 4021, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 3391, 3391, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 1461, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 2891, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 3253, 7349, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 3535, 7631, 0, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 1205, 1205, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 677, 677, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 325, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 7679, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 3397, 3397, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 4403, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 8005, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 3213, 3213, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 581, 4677, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 3343, 3343, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 2629, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 3429, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 1477, 5573, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 221, 221, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 5317, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 7379, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 7877, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 2087, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 1733, 1733, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 5869, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 1925, 6021, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 1099, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 7045, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 3079, 3079, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 2181, 2181, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 2295, 6391, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 3717, 3717, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 719, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 1637, 1637, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 3679, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 2661, 2661, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 2195, 2195, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 3173, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 1579, 5675, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 8165, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 3519, 3519, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 741, 4837, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 4093, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 229, 229, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 1667, 1667, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 2341, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 1317, 1317, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 3143, 3143, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 3621, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 829, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 37, 4133, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 655, 4751, 0, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 1189, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 3949, 3949, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 4765, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 3891, 3891, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 2973, 2973, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 2359, 6455, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 925, 5021, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 3261, 7357, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 413, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 3267, 3267, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 2589, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 1757, 1757, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 7901, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 3351, 7447, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 3037, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 4063, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 2013, 2013, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 275, 4371, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 5597, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 3117, 7213, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 2141, 6237, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 2635, 6731, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 2909, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 3515, 7611, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 1885, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 1783, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 3517, 7613, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 5779, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 3005, 7101, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 2091, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 6077, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 1639, 5735, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 3645, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 3463, 3463, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 317, 4413, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 2619, 6715, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 2301, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 2227, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 3581, 7677, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 2555, 6651, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 509, 4605, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 1719, 1719, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 7549, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 3999, 8095, 0, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 893, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 2413, 2413, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 3725, 7821, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 219, 219, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 5261, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 4015, 8111, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 525, 4621, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 1139, 5235, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 2061, 6157, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 647, 647, 4743, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 3277, 3277, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 2829, 2829, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 1655, 1655, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 7885, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 1971, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 6349, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 1997, 1997, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 2487, 6583, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 461, 461, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 911, 5007, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 1101, 5197, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 2467, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 3405, 3405, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 5799, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 1357, 5453, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 2669, 6765, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 685, 685, 685, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 1675, 5771, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 1965, 6061, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 963, 963, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 1069, 1069, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 3543, 7639, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 3629, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 3619, 3619, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 493, 4589, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 3603, 7699, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 2157, 2157, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 1011, 1011, 5107, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 3437, 7533, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 699, 4795, 0, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 7021, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4099, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 2047, 2047, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 1755, 1755, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 1791, 1791, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 3987, 8083, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 6527, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 627, 4723, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 2175, 6271, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 827, 4923, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 1663, 1663, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 4483, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 2495, 2495, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 579, 579, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 2623, 2623, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 1647, 5743, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 2367, 2367, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 3155, 3155, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 1375, 5471, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 1587, 1587, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 3039, 3039, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 667, 667, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 5599, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 2083, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 1759, 5855, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 2335, 6431, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 2271, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 3879, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 6943, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 1707, 1707, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 2207, 6303, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 2823, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 1951, 1951, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 4087, 8183, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 2463, 6559, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 1487, 1487, 0, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 1439, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 1539, 5635, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 1455, 1455, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 2355, 2355, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 1199, 1199, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 2171, 6267, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 1839, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 1239, 1239, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 2351, 6447, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 1775, 5871, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 2799, 2799, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 5347, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 3055, 3055, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 2475, 2475, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 2031, 6127, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 4071, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 1135, 5231, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 3147, 7243, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 2159, 2159, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 5127, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 2927, 2927, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 7099, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 5903, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 2523, 2523, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 1551, 5647, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 4243, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 2127, 6223, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 2059, 6155, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 1103, 1103, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 5191, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 2895, 6991, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 183, 183, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 2255, 6351, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 2587, 2587, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 1999, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 3563, 3563, 0, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 7119, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 4007, 4007, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 1431, 1431, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 1479, 5575, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 1687, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 1659, 1659, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 1815, 1815, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 2339, 6435, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 1559, 1559, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 1131, 5227, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 2583, 6679, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 3623, 3623, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 1751, 1751, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 91, 4187, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 2647, 6743, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 2567, 2567, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 6487, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 1467, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 823, 823, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 3427, 3427, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 567, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 4139, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 951, 951, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 883, 883, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 7351, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 131, 0, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 1015, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 3411, 7507, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 1991, 6087, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 611, 611, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 2247, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 403, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 2759, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 4455, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 5447, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 647, 2695, 2695, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 1799, 5895, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 595, 4691, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 871, 4967, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 2099, 6195, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 3559, 3559, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 1179, 3227, 7323, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 743, 4839, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 2923, 7019, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 3239, 3239, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 1011, 3059, 3059, 0, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 679, 4775, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 3403, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 1243, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 3467, 7563, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 3035, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 2683, 6779, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 6427, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 2291, 6387, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 3323, 3323, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 3955, 8051, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 3579, 7675, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 3643, 7739, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 4411, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 2571, 6667, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 2235, 2235, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 339, 339, 0, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 1723, 5819, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 4075, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 3211, 3211, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 7571, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 1995, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 67, 67, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 75, 75, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 3491, 3491, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 555, 4651, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 1987, 1987, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 2731, 6827, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 2515, 2515, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 1195, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 1899, 1899, 0, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 4587, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 1027, 5123, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 1331, 5427, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 99, 99, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 1459, 3507, 7603, 0, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 3699, 3699, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 3939, 0, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 1731, 5827, 0, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 513, 513, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 1057, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 2561, 10753, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 1335, 1335, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 1537, 1537, 9729, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 3855, 3855, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 3585, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 889, 889, 889, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 7681, 15873, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 4291, 12483, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 1281, 9473, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 3311, 3311, 11503, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 15617, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 3363, 7459, 15651, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 4865, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 1845, 5941, 14133, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 12033, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 2599, 10791, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 4225, 12417, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 1115, 5211, 5211, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 2689, 2689, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 3817, 7913, 7913, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 14977, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 3347, 11539, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 3713, 11905, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 5607, 5607, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 7809, 7809, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 45, 4141, 4141, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 6529, 14721, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 243, 243, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 5505, 13697, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 1611, 1611, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 11137, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 2807, 6903, 15095, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 1921, 10113, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 207, 207, 207, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 3969, 3969, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 953, 9145, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 14401, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 7831, 7831, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 2113, 2113, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 8093, 8093, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 5185, 13377, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 3247, 7343, 7343, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 7745, 15937, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 2663, 2663, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 321, 4417, 12609, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 4031, 4031, 4031, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 6465, 6465, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 777, 4873, 4873, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 1345, 1345, 9537, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 459, 8651, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 9025, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 1595, 1595, 9787, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 2881, 2881, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 1533, 1533, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 5313, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 4241, 4241, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 7361, 15553, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 3655, 3655, 11847, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 3265, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 3853, 7949, 16141, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 705, 8897, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 1531, 9723, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 6849, 15041, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 6839, 6839, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 2753, 2753, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 2365, 2365, 10557, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 1729, 1729, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 3813, 7909, 7909, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 1473, 1473, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 3205, 7301, 7301, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 7617, 7617, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 3737, 11929, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 1985, 6081, 6081, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 1265, 9457, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 7201, 7201, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 3229, 3229, 11421, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 5409, 5409, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 789, 8981, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 3361, 3361, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4105, 4105, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 4385, 12577, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 3787, 3787, 11979, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 1825, 1825, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 5729, 5729, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 801, 8993, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 79, 79, 79, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 2849, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 313, 313, 313, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 6945, 15137, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 2947, 2947, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 1185, 9377, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 8063, 16255, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 5281, 5281, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 4053, 8149, 16341, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 6305, 6305, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 3085, 3085, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 1697, 1697, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 13729, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 3867, 7963, 16155, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 3489, 11681, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 3671, 7767, 7767, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 7585, 7585, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 93, 93, 93, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 1953, 10145, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 3231, 7327, 15519, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 4001, 4001, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 3241, 7337, 7337, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 16289, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 1619, 5715, 5715, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 5217, 13409, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 7265, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 4425, 4425, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 6241, 14433, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 3783, 3783, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 1633, 9825, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 3451, 3451, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 2657, 10849, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 4035, 8131, 16323, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 8033, 8033, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 7465, 15657, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 7009, 15201, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 5415, 5415, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 2913, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 4077, 4077, 4077, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 9441, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 2907, 7003, 7003, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 225, 225, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 2757, 2757, 10949, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 3809, 12001, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 531, 531, 8723, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 7649, 7649, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 393, 4489, 12681, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 2529, 2529, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 6477, 6477, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 8161, 16353, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 1527, 1527, 1527, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 4065, 4065, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 3965, 3965, 0, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 3041, 11233, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 3075, 3075, 3075, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 6417, 14609, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 3991, 8087, 8087, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 2321, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 2717, 2717, 2717, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 4113, 12305, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 3775, 3775, 3775, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 3089, 3089, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 1741, 1741, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 1553, 5649, 13841, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 3663, 7759, 15951, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 6545, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 5833, 14025, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 5265, 13457, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 623, 4719, 4719, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 1169, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 2437, 2437, 2437, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 3217, 11409, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 2979, 11171, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 4753, 12945, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 671, 671, 671, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 5777, 5777, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 497, 8689, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 7825, 16017, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 1191, 5287, 13479, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 337, 337, 8529, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 3839, 7935, 16127, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 2385, 2385, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 1865, 5961, 5961, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 14673, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 563, 563, 8755, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 2897, 11089, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 1079, 1079, 1079, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 3921, 3921, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 1657, 1657, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 3153, 3153, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 2585, 2585, 2585, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 6737, 14929, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 4051, 4051, 4051, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 13905, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 363, 8555, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 7761, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 2541, 2541, 10733, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 6609, 6609, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 797, 4893, 13085, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 3537, 3537, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 2777, 2777, 10969, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 7633, 15825, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 4067, 8163, 8163, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 5073, 5073, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 3829, 7925, 16117, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 6097, 14289, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 683, 8875, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 209, 4305, 4305, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 7317, 7317, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 2257, 2257, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 1929, 6025, 14217, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 1233, 1233, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 5329, 13521, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 5963, 5963, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 13009, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 187, 4283, 4283, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 1745, 9937, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 463, 463, 0, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 7889, 16081, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 515, 4611, 4611, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 3377, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 3379, 3379, 11571, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 2353, 10545, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 141, 141, 8333, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 1841, 1841, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 3195, 7291, 7291, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 817, 9009, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 357, 357, 8549, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 1073, 1073, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 2459, 2459, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 14385, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 2329, 2329, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 5681, 5681, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 543, 543, 543, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 12849, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 881, 9073, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 6705, 6705, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 1063, 5159, 5159, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 3505, 11697, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 4529, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 3375, 7471, 7471, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 8625, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 4037, 8133, 16325, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 6065, 6065, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 3551, 3551, 3551, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 1969, 10161, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 3573, 3573, 3573, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 1201, 9393, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 3989, 12181, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 3249, 3249, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 3827, 7923, 7923, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 6321, 6321, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4103, 12295, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 7857, 7857, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 1271, 1271, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 2737, 2737, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 3331, 7427, 7427, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 6001, 14193, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 1141, 5237, 5237, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 1137, 1137, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 4543, 12735, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 7281, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 6515, 6515, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 6769, 6769, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 2691, 6787, 6787, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 3569, 11761, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 1481, 5577, 13769, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 2545, 2545, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 71, 4167, 4167, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 6129, 6129, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 3067, 7163, 15355, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 5105, 13297, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 6373, 14565, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 241, 241, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 3439, 3439, 11631, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 10481, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 2201, 2201, 10393, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 14065, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 2229, 2229, 2229, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 3825, 12017, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 6569, 6569, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 7921, 7921, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 1875, 1875, 1875, 0, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 2801, 6897, 15089, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 877, 877, 9069, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 5705, 13897, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 431, 431, 8623, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 7753, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 1881, 1881, 1881, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 11849, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 1123, 9315, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 3145, 7241, 15433, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 14183, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 4937, 13129, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 703, 4799, 12991, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 3913, 8009, 16201, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 3207, 3207, 11399, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 329, 8521, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 2875, 2875, 2875, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 3401, 3401, 11593, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 2435, 2435, 10627, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 4809, 4809, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 3455, 7551, 15743, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 3273, 3273, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 6723, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 969, 969, 969, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 7451, 7451, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 457, 4553, 4553, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 3743, 7839, 16031, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 1481, 1481, 1481, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 2795, 6891, 15083, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 3529, 3529, 11721, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 7277, 7277, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 3593, 3593, 3593, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 3981, 8077, 8077, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 2057, 2057, 2057, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 2493, 2493, 2493, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 3081, 7177, 7177, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 2681, 2681, 2681, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 1801, 5897, 14089, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 495, 4591, 4591, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 3849, 3849, 12041, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 4131, 4131, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 265, 265, 265, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 3637, 11829, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 2313, 6409, 6409, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 5929, 14121, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 1289, 1289, 9481, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 7531, 7531, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 649, 649, 649, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 347, 2395, 6491, 14683, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 6793, 6793, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 7191, 15383, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 2185, 6281, 14473, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 6121, 6121, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 2953, 2953, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 3571, 11763, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 3977, 3977, 12169, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 4941, 13133, 0, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 393, 393, 393, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 3259, 11451, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 2665, 2665, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 1931, 1931, 10123, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 2153, 2153, 10345, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 3429, 11621, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 873, 4969, 13161, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 1305, 1305, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 3433, 3433, 11625, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 7477, 7477, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 361, 4457, 4457, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 2087, 10279, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 3817, 3817, 12009, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 1627, 5723, 13915, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 5865, 14057, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 791, 791, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 2793, 6889, 15081, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 303, 8495, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 7401, 15593, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 479, 4575, 12767, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 1257, 1257, 9449, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 3859, 3859, 3859, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 233, 233, 233, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 2605, 6701, 14893, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 1001, 1001, 1001, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 77, 77, 77, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 1513, 1513, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 1661, 5757, 5757, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 489, 4585, 4585, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 2489, 2489, 10681, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 553, 553, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 2915, 11107, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 2089, 2089, 2089, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 1579, 5675, 13867, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 4905, 4905, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 4999, 4999, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 1321, 5417, 5417, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 1911, 1911, 10103, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 1321, 1321, 9513, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 4093, 12285, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 2345, 6441, 6441, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 3407, 7503, 15695, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 297, 4393, 12585, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 2105, 2105, 2105, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 3753, 3753, 3753, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 1749, 1749, 9941, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 1705, 1705, 9897, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 1715, 5811, 5811, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 2729, 10921, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 1193, 5289, 13481, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 6327, 6327, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 2217, 6313, 14505, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 655, 4751, 12943, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 169, 4265, 4265, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 2297, 2297, 10489, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 6057, 14249, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 855, 9047, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 1961, 1961, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 6493, 6493, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 2985, 2985, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 1669, 5765, 13957, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 937, 937, 9129, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 6307, 6307, 0, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 425, 4521, 12713, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 1959, 6055, 14247, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 857, 9049, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 3527, 3527, 3527, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 4953, 4953, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 2701, 2701, 2701, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 7513, 15705, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 7803, 15995, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 1369, 1369, 9561, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 2359, 6455, 14647, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 345, 4441, 12633, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 3267, 3267, 3267, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 3673, 7769, 15961, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 2971, 11163, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 1625, 1625, 9817, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 727, 727, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 2649, 10841, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 239, 4335, 4335, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 6745, 6745, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 2309, 2309, 2309, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 3161, 7257, 7257, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 6965, 15157, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 4185, 4185, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 237, 4333, 12525, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 6105, 14297, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 2589, 10781, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 7641, 15833, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 2037, 2037, 10229, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 473, 4569, 12761, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 3117, 7213, 7213, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 3801, 7897, 16089, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 1429, 1429, 1429, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 2777, 6873, 6873, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 2635, 6731, 14923, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 1241, 5337, 13529, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 4221, 12413, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 4313, 4313, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 3843, 7939, 16131, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 2841, 6937, 6937, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 3141, 3141, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 793, 4889, 13081, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 1379, 5475, 13667, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 3609, 7705, 7705, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 7189, 7189, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 1561, 5657, 13849, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 7027, 15219, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 2073, 6169, 6169, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 3621, 3621, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 3993, 8089, 16281, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 213, 213, 213, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 6041, 6041, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 2227, 2227, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 5529, 13721, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 1341, 1341, 9533, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 2457, 2457, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 3215, 3215, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 2713, 2713, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 3951, 3951, 12143, 0, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 153, 153, 153, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 2471, 2471, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 6009, 6009, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 8005, 16197, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 377, 377, 8569, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 3935, 3935, 3935, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 5497, 13689, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 1835, 1835, 10027, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 633, 633, 8825, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 3263, 3263, 3263, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 2169, 10361, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 1655, 1655, 9847, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 6265, 6265, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 2813, 6909, 15101, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 1017, 1017, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 895, 895, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 4089, 4089, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 3399, 11591, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 1529, 1529, 1529, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 911, 5007, 13199, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 1785, 1785, 1785, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 4207, 4207, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 249, 4345, 12537, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 4533, 4533, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 2297, 6393, 6393, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 2643, 2643, 10835, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 3897, 7993, 7993, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 397, 2445, 6541, 14733, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 2617, 2617, 10809, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 3543, 7639, 15831, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 1593, 5689, 5689, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 6661, 14853, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 3641, 7737, 15929, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 3619, 3619, 3619, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 2105, 6201, 14393, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 3539, 3539, 11731, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 7097, 15289, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 2333, 6429, 6429, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 4025, 8121, 8121, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 3555, 7651, 15843, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 4537, 12729, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 5365, 5365, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 1465, 5561, 5561, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 171, 171, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 3513, 3513, 3513, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 1767, 5863, 5863, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 1721, 5817, 5817, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 1355, 5451, 13643, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 2233, 2233, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 2551, 6647, 14839, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 6329, 14521, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 893, 893, 0, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 3257, 3257, 11449, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 1365, 1365, 9557, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 1755, 1755, 9947, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 2389, 2389, 10581, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 3171, 7267, 7267, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 1877, 10069, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 4981, 13173, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 2133, 2133, 10325, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 5255, 5255, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 2133, 6229, 6229, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 4813, 4813, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 1237, 1237, 9429, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 1111, 1111, 9303, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 2261, 6357, 6357, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 7557, 7557, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 3797, 3797, 3797, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 1695, 1695, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 1749, 5845, 5845, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 3155, 3155, 3155, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 725, 725, 725, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 167, 4263, 12455, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 3349, 3349, 11541, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 1223, 5319, 13511, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 2837, 6933, 15125, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 4541, 4541, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 3861, 7957, 7957, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 1475, 1475, 9667, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 1045, 5141, 13333, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 2543, 10735, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 3093, 11285, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 2083, 10275, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 2581, 2581, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 3027, 3027, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 3605, 11797, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 3565, 7661, 15853, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 405, 8597, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 1047, 1047, 1047, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 2965, 7061, 15253, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 2805, 10997, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 8085, 8085, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 1707, 1707, 9899, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 149, 149, 8341, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 1523, 5619, 5619, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 1173, 5269, 13461, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 2823, 2823, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 661, 4757, 4757, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 4087, 8183, 16375, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 661, 661, 8853, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 7549, 15741, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 3733, 3733, 11925, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 2725, 6821, 6821, 0, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 1685, 1685, 1685, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 1539, 5635, 5635, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 2933, 7029, 7029, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 2355, 2355, 10547, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 2421, 6517, 6517, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 701, 701, 8893, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 117, 117, 117, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 1333, 1333, 1333, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 1013, 1013, 1013, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 2839, 6935, 15127, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 2549, 2549, 10741, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 2527, 2527, 2527, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 1525, 5621, 5621, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 557, 557, 8749, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 6901, 6901, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 2623, 2623, 2623, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 757, 757, 757, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 6899, 6899, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 2293, 10485, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 7099, 7099, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 245, 4341, 12533, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 247, 247, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 309, 309, 8501, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 3627, 3627, 3627, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 2613, 2613, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 2951, 2951, 11143, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 1077, 5173, 13365, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 3131, 7227, 15419, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 53, 4149, 4149, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 37, 4133, 12325, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 5045, 5045, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 5191, 5191, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 949, 9141, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 3341, 3341, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 3509, 3509, 11701, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 4091, 8187, 16379, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 437, 8629, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 3395, 11587, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 3765, 7861, 7861, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 2587, 2587, 10779, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 2741, 2741, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 2415, 2415, 10607, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 3253, 7349, 7349, 0, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 181, 4277, 4277, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 1901, 5997, 14189, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 4421, 12613, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 3071, 7167, 15359, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 2373, 2373, 10565, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 5939, 14131, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 1349, 1349, 9541, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 395, 395, 395, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 1861, 1861, 10053, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 869, 4965, 4965, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 69, 4165, 12357, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 923, 5019, 5019, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 7237, 15429, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 2339, 6435, 14627, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 3653, 3653, 3653, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 3623, 3623, 11815, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 453, 453, 453, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 541, 4637, 12829, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 3525, 7621, 15813, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 1839, 10031, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 3525, 3525, 3525, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 1477, 1477, 9669, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 2787, 2787, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 4037, 4037, 4037, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 1963, 6059, 14251, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 1989, 6085, 6085, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 4583, 4583, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 5317, 5317, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 3661, 7757, 15949, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 709, 709, 709, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 3831, 7927, 16119, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 261, 261, 8453, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 6319, 6319, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 7941, 7941, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 3731, 3731, 11923, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 4869, 4869, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 4139, 4139, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 1541, 1541, 1541, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 571, 571, 8763, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 7685, 7685, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 375, 375, 8567, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 517, 517, 8709, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 1573, 5669, 5669, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 2565, 2565, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 131, 131, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 3461, 11653, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 1151, 1151, 1151, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 2437, 6533, 14725, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 1547, 1547, 9739, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 1925, 6021, 14213, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 7485, 15677, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 2181, 6277, 14469, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 1903, 5999, 5999, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 133, 133, 8325, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 7843, 16035, 0, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 2693, 2693, 2693, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 1003, 5099, 5099, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 5989, 14181, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 6363, 14555, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 3941, 8037, 8037, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 2205, 6301, 14493, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 1381, 1381, 1381, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 5983, 14175, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 7525, 7525, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 403, 8595, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 613, 613, 8805, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 2763, 2763, 10955, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 2661, 2661, 2661, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 5325, 13517, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 997, 997, 9189, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 5447, 5447, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 1509, 1509, 1509, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 439, 8631, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 1509, 5605, 13797, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 3645, 3645, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 2533, 2533, 2533, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 2959, 2959, 2959, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 3813, 3813, 12005, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 2843, 6939, 15131, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 1765, 1765, 1765, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 1117, 5213, 5213, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 2277, 2277, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 3307, 7403, 7403, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 229, 4325, 4325, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 3751, 3751, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 6437, 6437, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 3639, 7735, 15927, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 2341, 10533, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 6077, 14269, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 3365, 3365, 3365, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 7107, 15299, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 2597, 2597, 10789, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 1495, 1495, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 37, 37, 37, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 1823, 1823, 1823, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 3109, 7205, 15397, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 7149, 7149, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 4005, 8101, 16293, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 6191, 6191, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 421, 421, 421, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 1555, 9747, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 1445, 1445, 9637, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 1837, 5933, 14125, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 2725, 2725, 10917, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 2879, 2879, 2879, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 3749, 7845, 16037, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 3403, 3403, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 2213, 6309, 6309, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 2747, 2747, 2747, 0, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 3237, 3237, 3237, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 7119, 15311, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 3741, 3741, 11933, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 2047, 2047, 2047, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 1181, 5277, 13469, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 2237, 2237, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 2205, 2205, 2205, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 5903, 14095, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 157, 4253, 4253, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 2243, 2243, 2243, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 413, 8605, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 1261, 1261, 9453, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 5661, 5661, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 3163, 3163, 11355, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 3613, 3613, 3613, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 2327, 6423, 14615, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 1053, 1053, 9245, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 3039, 3039, 3039, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 3101, 7197, 15389, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 1299, 5395, 5395, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 2845, 2845, 11037, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 4685, 12877, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 1309, 1309, 9501, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 2491, 6587, 14779, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 3357, 7453, 15645, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 759, 759, 759, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 2333, 2333, 10525, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 6915, 15107, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 3805, 11997, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 1199, 1199, 9391, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 2269, 2269, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 5215, 13407, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 1245, 1245, 1245, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 4711, 12903, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 989, 9181, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 3955, 8051, 16243, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 1501, 1501, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 7299, 15491, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 6749, 6749, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 3251, 3251, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 5725, 5725, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 2571, 6667, 6667, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 3677, 7773, 15965, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 1805, 1805, 9997, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 93, 4189, 12381, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 3579, 7675, 7675, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 2141, 2141, 10333, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 695, 695, 8887, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 7005, 7005, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 6487, 6487, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 3933, 3933, 3933, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 675, 675, 675, 0, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 3421, 3421, 3421, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 3437, 7533, 7533, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 1213, 5309, 13501, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 7087, 7087, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 3261, 3261, 11453, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 3683, 7779, 15971, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 3773, 7869, 7869, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 3431, 3431, 3431, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 3773, 3773, 11965, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 685, 685, 685, 685, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 445, 8637, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 2239, 2239, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 61, 61, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 947, 947, 947, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 2621, 2621, 10813, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 4859, 4859, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 3389, 3389, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 1135, 5231, 5231, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 7997, 16189, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 235, 235, 8427, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 3325, 11517, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 1075, 1075, 1075, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 253, 8445, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 651, 4747, 12939, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 2301, 2301, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 3469, 3469, 11661, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 3837, 7933, 7933, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 567, 567, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 765, 4861, 4861, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 2063, 2063, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 2045, 2045, 2045, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 6943, 15135, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 5117, 5117, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 1899, 1899, 1899, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 7805, 15997, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 1247, 5343, 13535, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 3453, 3453, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 1855, 5951, 14143, 0, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 1917, 1917, 10109, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 3575, 7671, 15863, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 1677, 5773, 13965, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 6875, 6875, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 3725, 3725, 11917, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 1943, 10135, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 141, 4237, 4237, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 3371, 7467, 15659, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 2957, 2957, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 7885, 7885, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 3597, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 6527, 14719, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 13, 4109, 12301, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 3651, 7747, 7747, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 1805, 5901, 5901, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 6231, 6231, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 1229, 1229, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 1551, 5647, 13839, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 973, 9165, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 3739, 7835, 16027, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 2509, 2509, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 2003, 6099, 14291, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 6733, 6733, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 3419, 7515, 15707, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 1613, 5709, 5709, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 2019, 10211, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 2125, 10317, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 2783, 2783, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 1101, 1101, 9293, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 3303, 3303, 11495, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 845, 845, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 2547, 10739, 0, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 1869, 5965, 5965, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 1799, 5895, 14087, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 2221, 6317, 6317, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 2559, 6655, 14847, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 173, 173, 173, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 1331, 5427, 5427, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 1197, 5293, 5293, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 1991, 6087, 14279, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 6573, 6573, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 411, 4507, 12699, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 429, 429, 429, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 6359, 14551, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 2989, 2989, 11181, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 6687, 14879, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 1965, 6061, 6061, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 749, 749, 749, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 1325, 5421, 13613, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 75, 75, 8267, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 3373, 3373, 11565, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 2055, 2055, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 813, 4909, 4909, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 1979, 1979, 10171, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 3309, 3309, 3309, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 1499, 5595, 5595, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 237, 237, 237, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 3939, 12131, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 3821, 7917, 16109, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 2655, 2655, 2655, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 3565, 3565, 3565, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 2495, 2495, 2495, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 2029, 10221, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 887, 887, 9079, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 109, 8301, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 1035, 1035, 1035, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 3693, 7789, 7789, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 7351, 7351, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 2413, 6509, 14701, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 3235, 7331, 7331, 0, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 1901, 1901, 1901, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 1439, 1439, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 2047, 6143, 14335, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 2967, 2967, 11159, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 3583, 3583, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 3987, 3987, 3987, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 4863, 13055, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 627, 627, 8819, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 255, 4351, 12543, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 827, 827, 827, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 2303, 2303, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 119, 4215, 4215, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 383, 4479, 12671, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 1803, 1803, 1803, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 1919, 6015, 14207, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 4023, 12215, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 2943, 2943, 2943, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 1423, 1423, 1423, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 1151, 5247, 13439, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 1647, 1647, 9839, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 3711, 3711, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 747, 4843, 13035, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 3007, 7103, 15295, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 6639, 6639, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 3135, 7231, 15423, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 3043, 3043, 11235, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 575, 575, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 2067, 2067, 2067, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 1599, 1599, 1599, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 231, 231, 8423, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 2367, 6463, 14655, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 6919, 15111, 0, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 831, 831, 831, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 1539, 1539, 9731, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 2911, 7007, 15199, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 3895, 3895, 3895, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 1887, 1887, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 1295, 1295, 1295, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 3167, 7263, 15455, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 3483, 7579, 15771, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 1631, 1631, 1631, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 5663, 13855, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 7775, 15967, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 1235, 5331, 13523, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 8159, 16351, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 1251, 9443, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 3551, 7647, 15839, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 2475, 6571, 6571, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 735, 735, 735, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 3147, 3147, 11339, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 6879, 15071, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 1031, 1031, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 1247, 1247, 1247, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 4343, 12535, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 6367, 14559, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 2767, 2767, 2767, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 223, 223, 223, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 2307, 2307, 10499, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 543, 4639, 12831, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 3627, 7723, 15915, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 5407, 13599, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 2951, 7047, 7047, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 159, 4255, 12447, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 7491, 7491, 0, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 415, 4511, 12703, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 4947, 13139, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 3503, 11695, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 395, 4491, 12683, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 3247, 3247, 11439, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 923, 923, 9115, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 2863, 11055, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 1303, 5399, 13591, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 3887, 12079, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 6883, 15075, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 3119, 11311, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 5563, 13755, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 1263, 1263, 9455, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 663, 2711, 2711, 10903, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 751, 751, 8943, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 43, 8235, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 2799, 6895, 6895, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 3687, 7783, 15975, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 1519, 9711, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 1415, 1415, 9607, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 3183, 7279, 7279, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 4603, 4603, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 111, 8303, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 835, 835, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 1903, 1903, 10095, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 367, 8559, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 3411, 3411, 11603, 0, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 3439, 7535, 7535, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 1003, 1003, 9195, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 7951, 16143, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 2267, 2267, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 2319, 6415, 14607, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 359, 359, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 527, 527, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 3187, 7283, 15475, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 6159, 14351, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 3703, 3703, 11895, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 1039, 1039, 1039, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 1103, 5199, 13391, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 3471, 7567, 15759, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 4019, 4019, 4019, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 399, 399, 399, 399, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 2315, 6411, 6411, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 8079, 16271, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 1787, 3835, 7931, 7931, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 1935, 1935, 1935, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 4535, 4535, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 7311, 15503, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 419, 419, 419, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 1615, 5711, 13903, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 6855, 15047, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 5967, 14159, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 5591, 13783, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 847, 4943, 13135, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 1571, 1571, 1571, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 335, 4431, 12623, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 2923, 2923, 2923, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 4815, 13007, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 5651, 5651, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 3791, 3791, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 2219, 2219, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 4047, 4047, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 2747, 6843, 15035, 0, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 6095, 14287, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 503, 4599, 12791, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 6039, 6039, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 2503, 6599, 14791, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 2455, 2455, 10647, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 3383, 3383, 3383, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 3223, 3223, 11415, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 1747, 5843, 5843, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 151, 4247, 4247, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 2155, 6251, 14443, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 2327, 2327, 2327, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 3351, 3351, 3351, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 1763, 1763, 1763, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 535, 4631, 12823, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 2819, 2819, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 3799, 3799, 3799, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 7131, 15323, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 3287, 3287, 3287, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 659, 8851, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 4055, 4055, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 2507, 2507, 10699, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 2519, 2519, 2519, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 3447, 3447, 11639, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 3159, 11351, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 7347, 15539, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 2135, 10327, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 1607, 1607, 9799, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 1623, 5719, 5719, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 695, 4791, 4791, 0, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 343, 4439, 4439, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 2075, 6171, 14363, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 5431, 13623, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 5339, 13531, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 1847, 5943, 14135, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 3475, 11667, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 3127, 3127, 3127, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 1671, 1671, 9863, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 2615, 2615, 2615, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 315, 8507, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 4663, 12855, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 631, 4727, 4727, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 2999, 11191, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 1291, 1291, 9483, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 2487, 2487, 10679, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 67, 4163, 12355, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 2231, 10423, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 7763, 7763, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 3255, 11447, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 679, 679, 679, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 5239, 5239, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 651, 651, 651, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 1399, 5495, 5495, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 155, 4251, 4251, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 5879, 14071, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 2531, 2531, 2531, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 5367, 13559, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 5291, 13483, 0, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 3063, 3063, 3063, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 331, 331, 331, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 967, 967, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 5011, 13203, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 199, 199, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 2251, 6347, 14539, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 7495, 7495, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 3651, 3651, 11843, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 3655, 7751, 7751, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 2331, 10523, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 3207, 7303, 7303, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 2611, 2611, 10803, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 135, 135, 8327, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 3211, 7307, 7307, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 1927, 1927, 10119, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 807, 807, 8999, 0, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 6151, 14343, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 3303, 7399, 7399, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 1383, 1383, 1383, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 5243, 5243, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 6247, 14439, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 2259, 2259, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 3175, 7271, 15463, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 3111, 7207, 7207, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 1511, 9703, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 603, 603, 603, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 2023, 2023, 10215, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 2835, 6931, 15123, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 3047, 7143, 7143, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 1451, 1451, 9643, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 1831, 1831, 10023, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 371, 4467, 4467, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 2855, 6951, 6951, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 6091, 14283, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 1191, 1191, 1191, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 1035, 5131, 13323, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 1447, 1447, 1447, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 1563, 9755, 0, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 6567, 14759, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 3235, 3235, 11427, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 6747, 14939, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 939, 939, 939, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 347, 2395, 2395, 2395, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 4339, 12531, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 6555, 14747, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 1067, 9259, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 283, 4379, 4379, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 523, 4619, 4619, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 795, 4891, 13083, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 1859, 1859, 1859, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 3099, 7195, 15387, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 2723, 2723, 0, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 3611, 7707, 7707, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 2027, 2027, 10219, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 3707, 3707, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 1635, 5731, 13923, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 123, 4219, 4219, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 1427, 5523, 5523, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 3963, 8059, 8059, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 2163, 6259, 14451, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 15739, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 2363, 6459, 6459, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 2299, 6395, 14587, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 2995, 2995, 2995, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 2555, 2555, 10747, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 1443, 1443, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 3067, 3067, 3067, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 2283, 2283, 10475, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 1083, 5179, 13371, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 467, 467, 8659, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 3771, 7867, 16059, 0, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 699, 699, 699, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 3075, 7171, 15363, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 2187, 6283, 6283, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 1651, 1651, 9843, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 1163, 1163, 9355, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 203, 203, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 3595, 3595, 11787, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 7075, 7075, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 4043, 4043, 4043, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 4459, 4459, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 6987, 6987, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 499, 499, 8691, 0, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 1355, 1355, 1355, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 515, 515, 8707, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 6187, 6187, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 803, 4899, 4899, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 8107, 16299, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 227, 227, 8419, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 427, 8619, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 787, 787, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 619, 619, 8811, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 1171, 1171, 1171, 0, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 1515, 1515, 1515, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 1875, 5971, 14163, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 3635, 3635, 11827, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 6771, 6771, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 6067, 14259, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 2627, 10819, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 6323, 14515, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 1955, 10147, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 1715, 1715, 9907, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 1107, 1107, 1107, 0, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 1395, 5491, 5491, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 979, 979, 979, 0, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 2451, 2451, 10643, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 707, 707, 8899, 0, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 3555, 3555, 3555, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 3843, 3843, 3843, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 963, 5059, 13251, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 1923, 1923, 0, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 5187, 13379, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16385, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 2049, 2049, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 4369, 4369, 4369, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 10241, 26625, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 1419, 1419, 1419, 17803, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 5121, 13313, 13313, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 4285, 4285, 20669, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 3073, 3073, 11265, 11265, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 1893, 1893, 1893, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 14849, 31233, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 3363, 7459, 15651, 32035, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 1537, 5633, 13825, 30209, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 3795, 7891, 7891, 24275, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 11777, 28161, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 4203, 12395, 12395, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 257, 257, 257, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 129, 129, 16513, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 257, 8449, 24833, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 1115, 5211, 5211, 21595, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 2305, 2305, 18689, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 815, 815, 9007, 25391, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 1281, 9473, 9473, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 3061, 11253, 11253, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 3329, 3329, 3329, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 13745, 13745, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 15617, 15617, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 45, 4141, 4141, 20525, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 769, 17153, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 63, 4159, 12351, 28735, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 13057, 29441, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 243, 243, 16627, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 6913, 15105, 15105, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 2637, 10829, 27213, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 1793, 9985, 26369, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 443, 443, 443, 443, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 12033, 12033, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 7077, 7077, 7077, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 7937, 16129, 32513, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 771, 771, 771, 771, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 10369, 26753, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 69, 69, 69, 16453, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 1153, 9345, 25729, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 4725, 12917, 29301, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 2689, 10881, 10881, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 459, 8651, 25035, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 14977, 31361, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 5069, 5069, 21453, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 1665, 1665, 18049, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 5473, 5473, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 5761, 13953, 30337, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 1533, 1533, 1533, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 7809, 7809, 24193, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 569, 569, 569, 16953, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 385, 8577, 24961, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 3285, 3285, 3285, 3285, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 1409, 1409, 17793, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 1441, 1441, 17825, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 1409, 9601, 9601, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 1531, 9723, 26107, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 7553, 23937, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 761, 761, 8953, 25337, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 4993, 4993, 4993, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 343, 343, 8535, 24919, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 4993, 13185, 29569, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 4957, 13149, 29533, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 11137, 27521, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 3205, 7301, 7301, 23685, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 7041, 15233, 15233, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 6819, 15011, 15011, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 8065, 16257, 32641, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 1389, 1389, 1389, 17773, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 6209, 22593, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 943, 943, 9135, 9135, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 3137, 3137, 19521, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 1383, 5479, 13671, 30055, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 12865, 12865, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 789, 8981, 25365, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 3649, 11841, 28225, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 2947, 2947, 19331, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 321, 321, 321, 321, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 4297, 12489, 28873, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 321, 321, 8513, 24897, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 2995, 7091, 15283, 31667, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 2369, 18753, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 327, 4423, 4423, 4423, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 833, 17217, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 3671, 7767, 7767, 24151, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 2881, 2881, 2881, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 3481, 3481, 11673, 11673, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 5953, 5953, 22337, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 3231, 7327, 15519, 15519, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 8001, 8001, 8001, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 2033, 10225, 26609, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 6337, 14529, 14529, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 2699, 2699, 2699, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 2241, 2241, 2241, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 3783, 3783, 20167, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 1217, 1217, 1217, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 2615, 6711, 14903, 14903, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 7361, 7361, 7361, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 15, 4111, 12303, 28687, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 12993, 12993, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 2203, 6299, 6299, 22683, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 705, 8897, 25281, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 2525, 6621, 14813, 14813, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 2753, 10945, 10945, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 547, 4643, 12835, 29219, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 5825, 5825, 5825, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 799, 799, 799, 799, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 1729, 1729, 18113, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 7465, 15657, 32041, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 7873, 7873, 24257, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 1649, 9841, 9841, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 449, 449, 449, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 3607, 7703, 15895, 15895, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 6593, 14785, 31169, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 2757, 2757, 10949, 10949, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 2497, 2497, 18881, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 3289, 3289, 11481, 11481, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 1473, 9665, 9665, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 531, 531, 8723, 8723, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 3521, 3521, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 2791, 2791, 10983, 10983, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 11713, 28097, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 813, 813, 9005, 9005, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 5057, 13249, 29633, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 2709, 6805, 14997, 14997, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 3009, 7105, 7105, 23489, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 721, 721, 721, 0, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 8129, 16321, 32705, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 2213, 2213, 10405, 10405, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 7201, 7201, 7201, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 2905, 2905, 2905, 2905, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 16417, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 3423, 3423, 3423, 19807, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 4129, 12321, 28705, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 2963, 7059, 15251, 31635, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 2081, 2081, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 4401, 12593, 28977, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 10273, 26657, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 1323, 1323, 1323, 17707, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 5665, 5665, 5665, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 5641, 5641, 5641, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 545, 8737, 25121, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 1851, 5947, 14139, 30523, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 4641, 12833, 12833, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 4349, 4349, 4349, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 6689, 6689, 6689, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 1849, 1849, 1849, 1849, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 1313, 1313, 17697, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 383, 383, 383, 16767, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 1313, 9505, 9505, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 2517, 6613, 6613, 22997, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 3361, 11553, 27937, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 4875, 13067, 13067, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 289, 289, 289, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 161, 161, 16545, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 2337, 10529, 10529, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 3045, 3045, 3045, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 16161, 32545, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 2979, 11171, 11171, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 4897, 13089, 29473, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 2131, 2131, 2131, 2131, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 11041, 27425, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 1771, 1771, 1771, 18155, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 6945, 6945, 23329, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 1191, 5287, 13479, 29863, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 6945, 15137, 15137, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 4205, 4205, 20589, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 3233, 7329, 15521, 31905, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 5005, 5005, 21389, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 161, 8353, 8353, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 4987, 4987, 4987, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 2209, 2209, 2209, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 3599, 3599, 3599, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 1697, 9889, 9889, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 1691, 1691, 18075, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 5793, 5793, 5793, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 8151, 16343, 32727, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 7841, 16033, 16033, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 3107, 3107, 11299, 27683, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 2721, 2721, 19105, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 113, 8305, 8305, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 6817, 6817, 6817, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 2855, 2855, 11047, 11047, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 13729, 30113, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 797, 4893, 13085, 13085, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 417, 417, 417, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 735, 4831, 13023, 29407, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 2465, 2465, 2465, 18849, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 4273, 12465, 12465, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 2465, 2465, 10657, 10657, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 683, 8875, 25259, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 1953, 10145, 26529, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 7317, 7317, 23701, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 6049, 22433, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 1929, 6025, 14217, 14217, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 8097, 8097, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 3847, 3847, 3847, 20231, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 13217, 29601, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 2429, 2429, 10621, 10621, 0, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 2977, 2977, 2977, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 463, 463, 16847, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 1121, 1121, 1121, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 1097, 5193, 5193, 5193, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 7265, 7265, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 1809, 5905, 5905, 5905, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 3169, 11361, 11361, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 141, 141, 8333, 8333, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 97, 97, 16481, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 2871, 6967, 15159, 31543, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 7777, 15969, 15969, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 773, 8965, 25349, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 3681, 3681, 3681, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 2329, 2329, 18713, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 4705, 12897, 12897, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 309, 4405, 4405, 4405, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 2657, 10849, 10849, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 2797, 6893, 6893, 6893, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 7521, 7521, 23905, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 3375, 7471, 7471, 7471, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 353, 353, 353, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 6377, 6377, 22761, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 353, 8545, 24929, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 4883, 13075, 13075, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 2401, 6497, 14689, 31073, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 3499, 11691, 11691, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 5985, 5985, 22369, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 3647, 3647, 3647, 3647, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 3937, 3937, 20321, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4103, 12295, 28679, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 7009, 7009, 23393, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 7887, 16079, 16079, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 11105, 27489, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 3331, 7427, 7427, 7427, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 1249, 1249, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 151, 151, 8343, 8343, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 9441, 25825, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 2461, 6557, 14749, 31133, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 7393, 15585, 31969, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 1605, 9797, 9797, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 3297, 11489, 11489, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 1891, 5987, 5987, 5987, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 225, 225, 16609, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 2409, 6505, 14697, 31081, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 6369, 22753, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 12849, 29233, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 737, 737, 737, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 7031, 7031, 7031, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 5601, 13793, 30177, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 2773, 2773, 10965, 27349, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 1505, 17889, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 1481, 5577, 13769, 13769, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 9697, 9697, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 2739, 2739, 10931, 27315, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 3553, 11745, 28129, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 2317, 6413, 6413, 6413, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 481, 481, 481, 481, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 1207, 1207, 9399, 9399, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 481, 481, 8673, 25057, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 3901, 3901, 3901, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 6625, 6625, 6625, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 3727, 3727, 20111, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 2529, 10721, 10721, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 2371, 10563, 26947, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 4065, 12257, 12257, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 1187, 1187, 9379, 9379, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 993, 993, 17377, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 6569, 6569, 6569, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 7137, 23521, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 8945, 25329, 0, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 15329, 15329, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 2539, 2539, 2539, 2539, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 4369, 12561, 28945, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 7899, 7899, 7899, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 5393, 13585, 13585, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 2933, 2933, 11125, 27509, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 7441, 15633, 32017, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 6443, 14635, 31019, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 3345, 3345, 19729, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 14183, 30567, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 785, 785, 785, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 6665, 6665, 6665, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 2833, 11025, 11025, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 2765, 2765, 2765, 2765, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 7953, 7953, 24337, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 591, 591, 591, 591, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 3857, 3857, 3857, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 2873, 2873, 2873, 2873, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 4113, 4113, 20497, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 3455, 7551, 15743, 15743, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 8209, 24593, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 2483, 6579, 6579, 22963, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 6161, 6161, 6161, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 6545, 22929, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 7185, 7185, 23569, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 3471, 3471, 3471, 19855, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 7185, 15377, 15377, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 2021, 2021, 2021, 18405, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 529, 4625, 12817, 29201, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 7451, 7451, 23835, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 2577, 2577, 2577, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 1945, 10137, 10137, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 4497, 4497, 4497, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 767, 767, 767, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 4497, 12689, 29073, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 3157, 3157, 3157, 19541, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 401, 401, 16785, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 2889, 6985, 6985, 23369, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 14737, 14737, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 2187, 2187, 10379, 10379, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 5521, 13713, 13713, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 3963, 3963, 12155, 12155, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 6033, 14225, 30609, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 3637, 11829, 28213, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 3985, 12177, 28561, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 1517, 1517, 9709, 9709, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 6289, 14481, 30865, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 197, 197, 197, 197, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 2193, 2193, 18577, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 1753, 1753, 9945, 9945, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 9361, 9361, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 657, 8849, 8849, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 3571, 11763, 28147, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 6801, 6801, 23185, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 2257, 2257, 2257, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 2705, 2705, 2705, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 775, 4871, 13063, 13063, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 2705, 10897, 27281, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 4941, 13133, 13133, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 1681, 9873, 26257, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 1405, 9597, 25981, 0, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 3729, 11921, 11921, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 3587, 3587, 11779, 11779, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 2385, 10577, 10577, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 1931, 1931, 10123, 26507, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 3409, 7505, 7505, 23889, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 2425, 2425, 2425, 18809, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 2897, 11089, 27473, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 3845, 12037, 12037, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 1873, 1873, 1873, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 3615, 7711, 15903, 32287, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 1873, 10065, 26449, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 7477, 7477, 23861, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 3921, 3921, 20305, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 3953, 12145, 12145, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 8017, 8017, 8017, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 2087, 10279, 26663, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 81, 8273, 8273, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 1627, 5723, 13915, 30299, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 4177, 4177, 4177, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 791, 791, 791, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 2129, 6225, 14417, 14417, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 3299, 3299, 11491, 27875, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 1105, 5201, 13393, 13393, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 3859, 3859, 3859, 3859, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 3153, 3153, 19537, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 8113, 16305, 16305, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 6737, 14929, 31313, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 77, 77, 77, 16461, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 4561, 4561, 20945, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 3223, 7319, 7319, 23703, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 4561, 12753, 12753, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 1437, 5533, 13725, 13725, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 7633, 7633, 24017, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 2151, 2151, 18535, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 7633, 15825, 15825, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 941, 941, 941, 17325, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 977, 977, 17361, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 3519, 3519, 3519, 19903, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 6097, 14289, 14289, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 4093, 12285, 12285, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 4049, 4049, 20433, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 3407, 7503, 15695, 32079, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 6353, 14545, 14545, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 1293, 5389, 5389, 21773, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 4817, 21201, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 855, 9047, 25431, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 2769, 10961, 10961, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 1669, 5765, 13957, 30341, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 6865, 6865, 6865, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 1177, 1177, 9369, 25753, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 1745, 9937, 9937, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 1205, 1205, 1205, 1205, 0, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 3793, 3793, 3793, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 3825, 12017, 28401, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 4401, 4401, 4401, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 7803, 15995, 32379, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 5937, 5937, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 2971, 11163, 11163, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 7985, 7985, 24369, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 2309, 2309, 2309, 18693, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 3889, 12081, 28465, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 793, 793, 793, 17177, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 4913, 13105, 13105, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 817, 9009, 25393, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 4649, 12841, 12841, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 5169, 5169, 5169, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 2139, 2139, 10331, 26715, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 7217, 15409, 15409, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 7983, 7983, 7983, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 4145, 12337, 12337, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 4063, 4063, 4063, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 8241, 24625, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 745, 4841, 4841, 21225, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 2097, 10289, 10289, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 2535, 2535, 10727, 27111, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 1585, 9777, 26161, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 7817, 16009, 32393, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 561, 8753, 8753, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 1783, 1783, 18167, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 5553, 21937, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 4059, 4059, 20443, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 1457, 9649, 26033, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 663, 663, 663, 8855, 8855, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 4529, 4529, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 3701, 7797, 15989, 15989, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 433, 16817, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 5779, 5779, 22163, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 6065, 14257, 30641, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 5055, 13247, 13247, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 4017, 12209, 28593, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 3463, 3463, 11655, 11655, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 945, 945, 945, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 2557, 2557, 2557, 18941, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 2993, 2993, 19377, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 2179, 6275, 14467, 30851, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 5297, 5297, 5297, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 213, 213, 213, 16597, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 1201, 9393, 9393, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 4041, 8137, 16329, 16329, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 3249, 11441, 27825, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 583, 4679, 4679, 21063, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 2225, 2225, 18609, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 2883, 2883, 2883, 19267, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 1713, 9905, 26289, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 3415, 7511, 7511, 7511, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 1713, 1713, 1713, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 3933, 8029, 16221, 16221, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 4785, 4785, 4785, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 693, 8885, 25269, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 689, 8881, 8881, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 937, 5033, 5033, 5033, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 689, 689, 17073, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 1363, 9555, 9555, 0, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 6833, 6833, 23217, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 3051, 3051, 11243, 11243, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 5489, 13681, 30065, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 3479, 7575, 7575, 7575, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 7537, 7537, 23921, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 2659, 6755, 14947, 14947, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 6513, 14705, 31089, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 2407, 2407, 2407, 2407, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 3953, 3953, 20337, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 4811, 4811, 4811, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 2929, 11121, 27505, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 7247, 15439, 31823, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 2929, 2929, 2929, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 3365, 7461, 15653, 15653, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 5233, 21617, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 1971, 1971, 18355, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 3185, 3185, 19569, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 4363, 4363, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 15473, 31857, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 3399, 11591, 27975, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 6257, 6257, 22641, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 1091, 1091, 17475, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 3697, 11889, 28273, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 4207, 4207, 4207, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 7793, 7793, 24177, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 2467, 2467, 2467, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 625, 625, 625, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 4533, 4533, 20917, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 6769, 14961, 31345, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 5799, 13991, 30375, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 1521, 5617, 5617, 5617, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 497, 497, 497, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 379, 379, 4475, 12667, 12667, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 4593, 12785, 12785, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 1591, 1591, 17975, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 6641, 14833, 31217, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 3193, 3193, 3193, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 12273, 12273, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 4079, 4079, 12271, 12271, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 4081, 20465, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 6661, 14853, 31237, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 1009, 17393, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 2101, 2101, 2101, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 3057, 3057, 3057, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 875, 875, 875, 17259, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 7153, 7153, 23537, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 1005, 1005, 1005, 17389, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 241, 241, 16625, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 5365, 5365, 21749, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 2289, 2289, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 171, 171, 16555, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 6385, 6385, 22769, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 3885, 12077, 28461, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 14065, 30449, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 7561, 15753, 15753, 0, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 753, 753, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 699, 4795, 12987, 29371, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 585, 585, 16969, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 2967, 7063, 7063, 7063, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 2633, 2633, 2633, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 3929, 8025, 8025, 8025, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 2633, 10825, 27209, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 3171, 7267, 7267, 23651, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 5705, 13897, 13897, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 4981, 13173, 29557, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 15945, 32329, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 299, 299, 299, 299, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 11849, 11849, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 2221, 2221, 10413, 10413, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 4169, 4169, 20553, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 2751, 2751, 2751, 19135, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 2121, 6217, 14409, 30793, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 1227, 5323, 13515, 29899, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 1097, 1097, 9289, 9289, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 1277, 1277, 1277, 17661, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 3145, 7241, 15433, 15433, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 805, 805, 805, 17189, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 841, 841, 17225, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 713, 8905, 25289, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 2889, 2889, 2889, 2889, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 2887, 2887, 11079, 27463, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 2889, 2889, 11081, 27465, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 7693, 15885, 15885, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 1865, 1865, 10057, 26441, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 2109, 2109, 10301, 10301, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 1353, 5449, 5449, 5449, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 1695, 1695, 18079, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 4809, 4809, 21193, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 1109, 5205, 5205, 21589, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 713, 713, 713, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 1587, 1587, 9779, 26163, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 2761, 6857, 6857, 6857, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 139, 4235, 4235, 20619, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 2761, 2761, 10953, 10953, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 1223, 5319, 13511, 13511, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 2761, 2761, 2761, 19145, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 1933, 1933, 1933, 1933, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 201, 201, 16585, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 3037, 3037, 3037, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 7369, 7369, 7369, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 1387, 9579, 9579, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 3273, 11465, 11465, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 3879, 12071, 12071, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 3017, 3017, 11209, 11209, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 3801, 7897, 16089, 16089, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 1993, 6089, 14281, 30665, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 1759, 5855, 14047, 30431, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 1993, 1993, 10185, 10185, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 4073, 4073, 4073, 4073, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 4041, 4041, 4041, 4041, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 301, 4397, 4397, 4397, 0, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 457, 457, 457, 16841, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 1523, 5619, 5619, 5619, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 521, 4617, 4617, 21001, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 1535, 1535, 1535, 1535, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 2569, 2569, 18953, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 3015, 3015, 3015, 3015, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 5641, 13833, 30217, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 2171, 6267, 6267, 6267, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 3593, 7689, 7689, 24073, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 1295, 5391, 13583, 29967, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 3593, 3593, 11785, 28169, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 2755, 2755, 10947, 27331, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8201, 8201, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 6365, 14557, 30941, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 2057, 6153, 6153, 22537, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 1775, 5871, 5871, 22255, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 2057, 2057, 10249, 26633, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 1827, 1827, 10019, 10019, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 3081, 3081, 3081, 19465, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 4135, 4135, 4135, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 777, 4873, 13065, 13065, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 3675, 3675, 3675, 3675, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 2825, 6921, 15113, 31497, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 3013, 3013, 11205, 11205, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 1801, 5897, 5897, 5897, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 2527, 2527, 2527, 2527, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 3849, 7945, 16137, 16137, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 2475, 2475, 10667, 27051, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 265, 265, 265, 16649, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 137, 137, 8329, 24713, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 2313, 2313, 10505, 26889, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 6221, 6221, 22605, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 3337, 7433, 15625, 32009, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 2469, 2469, 10661, 10661, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 3337, 3337, 3337, 19721, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 4537, 12729, 29113, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 6793, 14985, 14985, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 1711, 1711, 9903, 9903, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 7817, 7817, 7817, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 3627, 3627, 3627, 20011, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 137, 4233, 4233, 20617, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 533, 8725, 25109, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 2185, 6281, 6281, 6281, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 3019, 7115, 15307, 15307, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 3209, 7305, 15497, 15497, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 1359, 1359, 1359, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 3209, 3209, 3209, 3209, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 3715, 7811, 7811, 7811, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 905, 5001, 13193, 29577, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 2687, 6783, 14975, 14975, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 2953, 2953, 2953, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 3341, 3341, 19725, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 3977, 8073, 8073, 8073, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 1253, 3301, 3301, 11493, 27877, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 393, 393, 8585, 24969, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 2903, 6999, 6999, 6999, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 2441, 2441, 2441, 18825, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 163, 163, 8355, 24739, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 1417, 1417, 1417, 17801, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 851, 851, 17235, 0, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 3465, 11657, 28041, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 4007, 4007, 4007, 20391, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 3689, 3689, 3689, 20073, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 5939, 14131, 30515, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 2665, 10857, 27241, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 311, 311, 311, 311, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 2665, 2665, 2665, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 1213, 1213, 1213, 1213, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 617, 4713, 4713, 4713, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 869, 4965, 4965, 21349, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 3177, 3177, 11369, 27753, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 2775, 6871, 15063, 15063, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 1129, 5225, 13417, 29801, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 2287, 10479, 10479, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 105, 4201, 4201, 20585, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 1131, 5227, 13419, 29803, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 105, 105, 105, 105, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 2285, 2285, 10477, 10477, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 3945, 3945, 12137, 12137, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 1303, 1303, 1303, 1303, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 1897, 5993, 14185, 14185, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 1839, 10031, 26415, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 1897, 1897, 10089, 26473, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 7129, 15321, 31705, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 2921, 7017, 7017, 23401, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 4085, 8181, 16373, 32757, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 2921, 2921, 11113, 27497, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 2793, 2793, 2793, 19177, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 873, 873, 9065, 9065, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 4583, 4583, 4583, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 3433, 7529, 7529, 23913, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 7573, 7573, 23957, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 1385, 5481, 5481, 5481, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 587, 587, 587, 587, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 1385, 1385, 9577, 9577, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 2567, 2567, 2567, 2567, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 2409, 6505, 6505, 6505, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 1467, 1467, 17851, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 361, 4457, 4457, 20841, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 4005, 4005, 4005, 20389, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 361, 361, 361, 361, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 1795, 1795, 1795, 18179, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 3817, 7913, 16105, 16105, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 2011, 6107, 14299, 14299, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 5865, 14057, 30441, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 1093, 5189, 5189, 5189, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 745, 745, 8937, 25321, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 1453, 3501, 7597, 15789, 15789, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 7401, 15593, 31977, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 1045, 1045, 1045, 1045, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 2281, 2281, 2281, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 375, 375, 8567, 24951, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 2025, 2025, 18409, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 2631, 10823, 10823, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 3049, 3049, 11241, 11241, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 7485, 15677, 15677, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 3561, 3561, 11753, 11753, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 1885, 10077, 10077, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 1513, 9705, 26089, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 7843, 16035, 32419, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 6633, 6633, 23017, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 1951, 1951, 1951, 18335, 0, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 2537, 2537, 2537, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 2985, 2985, 2985, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 1577, 5673, 13865, 30249, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 1967, 1967, 10159, 10159, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 1577, 5673, 5673, 5673, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 1861, 1861, 10053, 10053, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 2601, 2601, 18985, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 403, 8595, 8595, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 4649, 4649, 21033, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 3883, 7979, 7979, 7979, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 553, 553, 553, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 3757, 3757, 20141, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 3113, 7209, 15401, 31785, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 1215, 5311, 13503, 13503, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 1065, 1065, 1065, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 5325, 13517, 29901, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 2089, 6185, 6185, 22569, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 3387, 3387, 11579, 11579, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 41, 41, 8233, 8233, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 1337, 5433, 5433, 5433, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 5929, 5929, 5929, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 2315, 2315, 10507, 26891, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 2857, 2857, 2857, 19241, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 3645, 3645, 20029, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 3369, 11561, 11561, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 2647, 6743, 6743, 23127, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 1321, 5417, 13609, 13609, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 2159, 2159, 10351, 26735, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 1321, 1321, 1321, 1321, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 419, 4515, 12707, 29091, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 2345, 2345, 2345, 2345, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 595, 4691, 4691, 21075, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 297, 297, 8489, 8489, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 3751, 3751, 3751, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 3753, 7849, 16041, 32425, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 597, 4693, 12885, 12885, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 2729, 2729, 2729, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 3639, 7735, 15927, 15927, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 681, 4777, 12969, 29353, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 101, 8293, 24677, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 681, 681, 681, 17065, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 1145, 5241, 5241, 5241, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 3241, 3241, 11433, 27817, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 3549, 3549, 11741, 28125, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 2217, 6313, 6313, 6313, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 1823, 1823, 1823, 1823, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 6057, 14249, 14249, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 7877, 16069, 32453, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 1961, 10153, 26537, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 1507, 1507, 1507, 1507, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 7081, 7081, 23465, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 2271, 2271, 2271, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 7081, 15273, 15273, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 3317, 3317, 3317, 19701, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 1449, 1449, 17833, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 5383, 13575, 13575, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 1449, 9641, 9641, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 3405, 3405, 3405, 19789, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 425, 4521, 4521, 20905, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 7119, 15311, 15311, 0, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 425, 425, 8617, 25001, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2051, 2051, 2051, 18435, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 2905, 7001, 15193, 15193, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 2237, 2237, 18621, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 3417, 11609, 27993, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 3995, 3995, 12187, 28571, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 1625, 1625, 9817, 26201, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 453, 453, 453, 453, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 1625, 5721, 5721, 22105, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 6105, 14297, 30681, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 6745, 14937, 14937, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 1299, 5395, 5395, 21779, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 601, 4697, 4697, 4697, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 3559, 3559, 11751, 28135, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 3161, 3161, 3161, 3161, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 2111, 2111, 2111, 2111, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 3161, 3161, 11353, 27737, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 4501, 4501, 4501, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 1113, 1113, 9305, 9305, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 3659, 7755, 15947, 15947, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 1113, 5209, 13401, 29785, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 4685, 12877, 29261, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 2137, 2137, 10329, 10329, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 2491, 6587, 14779, 31163, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 89, 89, 89, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 2255, 6351, 14543, 14543, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 4185, 4185, 20569, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 7097, 15289, 31673, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 4057, 8153, 16345, 16345, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 1687, 9879, 9879, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 3033, 3033, 19417, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 2677, 2677, 10869, 27253, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 7129, 7129, 7129, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 4755, 4755, 4755, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 985, 985, 985, 985, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 3115, 3115, 11307, 27691, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 3545, 11737, 11737, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 1983, 6079, 14271, 14271, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 3545, 3545, 19929, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 2069, 2069, 2069, 18453, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 1497, 5593, 13785, 13785, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 2439, 2439, 10631, 10631, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 2521, 6617, 6617, 23001, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 3581, 7677, 7677, 7677, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 473, 4569, 4569, 4569, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 7299, 15491, 15491, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 1753, 5849, 14041, 30425, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 1607, 5703, 5703, 22087, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 729, 4825, 13017, 13017, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 6905, 15097, 31481, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 729, 4825, 4825, 21209, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 3907, 3907, 3907, 3907, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 3289, 7385, 15577, 31961, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 6487, 6487, 6487, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 1241, 1241, 1241, 1241, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 1157, 1157, 1157, 17541, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 2265, 2265, 10457, 26841, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 2975, 7071, 15263, 15263, 0, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 2265, 2265, 2265, 2265, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 1717, 5813, 14005, 14005, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 2841, 2841, 11033, 27417, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 2421, 6517, 6517, 22901, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 3353, 7449, 15641, 15641, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 115, 4211, 12403, 28787, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 1305, 9497, 9497, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 1739, 5835, 5835, 22219, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 5401, 5401, 5401, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 1671, 5767, 5767, 5767, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 5401, 13593, 29977, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 6349, 14541, 14541, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 6425, 14617, 31001, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 3837, 3837, 12029, 28413, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 281, 4377, 4377, 20761, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 2361, 6457, 6457, 6457, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 281, 4377, 12569, 12569, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 899, 4995, 13187, 13187, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 3609, 3609, 11801, 11801, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 2005, 2005, 10197, 10197, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 1561, 1561, 9753, 26137, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 1291, 5387, 5387, 21771, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 1561, 5657, 13849, 13849, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 1037, 5133, 5133, 5133, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 2585, 6681, 6681, 23065, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 3511, 7607, 7607, 7607, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 537, 4633, 4633, 4633, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 6649, 14841, 14841, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 3097, 3097, 11289, 27673, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 1819, 1819, 1819, 1819, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 3097, 7193, 7193, 23577, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 1623, 1623, 9815, 9815, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 2073, 2073, 2073, 18457, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 1183, 1183, 17567, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 25, 4121, 4121, 20505, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 679, 4775, 12967, 29351, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 6041, 14233, 30617, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 1735, 5831, 14023, 14023, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 2969, 7065, 7065, 7065, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 3005, 7101, 15293, 15293, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 921, 921, 9113, 25497, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 2063, 2063, 2063, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 1433, 9625, 26009, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 3055, 3055, 11247, 11247, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 5529, 5529, 21913, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 2595, 2595, 2595, 2595, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 6553, 6553, 22937, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 2515, 2515, 10707, 10707, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 409, 409, 409, 16793, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 1899, 1899, 1899, 1899, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 409, 4505, 4505, 4505, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 6125, 6125, 6125, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 3737, 3737, 3737, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 859, 859, 9051, 25435, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 7833, 16025, 16025, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 1559, 1559, 1559, 17943, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 1689, 1689, 9881, 9881, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 1071, 1071, 9263, 25647, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 665, 665, 665, 665, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 1195, 1195, 1195, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 665, 4761, 4761, 21145, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 6957, 15149, 15149, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 2201, 6297, 14489, 14489, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 3575, 7671, 15863, 32247, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 153, 4249, 12441, 28825, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 6329, 14521, 14521, 0, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 153, 4249, 4249, 4249, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 1027, 5123, 13315, 29699, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 2937, 2937, 11129, 27513, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 3397, 3397, 3397, 3397, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 2937, 7033, 15225, 15225, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 99, 99, 8291, 24675, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 6009, 14201, 14201, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 915, 915, 915, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 3961, 8057, 8057, 8057, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 871, 4967, 13159, 29543, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 3961, 8057, 16249, 32633, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 1197, 1197, 9389, 25773, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 2425, 6521, 14713, 31097, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 7885, 7885, 24269, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 1401, 9593, 9593, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 3899, 3899, 3899, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 3449, 3449, 3449, 3449, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 1615, 1615, 1615, 1615, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 3449, 3449, 11641, 28025, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 3877, 3877, 3877, 3877, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 3449, 7545, 7545, 23929, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 3897, 7993, 7993, 7993, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 633, 633, 8825, 8825, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 469, 469, 16853, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 3705, 7801, 15993, 32377, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 3651, 7747, 7747, 7747, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 121, 121, 8313, 24697, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 6427, 6427, 6427, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 2169, 10361, 10361, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 389, 4485, 4485, 4485, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 1145, 1145, 9337, 9337, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 949, 9141, 25525, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 3193, 11385, 27769, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 3819, 7915, 16107, 16107, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 1017, 9209, 25593, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 1791, 1791, 1791, 1791, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 2553, 2553, 2553, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2053, 2053, 2053, 18437, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 1529, 1529, 9721, 26105, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 1311, 1311, 1311, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 3577, 3577, 19961, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 2411, 6507, 6507, 6507, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 761, 4857, 13049, 13049, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 6167, 14359, 14359, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 6905, 6905, 6905, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 2019, 10211, 10211, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 1785, 1785, 1785, 18169, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 1781, 1781, 9973, 26357, 0, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 3833, 7929, 7929, 24313, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 3373, 7469, 7469, 23853, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 825, 825, 825, 17209, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 2559, 6655, 14847, 31231, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 2873, 2873, 11065, 27449, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 907, 907, 9099, 9099, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 1849, 1849, 10041, 26425, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 1147, 9339, 9339, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 313, 313, 8505, 24889, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 411, 4507, 12699, 29083, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 2361, 2361, 10553, 10553, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 2821, 6917, 15109, 31493, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 2361, 6457, 14649, 31033, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 6947, 6947, 6947, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 1337, 1337, 1337, 17721, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 6687, 14879, 31263, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 2617, 6713, 14905, 14905, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 2275, 2275, 10467, 10467, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 1593, 1593, 1593, 1593, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 5599, 13791, 30175, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 5177, 13369, 29753, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 637, 637, 637, 17021, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 3129, 3129, 3129, 3129, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 1743, 1743, 1743, 18127, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 5049, 13241, 13241, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 2199, 6295, 6295, 22679, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 3001, 11193, 11193, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 6831, 6831, 23215, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 1977, 10169, 10169, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 2655, 2655, 2655, 19039, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 6073, 6073, 6073, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 3219, 3219, 3219, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 4537, 4537, 4537, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 371, 371, 8563, 24947, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 1465, 1465, 1465, 1465, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 59, 59, 16443, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 2745, 6841, 15033, 31417, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 2119, 2119, 10311, 10311, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 1721, 5817, 5817, 5817, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 1853, 5949, 5949, 5949, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 3769, 3769, 11961, 28345, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 1679, 5775, 13967, 13967, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 3769, 3769, 3769, 3769, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 229, 229, 8421, 8421, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 185, 4281, 4281, 4281, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 3421, 3421, 3421, 3421, 0, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 3257, 3257, 3257, 19641, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 4587, 12779, 29163, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 1365, 1365, 1365, 1365, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 2967, 2967, 11159, 27543, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 3413, 7509, 15701, 32085, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 4421, 12613, 28997, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 341, 4437, 4437, 20821, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 2399, 6495, 14687, 14687, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 341, 4437, 12629, 12629, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 885, 885, 17269, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 341, 341, 8533, 24917, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 3987, 3987, 3987, 20371, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 5973, 14165, 14165, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 2751, 6847, 15039, 15039, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 3925, 3925, 12117, 12117, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 1159, 9351, 25735, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 3925, 3925, 3925, 20309, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 717, 8909, 8909, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 4949, 4949, 21333, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 827, 827, 827, 17211, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 853, 9045, 25429, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 119, 4215, 4215, 20599, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 853, 853, 853, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 1277, 5373, 13565, 29949, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 2901, 2901, 2901, 19285, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 387, 8579, 24963, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 85, 85, 8277, 24661, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 251, 251, 251, 251, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 2133, 2133, 10325, 10325, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 4069, 12261, 28645, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 1621, 5717, 5717, 22101, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 605, 605, 605, 605, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 3669, 7765, 7765, 7765, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 4003, 8099, 8099, 8099, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 6741, 14933, 31317, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 167, 167, 167, 167, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 3541, 7637, 7637, 24021, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 2815, 2815, 2815, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 3541, 3541, 11733, 28117, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 1587, 5683, 5683, 5683, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 1493, 1493, 9685, 9685, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 1933, 6029, 14221, 14221, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 2517, 6613, 14805, 14805, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 1915, 1915, 10107, 10107, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 4565, 4565, 4565, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 6671, 14863, 31247, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 4565, 12757, 29141, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 1637, 5733, 13925, 13925, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 4053, 8149, 8149, 24533, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 667, 4763, 12955, 29339, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 3029, 3029, 3029, 3029, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 7123, 15315, 31699, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 981, 981, 9173, 9173, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 7975, 7975, 24359, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 1237, 5333, 13525, 29909, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 3043, 3043, 11235, 27619, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 3797, 3797, 3797, 3797, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 2197, 6293, 14485, 14485, 0, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 3797, 7893, 7893, 24277, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 1523, 1523, 9715, 26099, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 277, 277, 4373, 12565, 12565, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 2355, 6451, 6451, 6451, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 277, 2325, 6421, 14613, 30997, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 1165, 1165, 17549, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 1301, 5397, 13589, 13589, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 701, 4797, 4797, 21181, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 3349, 3349, 11541, 11541, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 1381, 1381, 1381, 1381, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 789, 789, 789, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 3483, 7579, 15771, 15771, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 2837, 2837, 2837, 19221, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 1797, 1797, 1797, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 1813, 10005, 26389, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 5663, 13855, 30239, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 5909, 5909, 22293, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 1235, 5331, 13523, 29907, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 3093, 3093, 19477, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 8167, 8167, 8167, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 3093, 11285, 11285, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 557, 4653, 4653, 21037, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 4629, 4629, 21013, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 2965, 2965, 2965, 2965, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 6677, 6677, 6677, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 3147, 3147, 11339, 27723, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 2581, 10773, 10773, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 1031, 1031, 1031, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 1557, 1557, 1557, 1557, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 7805, 15997, 15997, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 2453, 2453, 10645, 27029, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 2523, 6619, 6619, 23003, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 2453, 6549, 6549, 22933, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 1175, 5271, 5271, 21655, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 2453, 6549, 14741, 14741, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 3485, 7581, 7581, 7581, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 4501, 12693, 29077, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 867, 867, 9059, 9059, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 3477, 3477, 3477, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 1631, 1631, 1631, 18015, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 8085, 16277, 16277, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 3959, 3959, 12151, 28535, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 1941, 10133, 10133, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 5455, 13647, 30031, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 2197, 2197, 10389, 26773, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 3763, 7859, 7859, 24243, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 149, 4245, 12437, 28821, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 2059, 2059, 2059, 18443, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 1173, 5269, 5269, 5269, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 2703, 6799, 14991, 14991, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 2709, 2709, 2709, 2709, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 349, 4445, 12637, 29021, 0, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 661, 4757, 4757, 4757, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 3717, 7813, 7813, 24197, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 885, 9077, 9077, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 3071, 3071, 3071, 3071, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 2421, 2421, 2421, 2421, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 6383, 6383, 22767, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 1397, 1397, 9589, 9589, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 821, 4917, 4917, 4917, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 4725, 4725, 4725, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 91, 91, 8283, 24667, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 629, 8821, 8821, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 1303, 5399, 13591, 29975, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 2677, 6773, 6773, 23157, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 3525, 7621, 15813, 32197, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 5749, 5749, 5749, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 4085, 4085, 4085, 20469, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 1653, 1653, 18037, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 2323, 6419, 6419, 6419, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 3701, 3701, 3701, 3701, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 1069, 5165, 13357, 13357, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 117, 4213, 4213, 4213, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 1087, 1087, 1087, 1087, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 2165, 2165, 2165, 2165, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 2567, 6663, 14855, 31239, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 1141, 1141, 1141, 17525, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 3831, 3831, 3831, 20215, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 1141, 1141, 9333, 9333, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 2173, 6269, 6269, 22653, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 4085, 4085, 12277, 12277, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 2143, 6239, 14431, 14431, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 2549, 6645, 14837, 31221, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 883, 4979, 13171, 13171, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 1525, 1525, 1525, 1525, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 2895, 2895, 2895, 2895, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 6901, 15093, 31477, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 1151, 5247, 13439, 13439, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 3829, 7925, 7925, 7925, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 4603, 4603, 20987, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 6389, 14581, 30965, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 1051, 1051, 1051, 1051, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 2293, 10485, 10485, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 5981, 5981, 5981, 0, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 1269, 1269, 1269, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 423, 423, 423, 16807, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 3893, 7989, 16181, 16181, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 1967, 6063, 6063, 22447, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 821, 821, 821, 17205, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 4499, 4499, 20883, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 6965, 6965, 23349, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 3883, 3883, 12075, 28459, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 2869, 2869, 2869, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 7853, 16045, 32429, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 2357, 6453, 6453, 22837, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 1103, 5199, 13391, 29775, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 7733, 15925, 15925, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 1351, 9543, 25927, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 7733, 7733, 24117, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 2061, 2061, 10253, 26637, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 1077, 1077, 9269, 9269, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 2843, 2843, 2843, 19227, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 6197, 14389, 14389, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 621, 4717, 4717, 21101, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 1973, 1973, 1973, 10165, 26549, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 6855, 15047, 15047, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 2997, 2997, 11189, 11189, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 3639, 3639, 3639, 20023, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 1461, 9653, 26037, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 1571, 1571, 1571, 17955, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 3765, 7861, 7861, 7861, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 285, 4381, 12573, 12573, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 4789, 12981, 12981, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 3815, 7911, 7911, 24295, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 4789, 4789, 21173, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 1837, 1837, 1837, 18221, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 3253, 7349, 15541, 31925, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 1011, 3059, 7155, 15347, 31731, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 1205, 5301, 13493, 13493, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 3405, 7501, 15693, 32077, 0, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 2229, 2229, 10421, 10421, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 2747, 6843, 15035, 31419, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 1349, 1349, 1349, 17733, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 3383, 3383, 3383, 3383, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 3397, 7493, 7493, 23877, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 1807, 1807, 1807, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 837, 837, 9029, 9029, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 1751, 5847, 14039, 14039, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 837, 837, 837, 17221, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 733, 733, 8925, 25309, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 2885, 6981, 6981, 23365, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 3333, 3333, 11525, 11525, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 1861, 1861, 1861, 18245, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 1747, 5843, 5843, 22227, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 3909, 3909, 3909, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 1261, 5357, 5357, 21741, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 2117, 2117, 2117, 2117, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 2863, 11055, 27439, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 2117, 6213, 14405, 14405, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 1763, 1763, 1763, 18147, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 1093, 1093, 1093, 17477, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 3039, 7135, 15327, 31711, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 3141, 11333, 27717, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 2987, 7083, 15275, 15275, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 581, 4677, 4677, 4677, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 2291, 2291, 2291, 18675, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 6725, 6725, 23109, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 589, 589, 16973, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 5701, 13893, 30277, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 759, 4855, 13047, 13047, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 2501, 2501, 2501, 18885, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 5783, 5783, 22167, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 453, 4549, 4549, 20933, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 1199, 5295, 5295, 21679, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 1989, 6085, 6085, 22469, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 2597, 2597, 10789, 27173, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 3269, 3269, 11461, 11461, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 3579, 3579, 11771, 28155, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 3269, 7365, 15557, 31941, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 317, 317, 317, 16701, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 5317, 13509, 13509, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 3907, 8003, 16195, 32579, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 7877, 7877, 7877, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 339, 4435, 4435, 4435, 0, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 1733, 1733, 1733, 1733, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 8171, 8171, 8171, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 1285, 5381, 13573, 13573, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 1181, 1181, 1181, 17565, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 261, 4357, 12549, 12549, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 3475, 11667, 28051, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 1797, 9989, 26373, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 6335, 14527, 14527, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 5893, 5893, 22277, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 115, 115, 115, 115, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1029, 3077, 3077, 11269, 11269, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 1037, 1037, 9229, 9229, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 3511, 3511, 11703, 28087, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 8197, 24581, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 4669, 12861, 12861, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2053, 6149, 6149, 6149, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 1935, 1935, 1935, 18319, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 7685, 15877, 32261, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 1135, 1135, 9327, 25711, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 3589, 3589, 19973, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 3491, 7587, 15779, 15779, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 3461, 3461, 3461, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 2303, 2303, 2303, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 7557, 15749, 15749, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 1075, 5171, 13363, 13363, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 5509, 13701, 30085, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 3469, 7565, 7565, 7565, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 389, 389, 8581, 8581, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 7269, 7269, 7269, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 3973, 3973, 3973, 3973, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 155, 4251, 4251, 20635, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 2949, 11141, 27525, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 2847, 2847, 2847, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 901, 4997, 4997, 4997, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 2029, 10221, 10221, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 3205, 3205, 3205, 3205, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 1559, 5655, 13847, 13847, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 133, 133, 133, 16517, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 743, 743, 8935, 8935, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 1669, 5765, 5765, 5765, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 331, 331, 331, 331, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 1669, 1669, 9861, 9861, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 6407, 14599, 14599, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 2693, 6789, 6789, 23173, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 1723, 1723, 1723, 18107, 0, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 645, 4741, 12933, 29317, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 6095, 14287, 14287, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 1893, 10085, 26469, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 2779, 10971, 10971, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 5989, 14181, 14181, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 669, 8861, 8861, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 3941, 3941, 3941, 20325, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 1455, 5551, 5551, 21935, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 2917, 2917, 11109, 11109, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 3371, 3371, 3371, 19755, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 2917, 7013, 7013, 7013, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 871, 871, 871, 871, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 7525, 15717, 32101, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 2183, 6279, 6279, 6279, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 357, 4453, 4453, 20837, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 6397, 14589, 14589, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 2405, 10597, 10597, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 1615, 5711, 13903, 30287, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 6501, 6501, 6501, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 7555, 7555, 23939, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 1637, 1637, 9829, 26213, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 1459, 3507, 3507, 11699, 28083, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 7781, 15973, 32357, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 2827, 6923, 15115, 15115, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 5221, 5221, 21605, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 2331, 10523, 26907, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 3173, 3173, 19557, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 931, 931, 9123, 9123, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 2149, 2149, 2149, 18533, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 2157, 6253, 14445, 30829, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 2021, 6117, 6117, 6117, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 6343, 14535, 14535, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 3557, 7653, 15845, 15845, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 2007, 6103, 14295, 30679, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 3557, 7653, 7653, 24037, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 2013, 6109, 14301, 30685, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 2533, 6629, 6629, 23013, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 2003, 2003, 2003, 18387, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 2789, 6885, 6885, 23269, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 6879, 15071, 31455, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 2789, 2789, 10981, 27365, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 1043, 5139, 13331, 13331, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 1253, 1253, 1253, 1253, 17637, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 1869, 5965, 5965, 22349, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 6373, 6373, 22757, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 2235, 6331, 6331, 22715, 0, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 2277, 10469, 26853, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 5111, 13303, 29687, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 2853, 2853, 11045, 27429, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 2189, 2189, 2189, 2189, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 1829, 1829, 10021, 10021, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 3773, 7869, 7869, 7869, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 3877, 3877, 12069, 28453, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 1731, 1731, 9923, 9923, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 293, 293, 293, 16677, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 1245, 1245, 1245, 1245, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 2341, 2341, 2341, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 2851, 11043, 27427, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 1317, 5413, 13605, 29989, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 2591, 2591, 2591, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 3365, 7461, 7461, 23845, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 1643, 1643, 9835, 9835, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 3365, 3365, 11557, 27941, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 3111, 7207, 7207, 7207, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 4645, 12837, 29221, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 2077, 2077, 10269, 26653, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 1573, 1573, 1573, 17957, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 1503, 1503, 1503, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 7717, 7717, 24101, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 999, 999, 9191, 25575, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 2085, 2085, 2085, 2085, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 75, 4171, 4171, 20555, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 2085, 6181, 6181, 22565, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 1101, 1101, 9293, 9293, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 1061, 1061, 1061, 17445, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 1979, 6075, 6075, 6075, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 3109, 3109, 3109, 3109, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 1445, 5541, 5541, 21925, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 933, 5029, 5029, 21413, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 2735, 10927, 10927, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 933, 933, 9125, 25509, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 8035, 8035, 8035, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 4005, 4005, 12197, 12197, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 7315, 15507, 31891, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 1957, 1957, 1957, 1957, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 3175, 7271, 15463, 15463, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 2469, 6565, 14757, 31141, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 2495, 6591, 14783, 14783, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 3493, 7589, 7589, 7589, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 4155, 12347, 12347, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 2725, 6821, 15013, 31397, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 691, 691, 8883, 25267, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 677, 4773, 12965, 12965, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 269, 4365, 12557, 12557, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 3749, 7845, 7845, 7845, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 3255, 11447, 11447, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 165, 165, 8357, 24741, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 1391, 1391, 9583, 25967, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 3237, 3237, 11429, 11429, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 5535, 13727, 13727, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 1189, 1189, 1189, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 491, 491, 491, 0, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 5285, 5285, 21669, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 2925, 2925, 2925, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 3741, 7837, 16029, 16029, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 819, 819, 17203, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 5789, 5789, 5789, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 455, 455, 455, 455, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 2717, 6813, 15005, 15005, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 189, 8381, 24765, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 4765, 12957, 29341, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 195, 195, 16579, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 157, 157, 157, 16541, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 107, 107, 16491, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 3997, 12189, 12189, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 5661, 5661, 5661, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 1949, 6045, 6045, 22429, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 815, 4911, 4911, 4911, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 2973, 2973, 11165, 11165, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 7443, 7443, 23827, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 3485, 7581, 15773, 32157, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 4509, 12701, 12701, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 207, 4303, 12495, 12495, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 1565, 1565, 17949, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 987, 987, 987, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 5661, 13853, 30237, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 3735, 11927, 11927, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 6685, 6685, 23069, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 6573, 6573, 22957, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 3101, 3101, 11293, 27677, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 4555, 4555, 4555, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 3101, 7197, 15389, 15389, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 973, 9165, 25549, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 1821, 1821, 1821, 1821, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 1203, 1203, 1203, 1203, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 7965, 7965, 7965, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 523, 4619, 4619, 4619, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 3869, 3869, 20253, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 3853, 3853, 3853, 20237, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 1309, 5405, 13597, 13597, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 16411, 0, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 3357, 3357, 11549, 11549, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 2723, 2723, 19107, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 6877, 6877, 6877, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 407, 4503, 4503, 4503, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 733, 733, 733, 733, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 943, 5039, 5039, 21423, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 2269, 10461, 10461, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 191, 191, 191, 16575, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 6365, 6365, 6365, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 2163, 6259, 14451, 30835, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 1245, 5341, 5341, 21725, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 7043, 15235, 15235, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 989, 989, 17373, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 327, 327, 8519, 24903, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 477, 477, 477, 16861, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 1443, 1443, 17827, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 3549, 3549, 3549, 3549, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 1619, 1619, 9811, 26195, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 5597, 5597, 5597, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 2283, 2283, 10475, 10475, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 2653, 2653, 19037, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 6795, 14987, 31371, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 1629, 1629, 1629, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 15739, 32123, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 1117, 1117, 1117, 1117, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 799, 4895, 13087, 29471, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 3165, 7261, 7261, 7261, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 1319, 9511, 9511, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 7005, 15197, 15197, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 3119, 11311, 27695, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 3933, 8029, 8029, 24413, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 3243, 3243, 3243, 3243, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 6493, 14685, 14685, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 2379, 6475, 14667, 31051, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 2397, 2397, 2397, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 263, 263, 263, 16647, 0, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 2397, 10589, 26973, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 2381, 10573, 10573, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 2237, 10429, 10429, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 2147, 10339, 26723, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 701, 4797, 12989, 12989, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 3775, 7871, 16063, 16063, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 2749, 6845, 6845, 6845, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 203, 203, 16587, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 1725, 1725, 1725, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 253, 8445, 8445, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 3773, 3773, 3773, 20157, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 1411, 9603, 9603, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 1469, 1469, 9661, 9661, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 1275, 1275, 17659, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 3517, 7613, 15805, 15805, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 5699, 5699, 5699, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 6077, 6077, 6077, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 2131, 6227, 14419, 30803, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 4029, 4029, 4029, 4029, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 1771, 5867, 14059, 14059, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 909, 9101, 25485, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 5181, 13373, 13373, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 7695, 15887, 32271, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 1085, 1085, 1085, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 451, 4547, 4547, 20931, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 2621, 6717, 14909, 31293, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 5787, 13979, 13979, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 4669, 4669, 21053, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 3567, 7663, 7663, 24047, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 1597, 5693, 13885, 13885, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 4459, 4459, 4459, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 1597, 1597, 1597, 1597, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 2855, 6951, 6951, 23335, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 1341, 5437, 13629, 30013, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 1255, 1255, 9447, 9447, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 2877, 2877, 2877, 2877, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 319, 319, 319, 319, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 829, 9021, 9021, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 1867, 10059, 26443, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 3901, 12093, 28477, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 187, 187, 8379, 8379, 0, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 7997, 7997, 24381, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 3063, 3063, 3063, 3063, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 7421, 15613, 15613, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 2955, 2955, 11147, 11147, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 3325, 3325, 3325, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 4039, 8135, 16327, 32711, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 4349, 12541, 28925, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 3195, 3195, 11387, 11387, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 6397, 6397, 22781, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 271, 271, 271, 271, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 1789, 1789, 9981, 9981, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 4311, 12503, 12503, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 2813, 2813, 11005, 27389, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 1063, 1063, 9255, 25639, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 5629, 5629, 22013, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 3863, 3863, 3863, 3863, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 509, 4605, 12797, 12797, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 787, 787, 17171, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 1021, 1021, 1021, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 4027, 4027, 12219, 28603, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 5117, 13309, 13309, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 5367, 13559, 13559, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 3197, 7293, 7293, 23677, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 7643, 7643, 7643, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 1149, 1149, 1149, 17533, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 1891, 1891, 10083, 26467, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 1661, 5757, 13949, 30333, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 4043, 4043, 4043, 4043, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 1661, 1661, 1661, 18045, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 3975, 8071, 8071, 24455, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 2685, 2685, 2685, 2685, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 2935, 11127, 27511, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 3453, 11645, 11645, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 3711, 3711, 20095, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 1405, 1405, 1405, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 3083, 3083, 3083, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 5501, 5501, 21885, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 2317, 2317, 10509, 10509, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 381, 381, 8573, 24957, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 7823, 16015, 16015, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 8061, 8061, 8061, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 3927, 3927, 12119, 28503, 0, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 4989, 13181, 13181, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 877, 4973, 4973, 4973, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 3725, 7821, 16013, 16013, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 5219, 5219, 21603, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 5261, 5261, 5261, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 6771, 6771, 23155, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 3981, 3981, 12173, 12173, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 1549, 5645, 5645, 5645, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 2957, 11149, 11149, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 2627, 10819, 10819, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 3469, 7565, 15757, 32141, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 7791, 7791, 7791, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 397, 2445, 2445, 10637, 10637, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 6311, 14503, 30887, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 11789, 28173, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 4863, 13055, 29439, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 2573, 2573, 2573, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 3963, 8059, 8059, 24443, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 6669, 14861, 14861, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 2103, 2103, 2103, 18487, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 3085, 11277, 27661, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 2715, 2715, 2715, 2715, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 8205, 8205, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 3435, 11627, 11627, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 2829, 2829, 2829, 19213, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 4115, 12307, 28691, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 781, 8973, 25357, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 2279, 6375, 6375, 22759, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 7437, 7437, 7437, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 3391, 7487, 15679, 32063, 0, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 269, 4365, 4365, 20749, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 3535, 3535, 3535, 19919, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 4813, 13005, 29389, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 307, 8499, 24883, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 5837, 5837, 5837, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 1847, 5943, 14135, 30519, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 5325, 5325, 5325, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 3283, 3283, 3283, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 5069, 13261, 13261, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 1627, 1627, 1627, 1627, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 3021, 7117, 7117, 7117, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 4399, 4399, 4399, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 4045, 8141, 16333, 32717, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 427, 8619, 25003, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 6605, 6605, 6605, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 5195, 5195, 5195, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 3533, 7629, 15821, 32205, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 4815, 13007, 13007, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 3533, 3533, 3533, 19917, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 259, 4355, 4355, 20739, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 2637, 2637, 2637, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 475, 475, 8667, 8667, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 3661, 3661, 11853, 28237, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 7775, 15967, 15967, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 1613, 5709, 5709, 5709, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 941, 5037, 13229, 29613, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 2125, 2125, 2125, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 3519, 7615, 15807, 15807, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 6221, 14413, 14413, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 1395, 5491, 5491, 21875, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 77, 4173, 4173, 4173, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 903, 9095, 9095, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 3149, 3149, 11341, 27725, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 1083, 5179, 13371, 29755, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 1869, 1869, 1869, 1869, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 1347, 1347, 9539, 9539, 0, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 2381, 2381, 18765, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 4951, 4951, 4951, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 1197, 5293, 13485, 13485, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 783, 783, 783, 783, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 7853, 7853, 7853, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 31, 31, 4127, 12319, 28703, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 1709, 1709, 1709, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 1575, 1575, 9767, 26151, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 6573, 14765, 14765, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 3351, 3351, 3351, 3351, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 429, 4525, 4525, 4525, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 739, 739, 739, 739, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 2989, 2989, 2989, 2989, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 3135, 7231, 15423, 31807, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 2093, 6189, 6189, 6189, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 175, 4271, 4271, 20655, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 1069, 1069, 9261, 25645, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 1683, 9875, 9875, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 3117, 7213, 15405, 31789, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 6187, 6187, 22571, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 1581, 5677, 5677, 22061, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 2619, 2619, 10811, 27195, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 3629, 3629, 20013, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 2179, 2179, 2179, 2179, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 301, 301, 301, 16685, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 3199, 3199, 19583, 0, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 2861, 11053, 27437, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 3951, 8047, 8047, 8047, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 3309, 7405, 7405, 7405, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 219, 4315, 12507, 28891, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 2285, 6381, 14573, 30957, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 3935, 8031, 16223, 16223, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 237, 4333, 4333, 20717, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 1835, 5931, 5931, 5931, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 5869, 14061, 14061, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 715, 8907, 25291, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 1773, 1773, 1773, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 647, 647, 647, 8839, 25223, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 2797, 2797, 2797, 19181, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 1655, 5751, 5751, 22135, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 749, 749, 8941, 25325, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 1923, 1923, 1923, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 3565, 3565, 11757, 28141, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 13183, 13183, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 2541, 6637, 14829, 14829, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 2487, 2487, 10679, 27063, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 7277, 15469, 31853, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 1675, 1675, 1675, 18059, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 4205, 12397, 12397, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 379, 379, 379, 379, 16763, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 2157, 6253, 6253, 6253, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 7183, 15375, 31759, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 3693, 7789, 15981, 32365, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 4079, 8175, 8175, 24559, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 1389, 5485, 5485, 5485, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 535, 4631, 12823, 12823, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 365, 365, 365, 16749, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 223, 223, 223, 223, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 2413, 2413, 10605, 26989, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 4267, 12459, 12459, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 1901, 1901, 10093, 10093, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 831, 831, 831, 831, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 3949, 8045, 16237, 16237, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 7431, 15623, 15623, 0, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 7021, 7021, 23405, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 16387, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 8191, 8191, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 1755, 5851, 14043, 30427, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 2047, 6143, 6143, 6143, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 2479, 2479, 2479, 18863, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 2047, 2047, 10239, 26623, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 3171, 3171, 3171, 19555, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 2559, 2559, 10751, 27135, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 2639, 2639, 10831, 27215, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 767, 8959, 25343, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 1803, 1803, 9995, 26379, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 3839, 7935, 7935, 7935, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 251, 251, 8443, 24827, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 255, 4351, 4351, 4351, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 1111, 5207, 13399, 13399, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 1279, 5375, 5375, 5375, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 5791, 5791, 22175, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 3327, 3327, 11519, 27903, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 167, 167, 8359, 24743, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 2431, 10623, 10623, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 6671, 6671, 6671, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 6527, 6527, 22911, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 1475, 5571, 13763, 30147, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 3967, 12159, 12159, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 3031, 3031, 11223, 27607, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 1919, 1919, 10111, 10111, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 6179, 14371, 14371, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 2943, 7039, 7039, 23423, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 7123, 7123, 7123, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 895, 9087, 9087, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 5483, 13675, 13675, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 4991, 21375, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 7975, 16167, 16167, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 2175, 2175, 10367, 10367, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 1583, 5679, 13871, 30255, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 2687, 2687, 10879, 10879, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 1343, 1343, 9535, 25919, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 4735, 4735, 21119, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 6919, 6919, 23303, 0, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 7807, 7807, 24191, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 1211, 1211, 1211, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 703, 4799, 4799, 21183, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 3979, 3979, 3979, 3979, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 6335, 6335, 22719, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 1775, 1775, 1775, 18159, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 1471, 5567, 5567, 21951, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 2803, 2803, 2803, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 1087, 5183, 5183, 5183, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 147, 8339, 8339, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 4671, 4671, 4671, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 3019, 3019, 11211, 11211, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 575, 8767, 25151, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 2951, 7047, 15239, 15239, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 1599, 1599, 9791, 26175, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 5455, 5455, 5455, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 3391, 7487, 7487, 7487, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 1095, 1095, 17479, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 319, 319, 8511, 24895, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 183, 4279, 12471, 12471, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 2367, 2367, 10559, 26943, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 7491, 15683, 15683, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 3903, 3903, 12095, 28479, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 2587, 6683, 14875, 31259, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 2879, 6975, 6975, 6975, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 2463, 2463, 10655, 10655, 0, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 2879, 2879, 11071, 27455, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 4947, 4947, 21331, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 1375, 1375, 9567, 9567, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 2831, 6927, 6927, 6927, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 863, 4959, 4959, 21343, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 923, 923, 923, 17307, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 863, 863, 9055, 9055, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 2775, 2775, 10967, 10967, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 2911, 2911, 11103, 11103, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 2339, 2339, 10531, 10531, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 5983, 5983, 22367, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 2771, 2771, 2771, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 1119, 9311, 9311, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 5935, 14127, 30511, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 5215, 5215, 21599, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 6883, 6883, 6883, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 95, 4191, 4191, 20575, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 1963, 1963, 10155, 26539, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 3679, 11871, 11871, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 587, 4683, 4683, 4683, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 607, 607, 8799, 8799, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 3831, 3831, 12023, 12023, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 2655, 2655, 10847, 10847, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 1795, 5891, 5891, 22275, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 991, 991, 9183, 25567, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 663, 2711, 2711, 2711, 19095, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 2015, 6111, 6111, 6111, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 3731, 7827, 16019, 16019, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 479, 479, 8671, 25055, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 1415, 1415, 1415, 17799, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 3807, 7903, 7903, 7903, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 6727, 14919, 14919, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 6879, 6879, 6879, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 1167, 1167, 9359, 9359, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 2783, 10975, 27359, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 835, 9027, 9027, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 7391, 7391, 7391, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 1367, 5463, 13655, 30039, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 1247, 5343, 5343, 5343, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 3747, 11939, 28323, 0, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 2271, 10463, 26847, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 3411, 3411, 3411, 19795, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 31, 2079, 6175, 6175, 6175, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 4499, 12691, 12691, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 543, 4639, 4639, 4639, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 3703, 3703, 3703, 20087, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 2335, 6431, 6431, 6431, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 4019, 4019, 12211, 12211, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 287, 287, 8479, 24863, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 2315, 6411, 14603, 30987, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 3359, 3359, 11551, 27935, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 4535, 12727, 29111, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 5407, 5407, 5407, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 2959, 7055, 7055, 23439, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 799, 799, 8991, 25375, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 2843, 2843, 11035, 11035, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 1823, 5919, 5919, 5919, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 2207, 2207, 10399, 10399, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 3871, 3871, 12063, 28447, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 7847, 7847, 7847, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 5279, 5279, 21663, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 2031, 2031, 2031, 18415, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 159, 159, 8351, 8351, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 2923, 2923, 11115, 11115, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 2975, 7071, 7071, 23455, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 1507, 5603, 5603, 5603, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 415, 415, 8607, 8607, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 7499, 7499, 23883, 0, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 415, 4511, 4511, 20895, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 1287, 9479, 9479, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 431, 4527, 12719, 12719, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 2503, 6599, 6599, 6599, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 7087, 15279, 15279, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 1315, 5411, 5411, 5411, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 6831, 15023, 15023, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 2819, 11011, 27395, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 6959, 15151, 31535, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 355, 355, 8547, 24931, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 7983, 16175, 32559, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 3115, 7211, 15403, 31787, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 3887, 3887, 3887, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 615, 8807, 8807, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 4399, 12591, 28975, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 2439, 6535, 14727, 14727, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 1327, 1327, 1327, 1327, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 3203, 11395, 11395, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 1583, 1583, 1583, 1583, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 7347, 7347, 7347, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 4655, 12847, 29231, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 695, 4791, 12983, 12983, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 7215, 15407, 31791, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 2075, 6171, 6171, 22555, 0, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 3119, 3119, 3119, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 2391, 2391, 2391, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 2287, 2287, 18671, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 3475, 3475, 3475, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 751, 4847, 13039, 13039, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 315, 315, 315, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 2543, 2543, 18927, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 947, 5043, 5043, 5043, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 5615, 13807, 13807, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 67, 4163, 4163, 4163, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 2031, 6127, 14319, 14319, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 7763, 15955, 32339, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 3695, 3695, 3695, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 651, 651, 8843, 25227, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 7791, 15983, 32367, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 1735, 1735, 9927, 9927, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 623, 623, 623, 623, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 4663, 4663, 21047, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 2671, 2671, 2671, 2671, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 1987, 6083, 6083, 22467, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 111, 111, 111, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 3367, 7463, 15655, 15655, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 4975, 13167, 29551, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 859, 4955, 13147, 29531, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 4463, 12655, 29039, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 331, 331, 8523, 24907, 0, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 3439, 3439, 3439, 3439, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 1723, 1723, 9915, 9915, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 3855, 12047, 28431, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 2779, 2779, 19163, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 3343, 7439, 7439, 7439, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 2183, 6279, 14471, 30855, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 2319, 2319, 10511, 26895, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 7555, 15747, 15747, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 527, 8719, 25103, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 1863, 1863, 1863, 1863, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 3599, 11791, 28175, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 3323, 7419, 7419, 23803, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 1551, 1551, 9743, 26127, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 399, 2447, 6543, 6543, 22927, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 3087, 11279, 27663, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 3819, 3819, 12011, 12011, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 7183, 7183, 7183, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 3239, 7335, 7335, 7335, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 399, 399, 399, 8591, 8591, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 3127, 3127, 11319, 11319, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 2959, 2959, 11151, 11151, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 2003, 2003, 10195, 10195, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 143, 4239, 4239, 20623, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 3419, 3419, 11611, 27995, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 2191, 2191, 10383, 10383, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 6115, 14307, 14307, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 3215, 11407, 11407, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 2731, 2731, 2731, 2731, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 2703, 2703, 10895, 10895, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 6643, 14835, 14835, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 655, 4751, 4751, 21135, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 3915, 8011, 16203, 32587, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 7823, 7823, 24207, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 5111, 5111, 5111, 0, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 1679, 5775, 5775, 22159, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 2563, 6659, 14851, 31235, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 3663, 7759, 7759, 7759, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 5243, 13435, 13435, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 1103, 1103, 9295, 25679, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 2259, 10451, 10451, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 1871, 10063, 26447, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 2275, 6371, 14563, 14563, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 847, 4943, 4943, 4943, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 999, 999, 999, 999, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 3407, 7503, 7503, 7503, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 75, 4171, 12363, 12363, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 2383, 10575, 26959, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 1743, 5839, 5839, 22223, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 6479, 6479, 6479, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 5379, 13571, 29955, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 2255, 6351, 6351, 22735, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 8035, 16227, 32611, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 1231, 1231, 9423, 9423, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 7315, 7315, 7315, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 3791, 11983, 11983, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 887, 4983, 13175, 29559, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 1487, 1487, 9679, 9679, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 691, 691, 691, 691, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 3535, 3535, 11727, 11727, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 2119, 6215, 14407, 14407, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 4559, 4559, 20943, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 3255, 3255, 19639, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 8143, 8143, 24527, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 1563, 1563, 17947, 0, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 975, 975, 9167, 9167, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 491, 8683, 25067, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 1943, 1943, 1943, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 195, 8387, 8387, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 407, 407, 407, 407, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 1947, 1947, 1947, 1947, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 3479, 7575, 15767, 32151, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 107, 8299, 8299, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 7831, 16023, 16023, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 1115, 1115, 1115, 17499, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 3735, 3735, 20119, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 279, 4375, 4375, 4375, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 1175, 1175, 1175, 17559, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 4339, 4339, 20723, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 3223, 7319, 15511, 15511, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 5707, 5707, 22091, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 1303, 1303, 9495, 25879, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 2707, 6803, 14995, 31379, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 4887, 4887, 4887, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 391, 391, 391, 16775, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 3095, 11287, 11287, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 3655, 7751, 15943, 15943, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 6167, 6167, 22551, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 1859, 1859, 10051, 26435, 0, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 2583, 6679, 6679, 23063, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 2387, 2387, 2387, 2387, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 3799, 7895, 7895, 24279, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 3291, 3291, 11483, 11483, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 1751, 1751, 9943, 9943, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 1635, 5731, 5731, 5731, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 727, 8919, 8919, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 2859, 2859, 2859, 19243, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 3287, 7383, 7383, 23767, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 3787, 7883, 16075, 16075, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 4311, 4311, 20695, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 2679, 2679, 2679, 19063, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 3031, 7127, 7127, 7127, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 2995, 2995, 11187, 27571, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 471, 4567, 4567, 4567, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 3671, 3671, 3671, 20055, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 7255, 15447, 15447, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 6795, 6795, 6795, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 87, 87, 87, 16471, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 7547, 7547, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 1623, 1623, 1623, 18007, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 547, 547, 8739, 25123, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 599, 599, 16983, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 3947, 12139, 28523, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 4695, 12887, 12887, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 1319, 1319, 17703, 0, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 3927, 8023, 16215, 32599, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 3771, 7867, 7867, 24251, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 2359, 2359, 10551, 26935, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 2919, 7015, 7015, 7015, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 2871, 2871, 11063, 27447, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 5239, 13431, 13431, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 2103, 6199, 6199, 22583, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 779, 8971, 8971, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 1079, 5175, 5175, 21559, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 2999, 2999, 2999, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 3127, 7223, 7223, 23607, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 5699, 13891, 30275, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 8119, 16311, 32695, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 563, 4659, 12851, 12851, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 1975, 6071, 14263, 30647, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 199, 8391, 8391, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 7095, 15287, 31671, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 891, 891, 891, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 1463, 1463, 1463, 1463, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 5787, 5787, 22171, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 1719, 1719, 1719, 18103, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 4779, 12971, 29355, 0, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 1207, 1207, 1207, 17591, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 187, 187, 187, 16571, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 1143, 1143, 17527, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 3195, 3195, 3195, 19579, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 631, 631, 631, 17015, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 803, 4899, 13091, 29475, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 3703, 7799, 15991, 15991, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 211, 4307, 4307, 20691, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 1399, 1399, 1399, 1399, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 6747, 6747, 23131, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 6519, 14711, 31095, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 7595, 15787, 15787, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 1911, 1911, 1911, 1911, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 2123, 2123, 18507, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 1271, 9463, 9463, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 2107, 10299, 10299, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 3319, 7415, 7415, 23799, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 2691, 2691, 2691, 19075, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 1015, 9207, 25591, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 6467, 14659, 31043, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 2551, 6647, 6647, 6647, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 2539, 6635, 6635, 6635, 0, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 2551, 2551, 10743, 27127, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 2983, 7079, 7079, 23463, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 5063, 5063, 5063, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 3275, 7371, 7371, 7371, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 1223, 5319, 5319, 21703, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 2483, 2483, 2483, 18867, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 7367, 7367, 23751, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 839, 839, 839, 839, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 4295, 4295, 20679, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 2299, 6395, 6395, 6395, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 3783, 11975, 11975, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 3355, 3355, 19739, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 327, 4423, 12615, 28999, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 2715, 2715, 10907, 27291, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 2375, 2375, 2375, 2375, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 35, 35, 16419, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 1607, 5703, 13895, 13895, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 995, 5091, 13283, 29667, 0, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 3143, 3143, 3143, 19527, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 6987, 15179, 15179, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 3207, 3207, 3207, 3207, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 1931, 6027, 14219, 30603, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 135, 4231, 12423, 28807, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 123, 4219, 12411, 28795, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 2183, 2183, 2183, 2183, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 707, 707, 707, 707, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 3591, 3591, 11783, 28167, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 475, 475, 475, 16859, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 1543, 5639, 5639, 5639, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 7011, 15203, 15203, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 519, 519, 8711, 25095, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 6247, 6247, 22631, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 5127, 5127, 5127, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 1395, 5491, 13683, 13683, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 263, 4359, 4359, 20743, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 539, 539, 539, 539, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 2311, 10503, 10503, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 2211, 2211, 2211, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 5383, 5383, 21767, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 2899, 11091, 11091, 0, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 7431, 7431, 23815, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 1959, 1959, 10151, 10151, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 4455, 4455, 4455, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 723, 4819, 13011, 29395, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 4711, 4711, 21095, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 739, 739, 8931, 25315, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 3687, 3687, 11879, 11879, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 275, 275, 275, 275, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 2151, 10343, 10343, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 2635, 2635, 10827, 27211, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 2023, 6119, 14311, 30695, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 1483, 3531, 3531, 3531, 19915, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 3047, 3047, 3047, 3047, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 2619, 2619, 2619, 2619, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 1767, 5863, 14055, 14055, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 3051, 7147, 15339, 15339, 0, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 1767, 1767, 1767, 18151, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 6567, 6567, 22951, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 2599, 2599, 2599, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 219, 4315, 4315, 4315, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 3623, 3623, 3623, 3623, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 2451, 2451, 2451, 18835, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 4135, 12327, 28711, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 1139, 1139, 9331, 9331, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 2215, 10407, 26791, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 1675, 1675, 9867, 9867, 0, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 3751, 11943, 28327, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 3539, 7635, 15827, 32211, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 1755, 1755, 1755, 1755, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 4915, 4915, 21299, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 3291, 7387, 7387, 23771, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 1947, 6043, 14235, 30619, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 1243, 9435, 9435, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 3363, 7459, 7459, 7459, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 3035, 11227, 27611, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 3811, 3811, 12003, 12003, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 4059, 12251, 12251, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 939, 5035, 5035, 21419, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 475, 4571, 12763, 12763, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 1611, 9803, 9803, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 1499, 5595, 13787, 30171, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 771, 771, 8963, 25347, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 3675, 3675, 11867, 28251, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 1907, 1907, 10099, 26483, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 2651, 10843, 10843, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 1595, 1595, 1595, 17979, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 603, 4699, 4699, 21083, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 1155, 1155, 9347, 9347, 0, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 3931, 8027, 16219, 16219, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 2387, 6483, 14675, 31059, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 3483, 3483, 11675, 11675, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 2163, 2163, 10355, 26739, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 2459, 10651, 27035, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 2363, 2363, 2363, 2363, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 667, 667, 8859, 25243, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 2995, 7091, 7091, 7091, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 3739, 7835, 7835, 24219, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 6211, 6211, 6211, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 1307, 1307, 17691, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 3123, 7219, 7219, 23603, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 795, 795, 8987, 8987, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 8043, 8043, 8043, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 2075, 2075, 10267, 10267, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 483, 8675, 8675, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 1051, 5147, 5147, 5147, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 531, 531, 531, 16915, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 3099, 3099, 11291, 27675, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 3243, 7339, 7339, 7339, 0, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 5659, 13851, 13851, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 3075, 3075, 11267, 27651, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 2683, 6779, 6779, 23163, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 6243, 14435, 30819, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 3963, 3963, 3963, 20347, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 4875, 4875, 21259, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 1403, 5499, 5499, 5499, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 2979, 2979, 19363, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 2299, 2299, 10491, 26875, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 1163, 5259, 13451, 29835, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 507, 507, 16891, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 3091, 7187, 7187, 23571, 0, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 3067, 7163, 7163, 7163, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 187, 4283, 12475, 12475, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 3899, 12091, 28475, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 3779, 3779, 3779, 20163, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 1083, 1083, 9275, 25659, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 6219, 14411, 14411, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 5307, 13499, 29883, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 2739, 2739, 2739, 2739, 0, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 699, 4795, 4795, 4795, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 2539, 2539, 10731, 27115, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 395, 395, 8587, 24971, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 1939, 1939, 10131, 10131, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 3979, 8075, 16267, 32651, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 2675, 2675, 19059, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 3211, 3211, 3211, 3211, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 14915, 14915, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 1803, 5899, 5899, 5899, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 3635, 7731, 15923, 32307, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 1291, 5387, 13579, 13579, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 4131, 12323, 12323, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 3595, 7691, 15883, 15883, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 3755, 7851, 16043, 16043, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 2059, 6155, 6155, 22539, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 3571, 3571, 3571, 0, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 8203, 8203, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 2891, 2891, 19275, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 971, 9163, 9163, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 1099, 1099, 1099, 0, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 1995, 10187, 26571, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 259, 259, 259, 16643, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 811, 811, 811, 17195, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 291, 291, 8483, 8483, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 4139, 12331, 12331, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 275, 4371, 12563, 28947, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 2091, 2091, 18475, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 4011, 12203, 28587, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 3627, 3627, 11819, 11819, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 3315, 7411, 7411, 7411, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 555, 4651, 4651, 4651, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 3843, 7939, 7939, 24323, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 1195, 9387, 25771, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 1699, 1699, 9891, 26275, 0, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 6315, 6315, 22699, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 1363, 1363, 17747, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 2155, 2155, 10347, 10347, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 2659, 6755, 6755, 23139, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 875, 875, 9067, 9067, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 1259, 1259, 1259, 1259, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 747, 747, 8939, 25323, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 51, 51, 8243, 24627, 0, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 4075, 4075, 4075, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 3555, 7651, 7651, 7651, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 2867, 2867, 11059, 11059, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 3171, 7267, 15459, 15459, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 5939, 5939, 5939, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 3987, 8083, 8083, 24467, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 2611, 6707, 14899, 14899, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 579, 579, 579, 16963, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 1075, 1075, 9267, 9267, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 4003, 4003, 4003, 4003, 0, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 691, 4787, 12979, 29363, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 1539, 5635, 13827, 13827, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 3187, 3187, 11379, 11379, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 1235, 1235, 9427, 25811, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 3955, 8051, 8051, 8051, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 5347, 13539, 29923, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 371, 371, 371, 371, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 2307, 6403, 14595, 14595, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 1267, 1267, 9459, 25843, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 4243, 4243, 20627, 0, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 2035, 6131, 6131, 22515, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 163, 163, 163, 163, 0, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 1043, 1043, 9235, 9235, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 4931, 4931, 21315, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 1747, 1747, 1747, 18131, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 611, 611, 8803, 8803, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 1491, 5587, 13779, 30163, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 595, 4691, 12883, 12883, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 83, 4179, 4179, 4179, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 7107, 7107, 7107, 0, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 3923, 8019, 8019, 8019, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2051, 2051, 10243, 10243, 0, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 99, 99, 99, 99, 0, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 2243, 2243, 10435, 10435, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 6947, 15139, 31523, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 899, 4995, 4995, 21379, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 2595, 2595, 10787, 27171, 0, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 3491, 3491, 11683, 11683, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 643, 643, 643, 17027, 0, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 1283, 1283, 1283, 0, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 10241, 10241, 43009, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 1335, 1335, 1335, 34103, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 10241, 26625, 26625, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 4285, 4285, 20669, 53437, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 6145, 14337, 14337, 14337, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 889, 889, 889, 17273, 17273, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 6145, 14337, 30721, 63489, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 4291, 12483, 12483, 12483, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 1025, 1025, 17409, 50177, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 1947, 6043, 6043, 6043, 38811, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 5121, 5121, 5121, 37889, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 3311, 3311, 11503, 11503, 44271, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 513, 8705, 25089, 25089, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 1565, 9757, 9757, 42525, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 14849, 31233, 31233, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 45, 4141, 4141, 20525, 53293, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 1537, 5633, 5633, 22017, 54785, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 1611, 1611, 17995, 17995, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 7681, 7681, 24065, 24065, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 7077, 7077, 7077, 39845, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 2305, 10497, 10497, 10497, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 3945, 8041, 16233, 32617, 32617, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 2305, 10497, 26881, 59649, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 2707, 2707, 10899, 27283, 60051, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 14593, 14593, 47361, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 2663, 2663, 19047, 19047, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 14593, 30977, 30977, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 2477, 10669, 27053, 59821, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 1281, 9473, 25857, 58625, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 1907, 1907, 1907, 1907, 34675, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 5377, 13569, 29953, 29953, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 5069, 5069, 21453, 54221, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 7425, 7425, 40193, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 3919, 8015, 16207, 32591, 32591, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 7425, 23809, 23809, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 549, 549, 16933, 49701, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 8961, 25345, 58113, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 1203, 5299, 13491, 29875, 29875, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 4865, 21249, 54017, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 523, 523, 8715, 25099, 25099, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 2817, 2817, 2817, 2817, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 1441, 1441, 17825, 50593, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 2817, 11009, 27393, 27393, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 2365, 2365, 10557, 26941, 26941, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 6913, 15105, 31489, 64257, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 1859, 5955, 14147, 30531, 63299, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 1793, 1793, 18177, 50945, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 27, 4123, 12315, 12315, 45083, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 1793, 9985, 26369, 26369, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 4957, 13149, 29533, 29533, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 5889, 5889, 22273, 22273, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 3205, 7301, 7301, 23685, 23685, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 12033, 12033, 12033, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 4009, 8105, 8105, 8105, 40873, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 7937, 7937, 24321, 57089, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 2027, 6123, 6123, 6123, 6123, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 4225, 4225, 4225, 4225, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 837, 4933, 13125, 29509, 29509, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 4225, 12417, 28801, 28801, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 3417, 3417, 3417, 3417, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 2177, 2177, 2177, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 373, 373, 373, 16757, 49525, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 10369, 10369, 43137, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 1427, 1427, 9619, 26003, 58771, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 5249, 13441, 29825, 62593, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 3719, 3719, 11911, 28295, 61063, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 5249, 13441, 13441, 13441, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 205, 205, 8397, 8397, 8397, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 3201, 11393, 27777, 60545, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 2679, 6775, 6775, 23159, 23159, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 3201, 11393, 11393, 11393, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 1789, 5885, 14077, 30461, 63229, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 7297, 7297, 7297, 7297, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 293, 4389, 12581, 28965, 61733, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 641, 641, 641, 641, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 4053, 8149, 16341, 16341, 49109, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 4737, 4737, 21121, 21121, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 5009, 5009, 21393, 54161, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 2689, 2689, 19073, 19073, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 1697, 1697, 18081, 50849, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 6785, 23169, 55937, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 3983, 3983, 20367, 20367, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 1665, 9857, 9857, 9857, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 93, 93, 93, 93, 32861, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 5761, 5761, 22145, 54913, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 3183, 3183, 11375, 27759, 60527, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 3713, 3713, 3713, 3713, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 3509, 7605, 7605, 7605, 7605, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 7809, 7809, 7809, 40577, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 2283, 6379, 6379, 22763, 55531, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 7809, 16001, 32385, 65153, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 2727, 2727, 2727, 2727, 2727, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 4481, 4481, 4481, 37249, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 2699, 2699, 2699, 2699, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 4481, 12673, 12673, 12673, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 1421, 5517, 13709, 13709, 46477, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 6529, 6529, 6529, 6529, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 5221, 13413, 13413, 46181, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 6529, 14721, 31105, 31105, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 121, 121, 121, 121, 32889, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 1409, 9601, 25985, 58753, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 471, 471, 471, 471, 471, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 1409, 9601, 9601, 9601, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 2525, 6621, 14813, 14813, 14813, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 3457, 11649, 28033, 28033, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 7465, 15657, 32041, 32041, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 3457, 11649, 11649, 44417, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 467, 4563, 4563, 20947, 20947, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 7553, 23937, 23937, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 1649, 9841, 9841, 42609, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 897, 897, 897, 33665, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 2907, 7003, 7003, 7003, 7003, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 897, 9089, 9089, 9089, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 1309, 5405, 5405, 21789, 21789, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 4993, 13185, 13185, 45953, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 483, 483, 16867, 16867, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 2945, 19329, 52097, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 3295, 3295, 3295, 36063, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 7041, 15233, 31617, 64385, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 2791, 2791, 10983, 10983, 43751, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 1921, 10113, 10113, 42881, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 4083, 4083, 4083, 20467, 53235, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 6017, 14209, 14209, 14209, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 6477, 6477, 6477, 6477, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 3969, 12161, 12161, 12161, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 3965, 3965, 20349, 20349, 0},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 8065, 16257, 32641, 32641, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 185, 185, 8377, 8377, 41145, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 4161, 12353, 12353, 45121, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 3991, 8087, 8087, 8087, 40855, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 6209, 22593, 22593, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 1909, 1909, 1909, 10101, 10101, 42869, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 14401, 14401, 14401, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 6761, 14953, 14953, 14953, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 1089, 1089, 17473, 50241, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 4299, 12491, 12491, 45259, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 7233, 7233, 7233, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 4193, 4193, 4193, 36961, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 7233, 23617, 56385, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 1851, 5947, 14139, 30523, 63291, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 15425, 31809, 31809, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 253, 4349, 4349, 4349, 4349, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 4673, 4673, 37441, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 383, 383, 383, 16767, 49535, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 12865, 12865, 12865, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 5833, 14025, 30409, 63177, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 577, 577, 577, 577, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 5521, 5521, 21905, 54673, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 6721, 6721, 23105, 55873, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 5371, 13563, 13563, 46331, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 6721, 14913, 31297, 31297, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 3133, 7229, 15421, 31805, 31805, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 2625, 2625, 19009, 19009, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 3045, 3045, 3045, 35813, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 2625, 10817, 27201, 59969, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 1603, 9795, 26179, 58947, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 1601, 5697, 5697, 5697, 5697, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 5313, 21697, 21697, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 3649, 11841, 28225, 28225, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 4205, 4205, 20589, 20589, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 321, 4417, 12609, 12609, 12609, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 1865, 5961, 5961, 22345, 55113, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 2369, 2369, 35137, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 3599, 3599, 3599, 3599, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 10561, 10561, 10561, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 1657, 1657, 1657, 1657, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 1345, 5441, 5441, 21825, 54593, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 1691, 1691, 18075, 50843, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 7489, 7489, 40257, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 3359, 7455, 15647, 32031, 32031, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 7489, 23873, 23873, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 565, 8757, 8757, 41525, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 15681, 15681, 15681, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 2857, 6953, 15145, 31529, 64297, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 4929, 4929, 21313, 54081, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 1371, 1371, 1371, 1371, 34139, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 6977, 15169, 31553, 64321, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 3091, 7187, 15379, 15379, 48147, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 5953, 5953, 5953, 38721, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 319, 4415, 12607, 28991, 61759, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 5953, 14145, 30529, 63297, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 499, 4595, 4595, 20979, 53747, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 1857, 1857, 1857, 1857, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 1233, 1233, 1233, 34001, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 1857, 10049, 26433, 26433, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 3917, 8013, 16205, 32589, 65357, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 8001, 16193, 16193, 48961, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 3063, 7159, 15351, 31735, 31735, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 3905, 3905, 20289, 20289, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 3749, 3749, 3749, 20133, 52901, 0},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 3905, 12097, 12097, 12097, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 1721, 1721, 1721, 9913, 9913, 9913, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 13505, 29889, 62657, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 215, 215, 16599, 16599, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 1217, 1217, 17601, 50369, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 751, 4847, 4847, 21231, 21231, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 1217, 9409, 9409, 42177, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 803, 803, 8995, 25379, 25379, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 11457, 27841, 60609, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 1063, 5159, 5159, 5159, 37927, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 11457, 11457, 11457, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 2797, 6893, 6893, 6893, 39661, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 4801, 4801, 37569, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 2651, 2651, 19035, 19035, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 12993, 29377, 62145, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 3863, 7959, 16151, 32535, 65303, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 6849, 6849, 23233, 56001, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 3551, 3551, 3551, 3551, 36319, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 6849, 15041, 15041, 47809, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 4883, 13075, 13075, 45843, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 5825, 5825, 22209, 54977, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 3647, 3647, 3647, 3647, 3647, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 5825, 14017, 30401, 30401, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 1161, 5257, 13449, 29833, 62601, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 3777, 3777, 3777, 3777, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 3493, 7589, 15781, 32165, 64933, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 3777, 11969, 11969, 44737, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 3331, 7427, 7427, 7427, 7427, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 7617, 15809, 32193, 64961, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 7031, 7031, 7031, 7031, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 7617, 15809, 15809, 15809, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 1021, 9213, 25597, 58365, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 11713, 28097, 28097, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 1081, 1081, 17465, 17465, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 11713, 11713, 44481, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 2691, 6787, 6787, 23171, 55939, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 5057, 5057, 21441, 54209, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 7807, 15999, 15999, 15999, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 5057, 13249, 13249, 46017, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 2739, 2739, 10931, 27315, 27315, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 961, 961, 961, 33729, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 7179, 15371, 31755, 64523, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 8129, 16321, 16321, 49089, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 1875, 1875, 1875, 1875, 1875, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 4033, 4033, 20417, 20417, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 8945, 25329, 25329, 0},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 4033, 12225, 28609, 61377, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 2983, 2983, 2983, 19367, 19367, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 1057, 17441, 17441, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 7899, 7899, 7899, 40667, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 9249, 9249, 9249, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 919, 919, 9111, 25495, 25495, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 9249, 25633, 58401, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 1693, 1693, 18077, 50845, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 5153, 5153, 21537, 54305, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 2373, 6469, 6469, 22853, 55621, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 7201, 15393, 15393, 15393, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 14183, 30567, 63335, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 2081, 2081, 34849, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 7265, 7265, 40033, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 6177, 14369, 14369, 47137, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 2873, 2873, 2873, 2873, 35641, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 5665, 5665, 22049, 22049, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 3851, 3851, 3851, 3851, 3851, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 5665, 13857, 30241, 63009, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 1549, 1549, 9741, 9741, 42509, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 3617, 11809, 11809, 11809, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 1975, 1975, 10167, 26551, 26551, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 7713, 15905, 32289, 32289, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 6723, 23107, 55875, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 4641, 4641, 21025, 53793, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 1413, 1413, 17797, 50565, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 4641, 12833, 29217, 29217, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 6051, 6051, 6051, 38819, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 2593, 2593, 2593, 2593, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 3743, 7839, 16031, 16031, 48799, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 2593, 10785, 10785, 43553, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 1705, 5801, 5801, 22185, 54953, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 6689, 6689, 6689, 39457, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 3569, 11761, 28145, 28145, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 6689, 14881, 14881, 14881, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 2215, 2215, 2215, 34983, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 7457, 15649, 15649, 48417, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 2681, 2681, 2681, 2681, 2681, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 4385, 12577, 12577, 45345, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 1561, 1561, 1561, 1561, 1561, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 6433, 6433, 22817, 22817, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 7531, 7531, 23915, 56683, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 6433, 14625, 31009, 63777, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 1517, 1517, 9709, 9709, 42477, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 1825, 10017, 10017, 10017, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 7191, 15383, 15383, 15383, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 3873, 3873, 20257, 53025, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 757, 4853, 13045, 13045, 45813, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 3873, 12065, 28449, 28449, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 32787, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 801, 801, 801, 801, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 3391, 3391, 3391, 3391, 3391, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 801, 801, 17185, 49953, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 149, 4245, 4245, 4245, 4245, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 2849, 2849, 35617, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 7649, 7649, 24033, 56801, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 2849, 19233, 19233, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 3259, 11451, 27835, 60603, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 11041, 27425, 60193, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 1405, 9597, 25981, 25981, 0},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 6945, 6945, 6945, 6945, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 3535, 7631, 15823, 15823, 15823, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 1185, 1185, 17569, 17569, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 7679, 15871, 32255, 65023, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 5281, 5281, 21665, 54433, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 6929, 6929, 6929, 6929, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 3233, 7329, 7329, 7329, 40097, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 3429, 11621, 11621, 11621, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 3233, 7329, 15521, 31905, 64673, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 2425, 2425, 2425, 18809, 51577, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 4257, 12449, 12449, 12449, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 3875, 7971, 7971, 24355, 24355, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 2209, 2209, 18593, 18593, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 3615, 7711, 15903, 32287, 32287, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 6305, 6305, 22689, 55457, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 3953, 12145, 12145, 44913, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 6305, 14497, 14497, 47265, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 5869, 5869, 22253, 22253, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 5793, 13985, 13985, 13985, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 3299, 3299, 11491, 27875, 27875, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 7841, 16033, 32417, 32417, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 2023, 6119, 6119, 6119, 6119, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 673, 673, 673, 33441, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 917, 917, 9109, 9109, 9109, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 673, 8865, 8865, 8865, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 755, 755, 8947, 25331, 58099, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 4769, 12961, 12961, 45729, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 77, 77, 77, 16461, 49229, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 2721, 2721, 19105, 51873, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 7905, 7905, 24289, 57057, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 6817, 15009, 15009, 15009, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 259, 259, 8451, 8451, 8451, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 5537, 21921, 21921, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 3759, 7855, 7855, 24239, 57007, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 5537, 5537, 38305, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 2629, 10821, 27205, 59973, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 4513, 4513, 20897, 53665, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 2641, 2641, 19025, 19025, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 4513, 12705, 12705, 45473, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 6605, 14797, 31181, 63949, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 6049, 22433, 55201, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 6801, 6801, 23185, 55953, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 6049, 6049, 6049, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 16395, 49163, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 8097, 24481, 24481, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 655, 4751, 12943, 12943, 45711, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 929, 9121, 9121, 41889, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 6493, 6493, 22877, 22877, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 5025, 21409, 21409, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 4463, 4463, 4463, 4463, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 2977, 2977, 2977, 35745, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 1205, 1205, 1205, 1205, 33973, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 2977, 11169, 11169, 11169, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 6995, 15187, 15187, 15187, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 7073, 7073, 7073, 7073, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 1515, 5611, 13803, 13803, 46571, 0},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 7073, 15265, 15265, 48033, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 3949, 3949, 12141, 28525, 28525, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 5217, 13409, 29793, 29793, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 3891, 3891, 3891, 3891, 3891, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 1121, 9313, 25697, 58465, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 2701, 2701, 2701, 2701, 35469, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 15457, 15457, 15457, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 2359, 6455, 14647, 31031, 31031, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 6241, 14433, 14433, 47201, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 4649, 12841, 12841, 45609, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 2145, 2145, 2145, 34913, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 2417, 10609, 10609, 43377, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 2145, 10337, 10337, 10337, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 1575, 5671, 5671, 5671, 5671, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 5729, 13921, 30305, 63073, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 2589, 10781, 27165, 27165, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 1633, 1633, 18017, 50785, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 1477, 5573, 5573, 21957, 54725, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 7777, 7777, 7777, 7777, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 4063, 4063, 4063, 36831, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 7777, 15969, 32353, 32353, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 275, 4371, 4371, 4371, 37139, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 3681, 11873, 28257, 61025, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 3117, 7213, 7213, 7213, 7213, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 609, 8801, 25185, 57953, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 1613, 1613, 9805, 9805, 9805, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 6753, 14945, 14945, 14945, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 1783, 1783, 18167, 50935, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 2657, 2657, 2657, 2657, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 3279, 7375, 15567, 15567, 15567, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 13665, 30049, 62817, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 925, 5021, 5021, 21405, 54173, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 1377, 9569, 9569, 42337, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 601, 601, 601, 16985, 49753, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 1377, 9569, 25953, 25953, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 1379, 5475, 13667, 13667, 46435, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 4449, 4449, 4449, 4449, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 5055, 13247, 13247, 13247, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 4449, 12641, 12641, 45409, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 3849, 7945, 7945, 24329, 24329, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 5985, 5985, 5985, 5985, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 7295, 15487, 15487, 15487, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 5985, 14177, 30561, 30561, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 2227, 2227, 18611, 18611, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 1889, 1889, 1889, 34657, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 7313, 23697, 56465, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 1889, 10081, 26465, 59233, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 4877, 13069, 13069, 45837, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 8033, 16225, 32609, 65377, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 1341, 1341, 9533, 9533, 42301, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 3937, 3937, 20321, 53089, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 741, 4837, 4837, 4837, 4837, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 865, 865, 865, 865, 865, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 3951, 3951, 12143, 28527, 61295, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 7009, 7009, 7009, 7009, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 3999, 8095, 16287, 16287, 49055, 0},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 7009, 7009, 23393, 56161, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 693, 8885, 25269, 58037, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 7393, 7393, 23777, 23777, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 3935, 3935, 3935, 20319, 20319, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 4321, 4321, 4321, 37089, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 3861, 3861, 12053, 12053, 44821, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 2273, 2273, 18657, 18657, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 7247, 15439, 31823, 31823, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 2273, 10465, 10465, 10465, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 6019, 14211, 30595, 63363, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 5857, 5857, 5857, 38625, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 981, 5077, 13269, 29653, 29653, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 1761, 18145, 50913, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 8081, 8081, 24465, 57233, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 1761, 1761, 1761, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 4363, 4363, 37131, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 9953, 9953, 42721, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 16397, 16397, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 7905, 7905, 7905, 7905, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 1787, 1787, 5883, 5883, 5883, 5883, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 4833, 4833, 4833, 4833, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 795, 795, 795, 17179, 17179, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 4833, 13025, 29409, 29409, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 599, 8791, 8791, 41559, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 2785, 2785, 10977, 10977, 43745, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 2669, 6765, 14957, 31341, 31341, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 5601, 5601, 21985, 21985, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 3327, 7423, 15615, 31999, 64767, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 5601, 5601, 5601, 38369, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 2645, 10837, 10837, 43605, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 5601, 13793, 30177, 62945, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 3401, 7497, 7497, 23881, 23881, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 9697, 26081, 26081, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 711, 4807, 12999, 12999, 45767, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 6625, 14817, 31201, 63969, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 297, 4393, 12585, 28969, 28969, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 2529, 2529, 2529, 2529, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 875, 875, 875, 17259, 17259, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 6113, 6113, 6113, 6113, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 1883, 1883, 10075, 10075, 10075, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 6113, 14305, 30689, 30689, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 535, 535, 535, 16919, 16919, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 2017, 2017, 2017, 34785, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 1733, 1733, 9925, 26309, 59077, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 2017, 10209, 26593, 59361, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 217, 8409, 8409, 41177, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 4065, 4065, 20449, 53217, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 6833, 15025, 15025, 15025, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 4065, 12257, 12257, 45025, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 3885, 12077, 28461, 61229, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 5089, 13281, 13281, 13281, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 1011, 1011, 5107, 13299, 29683, 62451, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 993, 9185, 25569, 25569, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 3335, 3335, 19719, 52487, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 7137, 7137, 7137, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 699, 4795, 12987, 29371, 29371, 0},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 15329, 31713, 31713, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 2551, 6647, 14839, 31223, 63991, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 4369, 12561, 12561, 45329, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 2967, 7063, 7063, 7063, 39831, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 6417, 6417, 22801, 22801, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 4981, 13173, 29557, 62325, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 10513, 26897, 26897, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 2221, 2221, 10413, 10413, 43181, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 5393, 5393, 5393, 38161, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 2751, 2751, 2751, 19135, 51903, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 5393, 13585, 29969, 62737, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 627, 4723, 4723, 21107, 53875, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 1297, 9489, 25873, 25873, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 4813, 4813, 4813, 37581, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 3345, 11537, 27921, 60689, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 4483, 4483, 4483, 37251, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 4881, 4881, 4881, 37649, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 1407, 1407, 1407, 17791, 50559, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 4881, 4881, 21265, 21265, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 3541, 3541, 3541, 3541, 36309, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 785, 785, 17169, 49937, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 1803, 5899, 14091, 30475, 30475, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 785, 8977, 8977, 41745, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 2887, 2887, 11079, 27463, 60231, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 6929, 6929, 23313, 56081, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 251, 4347, 12539, 28923, 61691, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 2833, 2833, 19217, 19217, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 8165, 8165, 24549, 57317, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 8209, 24593, 24593, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 1933, 1933, 1933, 1933, 1933, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 6161, 6161, 22545, 55313, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 1915, 6011, 6011, 22395, 55163, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 2065, 10257, 10257, 10257, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 633, 4729, 4729, 4729, 4729, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 5137, 5137, 21521, 54289, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 667, 667, 667, 667, 33435, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 5137, 13329, 29713, 29713, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 3037, 3037, 3037, 35805, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 1041, 9233, 25617, 58385, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 2083, 10275, 10275, 10275, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 7185, 15377, 31761, 64529, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 3027, 3027, 3027, 3027, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 1553, 5649, 13841, 13841, 13841, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 905, 905, 9097, 9097, 9097, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 1553, 1553, 9745, 9745, 42513, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 2823, 2823, 19207, 19207, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 1553, 1553, 9745, 26129, 26129, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 2893, 2893, 11085, 11085, 43853, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 15889, 15889, 48657, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 4087, 8183, 16375, 32759, 32759, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 15889, 32273, 32273, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 7549, 15741, 32125, 64893, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 3601, 3601, 3601, 36369, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 1487, 1487, 1487, 17871, 50639, 0},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 3601, 11793, 11793, 11793, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 697, 4793, 12985, 12985, 12985, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 5521, 5521, 5521, 5521, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 3483, 3483, 3483, 19867, 19867, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 1425, 1425, 17809, 17809, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 1775, 5871, 5871, 22255, 22255, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 1425, 1425, 1425, 34193, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 5893, 14085, 14085, 14085, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 7569, 7569, 23953, 23953, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 1567, 1567, 1567, 34335, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 3473, 3473, 3473, 3473, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 2667, 2667, 10859, 27243, 27243, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 5009, 13201, 29585, 29585, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 2839, 6935, 15127, 31511, 64279, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 913, 913, 17297, 17297, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 2351, 6447, 6447, 6447, 39215, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 913, 9105, 25489, 58257, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 7641, 15833, 32217, 64985, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 2961, 7057, 7057, 7057, 39825, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 2549, 6645, 6645, 6645, 6645, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 2961, 7057, 15249, 15249, 15249, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 1811, 5907, 14099, 30483, 63251, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 2961, 2961, 11153, 11153, 43921, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 557, 557, 8749, 25133, 25133, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 6033, 6033, 6033, 38801, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 2965, 7061, 15253, 15253, 48021, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 1937, 1937, 1937, 1937, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 3147, 7243, 7243, 7243, 40011, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 1937, 10129, 26513, 26513, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 5127, 13319, 29703, 29703, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 8081, 16273, 16273, 49041, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 3709, 3709, 3709, 3709, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 3985, 3985, 20369, 20369, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 2767, 6863, 15055, 15055, 15055, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 3985, 12177, 12177, 12177, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 2307, 6403, 6403, 22787, 22787, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 2193, 10385, 26769, 26769, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 103, 4199, 12391, 12391, 12391, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 2193, 10385, 10385, 43153, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 2989, 7085, 7085, 23469, 23469, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 1169, 17553, 50321, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 4689, 4689, 21073, 21073, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 1169, 1169, 1169, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 3019, 7115, 15307, 15307, 15307, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 15505, 31889, 31889, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 3959, 8055, 8055, 8055, 8055, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 3217, 3217, 3217, 35985, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 37, 4133, 12325, 28709, 61477, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 3217, 11409, 27793, 60561, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 57, 4153, 4153, 20537, 20537, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 657, 8849, 8849, 41617, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 3341, 3341, 19725, 52493, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 1681, 9873, 9873, 9873, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 163, 163, 8355, 24739, 57507, 0},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 3729, 3729, 3729, 3729, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 3563, 3563, 3563, 19947, 52715, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 337, 337, 8529, 24913, 24913, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 1609, 1609, 1609, 34377, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 337, 4433, 12625, 29009, 61777, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 1479, 5575, 13767, 30151, 30151, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 6481, 22865, 55633, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 2831, 2831, 2831, 2831, 2831, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 6481, 6481, 6481, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 869, 4965, 4965, 21349, 54117, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 9553, 25937, 58705, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 2775, 6871, 15063, 15063, 15063, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 9553, 9553, 9553, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 7901, 7901, 7901, 40669, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 5457, 13649, 30033, 30033, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 2841, 6937, 6937, 23321, 23321, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 5457, 13649, 13649, 46417, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 2339, 6435, 14627, 14627, 14627, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 849, 849, 849, 33617, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 91, 4187, 4187, 4187, 36955, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 4945, 4945, 21329, 54097, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 1839, 10031, 26415, 26415, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 2897, 11089, 11089, 43857, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 2323, 2323, 10515, 26899, 59667, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 6993, 6993, 23377, 23377, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 8625, 8625, 8625, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 1873, 10065, 26449, 26449, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 1673, 1673, 9865, 26249, 26249, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 5969, 5969, 22353, 22353, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 5585, 5585, 5585, 38353, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 3921, 12113, 12113, 12113, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 2173, 2173, 10365, 26749, 59517, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 8017, 16209, 32593, 32593, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 6073, 14265, 30649, 30649, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 81, 81, 81, 32849, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 2011, 6107, 14299, 14299, 47067, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 4177, 4177, 20561, 53329, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 6319, 6319, 22703, 55471, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 593, 8785, 8785, 41553, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 179, 4275, 12467, 12467, 12467, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 2641, 2641, 2641, 35409, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 507, 8699, 8699, 41467, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 2641, 10833, 27217, 59985, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 3767, 7863, 7863, 24247, 57015, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 5713, 5713, 5713, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 2181, 2181, 2181, 2181, 2181, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 13905, 30289, 30289, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 6809, 15001, 31385, 64153, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 13905, 13905, 46673, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 7843, 16035, 32419, 65187, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 3665, 3665, 20049, 52817, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 1951, 1951, 1951, 18335, 18335, 0},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 15953, 32337, 65105, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 423, 4519, 12711, 12711, 12711, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 4561, 12753, 29137, 29137, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 611, 611, 611, 16995, 49763, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 2513, 10705, 27089, 27089, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 403, 8595, 8595, 41363, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 6609, 6609, 22993, 22993, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 3883, 7979, 7979, 7979, 7979, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 6609, 14801, 31185, 63953, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 3757, 3757, 20141, 20141, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 1489, 1489, 1489, 1489, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 1215, 5311, 13503, 13503, 13503, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 1489, 1489, 17873, 50641, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 5909, 14101, 14101, 14101, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 1489, 9681, 9681, 42449, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 1033, 1033, 1033, 1033, 33801, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 7633, 7633, 24017, 56785, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 1317, 1317, 9509, 9509, 42277, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 977, 977, 977, 977, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 2943, 7039, 15231, 15231, 15231, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 5073, 13265, 13265, 13265, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 5447, 5447, 5447, 38215, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 3025, 11217, 11217, 11217, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 439, 8631, 25015, 57783, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 6097, 6097, 22481, 55249, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 7045, 15237, 15237, 15237, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 6097, 14289, 14289, 47057, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 6553, 14745, 14745, 14745, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 8145, 8145, 24529, 24529, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 3307, 7403, 7403, 7403, 40171, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 8145, 16337, 32721, 65489, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 621, 621, 8813, 25197, 57965, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 209, 209, 8401, 24785, 24785, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 2099, 6195, 14387, 30771, 30771, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 2257, 10449, 26833, 59601, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 6077, 14269, 30653, 30653, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 6353, 6353, 6353, 6353, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 1039, 5135, 13327, 29711, 62479, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 6353, 14545, 30929, 30929, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 7107, 15299, 31683, 31683, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 1233, 1233, 17617, 17617, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 1179, 3227, 7323, 7323, 7323, 7323, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 1233, 9425, 25809, 58577, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 3549, 3549, 11741, 28125, 28125, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 5329, 5329, 5329, 5329, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 2031, 6127, 6127, 22511, 22511, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 3281, 3281, 19665, 52433, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 53, 4149, 4149, 4149, 36917, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 4817, 21201, 53969, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 7877, 16069, 32453, 32453, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 13009, 13009, 45777, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 2265, 6361, 14553, 14553, 47321, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 2769, 2769, 2769, 2769, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 2271, 2271, 2271, 35039, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 2769, 10961, 10961, 43729, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 2537, 2537, 2537, 35305, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 5841, 22225, 22225, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 3403, 3403, 19787, 52555, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 3793, 11985, 11985, 11985, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 503, 503, 503, 503, 503, 0},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 7889, 7889, 24273, 57041, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 3237, 7333, 15525, 31909, 64677, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 7473, 7473, 23857, 23857, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 3383, 7479, 15671, 32055, 32055, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 11569, 27953, 27953, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 5903, 14095, 30479, 63247, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 305, 8497, 8497, 41265, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 3333, 7429, 7429, 7429, 40197, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 6449, 14641, 31025, 31025, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 1055, 1055, 1055, 1055, 1055, 33823, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 6449, 6449, 6449, 6449, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 1747, 1747, 9939, 9939, 9939, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 14129, 14129, 14129, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 3163, 3163, 11355, 11355, 44123, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 5937, 5937, 38705, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 3613, 7709, 15901, 15901, 15901, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 1841, 10033, 26417, 26417, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 6959, 6959, 6959, 39727, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 7985, 7985, 24369, 57137, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 1769, 1769, 18153, 18153, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 3889, 12081, 28465, 61233, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 3505, 11697, 11697, 11697, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 3889, 12081, 12081, 12081, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 2987, 2987, 2987, 19371, 19371, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 3889, 3889, 20273, 20273, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 3559, 3559, 11751, 28135, 28135, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 4913, 4913, 4913, 4913, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 2291, 6387, 14579, 14579, 47347, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 817, 817, 17201, 17201, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 1543, 5639, 13831, 30215, 62983, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 2865, 19249, 52017, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 7097, 15289, 31673, 31673, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 2865, 2865, 2865, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 6915, 15107, 31491, 31491, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 5169, 5169, 21553, 21553, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 1687, 9879, 9879, 9879, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 7217, 15409, 31793, 31793, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 5215, 13407, 13407, 46175, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 7217, 15409, 15409, 48177, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 2677, 2677, 10869, 27253, 27253, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 3121, 11313, 27697, 60465, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 3121, 11313, 11313, 11313, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 3115, 3115, 11307, 27691, 60459, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 49, 16433, 16433, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 2439, 2439, 10631, 10631, 10631, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 6193, 22577, 22577, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 3447, 7543, 7543, 7543, 40311, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 6193, 6193, 38961, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 3581, 7677, 7677, 7677, 40445, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 2097, 10289, 10289, 43057, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 2597, 6693, 6693, 23077, 23077, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 2097, 2097, 18481, 51249, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 2617, 6713, 6713, 23097, 55865, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 3633, 3633, 11825, 28209, 28209, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 2191, 2191, 2191, 18575, 18575, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 4657, 21041, 21041, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 6487, 6487, 6487, 39255, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 4657, 4657, 37425, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 2909, 11101, 27485, 60253, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 6705, 14897, 14897, 47665, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 1717, 5813, 14005, 14005, 46773, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 2609, 2609, 18993, 18993, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 3495, 3495, 3495, 19879, 52647, 0},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 2609, 2609, 2609, 35377, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 3437, 7533, 7533, 23917, 56685, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 13745, 30129, 62897, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 1243, 1243, 17627, 17627, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 5553, 21937, 21937, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 1181, 5277, 13469, 29853, 29853, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 7601, 15793, 15793, 48561, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 2911, 2911, 2911, 19295, 19295, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 12721, 12721, 45489, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 2239, 2239, 18623, 51391, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 8625, 25009, 57777, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 1739, 5835, 5835, 22219, 22219, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 433, 16817, 16817, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 6349, 14541, 14541, 47309, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 6577, 6577, 6577, 39345, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 631, 631, 8823, 8823, 41591, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 2481, 10673, 10673, 43441, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 2127, 6223, 14415, 30799, 30799, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 2481, 2481, 2481, 2481, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 2361, 6457, 6457, 6457, 6457, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 6065, 6065, 6065, 6065, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 2249, 2249, 10441, 26825, 26825, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 1969, 1969, 1969, 34737, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 2375, 2375, 10567, 26951, 26951, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 4017, 4017, 20401, 53169, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 67, 67, 67, 67, 32835, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 7089, 15281, 15281, 48049, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 1183, 1183, 17567, 17567, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 7089, 15281, 31665, 31665, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 1461, 1461, 1461, 34229, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 5297, 5297, 5297, 5297, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 2377, 2377, 2377, 18761, 18761, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 1201, 1201, 17585, 17585, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 3469, 3469, 11661, 11661, 11661, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 7345, 15537, 31921, 64689, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 1403, 5499, 13691, 30075, 30075, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 7345, 7345, 7345, 40113, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 567, 567, 16951, 16951, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 4273, 12465, 28849, 61617, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 155, 155, 8347, 8347, 8347, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 4273, 4273, 4273, 37041, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 2519, 6615, 14807, 31191, 63959, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 177, 8369, 24753, 24753, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 3589, 11781, 11781, 44549, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 177, 177, 177, 177, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 1049, 5145, 5145, 5145, 37913, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 6321, 14513, 30897, 30897, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 3125, 7221, 7221, 23605, 23605, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 2225, 2225, 18609, 18609, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 6125, 6125, 6125, 6125, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 5809, 5809, 38577, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 1559, 1559, 1559, 17943, 17943, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 5809, 22193, 22193, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 3357, 3357, 3357, 19741, 52509, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 1713, 9905, 9905, 42673, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 1071, 1071, 9263, 25647, 25647, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 7857, 7857, 24241, 57009, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 2579, 6675, 6675, 23059, 55827, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 3761, 3761, 3761, 36529, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 743, 4839, 4839, 21223, 21223, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 3761, 3761, 20145, 20145, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 6957, 15149, 15149, 47917, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 4785, 12977, 12977, 45745, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 1855, 5951, 14143, 30527, 63295, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 689, 8881, 25265, 58033, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 331, 4427, 12619, 29003, 61771, 0},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 2737, 2737, 19121, 51889, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 1027, 5123, 13315, 29699, 29699, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 1393, 9585, 25969, 25969, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 6875, 6875, 23259, 56027, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 5489, 13681, 13681, 13681, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 1455, 1455, 9647, 9647, 9647, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 3441, 11633, 11633, 11633, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 1375, 5471, 13663, 13663, 46431, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 3441, 3441, 3441, 36209, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 617, 617, 8809, 8809, 8809, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 369, 8561, 24945, 57713, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 3349, 7445, 7445, 7445, 40213, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 369, 369, 16753, 16753, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 3699, 3699, 11891, 28275, 61043, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 4465, 12657, 29041, 29041, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 2251, 2251, 2251, 18635, 51403, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 4465, 4465, 20849, 53617, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 7885, 7885, 24269, 24269, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 6513, 6513, 22897, 22897, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 3459, 11651, 11651, 44419, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 1905, 10097, 26481, 59249, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 469, 469, 16853, 16853, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 6001, 6001, 22385, 55153, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 525, 4621, 12813, 29197, 61965, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 8049, 16241, 32625, 65393, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 997, 5093, 5093, 5093, 5093, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 881, 881, 881, 881, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 6231, 6231, 22615, 55383, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 881, 881, 17265, 50033, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 3677, 7773, 15965, 32349, 65117, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 4977, 4977, 4977, 37745, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 921, 5017, 13209, 13209, 45977, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 2929, 2929, 2929, 35697, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 681, 681, 681, 17065, 49833, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 2929, 2929, 19313, 19313, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 83, 4179, 12371, 28755, 28755, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 7025, 15217, 15217, 47985, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 6641, 14833, 31217, 31217, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 13425, 29809, 29809, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 3211, 3211, 11403, 27787, 60555, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 5233, 5233, 5233, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 2247, 2247, 18631, 51399, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 3185, 3185, 19569, 52337, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 3517, 7613, 7613, 23997, 23997, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 7281, 23665, 23665, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 2499, 6595, 6595, 22979, 22979, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 113, 113, 113, 113, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 2007, 2007, 2007, 2007, 34775, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 4209, 12401, 12401, 12401, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 5615, 5615, 21999, 21999, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 4209, 4209, 4209, 36977, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 537, 4633, 4633, 4633, 4633, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 4209, 4209, 20593, 20593, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 1059, 5155, 5155, 5155, 5155, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 2161, 10353, 26737, 59505, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 6709, 14901, 14901, 14901, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 2161, 2161, 2161, 34929, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 809, 9001, 25385, 58153, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 6257, 14449, 30833, 30833, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 2411, 6507, 6507, 6507, 39275, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 1649, 9841, 26225, 26225, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 3419, 7515, 15707, 32091, 64859, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 625, 625, 625, 33393, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 3977, 3977, 12169, 12169, 12169, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 2673, 2673, 19057, 51825, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 381, 4477, 12669, 12669, 12669, 0},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 6769, 6769, 23153, 23153, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 2563, 2563, 10755, 27139, 27139, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 7665, 7665, 7665, 40433, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 1731, 5827, 5827, 22211, 22211, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 4593, 4593, 4593, 37361, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 6947, 6947, 6947, 6947, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 6641, 6641, 23025, 55793, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 3111, 3111, 11303, 27687, 27687, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 6129, 6129, 22513, 22513, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 473, 4569, 12761, 29145, 61913, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 6129, 6129, 6129, 38897, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 2275, 2275, 10467, 10467, 10467, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 4081, 20465, 20465, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 233, 233, 233, 16617, 49385, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 8177, 8177, 8177, 8177, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 3629, 11821, 11821, 44589, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 9201, 25585, 58353, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 1599, 5695, 13887, 30271, 63039, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 9201, 9201, 9201, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 6037, 14229, 30613, 30613, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 1009, 1009, 33777, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 1779, 1779, 9971, 9971, 42739, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 5105, 5105, 5105, 5105, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 1101, 5197, 5197, 5197, 37965, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 3057, 11249, 11249, 44017, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 1979, 1979, 10171, 26555, 26555, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 3057, 3057, 19441, 52209, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 3319, 7415, 15607, 15607, 48375, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 7153, 15345, 31729, 64497, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 1743, 1743, 1743, 18127, 50895, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 5361, 13553, 29937, 62705, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 6831, 6831, 23215, 55983, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 3313, 3313, 19697, 19697, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 361, 361, 8553, 24937, 57705, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 3313, 3313, 3313, 36081, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 3219, 3219, 3219, 35987, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 7409, 7409, 23793, 56561, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 3175, 3175, 3175, 19559, 52327, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 7409, 7409, 7409, 7409, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 1965, 6061, 6061, 6061, 38829, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 4337, 12529, 12529, 45297, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 1995, 1995, 1995, 1995, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 10481, 10481, 43249, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 59, 59, 16443, 16443, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 2289, 2289, 2289, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 3069, 7165, 15357, 31741, 31741, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 6385, 14577, 30961, 63729, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 6479, 14671, 31055, 31055, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 6385, 14577, 14577, 14577, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 3109, 7205, 15397, 15397, 15397, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 1777, 9969, 26353, 59121, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 1663, 1663, 1663, 18047, 50815, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 5873, 22257, 55025, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 2119, 2119, 10311, 10311, 10311, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 5873, 5873, 5873, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 269, 269, 269, 269, 269, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 7921, 7921, 24305, 24305, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 3321, 7417, 15609, 31993, 31993, 0},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 7921, 7921, 7921, 40689, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 323, 4419, 4419, 4419, 37187, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 4681, 12873, 29257, 62025, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 3741, 3741, 11933, 28317, 28317, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 585, 8777, 25161, 25161, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 3171, 3171, 11363, 11363, 11363, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 6729, 6729, 23113, 55881, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 885, 885, 17269, 50037, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 2633, 10825, 27209, 59977, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 2221, 6317, 6317, 6317, 39085, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 3657, 3657, 3657, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 2639, 2639, 2639, 2639, 35407, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 4169, 12361, 28745, 61513, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 435, 4531, 4531, 20915, 53683, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 73, 8265, 8265, 41033, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 2887, 6983, 6983, 6983, 6983, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 2121, 6217, 14409, 14409, 47177, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 4023, 12215, 28599, 28599, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 2121, 2121, 2121, 18505, 18505, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 4069, 12261, 28645, 61413, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 2121, 2121, 10313, 10313, 10313, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 1017, 1017, 1017, 33785, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 1097, 5193, 5193, 21577, 54345, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 5403, 5403, 21787, 21787, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 3145, 7241, 7241, 7241, 40009, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 5791, 13983, 13983, 46751, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 4937, 4937, 4937, 37705, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 1109, 1109, 9301, 25685, 25685, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 4937, 13129, 29513, 62281, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 841, 9033, 25417, 25417, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 1223, 1223, 1223, 17607, 50375, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 1865, 1865, 1865, 18249, 18249, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 6639, 6639, 23023, 23023, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 3913, 8009, 8009, 24393, 24393, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 2335, 2335, 2335, 2335, 35103, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 3913, 8009, 16201, 32585, 65353, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 3881, 7977, 7977, 24361, 57129, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 1865, 3913, 3913, 12105, 28489, 28489, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 7975, 7975, 24359, 24359, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 4425, 4425, 4425, 37193, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 347, 347, 4443, 12635, 12635, 12635, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 329, 329, 329, 329, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 2245, 2245, 10437, 10437, 10437, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 2377, 6473, 14665, 31049, 31049, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 4073, 8169, 16361, 16361, 16361, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 1353, 5449, 5449, 5449, 5449, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 2197, 6293, 14485, 14485, 47253, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 1353, 5449, 13641, 13641, 46409, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 1523, 1523, 9715, 26099, 26099, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 3401, 7497, 7497, 7497, 40265, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 1211, 9403, 25787, 25787, 0},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 1353, 3401, 3401, 11593, 27977, 27977, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 697, 697, 697, 697, 697, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 713, 8905, 8905, 8905, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 3979, 3979, 12171, 28555, 61323, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 2761, 6857, 15049, 15049, 15049, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 2171, 2171, 10363, 26747, 59515, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 2761, 2761, 10953, 10953, 43721, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 1381, 1381, 1381, 1381, 34149, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 1737, 9929, 26313, 26313, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 1775, 1775, 9967, 9967, 42735, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 1737, 1737, 18121, 50889, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 3353, 3353, 11545, 27929, 60697, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 1737, 1737, 1737, 1737, 1737, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 1827, 5923, 5923, 22307, 55075, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 3785, 7881, 7881, 24265, 57033, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 3113, 7209, 7209, 7209, 7209, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 1737, 3785, 3785, 3785, 20169, 20169, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 39, 8231, 24615, 24615, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 4297, 4297, 20681, 53449, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 2839, 2839, 2839, 2839, 2839, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 201, 8393, 24777, 57545, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 2351, 2351, 10543, 26927, 26927, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 201, 8393, 8393, 8393, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 3013, 7109, 7109, 7109, 7109, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 2249, 6345, 14537, 14537, 14537, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 2549, 2549, 10741, 10741, 10741, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 2249, 6345, 6345, 6345, 39113, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 1811, 1811, 1811, 1811, 1811, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 1225, 5321, 5321, 5321, 38089, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 2803, 10995, 27379, 27379, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 1225, 1225, 1225, 1225, 1225, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 2125, 10317, 26701, 26701, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 7369, 15561, 15561, 48329, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 3003, 11195, 11195, 43963, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 3273, 3273, 19657, 19657, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 441, 441, 16825, 49593, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 969, 969, 9161, 25545, 58313, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 581, 581, 581, 16965, 16965, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 969, 969, 969, 17353, 17353, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 867, 867, 9059, 9059, 9059, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 3017, 7113, 15305, 31689, 64457, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 117, 4213, 12405, 28789, 61557, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 969, 3017, 7113, 7113, 7113, 39881, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 3433, 7529, 7529, 23913, 56681, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 1993, 6089, 14281, 30665, 63433, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 4629, 4629, 21013, 21013, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 1993, 1993, 10185, 26569, 26569, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 3019, 3019, 3019, 19403, 52171, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 4041, 8137, 8137, 24521, 57289, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 2045, 2045, 2045, 2045, 34813, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 457, 4553, 12745, 12745, 45513, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 2687, 2687, 2687, 19071, 51839, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 457, 457, 8649, 25033, 57801, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 2059, 2059, 2059, 18443, 18443, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 2505, 6601, 14793, 31177, 63945, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 4091, 4091, 4091, 20475, 53243, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 457, 2505, 2505, 2505, 2505, 2505, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 249, 249, 249, 16633, 16633, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 3529, 7625, 15817, 15817, 48585, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 2463, 2463, 2463, 18847, 18847, 0},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 3529, 7625, 7625, 7625, 7625, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 3497, 7593, 15785, 15785, 15785, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 521, 4617, 4617, 4617, 37385, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 3071, 3071, 3071, 3071, 3071, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 521, 4617, 12809, 29193, 61961, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 1843, 1843, 1843, 34611, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 6665, 14857, 31241, 31241, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 1213, 5309, 13501, 13501, 46269, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 2569, 10761, 10761, 10761, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 1913, 10105, 26489, 26489, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 2569, 2569, 10761, 27145, 59913, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 1219, 1219, 1219, 1219, 33987, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 5641, 13833, 13833, 46601, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 2775, 2775, 2775, 19159, 51927, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 1545, 1545, 1545, 34313, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 6383, 6383, 22767, 22767, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 4105, 12297, 28681, 61449, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 541, 541, 541, 16925, 49693, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8201, 8201, 40969, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 3033, 3033, 19417, 19417, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 8201, 24585, 24585, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 6883, 15075, 31459, 64227, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 2057, 2057, 2057, 18441, 18441, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 1963, 1963, 1963, 1963, 34731, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 1033, 5129, 5129, 21513, 54281, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 3477, 11669, 28053, 60821, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 3081, 7177, 7177, 23561, 23561, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 5563, 13755, 13755, 13755, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 1033, 3081, 3081, 11273, 27657, 27657, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 1795, 5891, 14083, 14083, 46851, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 777, 777, 777, 777, 777, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 1093, 1093, 9285, 9285, 9285, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 2825, 6921, 6921, 23305, 56073, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 2143, 6239, 14431, 14431, 47199, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 2825, 6921, 15113, 31497, 31497, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 2921, 7017, 7017, 23401, 23401, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 2825, 2825, 11017, 27401, 60169, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 3687, 7783, 15975, 15975, 48743, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 1801, 1801, 1801, 1801, 34569, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 1483, 1483, 5579, 5579, 21963, 21963, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 1801, 1801, 9993, 9993, 9993, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 1997, 6093, 14285, 14285, 47053, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 3849, 3849, 3849, 20233, 53001, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 2895, 2895, 2895, 2895, 35663, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 3849, 3849, 12041, 28425, 28425, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 1593, 1593, 9785, 26169, 58937, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 265, 4361, 4361, 4361, 37129, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 2261, 2261, 10453, 26837, 59605, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 265, 265, 8457, 24841, 24841, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 6727, 6727, 23111, 23111, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 265, 2313, 2313, 10505, 10505, 10505, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 835, 835, 17219, 17219, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 1289, 5385, 13577, 13577, 46345, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 5981, 5981, 5981, 5981, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 3337, 7433, 7433, 7433, 40201, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 2741, 2741, 19125, 19125, 0},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 3337, 3337, 3337, 3337, 3337, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 1003, 1003, 9195, 9195, 41963, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 649, 4745, 12937, 12937, 45705, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 2267, 2267, 2267, 35035, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 649, 649, 8841, 8841, 8841, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 1861, 5957, 5957, 5957, 5957, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 6793, 14985, 31369, 64137, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 1887, 1887, 18271, 18271, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 2697, 2697, 2697, 2697, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 7853, 16045, 32429, 32429, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 1673, 1673, 1673, 18057, 50825, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 647, 2695, 6791, 6791, 6791, 6791, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 7817, 7817, 7817, 7817, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 765, 4861, 4861, 4861, 37629, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 3721, 11913, 11913, 11913, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 1317, 5413, 5413, 5413, 38181, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 1673, 3721, 3721, 3721, 3721, 36489, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 3971, 8067, 16259, 32643, 32643, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 137, 4233, 12425, 28809, 28809, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 2943, 2943, 2943, 19327, 52095, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 137, 137, 137, 16521, 16521, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 1351, 9543, 25927, 25927, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 2185, 6281, 6281, 6281, 39049, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 7741, 15933, 32317, 65085, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 3209, 7305, 7305, 23689, 56457, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 2217, 6313, 14505, 30889, 30889, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 3209, 3209, 3209, 19593, 19593, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 7847, 16039, 32423, 65191, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 7049, 7049, 7049, 39817, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 3639, 3639, 3639, 20023, 20023, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 2953, 11145, 11145, 43913, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 1039, 1039, 1039, 1039, 1039, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 2953, 2953, 2953, 2953, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 1145, 1145, 9337, 9337, 42105, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 1929, 1929, 1929, 1929, 1929, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 2073, 2073, 10265, 10265, 43033, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 3977, 8073, 16265, 16265, 49033, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 1823, 5919, 14111, 30495, 30495, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 393, 4489, 12681, 29065, 29065, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 3931, 3931, 12123, 12123, 44891, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 393, 2441, 6537, 14729, 31113, 63881, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 3317, 7413, 15605, 31989, 31989, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 1417, 5513, 13705, 30089, 62857, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 3733, 7829, 7829, 24213, 56981, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 1417, 1417, 9609, 25993, 25993, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 7499, 15691, 15691, 15691, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 7561, 7561, 23945, 56713, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 2941, 2941, 11133, 11133, 11133, 0},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 3465, 11657, 11657, 11657, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 3023, 3023, 19407, 52175, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 3689, 3689, 3689, 3689, 36457, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 2503, 6599, 14791, 31175, 31175, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 3689, 3689, 3689, 20073, 20073, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 3725, 3725, 11917, 28301, 61069, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 1641, 5737, 5737, 22121, 22121, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 6333, 14525, 30909, 30909, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 2665, 6761, 14953, 31337, 64105, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 3995, 8091, 8091, 8091, 8091, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 617, 617, 617, 617, 617, 33385, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 551, 551, 8743, 25127, 57895, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 3177, 3177, 3177, 19561, 19561, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 1763, 1763, 1763, 18147, 50915, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 1129, 5225, 13417, 13417, 13417, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 3039, 7135, 15327, 31711, 31711, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 1129, 5225, 5225, 5225, 37993, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 5865, 14057, 30441, 30441, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 1129, 5225, 5225, 21609, 21609, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 1299, 1299, 9491, 9491, 9491, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 2153, 6249, 14441, 30825, 63593, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 405, 8597, 8597, 8597, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 105, 105, 8297, 24681, 57449, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 933, 5029, 13221, 13221, 13221, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 3945, 8041, 8041, 24425, 57193, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 5783, 5783, 22167, 54935, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 3945, 3945, 3945, 20329, 20329, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 1625, 1625, 9817, 26201, 58969, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 1897, 5993, 5993, 5993, 38761, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 659, 8851, 25235, 25235, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 1897, 1897, 1897, 1897, 18281, 51049, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 615, 615, 16999, 16999, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 2921, 7017, 15209, 31593, 64361, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 1983, 1983, 1983, 18367, 51135, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 2921, 7017, 15209, 15209, 15209, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 2069, 6165, 14357, 30741, 63509, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 873, 873, 9065, 25449, 58217, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 5967, 14159, 30543, 30543, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 873, 873, 873, 873, 873, 873, 33641, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 3203, 3203, 19587, 19587, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 3433, 7529, 15721, 32105, 32105, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 2175, 2175, 2175, 18559, 51327, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 3433, 3433, 3433, 3433, 36201, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 1805, 5901, 5901, 22285, 55053, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 1385, 5481, 5481, 5481, 38249, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 317, 317, 317, 16701, 49469, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 1385, 1385, 1385, 17769, 50537, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 2809, 2809, 19193, 51961, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 2409, 6505, 14697, 14697, 14697, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 2075, 6171, 14363, 14363, 14363, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 2409, 2409, 10601, 10601, 43369, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 1157, 5253, 13445, 29829, 62597, 0},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 361, 361, 361, 8553, 8553, 8553, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 8171, 8171, 8171, 40939, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 5865, 5865, 5865, 5865, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 2421, 2421, 10613, 26997, 26997, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 1769, 9961, 26345, 59113, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 3431, 7527, 15719, 32103, 32103, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 745, 745, 8937, 8937, 41705, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 899, 899, 899, 17283, 17283, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 7401, 7401, 7401, 40169, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 2005, 6101, 6101, 6101, 6101, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 3305, 11497, 11497, 44265, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 1037, 1037, 9229, 9229, 9229, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 1257, 5353, 5353, 5353, 5353, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 763, 8955, 8955, 41723, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 6377, 14569, 14569, 47337, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 2141, 2141, 10333, 10333, 10333, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 2281, 2281, 2281, 35049, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 1925, 1925, 1925, 18309, 51077, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 2281, 10473, 26857, 59625, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 1433, 1433, 1433, 1433, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 233, 4329, 4329, 20713, 20713, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 5279, 13471, 13471, 46239, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 233, 4329, 12521, 28905, 61673, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 1193, 5289, 13481, 29865, 29865, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 4073, 8169, 8169, 24553, 24553, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 3669, 3669, 3669, 20053, 52821, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 6121, 6121, 22505, 55273, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 1403, 1403, 1403, 1403, 34171, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 2025, 2025, 2025, 34793, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 6159, 14351, 30735, 63503, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 2025, 2025, 18409, 18409, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 7269, 7269, 7269, 7269, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 3049, 3049, 3049, 3049, 35817, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 3055, 7151, 7151, 23535, 23535, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 1001, 5097, 13289, 13289, 13289, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 1321, 5417, 5417, 21801, 21801, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 1001, 5097, 13289, 29673, 62441, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 2515, 6611, 6611, 22995, 55763, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 1001, 1001, 9193, 9193, 41961, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 3367, 7463, 7463, 23847, 56615, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 1001, 1001, 1001, 9193, 25577, 25577, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 2029, 10221, 10221, 10221, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 3561, 3561, 3561, 3561, 3561, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 1071, 5167, 5167, 5167, 37935, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 3561, 3561, 11753, 11753, 44521, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 1241, 1241, 1241, 1241, 34009, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 5609, 13801, 30185, 30185, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 2579, 2579, 10771, 10771, 10771, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 1513, 9705, 26089, 58857, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 2861, 2861, 2861, 35629, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 2537, 10729, 10729, 10729, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 6407, 14599, 14599, 14599, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 2537, 10729, 27113, 59881, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 333, 4429, 12621, 12621, 45389, 0},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 489, 489, 8681, 8681, 41449, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 2233, 2233, 2233, 35001, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 7721, 15913, 32297, 32297, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 2779, 10971, 10971, 10971, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 7721, 7721, 7721, 7721, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 6039, 6039, 6039, 38807, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 3625, 3625, 20009, 20009, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 99, 4195, 4195, 4195, 4195, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 1577, 1577, 1577, 1577, 1577, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 871, 871, 871, 871, 871, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 1577, 1577, 1577, 17961, 50729, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 1197, 5293, 5293, 21677, 21677, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 6697, 14889, 14889, 14889, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 1727, 1727, 1727, 18111, 50879, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 6697, 6697, 23081, 23081, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 3699, 7795, 7795, 7795, 7795, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 2601, 2601, 18985, 51753, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 3789, 11981, 28365, 28365, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 4649, 4649, 4649, 4649, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 3191, 3191, 11383, 11383, 11383, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 553, 8745, 8745, 8745, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 1615, 5711, 13903, 30287, 30287, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 553, 553, 553, 553, 33321, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 3897, 3897, 12089, 12089, 44857, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 5161, 5161, 21545, 21545, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 5181, 5181, 21565, 54333, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 1065, 1065, 1065, 1065, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 4089, 4089, 4089, 36857, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 2089, 6185, 6185, 22569, 22569, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 3677, 3677, 3677, 20061, 52829, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 2089, 2089, 10281, 10281, 43049, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 2671, 6767, 6767, 6767, 6767, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 41, 4137, 12329, 12329, 45097, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 2719, 2719, 2719, 19103, 19103, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 41, 41, 8233, 24617, 57385, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 3819, 3819, 3819, 20203, 52971, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 32809, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 3239, 7335, 15527, 31911, 31911, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 5929, 14121, 14121, 14121, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 2939, 7035, 7035, 7035, 7035, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 5929, 5929, 5929, 38697, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 3517, 3517, 11709, 28093, 28093, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 1833, 10025, 10025, 42793, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 2661, 6757, 14949, 31333, 31333, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 4905, 13097, 29481, 29481, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 5407, 13599, 29983, 29983, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 4905, 13097, 13097, 45865, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 2613, 2613, 2613, 2613, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 809, 9001, 9001, 9001, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 2411, 2411, 10603, 26987, 26987, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 7465, 7465, 23849, 56617, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 2071, 2071, 18455, 51223, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 7465, 7465, 7465, 7465, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 2845, 6941, 6941, 6941, 6941, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 1321, 3369, 3369, 3369, 3369, 36137, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 6115, 6115, 22499, 55267, 0},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 297, 297, 2345, 2345, 2345, 18729, 51497, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 1799, 1799, 1799, 18183, 18183, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 3753, 7849, 16041, 16041, 16041, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 1331, 1331, 9523, 9523, 42291, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 3753, 3753, 3753, 3753, 3753, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 907, 5003, 5003, 21387, 54155, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 1705, 1705, 1705, 18089, 18089, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 2319, 6415, 14607, 30991, 63759, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 1705, 1705, 1705, 1705, 34473, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 2405, 2405, 18789, 18789, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 6825, 6825, 6825, 6825, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 411, 411, 411, 411, 33179, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 6825, 15017, 31401, 31401, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 2263, 2263, 18647, 18647, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 6825, 15017, 15017, 47785, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 1245, 1245, 1245, 1245, 34013, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 2729, 10921, 10921, 10921, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 2851, 11043, 27427, 60195, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 681, 4777, 12969, 12969, 12969, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 2259, 2259, 18643, 51411, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 3241, 7337, 15529, 15529, 15529, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 2077, 2077, 10269, 26653, 59421, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 1193, 5289, 5289, 5289, 5289, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 1525, 1525, 9717, 26101, 58869, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 2217, 6313, 6313, 6313, 6313, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 1941, 1941, 18325, 18325, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 169, 4265, 12457, 28841, 61609, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 3319, 3319, 3319, 19703, 19703, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 169, 169, 8361, 24745, 24745, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 3513, 3513, 3513, 19897, 52665, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 169, 169, 8361, 8361, 41129, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 5379, 5379, 5379, 38147, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 4009, 8105, 8105, 24489, 24489, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 1499, 1499, 9691, 26075, 58843, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 4009, 4009, 4009, 4009, 4009, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 2735, 10927, 10927, 10927, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 1961, 10153, 26537, 59305, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 1965, 1965, 10157, 10157, 42925, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 7081, 7081, 7081, 7081, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 2495, 6591, 14783, 14783, 14783, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 2985, 11177, 11177, 11177, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 1927, 1927, 10119, 10119, 42887, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 937, 5033, 5033, 21417, 21417, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 4155, 12347, 12347, 45115, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 937, 937, 9129, 25513, 25513, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 643, 4739, 4739, 21123, 21123, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 3497, 3497, 3497, 19881, 52649, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 1035, 5131, 13323, 29707, 29707, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 3497, 3497, 11689, 11689, 44457, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 2119, 6215, 6215, 22599, 55367, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 5545, 5545, 21929, 54697, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 1019, 5115, 13307, 29691, 62459, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 1449, 1449, 17833, 17833, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 229, 4325, 4325, 4325, 4325, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 1449, 9641, 26025, 58793, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 323, 323, 8515, 24899, 24899, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 6569, 14761, 14761, 47529, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 1879, 5975, 5975, 5975, 5975, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 2473, 2473, 2473, 35241, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 1391, 1391, 9583, 25967, 58735, 0},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 2473, 10665, 27049, 59817, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 3235, 3235, 11427, 11427, 11427, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 3929, 3929, 3929, 20313, 53081, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 1365, 1365, 9557, 25941, 25941, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 3929, 8025, 8025, 24409, 24409, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 1419, 5515, 13707, 13707, 13707, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 1881, 1881, 1881, 18265, 18265, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 4731, 12923, 12923, 12923, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 2905, 2905, 11097, 11097, 11097, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 3799, 3799, 3799, 20183, 52951, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 2905, 7001, 15193, 15193, 47961, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 3865, 7961, 16153, 32537, 32537, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 857, 857, 17241, 50009, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 1845, 1845, 1845, 18229, 50997, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 4953, 4953, 21337, 21337, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 107, 107, 16491, 16491, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 4953, 13145, 13145, 13145, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 6695, 6695, 6695, 6695, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 857, 4953, 13145, 29529, 62297, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 3309, 3309, 3309, 19693, 19693, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 3417, 7513, 7513, 7513, 40281, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 815, 4911, 4911, 4911, 37679, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 1369, 1369, 9561, 25945, 58713, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 7443, 7443, 23827, 23827, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 1369, 5465, 5465, 21849, 54617, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 939, 939, 939, 17323, 50091, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 2393, 2393, 2393, 2393, 35161, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 2393, 6489, 14681, 14681, 47449, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 3591, 7687, 15879, 32263, 65031, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 2393, 6489, 14681, 31065, 31065, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 6733, 6733, 23117, 55885, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 345, 345, 8537, 24921, 24921, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 3197, 3197, 3197, 3197, 35965, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 345, 4441, 4441, 20825, 20825, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 2981, 11173, 11173, 43941, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 345, 345, 4441, 12633, 12633, 12633, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 5049, 5049, 21433, 21433, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 3673, 3673, 3673, 3673, 3673, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 987, 987, 987, 987, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 3673, 3673, 11865, 11865, 44633, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 3997, 12189, 12189, 12189, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 1625, 1625, 1625, 1625, 34393, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 629, 629, 17013, 49781, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 6745, 14937, 14937, 47705, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 973, 9165, 25549, 58317, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 601, 4697, 4697, 21081, 21081, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 3919, 3919, 3919, 3919, 36687, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 1113, 1113, 1113, 1113, 33881, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 5627, 5627, 5627, 5627, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 1113, 1113, 9305, 25689, 58457, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 2743, 10935, 10935, 10935, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 2137, 2137, 10329, 10329, 10329, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 861, 861, 17245, 17245, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 2137, 6233, 14425, 30809, 30809, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 7833, 7833, 24217, 56985, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 89, 89, 16473, 49241, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 927, 5023, 13215, 13215, 45983, 0},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 4185, 12377, 28761, 61529, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 1447, 1447, 1447, 17831, 50599, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 2009, 2009, 2009, 34777, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 1427, 5523, 5523, 5523, 5523, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 6105, 14297, 14297, 47065, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 2859, 2859, 11051, 11051, 43819, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 6105, 6105, 6105, 6105, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 685, 2733, 2733, 10925, 10925, 10925, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 7129, 15321, 15321, 48089, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 3787, 7883, 7883, 24267, 57035, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 3033, 7129, 7129, 23513, 56281, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 3719, 7815, 7815, 7815, 7815, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 985, 985, 9177, 9177, 41945, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 2363, 6459, 6459, 6459, 39227, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 985, 985, 5081, 13273, 13273, 13273, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 293, 293, 293, 16677, 49445, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 3545, 7641, 7641, 7641, 40409, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 7181, 15373, 15373, 48141, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 1497, 1497, 1497, 17881, 17881, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 1463, 5559, 5559, 5559, 5559, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 1497, 1497, 1497, 1497, 34265, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 2621, 2621, 10813, 10813, 43581, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 1497, 5593, 13785, 13785, 46553, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 3557, 7653, 7653, 24037, 56805, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 2521, 2521, 2521, 18905, 18905, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 3671, 3671, 11863, 11863, 44631, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 2521, 6617, 6617, 23001, 55769, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 3481, 7577, 7577, 7577, 7577, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 473, 473, 473, 473, 473, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 1619, 1619, 9811, 26195, 58963, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 3801, 3801, 11993, 28377, 28377, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 1621, 5717, 5717, 22101, 22101, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 3801, 7897, 7897, 7897, 40665, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 7879, 16071, 16071, 48839, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 1753, 1753, 1753, 1753, 34521, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 2615, 2615, 2615, 18999, 18999, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 1753, 1753, 5849, 5849, 5849, 5849, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 121, 4217, 12409, 12409, 45177, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 2777, 2777, 10969, 27353, 60121, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 2203, 2203, 10395, 10395, 43163, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 729, 4825, 13017, 29401, 62169, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 3947, 3947, 3947, 36715, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 1241, 3289, 7385, 7385, 23769, 23769, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 4579, 12771, 12771, 45539, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 2265, 2265, 10457, 26841, 59609, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 2709, 2709, 2709, 2709, 35477, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 217, 217, 217, 217, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 1527, 5623, 13815, 30199, 62967, 0},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 4313, 12505, 12505, 12505, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 4047, 4047, 20431, 53199, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 3865, 3865, 12057, 28441, 61209, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 3991, 3991, 12183, 28567, 28567, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 3865, 7961, 7961, 7961, 7961, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 1349, 1349, 9541, 9541, 9541, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 1817, 1817, 1817, 1817, 1817, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 1909, 1909, 6005, 6005, 6005, 38773, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 2841, 2841, 2841, 19225, 51993, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 3775, 7871, 16063, 16063, 16063, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 793, 4889, 13081, 13081, 45849, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 1411, 9603, 9603, 9603, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 3353, 7449, 15641, 32025, 32025, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 3911, 8007, 8007, 8007, 8007, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 1305, 1305, 1305, 1305, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 1275, 1275, 17659, 17659, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 5401, 13593, 13593, 13593, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 5699, 5699, 5699, 5699, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 2329, 10521, 10521, 43289, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 5725, 5725, 22109, 22109, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 281, 4377, 12569, 12569, 45337, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 109, 8301, 24685, 24685, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 3609, 3609, 3609, 19993, 19993, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 85, 4181, 12373, 12373, 12373, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 3609, 7705, 15897, 32281, 32281, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 909, 9101, 25485, 25485, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 1561, 1561, 5657, 5657, 5657, 38425, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 7695, 15887, 32271, 65039, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 2585, 2585, 2585, 18969, 51737, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 5787, 13979, 13979, 13979, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 2585, 2585, 10777, 10777, 43545, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 4055, 4055, 4055, 36823, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 2585, 6681, 14873, 14873, 14873, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 537, 4633, 12825, 29209, 29209, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 2541, 6637, 6637, 23021, 23021, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 3097, 7193, 15385, 31769, 31769, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 4067, 4067, 12259, 12259, 45027, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 1049, 1049, 1049, 1049, 1049, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 735, 735, 735, 735, 33503, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 2073, 6169, 6169, 22553, 22553, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 1867, 10059, 26443, 59211, 0},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 25, 25, 4121, 4121, 4121, 4121, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 4559, 12751, 12751, 12751, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 3993, 3993, 3993, 20377, 20377, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 3379, 7475, 7475, 23859, 56627, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 3993, 8089, 8089, 8089, 8089, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 4039, 8135, 16327, 32711, 65479, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 3993, 8089, 8089, 24473, 57241, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 141, 4237, 4237, 4237, 37005, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 6041, 14233, 30617, 63385, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 357, 4453, 4453, 20837, 53605, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 6041, 6041, 22425, 22425, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 3779, 7875, 7875, 24259, 57027, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 921, 921, 921, 17305, 17305, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 211, 4307, 12499, 12499, 45267, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 3481, 3481, 3481, 19865, 19865, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 29, 4125, 12317, 28701, 28701, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 5529, 13721, 30105, 62873, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 7595, 7595, 23979, 23979, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 2457, 10649, 10649, 43417, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 3647, 7743, 15935, 32319, 65087, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 6553, 14745, 31129, 63897, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 2123, 10315, 10315, 10315, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 409, 409, 409, 16793, 16793, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 2685, 2685, 10877, 27261, 27261, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 3737, 11929, 11929, 11929, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 7643, 7643, 7643, 40411, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 3737, 3737, 20121, 20121, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 151, 4247, 4247, 20631, 20631, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 1689, 1689, 9881, 26265, 26265, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 607, 607, 607, 16991, 16991, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 2713, 10905, 27289, 27289, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 447, 447, 16831, 49599, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 2713, 2713, 2713, 2713, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 2419, 10611, 26995, 26995, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 665, 4761, 12953, 12953, 45721, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 1061, 5157, 5157, 5157, 37925, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 665, 4761, 4761, 21145, 53913, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 5177, 13369, 29753, 29753, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 3225, 7321, 15513, 15513, 48281, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 3083, 3083, 3083, 3083, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 1177, 1177, 1177, 17561, 50329, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 1207, 5303, 5303, 21687, 21687, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 1177, 5273, 5273, 21657, 21657, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 1273, 5369, 5369, 21753, 21753, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 2201, 2201, 2201, 2201, 2201, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 1373, 1373, 9565, 9565, 42333, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 2201, 6297, 14489, 14489, 14489, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 2693, 2693, 2693, 2693, 2693, 0},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 153, 153, 8345, 24729, 57497, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 3487, 3487, 3487, 19871, 19871, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 889, 889, 9081, 9081, 9081, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 5789, 13981, 30365, 63133, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 889, 4985, 13177, 13177, 45945, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 5219, 5219, 21603, 21603, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 889, 2937, 7033, 7033, 7033, 39801, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 2347, 2347, 2347, 2347, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 1913, 10105, 10105, 42873, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 6771, 6771, 23155, 23155, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 6009, 14201, 30585, 63353, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 3207, 7303, 7303, 7303, 40071, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 6009, 14201, 14201, 14201, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 2765, 6861, 15053, 15053, 15053, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 3961, 3961, 12153, 12153, 12153, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 3325, 11517, 27901, 60669, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 377, 377, 8569, 8569, 8569, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 2483, 2483, 10675, 10675, 43443, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 1401, 1401, 1401, 1401, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 3355, 11547, 11547, 11547, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 1401, 9593, 25977, 25977, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 3159, 11351, 11351, 11351, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 1401, 9593, 9593, 42361, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 6749, 6749, 6749, 39517, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 5497, 13689, 13689, 13689, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 1955, 10147, 26531, 26531, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 3449, 7545, 15737, 32121, 32121, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 6311, 14503, 30887, 30887, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 633, 4729, 4729, 21113, 53881, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 2187, 6283, 6283, 22667, 22667, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 2681, 6777, 6777, 23161, 23161, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 3685, 11877, 11877, 11877, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 2681, 6777, 14969, 31353, 64121, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 3523, 3523, 11715, 28099, 60867, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 1657, 9849, 26233, 26233, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 989, 9181, 9181, 9181, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 5753, 5753, 5753, 38521, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 495, 495, 8687, 8687, 41455, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 1657, 5753, 13945, 30329, 63097, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 35, 8227, 8227, 40995, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 3705, 3705, 3705, 20089, 20089, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 7733, 7733, 24117, 24117, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 3705, 3705, 11897, 28281, 61049, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 979, 979, 979, 979, 33747, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 1657, 3705, 7801, 7801, 24185, 56953, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 3435, 11627, 11627, 11627, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 2169, 2169, 2169, 2169, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 3807, 7903, 16095, 32479, 32479, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 6265, 6265, 22649, 22649, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 3755, 3755, 11947, 11947, 44715, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 6265, 14457, 30841, 63609, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 2349, 6445, 14637, 14637, 14637, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 3193, 11385, 11385, 11385, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 2039, 6135, 14327, 30711, 30711, 0},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 7289, 15481, 31865, 31865, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 3587, 7683, 7683, 24067, 56835, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 5113, 5113, 5113, 5113, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 967, 967, 967, 967, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 5113, 5113, 21497, 54265, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 3213, 7309, 7309, 23693, 23693, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 3065, 3065, 3065, 19449, 52217, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 2749, 2749, 2749, 19133, 51901, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 3065, 7161, 15353, 15353, 15353, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 3343, 7439, 15631, 32015, 64783, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 2041, 2041, 2041, 18425, 51193, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 221, 4317, 4317, 20701, 53469, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 2041, 6137, 14329, 30713, 63481, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 7941, 7941, 7941, 40709, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 4089, 12281, 12281, 12281, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 3615, 3615, 3615, 3615, 36383, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 4089, 12281, 28665, 61433, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 3381, 11573, 27957, 27957, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 4089, 8185, 16377, 32761, 32761, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 619, 619, 8811, 25195, 57963, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 505, 4601, 12793, 29177, 29177, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 965, 965, 965, 965, 33733, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 505, 4601, 4601, 20985, 53753, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 3299, 7395, 7395, 7395, 40163, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 2553, 2553, 18937, 51705, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 3859, 7955, 16147, 32531, 32531, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 6649, 6649, 6649, 39417, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 2023, 2023, 10215, 26599, 59367, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 505, 2553, 6649, 6649, 23033, 23033, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 2605, 2605, 2605, 18989, 51757, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 1529, 1529, 1529, 17913, 50681, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 755, 4851, 4851, 4851, 4851, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 7673, 15865, 15865, 48633, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 4815, 13007, 13007, 13007, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 7673, 7673, 7673, 7673, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 2489, 6585, 6585, 22969, 55737, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 761, 4857, 13049, 29433, 29433, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 3759, 3759, 11951, 11951, 11951, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 6905, 6905, 23289, 23289, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 6247, 14439, 14439, 14439, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 6905, 6905, 6905, 39673, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 941, 5037, 13229, 29613, 62381, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 1785, 1785, 9977, 9977, 42745, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 2581, 2581, 18965, 51733, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 1785, 5881, 5881, 22265, 22265, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 903, 9095, 9095, 41863, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 3833, 3833, 3833, 3833, 36601, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 8189, 8189, 8189, 8189, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 1785, 3833, 7929, 16121, 32505, 32505, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 3407, 3407, 3407, 3407, 36175, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 249, 249, 8441, 24825, 57593, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 4735, 12927, 12927, 12927, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 249, 249, 4345, 4345, 4345, 4345, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 1293, 1293, 9485, 25869, 25869, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 1273, 1273, 1273, 17657, 50425, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 4951, 4951, 4951, 4951, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 1273, 5369, 13561, 29945, 62713, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 367, 8559, 24943, 57711, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 3321, 3321, 11513, 27897, 60665, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 415, 4511, 12703, 12703, 45471, 0},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 3321, 3321, 3321, 3321, 36089, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 2899, 2899, 19283, 52051, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 825, 825, 825, 17209, 49977, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 2389, 2389, 10581, 10581, 43349, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 825, 2873, 2873, 2873, 19257, 19257, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 3707, 3707, 3707, 3707, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 1849, 1849, 1849, 18233, 18233, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 7067, 7067, 23451, 23451, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 1849, 1849, 10041, 10041, 10041, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 4823, 13015, 13015, 13015, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 3897, 3897, 12089, 28473, 28473, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 723, 4819, 4819, 4819, 37587, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 313, 4409, 4409, 4409, 37177, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 3887, 12079, 28463, 28463, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 1337, 5433, 13625, 13625, 46393, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 519, 519, 519, 519, 519, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 3385, 7481, 7481, 7481, 40249, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 3279, 3279, 3279, 19663, 52431, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 3385, 7481, 15673, 15673, 15673, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 4025, 8121, 8121, 24505, 24505, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 3385, 7481, 15673, 32057, 64825, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 3843, 3843, 3843, 20227, 52995, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 569, 569, 569, 569, 569, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 8155, 16347, 16347, 16347, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 569, 4665, 4665, 21049, 21049, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 175, 4271, 4271, 20655, 53423, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 2617, 2617, 2617, 19001, 19001, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 95, 95, 95, 16479, 16479, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 569, 2617, 6713, 14905, 14905, 47673, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 1453, 1453, 5549, 5549, 5549, 5549, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 1593, 1593, 1593, 17977, 17977, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 959, 959, 17343, 50111, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 3641, 3641, 3641, 3641, 3641, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 2619, 2619, 10811, 27195, 27195, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 3641, 3641, 11833, 28217, 28217, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 2423, 10615, 26999, 26999, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 3641, 3641, 11833, 11833, 44601, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 2557, 6653, 14845, 31229, 63997, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 57, 57, 57, 16441, 49209, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 3199, 3199, 19583, 52351, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 2105, 6201, 6201, 22585, 55353, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 7311, 15503, 15503, 48271, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 2105, 6201, 6201, 6201, 6201, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 741, 741, 8933, 8933, 8933, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 1081, 1081, 9273, 9273, 9273, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 3933, 3933, 3933, 3933, 36701, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 3129, 3129, 11321, 11321, 44089, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 5459, 5459, 21843, 54611, 0},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 1081, 3129, 7225, 15417, 31801, 64569, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 6567, 14759, 14759, 14759, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 953, 953, 17337, 50105, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 3479, 3479, 11671, 28055, 60823, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 5049, 5049, 5049, 37817, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 2659, 2659, 2659, 19043, 19043, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 3001, 7097, 7097, 23481, 56249, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 2407, 6503, 14695, 31079, 31079, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 1977, 10169, 26553, 59321, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 3263, 7359, 15551, 15551, 15551, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 1977, 10169, 10169, 10169, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 3861, 7957, 7957, 7957, 40725, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 6073, 14265, 14265, 47033, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 715, 8907, 25291, 58059, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 441, 8633, 8633, 41401, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 981, 981, 981, 17365, 17365, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 441, 441, 441, 441, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 6067, 14259, 14259, 47027, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 1465, 5561, 13753, 30137, 30137, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 111, 8303, 24687, 57455, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 1465, 5561, 5561, 5561, 5561, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 6563, 14755, 31139, 31139, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 3513, 7609, 7609, 23993, 23993, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 1703, 1703, 1703, 1703, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 697, 697, 8889, 8889, 41657, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 3327, 3327, 3327, 3327, 3327, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 697, 697, 697, 4793, 4793, 21177, 21177, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 397, 2445, 2445, 2445, 18829, 18829, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 185, 185, 185, 185, 185, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 535, 4631, 12823, 12823, 45591, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 185, 4281, 4281, 20665, 20665, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 3555, 3555, 3555, 3555, 36323, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 2233, 10425, 26809, 59577, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 1269, 9461, 25845, 58613, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 185, 2233, 6329, 14521, 30905, 30905, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 4267, 12459, 12459, 12459, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 1209, 1209, 9401, 25785, 58553, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 1685, 1685, 1685, 18069, 18069, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 1209, 5305, 5305, 5305, 5305, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 7431, 15623, 15623, 15623, 0},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 3257, 7353, 15545, 31929, 64697, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 5285, 5285, 21669, 21669, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 341, 2389, 2389, 2389, 18773, 51541, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 805, 4901, 4901, 4901, 37669, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 5973, 14165, 14165, 14165, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 3541, 7637, 7637, 24021, 56789, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 1877, 1877, 18261, 51029, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 2887, 6983, 15175, 31559, 64327, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 1877, 1877, 1877, 1877, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 11789, 28173, 28173, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 3925, 8021, 8021, 8021, 40789, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 2109, 6205, 14397, 30781, 30781, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 4949, 4949, 21333, 21333, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 605, 605, 8797, 25181, 25181, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 853, 9045, 9045, 41813, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 1647, 1647, 1647, 1647, 1647, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 2901, 6997, 15189, 15189, 15189, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 5791, 5791, 22175, 22175, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 2901, 2901, 11093, 27477, 27477, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 747, 4843, 4843, 4843, 4843, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 1109, 1109, 1109, 17493, 50261, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 2815, 11007, 27391, 60159, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 3157, 7253, 15445, 15445, 15445, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 1475, 5571, 13763, 30147, 30147, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 85, 85, 8277, 8277, 41045, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 3031, 3031, 11223, 27607, 27607, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 85, 4181, 4181, 4181, 36949, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 6639, 14831, 14831, 47599, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 2133, 2133, 2133, 2133, 2133, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 2335, 2335, 10527, 26911, 26911, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 1621, 5717, 13909, 30293, 63061, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 1583, 5679, 13871, 30255, 30255, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 3669, 3669, 3669, 3669, 3669, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 2067, 2067, 10259, 26643, 59411, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 3669, 7765, 7765, 24149, 24149, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 231, 231, 231, 16615, 49383, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 1621, 3669, 7765, 7765, 7765, 40533, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 301, 301, 301, 16685, 49453, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 2645, 10837, 27221, 27221, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 1211, 1211, 1211, 33979, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 6741, 14933, 14933, 14933, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 1487, 5583, 5583, 21967, 54735, 0},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 2645, 6741, 6741, 23125, 23125, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 1539, 1539, 1539, 17923, 17923, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 3541, 7637, 7637, 7637, 7637, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 1535, 5631, 5631, 5631, 5631, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 2517, 6613, 14805, 31189, 31189, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 1239, 5335, 5335, 21719, 21719, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 2517, 2517, 2517, 2517, 35285, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 1797, 9989, 26373, 26373, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 469, 8661, 25045, 57813, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 32807, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 469, 469, 8661, 8661, 8661, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 3821, 7917, 7917, 7917, 40685, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 4053, 8149, 16341, 32725, 32725, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 3675, 7771, 7771, 7771, 7771, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 2005, 6101, 14293, 30677, 30677, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 2549, 2549, 2549, 18933, 18933, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 2005, 2005, 10197, 26581, 59349, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 2475, 6571, 14763, 31147, 63915, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 2005, 2005, 2005, 2005, 2005, 34773, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 8167, 16359, 32743, 65511, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 3029, 7125, 7125, 7125, 7125, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 2803, 2803, 2803, 35571, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 981, 981, 981, 5077, 5077, 5077, 5077, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 7805, 7805, 24189, 24189, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 3285, 3285, 3285, 19669, 19669, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 2523, 6619, 14811, 14811, 14811, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 3285, 3285, 11477, 11477, 11477, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 1175, 5271, 13463, 13463, 46231, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 1237, 1237, 1237, 1237, 34005, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 1631, 1631, 9823, 9823, 42591, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 2261, 2261, 2261, 18645, 18645, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 1471, 1471, 9663, 9663, 9663, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 213, 4309, 12501, 12501, 45269, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 3715, 3715, 3715, 3715, 36483, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 3797, 3797, 11989, 11989, 11989, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 2687, 2687, 10879, 10879, 10879, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 1749, 1749, 9941, 26325, 59093, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 4091, 4091, 12283, 12283, 12283, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 1749, 1749, 5845, 5845, 22229, 54997, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 7491, 15683, 15683, 48451, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 725, 725, 725, 725, 33493, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 4947, 4947, 21331, 21331, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 725, 4821, 13013, 13013, 45781, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 3563, 7659, 7659, 24043, 56811, 0},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 725, 4821, 4821, 21205, 53973, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 4007, 8103, 8103, 24487, 24487, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 277, 277, 277, 8469, 8469, 41237, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 1843, 10035, 26419, 26419, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 1301, 1301, 1301, 17685, 50453, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 923, 923, 923, 17307, 50075, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 1301, 1301, 9493, 25877, 25877, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 3805, 3805, 20189, 52957, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 3349, 7445, 7445, 23829, 23829, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 1131, 1131, 9323, 25707, 58475, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 3349, 7445, 15637, 15637, 15637, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 3623, 7719, 15911, 32295, 65063, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 789, 789, 789, 789, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 541, 541, 8733, 8733, 41501, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 4885, 13077, 13077, 13077, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 3525, 7621, 7621, 7621, 7621, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 4885, 4885, 4885, 37653, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 6883, 6883, 6883, 6883, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 2837, 2837, 11029, 27413, 27413, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 2015, 2015, 10207, 26591, 26591, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 2837, 6933, 6933, 23317, 23317, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 487, 487, 487, 33255, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 1813, 10005, 26389, 26389, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 3477, 3477, 3477, 36245, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 4117, 12309, 28693, 61461, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 663, 2711, 2711, 2711, 19095, 51863, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 8213, 8213, 40981, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 3427, 7523, 7523, 23907, 56675, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 2069, 2069, 2069, 2069, 2069, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 43, 43, 16427, 49195, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 1045, 5141, 5141, 5141, 37909, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 3007, 7103, 7103, 23487, 56255, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 3093, 3093, 3093, 3093, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 2895, 2895, 11087, 27471, 27471, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 4629, 4629, 4629, 37397, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 179, 179, 8371, 8371, 8371, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 533, 533, 16917, 49685, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 6727, 14919, 14919, 47687, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 533, 533, 533, 533, 533, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 2829, 6925, 15117, 31501, 31501, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 2581, 10773, 10773, 43541, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 2789, 6885, 6885, 23269, 56037, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 7701, 15893, 32277, 65045, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 2741, 10933, 10933, 10933, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 3605, 11797, 28181, 28181, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 1003, 1003, 1003, 17387, 17387, 0},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 3605, 3605, 19989, 52757, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 365, 365, 365, 16749, 16749, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 405, 405, 405, 33173, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 1887, 10079, 10079, 42847, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 405, 4501, 4501, 20885, 53653, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 3883, 3883, 3883, 3883, 3883, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 7573, 15765, 15765, 48533, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 1229, 9421, 9421, 9421, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 1429, 5525, 5525, 21909, 54677, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 1103, 5199, 5199, 5199, 37967, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 917, 2965, 2965, 2965, 19349, 19349, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 4019, 4019, 12211, 12211, 12211, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 3989, 3989, 20373, 20373, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 2647, 2647, 2647, 19031, 19031, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 8085, 16277, 16277, 49045, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 2949, 11141, 27525, 27525, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 3989, 8085, 8085, 8085, 8085, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 419, 419, 8611, 24995, 57763, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 6037, 6037, 6037, 6037, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 621, 4717, 12909, 12909, 45677, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 2197, 2197, 2197, 18581, 18581, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 3723, 7819, 7819, 24203, 24203, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 149, 149, 4245, 12437, 28821, 28821, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 1981, 10173, 10173, 10173, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 7317, 15509, 31893, 31893, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 5591, 5591, 5591, 5591, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 3221, 3221, 11413, 11413, 11413, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 1571, 1571, 9763, 9763, 9763, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 149, 1173, 1173, 1173, 9365, 9365, 9365, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 3053, 3053, 3053, 35821, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 2709, 2709, 10901, 10901, 10901, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 2095, 2095, 2095, 34863, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 2709, 2709, 10901, 27285, 60053, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 3781, 11973, 11973, 11973, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 661, 4757, 4757, 21141, 53909, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 5651, 13843, 30227, 62995, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 661, 661, 661, 8853, 25237, 58005, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 2219, 10411, 10411, 43179, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 3733, 7829, 16021, 32405, 32405, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 2879, 6975, 6975, 6975, 6975, 0},
{1, 1, 5, 5, 21, 21, 21, 149, 149, 661, 1685, 1685, 5781, 5781, 22165, 54933, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 503, 4599, 4599, 4599, 4599, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 885, 4981, 4981, 4981, 37749, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 3725, 3725, 3725, 3725, 36493, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 2933, 2933, 11125, 11125, 43893, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 2683, 2683, 10875, 10875, 43643, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 2933, 7029, 15221, 15221, 15221, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 3941, 3941, 3941, 20325, 20325, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 885, 2933, 7029, 7029, 7029, 39797, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 2243, 6339, 6339, 22723, 22723, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 885, 1909, 1909, 1909, 10101, 26485, 26485, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 3995, 8091, 16283, 32667, 65435, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 373, 373, 4469, 4469, 20853, 20853, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 2863, 2863, 2863, 35631, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 1397, 1397, 1397, 1397, 1397, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 2111, 6207, 6207, 6207, 6207, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 1397, 5493, 5493, 21877, 21877, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 3659, 3659, 11851, 11851, 11851, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 1397, 5493, 13685, 13685, 13685, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 1543, 1543, 9735, 26119, 58887, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 3445, 7541, 7541, 23925, 23925, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 933, 5029, 5029, 21413, 21413, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 373, 373, 1397, 3445, 7541, 15733, 32117, 64885, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 2819, 11011, 27395, 27395, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 4725, 4725, 21109, 21109, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 5783, 13975, 13975, 13975, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 629, 8821, 8821, 41589, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 2117, 2117, 2117, 2117, 34885, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 2677, 6773, 6773, 6773, 39541, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 659, 659, 659, 33427, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 5749, 13941, 13941, 13941, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 1983, 1983, 10175, 10175, 10175, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 1653, 1653, 18037, 50805, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 3021, 7117, 7117, 7117, 7117, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 3701, 7797, 15989, 32373, 65141, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 3643, 3643, 3643, 20027, 52795, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 117, 4213, 12405, 12405, 12405, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 7347, 7347, 7347, 7347, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 1141, 1141, 9333, 25717, 25717, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 675, 4771, 4771, 21155, 53923, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 3189, 7285, 7285, 23669, 23669, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 1717, 1717, 9909, 26293, 59061, 0},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 1141, 3189, 3189, 11381, 11381, 44149, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 3495, 7591, 7591, 23975, 56743, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 7157, 15349, 15349, 48117, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 2991, 2991, 19375, 52143, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 7157, 15349, 31733, 31733, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 2885, 6981, 15173, 15173, 47941, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 1013, 1013, 9205, 9205, 9205, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 2911, 7007, 7007, 23391, 23391, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 1013, 1013, 1013, 17397, 17397, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 3475, 3475, 3475, 36243, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 2037, 2037, 10229, 10229, 10229, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 315, 315, 315, 315, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 2037, 2037, 2037, 2037, 34805, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 3837, 7933, 16125, 16125, 16125, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 2037, 2037, 6133, 14325, 14325, 47093, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 6437, 14629, 14629, 14629, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 501, 501, 501, 16885, 16885, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 763, 763, 17147, 17147, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 501, 501, 8693, 25077, 57845, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 4669, 4669, 21053, 21053, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 501, 4597, 4597, 20981, 53749, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 1509, 1509, 9701, 9701, 9701, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 501, 501, 4597, 12789, 29173, 29173, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 67, 4163, 4163, 4163, 36931, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 3573, 3573, 11765, 28149, 60917, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 1623, 5719, 13911, 13911, 46679, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 3573, 7669, 15861, 15861, 48629, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 3491, 7587, 7587, 23971, 56739, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 1525, 5621, 5621, 5621, 5621, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 235, 4331, 12523, 12523, 45291, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 501, 1525, 1525, 5621, 13813, 30197, 30197, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 679, 679, 8871, 25255, 58023, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 6901, 15093, 15093, 47861, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 2303, 10495, 26879, 59647, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 6901, 6901, 23285, 56053, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 1075, 5171, 5171, 21555, 21555, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 3829, 7925, 7925, 7925, 7925, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 477, 4573, 12765, 29149, 61917, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 1781, 5877, 14069, 30453, 30453, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 2847, 11039, 27423, 27423, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 1781, 1781, 1781, 1781, 34549, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 2029, 2029, 2029, 18413, 18413, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 6389, 6389, 22773, 55541, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 859, 4955, 13147, 29531, 29531, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 2293, 2293, 18677, 18677, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 709, 709, 8901, 25285, 58053, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 245, 245, 245, 16629, 16629, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 5291, 5291, 5291, 38059, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 245, 245, 8437, 8437, 8437, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 743, 743, 743, 17127, 17127, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 3317, 7413, 15605, 15605, 48373, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 2035, 2035, 10227, 10227, 42995, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 3317, 3317, 11509, 27893, 60661, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 6407, 6407, 22791, 55559, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 3317, 3317, 11509, 11509, 11509, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 333, 4429, 4429, 20813, 53581, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 1269, 1269, 17653, 17653, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 6095, 6095, 22479, 55247, 0},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 1269, 1269, 1269, 9461, 9461, 9461, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 1027, 1027, 9219, 25603, 25603, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 1845, 5941, 5941, 5941, 38709, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 669, 669, 17053, 49821, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 1845, 1845, 1845, 1845, 1845, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 99, 4195, 12387, 28771, 61539, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 6965, 15157, 31541, 64309, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 7995, 7995, 7995, 40763, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 2869, 11061, 11061, 43829, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 1615, 5711, 5711, 5711, 38479, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 1333, 5429, 5429, 21813, 21813, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 2431, 10623, 10623, 10623, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 1333, 1333, 9525, 25909, 25909, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 1863, 1863, 1863, 1863, 1863, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 7477, 7477, 7477, 40245, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 3323, 7419, 7419, 23803, 56571, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 309, 4405, 4405, 20789, 20789, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 2331, 2331, 2331, 35099, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 309, 4405, 12597, 12597, 12597, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 2135, 2135, 18519, 51287, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 2357, 2357, 2357, 18741, 51509, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 3819, 3819, 12011, 12011, 12011, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 309, 2357, 2357, 10549, 26933, 26933, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 2157, 6253, 6253, 6253, 39021, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 1589, 1589, 1589, 1589, 1589, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 2611, 2611, 2611, 18995, 18995, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 3637, 3637, 3637, 3637, 3637, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 3517, 3517, 3517, 3517, 3517, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 565, 565, 16949, 49717, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 2013, 6109, 6109, 6109, 6109, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 4661, 12853, 12853, 12853, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 1519, 1519, 17903, 17903, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 4661, 4661, 21045, 21045, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 1059, 1059, 1059, 1059, 1059, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 6709, 6709, 6709, 39477, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 807, 807, 807, 17191, 17191, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 1077, 1077, 9269, 25653, 25653, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 2071, 10263, 10263, 10263, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 1077, 1077, 1077, 9269, 9269, 42037, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 2845, 6941, 15133, 31517, 31517, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 2101, 2101, 18485, 51253, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 2235, 6331, 14523, 14523, 47291, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 2101, 10293, 10293, 43061, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 5111, 5111, 5111, 37879, 0},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 6197, 6197, 6197, 38965, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 2511, 2511, 10703, 10703, 10703, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 1973, 4021, 4021, 12213, 28597, 61365, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 907, 5003, 13195, 13195, 13195, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 2997, 7093, 7093, 23477, 56245, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 2263, 10455, 10455, 43223, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 5045, 5045, 5045, 5045, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 2259, 10451, 10451, 10451, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 949, 9141, 9141, 9141, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 1643, 1643, 1643, 18027, 18027, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 3509, 7605, 7605, 23989, 56757, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 603, 603, 8795, 8795, 8795, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 5557, 5557, 5557, 5557, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 1503, 9695, 26079, 26079, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 5557, 13749, 30133, 30133, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 2835, 6931, 6931, 23315, 56083, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 1461, 9653, 26037, 58805, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 7725, 15917, 32301, 65069, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 2485, 2485, 10677, 27061, 59829, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 6151, 6151, 6151, 38919, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 4533, 12725, 29109, 29109, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 3319, 3319, 11511, 11511, 44279, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 437, 437, 437, 33205, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 1445, 5541, 13733, 13733, 13733, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 437, 437, 437, 8629, 8629, 8629, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 5379, 13571, 29955, 29955, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 3765, 7861, 16053, 16053, 48821, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 2735, 2735, 2735, 19119, 51887, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 2741, 2741, 2741, 35509, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 371, 4467, 12659, 29043, 61811, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 6837, 15029, 15029, 47797, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 6091, 6091, 6091, 6091, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 2741, 6837, 6837, 23221, 55989, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 1927, 1927, 1927, 18311, 18311, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 693, 693, 17077, 17077, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 887, 4983, 13175, 29559, 62327, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 693, 693, 693, 33461, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 3069, 3069, 11261, 11261, 11261, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 3253, 3253, 11445, 27829, 60597, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 691, 691, 691, 691, 691, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 2229, 2229, 2229, 2229, 34997, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 1563, 1563, 17947, 17947, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 2229, 2229, 10421, 10421, 10421, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 3421, 7517, 7517, 23901, 23901, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 181, 181, 181, 16565, 16565, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 5535, 5535, 21919, 21919, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 181, 4277, 12469, 28853, 28853, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 935, 935, 9127, 9127, 41895, 0},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 181, 4277, 12469, 12469, 45237, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 2925, 11117, 27501, 27501, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 4421, 4421, 20805, 53573, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 4095, 12287, 28671, 61439, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 4421, 12613, 12613, 45381, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 819, 9011, 9011, 9011, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 2373, 6469, 6469, 6469, 6469, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 4731, 4731, 21115, 53883, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 2373, 6469, 14661, 31045, 31045, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 5431, 5431, 5431, 38199, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 837, 837, 837, 837, 33605, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 3811, 7907, 7907, 24291, 24291, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 2885, 2885, 11077, 11077, 11077, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 939, 939, 9131, 9131, 9131, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 2885, 2885, 2885, 19269, 19269, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 1511, 1511, 1511, 34279, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 1861, 1861, 10053, 26437, 59205, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 5707, 5707, 22091, 22091, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 8005, 8005, 8005, 8005, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 2807, 2807, 10999, 10999, 10999, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 3909, 3909, 20293, 20293, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 771, 4867, 4867, 4867, 4867, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 69, 69, 69, 69, 32837, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 987, 9179, 25563, 58331, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 1093, 5189, 13381, 29765, 29765, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 973, 973, 973, 33741, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 3141, 11333, 27717, 60485, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 5629, 5629, 22013, 22013, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 7237, 7237, 23621, 56389, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 4645, 4645, 4645, 37413, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 581, 581, 8773, 25157, 57925, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 127, 4223, 4223, 20607, 53375, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 2629, 10821, 10821, 10821, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 5627, 13819, 30203, 62971, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 6725, 14917, 31301, 31301, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 143, 143, 8335, 8335, 41103, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 581, 2629, 6725, 14917, 14917, 47685, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 3813, 3813, 3813, 3813, 36581, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 1605, 1605, 17989, 17989, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 861, 9053, 9053, 9053, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 5701, 13893, 13893, 46661, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 879, 879, 879, 879, 0},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 1605, 5701, 5701, 22085, 54853, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 2723, 10915, 10915, 43683, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 2501, 6597, 14789, 14789, 47557, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 407, 4503, 12695, 29079, 61847, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 2501, 2501, 10693, 27077, 59845, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 1635, 5731, 5731, 5731, 38499, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 453, 453, 4549, 12741, 29125, 29125, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 1427, 5523, 13715, 30099, 62867, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 3525, 3525, 11717, 11717, 11717, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 205, 4301, 12493, 28877, 28877, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 453, 1477, 1477, 5573, 13765, 30149, 30149, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 2679, 2679, 2679, 19063, 19063, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 3013, 3013, 11205, 27589, 60357, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 3339, 7435, 15627, 15627, 48395, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 965, 965, 9157, 9157, 9157, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 8079, 8079, 24463, 24463, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 965, 965, 965, 17349, 17349, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 2115, 10307, 26691, 59459, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 4037, 8133, 16325, 16325, 49093, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 3867, 3867, 12059, 28443, 28443, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 4037, 4037, 12229, 12229, 12229, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 3973, 8069, 16261, 16261, 16261, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 1989, 1989, 10181, 10181, 10181, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 2283, 2283, 2283, 18667, 51435, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 1989, 1989, 1989, 18373, 18373, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 2727, 6823, 6823, 6823, 6823, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 2245, 2245, 2245, 2245, 35013, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 255, 4351, 4351, 4351, 4351, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 2245, 6341, 14533, 30917, 30917, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 1421, 1421, 9613, 25997, 58765, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 197, 197, 197, 16581, 16581, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 7547, 7547, 7547, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 1221, 1221, 17605, 17605, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 799, 4895, 4895, 4895, 37663, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 1221, 9413, 9413, 9413, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 467, 467, 467, 16851, 16851, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 1221, 5317, 5317, 5317, 5317, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 3947, 12139, 28523, 28523, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 2757, 6853, 6853, 23237, 56005, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 4579, 4579, 20963, 20963, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 709, 4805, 4805, 21189, 53957, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 813, 4909, 13101, 29485, 29485, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 3781, 7877, 7877, 24261, 57029, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 263, 263, 8455, 8455, 8455, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 1733, 1733, 1733, 1733, 34501, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 8061, 8061, 8061, 8061, 0},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 1733, 1733, 5829, 14021, 14021, 46789, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 2213, 6309, 14501, 30885, 63653, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 1285, 1285, 9477, 25861, 25861, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 2717, 6813, 6813, 23197, 23197, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 1285, 5381, 5381, 5381, 38149, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 3503, 3503, 19887, 52655, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 1285, 5381, 13573, 29957, 62725, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 2147, 2147, 2147, 34915, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 261, 4357, 4357, 4357, 37125, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 203, 8395, 8395, 41163, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 261, 4357, 12549, 28933, 61701, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 135, 135, 135, 135, 32903, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 2309, 6405, 14597, 14597, 14597, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 1411, 1411, 17795, 50563, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 1797, 9989, 9989, 42757, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 383, 4479, 4479, 20863, 53631, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 5893, 14085, 30469, 63237, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 779, 8971, 8971, 8971, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 7941, 16133, 32517, 65285, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 7141, 7141, 23525, 56293, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 773, 773, 17157, 49925, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 87, 4183, 12375, 12375, 12375, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 773, 773, 773, 773, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 5725, 13917, 13917, 13917, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 4869, 13061, 13061, 13061, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 2437, 6533, 6533, 22917, 22917, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 773, 773, 4869, 4869, 4869, 37637, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 2979, 7075, 15267, 15267, 48035, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1029, 3077, 7173, 7173, 23557, 23557, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 891, 891, 891, 33659, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1029, 3077, 7173, 15365, 31749, 64517, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 1469, 5565, 5565, 5565, 38333, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4101, 12293, 28677, 61445, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 4055, 12247, 28631, 28631, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 1541, 1541, 9733, 9733, 42501, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 4655, 12847, 29231, 29231, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 7685, 7685, 24069, 24069, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 3091, 3091, 11283, 11283, 44051, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 1541, 3589, 3589, 11781, 28165, 28165, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 4779, 12971, 29355, 29355, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 517, 4613, 4613, 4613, 37381, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 499, 499, 499, 16883, 49651, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 517, 517, 517, 16901, 49669, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 3847, 7943, 7943, 24327, 24327, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 6661, 6661, 6661, 39429, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 2429, 6525, 14717, 31101, 63869, 0},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 2565, 10757, 10757, 43525, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 3749, 7845, 7845, 7845, 40613, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 3461, 11653, 11653, 44421, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 3379, 7475, 15667, 15667, 15667, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 7557, 7557, 7557, 40325, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 2955, 2955, 2955, 19339, 19339, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 1413, 9605, 25989, 25989, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 2871, 2871, 11063, 27447, 60215, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 1413, 9605, 9605, 42373, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 1725, 9917, 26301, 26301, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 2437, 2437, 2437, 18821, 51589, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 6555, 6555, 6555, 6555, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 2437, 6533, 6533, 6533, 39301, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 751, 751, 751, 17135, 17135, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 3973, 3973, 12165, 12165, 44933, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 6747, 6747, 23131, 23131, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 3973, 3973, 3973, 3973, 3973, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 29, 4125, 4125, 4125, 4125, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 3973, 8069, 8069, 8069, 40837, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 227, 227, 227, 16611, 16611, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 1925, 1925, 1925, 1925, 1925, 1925, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 787, 8979, 8979, 41747, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 2949, 2949, 19333, 52101, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 3827, 3827, 3827, 20211, 52979, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 901, 4997, 13189, 29573, 62341, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 3493, 3493, 11685, 11685, 44453, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 1157, 3205, 7301, 15493, 15493, 15493, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 2461, 2461, 10653, 10653, 43421, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 2181, 2181, 10373, 10373, 43141, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 3975, 8071, 16263, 16263, 49031, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 133, 4229, 4229, 20613, 20613, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 2107, 10299, 10299, 10299, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 3717, 7813, 16005, 32389, 65157, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 3711, 11903, 11903, 11903, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 3717, 3717, 3717, 3717, 3717, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 2317, 2317, 2317, 18701, 51469, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 1669, 1669, 5765, 5765, 22149, 22149, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 1207, 5303, 13495, 13495, 46263, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 2693, 6789, 14981, 31365, 64133, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 3611, 7707, 15899, 15899, 15899, 0},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 645, 645, 2693, 2693, 10885, 10885, 43653, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 3439, 7535, 15727, 32111, 64879, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 1893, 1893, 18277, 18277, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 3803, 3803, 3803, 36571, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 3941, 8037, 16229, 32613, 32613, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 173, 173, 8365, 24749, 24749, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 869, 4965, 13157, 29541, 29541, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 3207, 7303, 15495, 31879, 31879, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 869, 2917, 2917, 11109, 27493, 60261, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 2167, 2167, 2167, 18551, 51319, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 1381, 1381, 9573, 9573, 9573, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 3455, 3455, 11647, 11647, 11647, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 7525, 15717, 15717, 48485, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 3471, 7567, 7567, 23951, 23951, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 357, 4453, 12645, 29029, 29029, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 7791, 15983, 32367, 65135, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 357, 4453, 4453, 4453, 4453, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 1955, 1955, 1955, 34723, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 2405, 2405, 2405, 35173, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 1107, 1107, 9299, 9299, 9299, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 6501, 6501, 22885, 55653, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 6311, 6311, 6311, 39079, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 6501, 6501, 6501, 6501, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 3181, 3181, 19565, 52333, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 7781, 15973, 15973, 48741, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 2103, 2103, 10295, 10295, 10295, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 3685, 3685, 20069, 20069, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 613, 4709, 12901, 29285, 29285, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 983, 5079, 5079, 5079, 37847, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 613, 4709, 12901, 12901, 45669, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 989, 989, 17373, 17373, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 2661, 6757, 6757, 23141, 55909, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 287, 4383, 4383, 4383, 37151, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 5221, 5221, 21605, 54373, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 3869, 12061, 12061, 12061, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 1125, 9317, 9317, 9317, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 3631, 3631, 3631, 3631, 36399, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 1125, 1125, 17509, 17509, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 995, 5091, 13283, 29667, 29667, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 7269, 15461, 15461, 48229, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 3807, 7903, 7903, 7903, 40671, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 3173, 3173, 11365, 27749, 60517, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 3755, 3755, 3755, 20139, 20139, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 4197, 4197, 4197, 4197, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 7667, 15859, 32243, 65011, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 101, 8293, 8293, 8293, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 6987, 15179, 15179, 15179, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 101, 101, 101, 32869, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 845, 9037, 25421, 25421, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 2149, 6245, 6245, 22629, 55397, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 2039, 6135, 6135, 6135, 38903, 0},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 2149, 2149, 2149, 2149, 34917, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 3587, 7683, 15875, 15875, 15875, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 4069, 12261, 12261, 12261, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 307, 307, 307, 307, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 3045, 11237, 11237, 11237, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 3287, 3287, 11479, 11479, 44247, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 997, 997, 9189, 25573, 58341, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 3283, 11475, 27859, 27859, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 997, 5093, 13285, 29669, 29669, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 1773, 1773, 1773, 1773, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 1509, 5605, 13797, 13797, 46565, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 427, 427, 427, 33195, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 2533, 6629, 14821, 31205, 31205, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 5195, 13387, 29771, 62539, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 2533, 6629, 6629, 6629, 6629, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 3079, 7175, 7175, 7175, 39943, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 485, 485, 8677, 25061, 57829, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 5051, 13243, 13243, 13243, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 485, 485, 485, 16869, 16869, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 1661, 1661, 1661, 18045, 50813, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 485, 4581, 12773, 12773, 45541, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 4815, 4815, 21199, 53967, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 3813, 7909, 16101, 16101, 48869, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 1437, 1437, 9629, 26013, 26013, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 1765, 1765, 9957, 26341, 59109, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 6247, 6247, 22631, 55399, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 2789, 6885, 15077, 31461, 31461, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 1395, 5491, 13683, 13683, 46451, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 741, 2789, 2789, 2789, 19173, 19173, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 5067, 5067, 21451, 21451, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 1253, 1253, 5349, 5349, 21733, 54501, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 2231, 2231, 18615, 18615, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 1253, 1253, 5349, 5349, 5349, 5349, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 4925, 4925, 4925, 4925, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 6373, 14565, 30949, 30949, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 539, 539, 539, 539, 539, 0},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 2277, 2277, 18661, 18661, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 2211, 2211, 2211, 34979, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 2853, 6949, 15141, 15141, 15141, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 3261, 3261, 3261, 19645, 19645, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 2853, 2853, 2853, 19237, 52005, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 783, 783, 8975, 25359, 58127, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 1829, 5925, 14117, 14117, 14117, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 4823, 4823, 21207, 53975, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 293, 4389, 4389, 20773, 20773, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 3351, 3351, 11543, 27927, 27927, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 293, 293, 8485, 24869, 24869, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 3887, 3887, 3887, 36655, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 6437, 14629, 31013, 63781, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 8159, 8159, 8159, 40927, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 1317, 1317, 1317, 17701, 50469, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 1613, 5709, 13901, 30285, 30285, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 1317, 3365, 7461, 7461, 7461, 40229, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 5879, 5879, 22263, 55031, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 549, 549, 549, 549, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 8155, 8155, 24539, 57307, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 549, 8741, 8741, 41509, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 925, 925, 925, 925, 33693, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 549, 4645, 12837, 12837, 12837, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 1379, 1379, 9571, 9571, 42339, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 2597, 6693, 6693, 6693, 39461, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 6187, 14379, 14379, 47147, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 549, 2597, 6693, 14885, 31269, 64037, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 1639, 1639, 9831, 9831, 42599, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 1573, 1573, 9765, 26149, 26149, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 2931, 11123, 11123, 43891, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 3621, 11813, 11813, 44581, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 2423, 2423, 2423, 35191, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 7717, 15909, 32293, 65061, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 2179, 2179, 10371, 26755, 59523, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 2085, 2085, 2085, 18469, 51237, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 1719, 5815, 14007, 14007, 14007, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 1061, 1061, 9253, 25637, 25637, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 3099, 7195, 7195, 7195, 39963, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 1061, 5157, 5157, 21541, 21541, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 1699, 5795, 5795, 5795, 38563, 0},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 1061, 3109, 7205, 7205, 23589, 23589, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 2413, 6509, 6509, 22893, 55661, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 7077, 15269, 15269, 15269, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 3479, 3479, 3479, 3479, 3479, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 2981, 2981, 2981, 2981, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 4015, 4015, 4015, 20399, 53167, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 933, 933, 933, 17317, 50085, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 1835, 5931, 14123, 30507, 30507, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 4005, 4005, 4005, 4005, 4005, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 715, 715, 715, 715, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 1957, 6053, 6053, 6053, 38821, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 1339, 1339, 1339, 17723, 17723, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 1957, 1957, 1957, 18341, 51109, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 3151, 11343, 27727, 27727, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 2469, 6565, 14757, 14757, 14757, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 4991, 21375, 54143, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 421, 4517, 4517, 4517, 37285, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 2487, 2487, 2487, 2487, 2487, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 421, 4517, 4517, 20901, 20901, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 1597, 1597, 1597, 1597, 1597, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 3493, 7589, 7589, 23973, 23973, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 4695, 12887, 12887, 45655, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 677, 677, 8869, 8869, 41637, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 5687, 5687, 22071, 22071, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 677, 4773, 12965, 29349, 62117, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 963, 5059, 5059, 5059, 5059, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 1701, 3749, 3749, 3749, 3749, 3749, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 1179, 1179, 5275, 13467, 29851, 29851, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 2213, 2213, 2213, 18597, 51365, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 2333, 2333, 2333, 18717, 51485, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 165, 165, 8357, 8357, 41125, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 223, 223, 8415, 24799, 24799, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 165, 4261, 4261, 20645, 20645, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 7981, 16173, 16173, 48941, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 3237, 7333, 7333, 7333, 40101, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 1357, 1357, 1357, 1357, 34125, 0},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 5285, 13477, 29861, 62629, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 975, 5071, 5071, 21455, 54223, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 3741, 7837, 7837, 7837, 40605, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 1419, 1419, 9611, 9611, 9611, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 1693, 9885, 26269, 26269, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 1335, 9527, 25911, 25911, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 2717, 2717, 10909, 27293, 27293, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 2781, 10973, 10973, 43741, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 669, 669, 669, 669, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 1055, 3103, 7199, 7199, 7199, 39967, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 4765, 4765, 21149, 21149, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 107, 4203, 4203, 20587, 20587, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 3229, 7325, 7325, 7325, 7325, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 3811, 3811, 12003, 12003, 44771, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 1181, 1181, 9373, 25757, 58525, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 991, 5087, 5087, 5087, 37855, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 2205, 6301, 6301, 22685, 55453, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 2637, 2637, 2637, 35405, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 8093, 16285, 16285, 49053, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 7831, 16023, 16023, 16023, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 1949, 1949, 1949, 18333, 18333, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 5163, 13355, 29739, 29739, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 1949, 1949, 10141, 10141, 10141, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 2663, 10855, 10855, 43623, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 1949, 1949, 10141, 26525, 59293, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 2477, 2477, 2477, 35245, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 2973, 7069, 7069, 23453, 56221, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 4031, 4031, 12223, 12223, 12223, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 2973, 2973, 11165, 27549, 60317, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 391, 4487, 12679, 12679, 12679, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 925, 5021, 5021, 5021, 5021, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 1595, 1595, 1595, 17979, 17979, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 925, 925, 9117, 9117, 9117, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 1155, 1155, 9347, 9347, 9347, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 1437, 5533, 5533, 21917, 21917, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 2365, 2365, 2365, 2365, 2365, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 2461, 6557, 14749, 14749, 14749, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 27, 4123, 4123, 20507, 20507, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 2461, 2461, 10653, 27037, 27037, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 4975, 13167, 29551, 62319, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 4509, 4509, 4509, 37277, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 2387, 6483, 14675, 31059, 63827, 0},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 413, 413, 413, 413, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 1389, 1389, 9581, 9581, 9581, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 5661, 13853, 13853, 13853, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 943, 943, 943, 17327, 50095, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 3613, 7709, 7709, 7709, 40477, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 1383, 5479, 5479, 5479, 38247, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 541, 541, 541, 541, 541, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 2163, 2163, 10355, 26739, 26739, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 541, 4637, 4637, 4637, 37405, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 205, 205, 205, 16589, 16589, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 2589, 2589, 18973, 51741, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 2679, 6775, 14967, 14967, 47735, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 6685, 14877, 31261, 64029, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 79, 79, 8271, 24655, 24655, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 6685, 6685, 6685, 39453, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 2947, 11139, 11139, 11139, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 1053, 1053, 9245, 25629, 58397, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 2995, 7091, 7091, 7091, 39859, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 1053, 5149, 5149, 21533, 54301, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 3339, 3339, 3339, 19723, 19723, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 1053, 5149, 13341, 29725, 29725, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 3085, 11277, 27661, 60429, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 3101, 3101, 11293, 11293, 11293, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 1463, 1463, 1463, 1463, 1463, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 3101, 7197, 7197, 7197, 7197, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 3983, 12175, 12175, 44943, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 2077, 6173, 14365, 14365, 47133, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 1645, 5741, 5741, 22125, 54893, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 7965, 16157, 16157, 48925, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 3451, 11643, 28027, 60795, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 7965, 7965, 7965, 7965, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 957, 957, 957, 17341, 17341, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 1821, 3869, 3869, 12061, 28445, 61213, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 15, 4111, 4111, 4111, 4111, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 797, 4893, 4893, 21277, 54045, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 2525, 6621, 6621, 23005, 23005, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 797, 797, 8989, 8989, 8989, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 1007, 5103, 13295, 13295, 46063, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 797, 797, 2845, 2845, 2845, 2845, 35613, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 5415, 13607, 13607, 13607, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 1309, 5405, 13597, 29981, 62749, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 3607, 7703, 7703, 24087, 24087, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 1309, 3357, 7453, 7453, 23837, 23837, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 3295, 11487, 27871, 27871, 0},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 2333, 6429, 14621, 31005, 63773, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 3965, 12157, 12157, 12157, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 2781, 2781, 2781, 2781, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 731, 731, 731, 17115, 17115, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 6877, 15069, 15069, 15069, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 6243, 14435, 30819, 30819, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 733, 733, 733, 17117, 49885, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 3423, 3423, 11615, 11615, 44383, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 733, 4829, 13021, 29405, 62173, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 2919, 2919, 11111, 27495, 60263, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 3805, 3805, 3805, 3805, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 3775, 3775, 11967, 11967, 11967, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 1757, 3805, 7901, 16093, 32477, 65245, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 1741, 9933, 9933, 42701, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 6365, 14557, 14557, 47325, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 4875, 4875, 21259, 54027, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 2269, 6365, 6365, 22749, 55517, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 3911, 3911, 3911, 3911, 3911, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 221, 221, 221, 221, 16605, 16605, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 7095, 15287, 31671, 31671, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 1245, 5341, 13533, 29917, 29917, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 1771, 1771, 9963, 9963, 42731, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 7133, 7133, 7133, 7133, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 3839, 7935, 7935, 7935, 7935, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 7133, 15325, 31709, 31709, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 563, 563, 563, 16947, 49715, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 3037, 3037, 11229, 11229, 11229, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 4295, 4295, 20679, 53447, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 5085, 13277, 13277, 46045, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 1079, 1079, 9271, 9271, 9271, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 989, 989, 989, 9181, 25565, 58333, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 451, 451, 451, 16835, 49603, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 4061, 8157, 8157, 8157, 8157, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 1691, 9883, 9883, 9883, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 4061, 8157, 16349, 32733, 32733, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 8151, 8151, 8151, 40919, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 2013, 2013, 2013, 2013, 34781, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 363, 363, 363, 363, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 2525, 2525, 10717, 10717, 43485, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 559, 559, 559, 33327, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 477, 477, 477, 477, 477, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 1255, 5351, 13543, 13543, 13543, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 3549, 3549, 3549, 19933, 52701, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 3847, 3847, 12039, 12039, 44807, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 5597, 13789, 13789, 13789, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 187, 4283, 12475, 12475, 12475, 0},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 1501, 9693, 26077, 26077, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 463, 8655, 8655, 8655, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 605, 605, 8797, 8797, 41565, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 511, 511, 8703, 25087, 57855, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 605, 4701, 12893, 29277, 62045, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 2955, 7051, 15243, 15243, 48011, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 605, 2653, 2653, 10845, 27229, 27229, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 3195, 7291, 15483, 15483, 48251, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 1629, 1629, 18013, 50781, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 215, 8407, 8407, 41175, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 93, 2141, 6237, 14429, 14429, 47197, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 3047, 3047, 3047, 3047, 3047, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 1117, 5213, 5213, 5213, 5213, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 6219, 14411, 14411, 14411, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 861, 4957, 13149, 13149, 45917, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 3547, 3547, 3547, 36315, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 7005, 7005, 7005, 7005, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 1171, 5267, 5267, 5267, 5267, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 5981, 14173, 14173, 46941, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 4543, 4543, 20927, 53695, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 1885, 5981, 5981, 22365, 55133, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 6515, 14707, 31091, 31091, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 1885, 3933, 8029, 8029, 8029, 8029, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 7031, 15223, 31607, 64375, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 2397, 10589, 10589, 43357, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 2371, 2371, 2371, 2371, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 1373, 5469, 13661, 13661, 13661, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 3927, 8023, 16215, 32599, 65367, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 1373, 1373, 9565, 25949, 25949, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 1187, 1187, 1187, 17571, 17571, 0},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 1373, 3421, 3421, 3421, 19805, 52573, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 2539, 2539, 10731, 27115, 27115, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 4285, 12477, 28861, 28861, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 919, 919, 919, 919, 33687, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 189, 8381, 8381, 8381, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 1123, 1123, 1123, 1123, 17507, 17507, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 2237, 10429, 26813, 59581, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 5991, 5991, 5991, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 3261, 3261, 11453, 27837, 60605, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 2435, 2435, 2435, 2435, 2435, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 701, 4797, 4797, 4797, 37565, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 2483, 6579, 14771, 14771, 47539, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 701, 701, 701, 701, 701, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 1549, 1549, 1549, 17933, 50701, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 701, 2749, 6845, 6845, 6845, 39613, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 4157, 4157, 20541, 53309, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 5821, 14013, 30397, 63165, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 7451, 15643, 15643, 15643, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 5821, 5821, 5821, 38589, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 7255, 15447, 15447, 15447, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 701, 1725, 1725, 1725, 9917, 9917, 42685, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 3695, 3695, 3695, 3695, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 4541, 4541, 20925, 20925, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 2187, 2187, 2187, 18571, 18571, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 4541, 12733, 12733, 12733, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 3271, 11463, 11463, 11463, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 2493, 6589, 6589, 6589, 39357, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 4623, 4623, 4623, 4623, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 1469, 1469, 1469, 1469, 1469, 1469, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 2715, 6811, 6811, 6811, 6811, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 957, 5053, 5053, 21437, 54205, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 995, 995, 995, 995, 33763, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 3005, 3005, 3005, 19389, 19389, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 19, 8211, 24595, 24595, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 3005, 7101, 7101, 7101, 7101, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 2279, 2279, 2279, 18663, 51431, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 1981, 1981, 1981, 34749, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 3571, 3571, 3571, 3571, 0},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 6077, 14269, 14269, 47037, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 2891, 2891, 19275, 52043, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 2109, 6205, 14397, 14397, 47165, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 7679, 7679, 7679, 7679, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 2109, 2109, 2109, 2109, 34877, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 5063, 5063, 5063, 5063, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 61, 61, 16445, 16445, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 707, 4803, 12995, 29379, 62147, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 3133, 3133, 11325, 27709, 60477, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 3823, 3823, 3823, 20207, 20207, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 5181, 5181, 5181, 5181, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 7379, 7379, 7379, 40147, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 1085, 9277, 9277, 9277, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 619, 4715, 12907, 29291, 62059, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 2621, 6717, 14909, 14909, 14909, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 791, 8983, 25367, 58135, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 4669, 4669, 4669, 37437, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 479, 4575, 4575, 4575, 37343, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 573, 8765, 25149, 25149, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 2605, 6701, 6701, 6701, 39469, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 7741, 7741, 24125, 24125, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 4671, 4671, 4671, 4671, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 7741, 15933, 15933, 15933, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 755, 755, 755, 755, 755, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 1597, 5693, 5693, 5693, 38461, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 955, 955, 17339, 50107, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 317, 317, 317, 8509, 24893, 24893, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 3679, 11871, 11871, 44639, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 7485, 15677, 32061, 64829, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 971, 9163, 9163, 41931, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 7485, 7485, 7485, 40253, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 4999, 13191, 13191, 45959, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 1341, 1341, 1341, 1341, 1341, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 1911, 1911, 1911, 1911, 1911, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 2877, 2877, 11069, 11069, 11069, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 1715, 5811, 14003, 14003, 46771, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 2877, 6973, 15165, 15165, 47933, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 1293, 5389, 13581, 13581, 13581, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 829, 9021, 25405, 58173, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 6327, 14519, 14519, 47287, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 4925, 4925, 21309, 54077, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 655, 4751, 4751, 21135, 21135, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 3901, 3901, 20285, 20285, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 539, 4635, 12827, 29211, 61979, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 1853, 1853, 10045, 26429, 59197, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 6995, 6995, 23379, 56147, 0},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 1853, 5949, 14141, 14141, 46909, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 1959, 6055, 6055, 22439, 22439, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 1277, 5373, 5373, 21757, 54525, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 1023, 1023, 9215, 25599, 58367, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 1277, 1277, 9469, 9469, 9469, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 2701, 2701, 10893, 27277, 60045, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 6397, 14589, 30973, 30973, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 723, 723, 723, 723, 33491, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 253, 2301, 2301, 2301, 18685, 18685, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 3179, 3179, 11371, 27755, 27755, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 1789, 1789, 9981, 26365, 26365, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 3887, 7983, 16175, 32559, 32559, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 1789, 3837, 3837, 12029, 12029, 44797, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 4011, 12203, 28587, 61355, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 2813, 6909, 15101, 31485, 64253, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 3515, 7611, 7611, 23995, 23995, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 2813, 2813, 11005, 11005, 43773, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 3279, 7375, 7375, 23759, 56527, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 3581, 7677, 15869, 15869, 15869, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 1639, 5735, 5735, 22119, 22119, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 509, 509, 509, 16893, 49661, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 5055, 5055, 21439, 54207, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 509, 509, 8701, 8701, 41469, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 7027, 7027, 23411, 23411, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 2045, 6141, 6141, 22525, 55293, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 4877, 4877, 21261, 54029, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 8189, 16381, 16381, 49149, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 3215, 11407, 11407, 44175, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 4093, 8189, 8189, 24573, 57341, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 2883, 2883, 11075, 11075, 11075, 0},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 1021, 9213, 9213, 9213, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 3099, 3099, 11291, 27675, 27675, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 1149, 5245, 5245, 21629, 54397, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 2451, 6547, 14739, 14739, 14739, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 1149, 1149, 1149, 17533, 17533, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 5805, 13997, 13997, 46765, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 2173, 2173, 2173, 2173, 34941, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 3277, 3277, 3277, 3277, 36045, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 4221, 12413, 12413, 45181, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 1339, 5435, 13627, 13627, 46395, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 125, 125, 125, 32893, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 6019, 6019, 6019, 6019, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 3709, 3709, 20093, 52861, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 12555, 28939, 28939, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 3709, 11901, 11901, 44669, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 3399, 3399, 3399, 36167, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 2685, 6781, 14973, 31357, 64125, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 599, 599, 16983, 16983, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 637, 4733, 12925, 12925, 12925, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 2643, 2643, 2643, 19027, 51795, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 637, 637, 8829, 8829, 41597, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 2669, 6765, 6765, 6765, 6765, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 3453, 3453, 3453, 3453, 3453, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 51, 51, 8243, 24627, 57395, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 1405, 1405, 1405, 1405, 17789, 50557, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 1591, 9783, 9783, 42551, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 2429, 2429, 10621, 27005, 27005, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 1179, 1179, 1179, 1179, 1179, 33947, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 3965, 3965, 3965, 3965, 36733, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 1883, 1883, 1883, 18267, 51035, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 1917, 6013, 6013, 6013, 6013, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 171, 8363, 8363, 8363, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 2941, 7037, 15229, 15229, 47997, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 3335, 11527, 11527, 11527, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 893, 9085, 25469, 58237, 0},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 4989, 13181, 29565, 29565, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4099, 4099, 20483, 53251, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 653, 4749, 4749, 21133, 53901, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 1227, 5323, 5323, 5323, 5323, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 653, 4749, 12941, 12941, 45709, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 5255, 13447, 29831, 29831, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 2701, 2701, 10893, 10893, 10893, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 119, 119, 119, 16503, 49271, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 1165, 9357, 25741, 25741, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 1407, 1407, 9599, 9599, 9599, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 1165, 1165, 1165, 1165, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 435, 435, 435, 16819, 49587, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 1165, 5261, 5261, 5261, 38029, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 7693, 7693, 24077, 24077, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 3213, 3213, 3213, 19597, 52365, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 8119, 16311, 32695, 32695, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 1165, 3213, 7309, 15501, 31885, 64653, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 1423, 5519, 5519, 21903, 21903, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 2189, 6285, 6285, 22669, 22669, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 1133, 1133, 9325, 25709, 25709, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 1933, 6029, 6029, 6029, 38797, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 6911, 6911, 6911, 6911, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 1933, 1933, 1933, 18317, 51085, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 139, 4235, 12427, 12427, 12427, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 3981, 8077, 8077, 24461, 24461, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 1915, 6011, 14203, 14203, 14203, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 3981, 3981, 3981, 3981, 3981, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 2575, 10767, 27151, 59919, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 909, 9101, 9101, 41869, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 2083, 2083, 18467, 51235, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 7053, 15245, 15245, 15245, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 3027, 11219, 27603, 60371, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 2957, 2957, 2957, 2957, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 1387, 1387, 17771, 17771, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 2957, 11149, 27533, 27533, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 3879, 3879, 3879, 20263, 20263, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 3469, 3469, 3469, 19853, 19853, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 301, 4397, 12589, 28973, 61741, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 397, 397, 4493, 12685, 29069, 29069, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 1343, 5439, 5439, 5439, 5439, 0},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 397, 397, 397, 397, 397, 33165, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 2893, 2893, 2893, 19277, 52045, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 3597, 19981, 52749, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 2355, 2355, 2355, 2355, 35123, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 7693, 7693, 7693, 40461, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 3015, 3015, 11207, 27591, 60359, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 6669, 6669, 6669, 39437, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 1827, 1827, 1827, 18211, 50979, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 525, 525, 8717, 25101, 25101, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 1567, 9759, 26143, 26143, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 3085, 3085, 19469, 19469, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 3675, 3675, 11867, 28251, 61019, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 3085, 3085, 11277, 11277, 11277, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 2839, 6935, 6935, 6935, 6935, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 1037, 1037, 1037, 1037, 33805, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 2527, 2527, 10719, 27103, 27103, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 1037, 1037, 1037, 9229, 25613, 58381, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 1811, 5907, 5907, 5907, 5907, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 2061, 2061, 10253, 10253, 10253, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 6899, 15091, 31475, 31475, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 2061, 6157, 14349, 14349, 47117, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 6221, 14413, 14413, 14413, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 32781, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 7099, 15291, 15291, 48059, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 1805, 1805, 1805, 1805, 34573, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 2989, 7085, 15277, 15277, 15277, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 2829, 6925, 15117, 15117, 47885, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 1471, 1471, 5567, 5567, 21951, 54719, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 4877, 13069, 29453, 29453, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 3131, 7227, 7227, 7227, 39995, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 781, 8973, 8973, 8973, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 1359, 9551, 25935, 25935, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 7437, 15629, 15629, 15629, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 3763, 3763, 3763, 20147, 52915, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 3341, 3341, 11533, 27917, 27917, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 5191, 13383, 13383, 13383, 0},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 1293, 1293, 1293, 9485, 9485, 42253, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 3395, 3395, 19779, 19779, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 717, 717, 717, 717, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 1023, 3071, 7167, 7167, 7167, 7167, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 1741, 1741, 1741, 1741, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 923, 5019, 13211, 13211, 13211, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 3789, 11981, 11981, 44749, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 6867, 15059, 31443, 64211, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 3789, 7885, 16077, 16077, 16077, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 2285, 2285, 2285, 18669, 18669, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 205, 205, 8397, 24781, 57549, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 91, 4187, 12379, 28763, 28763, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 6349, 14541, 30925, 30925, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 1963, 6059, 6059, 6059, 38827, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 6349, 6349, 6349, 6349, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 4583, 12775, 29159, 29159, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 5325, 13517, 13517, 46285, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 587, 587, 8779, 25163, 57931, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 3277, 3277, 3277, 19661, 19661, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 3831, 7927, 7927, 24311, 57079, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 973, 973, 973, 17357, 17357, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 6319, 14511, 14511, 14511, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 973, 3021, 7117, 7117, 23501, 56269, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 2143, 2143, 10335, 10335, 43103, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 1997, 1997, 10189, 26573, 59341, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 461, 4557, 12749, 29133, 61901, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 1151, 1151, 9343, 9343, 9343, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 461, 461, 8653, 8653, 41421, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 1547, 1547, 1547, 17931, 50699, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 461, 461, 461, 16845, 49613, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 2631, 2631, 19015, 19015, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 6605, 14797, 14797, 14797, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 507, 507, 16891, 16891, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 2509, 10701, 27085, 27085, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 1167, 5263, 5263, 21647, 21647, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 1485, 5581, 5581, 5581, 38349, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 1367, 1367, 1367, 1367, 34135, 0},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 1485, 3533, 3533, 3533, 19917, 52685, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 365, 4461, 12653, 29037, 29037, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 2637, 2637, 10829, 10829, 10829, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 6363, 6363, 6363, 39131, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 4685, 4685, 21069, 53837, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 4455, 4455, 4455, 37223, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 4685, 4685, 4685, 4685, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 3757, 11949, 11949, 11949, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 3661, 3661, 11853, 11853, 11853, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 1215, 5311, 5311, 21695, 54463, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 3661, 7757, 15949, 32333, 32333, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 2763, 2763, 2763, 2763, 35531, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 1613, 1613, 1613, 9805, 26189, 58957, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 3387, 3387, 3387, 19771, 52539, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 77, 77, 8269, 24653, 24653, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 439, 439, 439, 439, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 3149, 3149, 3149, 19533, 52301, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 2843, 6939, 6939, 23323, 56091, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 3149, 7245, 15437, 31821, 64589, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 419, 4515, 4515, 4515, 4515, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 2893, 2893, 2893, 2893, 2893, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 2759, 10951, 10951, 43719, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 845, 845, 845, 17229, 49997, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 7107, 7107, 7107, 39875, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 3917, 8013, 8013, 24397, 24397, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 1495, 9687, 26071, 58839, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 6477, 14669, 14669, 47437, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 2583, 6679, 6679, 23063, 23063, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 2381, 2381, 2381, 2381, 35149, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 6191, 14383, 30767, 30767, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 333, 333, 333, 16717, 16717, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 6315, 6315, 22699, 22699, 0},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 3405, 7501, 7501, 23885, 56653, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 2879, 2879, 11071, 27455, 60223, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 173, 173, 173, 16557, 49325, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 2243, 2243, 10435, 10435, 43203, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 3245, 3245, 11437, 27821, 27821, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 1263, 5359, 13551, 13551, 46319, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 3245, 3245, 3245, 3245, 3245, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 1315, 1315, 9507, 25891, 58659, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 1197, 1197, 9389, 9389, 42157, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 2155, 2155, 10347, 10347, 10347, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 7853, 7853, 24237, 57005, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 2111, 2111, 10303, 26687, 59455, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 7853, 16045, 16045, 48813, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 2291, 6387, 6387, 22771, 22771, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 3757, 11949, 28333, 61101, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 1543, 5639, 5639, 5639, 5639, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 5805, 5805, 5805, 5805, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 2491, 6587, 6587, 6587, 6587, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 5805, 13997, 30381, 30381, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 759, 759, 8951, 8951, 8951, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 2477, 10669, 10669, 10669, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 3035, 11227, 27611, 27611, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 1453, 1453, 5549, 13741, 13741, 46509, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 1871, 10063, 26447, 26447, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 1453, 1453, 5549, 5549, 21933, 54701, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 7299, 7299, 23683, 23683, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 2989, 7085, 7085, 7085, 39853, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 2571, 6667, 14859, 31243, 64011, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 941, 941, 941, 9133, 25517, 25517, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 695, 695, 695, 17079, 49847, 0},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 941, 1965, 1965, 1965, 10157, 26541, 26541, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 339, 339, 339, 339, 33107, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 45, 45, 45, 8237, 8237, 8237, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 3683, 7779, 7779, 7779, 7779, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 1069, 1069, 1069, 17453, 17453, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 1739, 5835, 14027, 14027, 46795, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 1069, 1069, 9261, 9261, 9261, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 1671, 1671, 5767, 13959, 30343, 63111, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 45, 1069, 3117, 3117, 11309, 27693, 60461, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 899, 4995, 4995, 21379, 21379, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 2605, 6701, 14893, 14893, 14893, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 4859, 13051, 13051, 45819, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 557, 2605, 6701, 6701, 23085, 23085, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 3511, 7607, 15799, 32183, 64951, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 7725, 15917, 15917, 15917, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 1183, 9375, 9375, 42143, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 7725, 7725, 24109, 24109, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 3667, 3667, 3667, 36435, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 45, 557, 1581, 3629, 3629, 11821, 28205, 28205, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 235, 235, 235, 16619, 16619, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 301, 2349, 6445, 6445, 6445, 39213, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 2063, 10255, 26639, 59407, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 3373, 3373, 3373, 19757, 52525, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 6943, 6943, 6943, 39711, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 301, 1325, 3373, 7469, 15661, 32045, 64813, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 3367, 3367, 3367, 19751, 52519, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 6957, 6957, 6957, 6957, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 743, 743, 4839, 13031, 13031, 45799, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 813, 2861, 6957, 6957, 23341, 56109, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 3885, 12077, 12077, 12077, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 1723, 5819, 5819, 22203, 54971, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 3885, 3885, 20269, 20269, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 3575, 7671, 7671, 7671, 7671, 0},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 7981, 16173, 32557, 32557, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 1999, 10191, 10191, 10191, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 3309, 7405, 15597, 15597, 48365, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 6875, 15067, 15067, 15067, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 1261, 5357, 5357, 5357, 5357, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 915, 9107, 25491, 25491, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 1261, 1261, 9453, 9453, 9453, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 3371, 7467, 7467, 23851, 23851, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 2285, 6381, 6381, 22765, 55533, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 3699, 3699, 3699, 3699, 3699, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 237, 237, 237, 237, 16621, 16621, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 3459, 3459, 19843, 19843, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 1773, 9965, 9965, 42733, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 3651, 7747, 15939, 32323, 32323, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 2797, 6893, 15085, 15085, 15085, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 6231, 14423, 14423, 14423, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 2797, 2797, 2797, 2797, 2797, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 2671, 2671, 2671, 2671, 2671, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 3565, 3565, 11757, 11757, 44525, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 1791, 1791, 9983, 26367, 59135, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 1517, 5613, 13805, 13805, 13805, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 1551, 5647, 5647, 5647, 5647, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 2541, 2541, 10733, 10733, 43501, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 3739, 7835, 7835, 24219, 24219, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 493, 493, 8685, 25069, 25069, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 1311, 9503, 25887, 25887, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 493, 493, 4589, 4589, 20973, 20973, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 807, 4903, 13095, 13095, 45863, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 4077, 4077, 4077, 20461, 20461, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 3419, 7515, 7515, 7515, 7515, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 7149, 7149, 7149, 7149, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 3915, 3915, 3915, 3915, 36683, 0},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 7149, 15341, 31725, 31725, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 1799, 5895, 5895, 22279, 22279, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 7277, 7277, 23661, 23661, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 1147, 1147, 17531, 50299, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 7277, 15469, 15469, 15469, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 823, 823, 9015, 25399, 58167, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 109, 4205, 12397, 28781, 61549, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 6359, 6359, 22743, 22743, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 1645, 5741, 5741, 5741, 5741, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 1815, 1815, 10007, 26391, 59159, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 1645, 1645, 9837, 9837, 9837, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 1327, 1327, 1327, 1327, 34095, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 3693, 7789, 7789, 24173, 56941, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 2835, 2835, 11027, 11027, 11027, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 3693, 3693, 3693, 3693, 36461, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 999, 5095, 13287, 29671, 62439, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 621, 4717, 12909, 29293, 29293, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 1599, 5695, 5695, 5695, 5695, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 621, 621, 8813, 8813, 8813, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 75, 75, 75, 16459, 16459, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 2669, 6765, 14957, 14957, 47725, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 1979, 1979, 1979, 1979, 34747, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 621, 2669, 2669, 2669, 2669, 35437, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 1283, 1283, 1283, 34051, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 1389, 1389, 9581, 25965, 58733, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 2199, 6295, 14487, 14487, 47255, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 1389, 3437, 3437, 11629, 11629, 11629, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 3219, 11411, 27795, 27795, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 2413, 6509, 6509, 6509, 6509, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 6479, 6479, 6479, 39247, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 3949, 8045, 16237, 32621, 65389, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 1679, 5775, 5775, 22159, 22159, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 877, 877, 9069, 25453, 25453, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 5659, 13851, 13851, 46619, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 877, 4973, 13165, 13165, 13165, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 1391, 5487, 13679, 30063, 62831, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 2925, 11117, 11117, 43885, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 1439, 9631, 9631, 42399, 0},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 877, 2925, 7021, 7021, 7021, 39789, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 935, 5031, 5031, 21415, 21415, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 4095, 12287, 12287, 12287, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 2479, 2479, 2479, 2479, 2479, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 7679, 15871, 15871, 15871, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 251, 251, 8443, 8443, 8443, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 511, 2559, 6655, 14847, 14847, 14847, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 747, 4843, 4843, 21227, 53995, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 2815, 11007, 11007, 11007, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 6911, 15103, 15103, 15103, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 139, 139, 139, 139, 139, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 767, 8959, 8959, 8959, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 55, 4151, 4151, 4151, 4151, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 1791, 1791, 5887, 14079, 14079, 14079, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 3027, 7123, 7123, 23507, 56275, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 2303, 10495, 10495, 10495, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 1759, 1759, 9951, 9951, 42719, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 6399, 14591, 14591, 14591, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 1707, 5803, 13995, 30379, 63147, 0},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 1279, 1279, 1279, 9471, 9471, 9471, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 6919, 6919, 6919, 39687, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 1407, 1407, 9599, 25983, 58751, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 3015, 7111, 7111, 23495, 56263, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 3455, 7551, 15743, 32127, 64895, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 2171, 2171, 2171, 18555, 51323, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 383, 2431, 6527, 14719, 31103, 63871, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 2667, 6763, 14955, 14955, 47723, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 8063, 8063, 8063, 8063, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 2839, 2839, 11031, 11031, 11031, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 3967, 12159, 28543, 61311, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 2351, 2351, 2351, 18735, 18735, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 3967, 3967, 3967, 3967, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 1251, 1251, 17635, 50403, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 1919, 1919, 10111, 26495, 59263, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 8167, 16359, 16359, 16359, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 2943, 2943, 11135, 27519, 60287, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 2623, 6719, 6719, 23103, 55871, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 895, 895, 895, 895, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 3003, 3003, 3003, 35771, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 4991, 4991, 4991, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 2767, 2767, 10959, 27343, 60111, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 13183, 29567, 62335, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 2307, 2307, 2307, 2307, 35075, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 2523, 6619, 14811, 31195, 63963, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 2175, 6271, 6271, 6271, 6271, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 103, 103, 8295, 24679, 57447, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 1151, 1151, 1151, 1151, 1151, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 3019, 3019, 11211, 27595, 60363, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 7295, 7295, 7295, 7295, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 3959, 3959, 3959, 20343, 53111, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 639, 8831, 25215, 57983, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 183, 4279, 12471, 28855, 28855, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 4735, 4735, 4735, 4735, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 2703, 6799, 6799, 6799, 39567, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 4735, 12927, 29311, 62079, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 7491, 15683, 32067, 32067, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 3711, 3711, 3711, 3711, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 163, 4259, 12451, 12451, 12451, 0},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 1663, 1663, 1663, 1663, 1663, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 3563, 7659, 7659, 7659, 7659, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 2751, 2751, 10943, 27327, 60095, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 1479, 1479, 9671, 9671, 42439, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 703, 703, 703, 8895, 25279, 58047, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 2831, 6927, 6927, 23311, 56079, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 1727, 1727, 1727, 1727, 1727, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 2771, 2771, 19155, 51923, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 1727, 5823, 14015, 30399, 63167, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 1131, 1131, 9323, 9323, 9323, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 191, 191, 8383, 24767, 57535, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 1839, 1839, 5935, 14127, 14127, 46895, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 6335, 14527, 30911, 63679, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 2323, 6419, 14611, 14611, 14611, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 191, 2239, 2239, 2239, 2239, 2239, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 1963, 1963, 10155, 10155, 42923, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 1215, 1215, 1215, 1215, 1215, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 1267, 5363, 5363, 21747, 21747, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 4031, 8127, 8127, 8127, 8127, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 2223, 2223, 2223, 2223, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 1983, 1983, 10175, 26559, 59327, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 2143, 6239, 6239, 6239, 39007, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 1983, 1983, 6079, 14271, 30655, 63423, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 3007, 7103, 15295, 31679, 64447, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 883, 4979, 4979, 4979, 4979, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 959, 959, 959, 959, 959, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 4227, 4227, 20611, 20611, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 4543, 12735, 29119, 61887, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 1051, 1051, 9243, 9243, 9243, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 447, 447, 447, 447, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 3747, 11939, 11939, 11939, 0},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 2495, 2495, 10687, 27071, 59839, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 423, 423, 8615, 24999, 57767, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 63, 4159, 4159, 20543, 53311, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 1431, 5527, 13719, 13719, 13719, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 2111, 2111, 2111, 18495, 51263, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 3883, 3883, 3883, 20267, 53035, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 1087, 5183, 13375, 13375, 13375, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 2763, 6859, 15051, 15051, 47819, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 4671, 4671, 21055, 53823, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 4535, 12727, 12727, 12727, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 1599, 1599, 5695, 13887, 13887, 13887, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 3307, 3307, 3307, 19691, 19691, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 1343, 1343, 1343, 17727, 50495, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 2099, 2099, 10291, 10291, 43059, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 3391, 7487, 7487, 23871, 56639, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 1039, 1039, 9231, 9231, 9231, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 319, 319, 319, 8511, 8511, 8511, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 2031, 2031, 2031, 2031, 34799, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 3903, 3903, 3903, 20287, 53055, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 3931, 3931, 3931, 3931, 36699, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 1855, 1855, 1855, 18239, 51007, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 5651, 13843, 13843, 13843, 0},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 831, 831, 831, 9023, 9023, 9023, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 3023, 11215, 27599, 60367, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 2399, 6495, 14687, 31071, 31071, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 2867, 6963, 6963, 6963, 39731, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 351, 351, 8543, 24927, 24927, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 1807, 9999, 9999, 9999, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 3423, 7519, 15711, 32095, 32095, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 1315, 5411, 5411, 21795, 54563, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 1375, 1375, 9567, 25951, 25951, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 1055, 1055, 5151, 5151, 21535, 21535, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 863, 4959, 13151, 29535, 29535, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 3163, 7259, 15451, 31835, 31835, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 1887, 5983, 14175, 30559, 30559, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 3659, 3659, 11851, 28235, 61003, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 1887, 3935, 3935, 12127, 28511, 28511, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 759, 4855, 4855, 4855, 4855, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 3167, 7263, 7263, 7263, 40031, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 1199, 5295, 13487, 29871, 62639, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 1119, 1119, 1119, 33887, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 659, 659, 17043, 17043, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 95, 95, 95, 95, 32863, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 3203, 11395, 27779, 27779, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 1631, 5727, 5727, 5727, 38495, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 1607, 1607, 1607, 1607, 34375, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 3679, 3679, 3679, 36447, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 3579, 3579, 3579, 19963, 19963, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 607, 4703, 4703, 4703, 37471, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 2391, 2391, 2391, 18775, 18775, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 2655, 6751, 14943, 31327, 31327, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 339, 4435, 12627, 12627, 45395, 0},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 607, 2655, 2655, 10847, 27231, 27231, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 3495, 7591, 7591, 7591, 7591, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 2015, 2015, 2015, 18399, 18399, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 115, 115, 8307, 8307, 8307, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 4063, 4063, 20447, 20447, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 315, 315, 16699, 49467, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 4063, 12255, 12255, 45023, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 631, 4727, 12919, 29303, 29303, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 8159, 8159, 24543, 24543, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 2127, 2127, 10319, 10319, 43087, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 479, 479, 479, 8671, 8671, 41439, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 1935, 1935, 10127, 26511, 26511, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 1503, 9695, 9695, 42463, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 5279, 5279, 5279, 38047, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 735, 4831, 13023, 13023, 45791, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 155, 4251, 12443, 28827, 61595, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 735, 4831, 4831, 21215, 21215, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 2519, 2519, 10711, 10711, 10711, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 6879, 6879, 23263, 23263, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 2847, 11039, 11039, 43807, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 2783, 2783, 19167, 19167, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 1899, 5995, 5995, 22379, 55147, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 3295, 7391, 15583, 15583, 48351, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 2531, 2531, 10723, 27107, 59875, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 1247, 5343, 13535, 13535, 46303, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 1195, 5291, 5291, 21675, 21675, 0},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 2271, 2271, 10463, 10463, 43231, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 6407, 6407, 6407, 6407, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 31, 31, 4127, 12319, 12319, 45087, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 7555, 15747, 32131, 32131, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 1567, 1567, 17951, 17951, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 2827, 6923, 6923, 6923, 39691, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 543, 543, 8735, 8735, 41503, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 2135, 2135, 2135, 2135, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 2591, 10783, 10783, 43551, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 2719, 2719, 10911, 27295, 27295, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 2591, 2591, 18975, 18975, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 83, 83, 8275, 8275, 41043, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 6687, 6687, 23071, 23071, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 3239, 7335, 7335, 23719, 23719, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 2335, 6431, 6431, 22815, 22815, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 6343, 6343, 6343, 6343, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 287, 287, 287, 287, 16671, 16671, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 2939, 7035, 15227, 15227, 15227, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 1311, 1311, 9503, 9503, 42271, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 807, 807, 807, 807, 33575, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 6943, 15135, 15135, 47903, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 2731, 2731, 2731, 19115, 51883, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 1823, 5919, 14111, 14111, 46879, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 6643, 14835, 31219, 31219, 0},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 1823, 3871, 7967, 16159, 16159, 48927, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 187, 2235, 6331, 14523, 30907, 30907, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 1695, 9887, 26271, 26271, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 1991, 1991, 10183, 10183, 10183, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 3743, 3743, 3743, 3743, 36511, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 1731, 1731, 1731, 1731, 34499, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 671, 671, 671, 671, 33439, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 411, 411, 8603, 8603, 41371, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 671, 2719, 6815, 15007, 31391, 31391, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 1643, 1643, 1643, 1643, 34411, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 3231, 7327, 15519, 31903, 31903, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 603, 603, 8795, 25179, 57947, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 1183, 1183, 9375, 25759, 25759, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 999, 999, 999, 17383, 50151, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 159, 2207, 2207, 2207, 2207, 34975, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 1779, 5875, 14067, 30451, 30451, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 927, 927, 9119, 25503, 25503, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 2199, 2199, 2199, 2199, 34967, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 927, 5023, 13215, 29599, 29599, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 8035, 16227, 16227, 16227, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 927, 2975, 2975, 2975, 2975, 35743, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 7315, 7315, 23699, 23699, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 1951, 1951, 1951, 1951, 34719, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 6091, 6091, 22475, 55243, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 1951, 1951, 10143, 26527, 26527, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 1927, 1927, 1927, 1927, 34695, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 3999, 3999, 12191, 28575, 28575, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 2383, 10575, 10575, 43343, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 415, 2463, 6559, 6559, 6559, 39327, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 2119, 6215, 14407, 30791, 63559, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 3487, 7583, 7583, 7583, 40351, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 1879, 1879, 5975, 14167, 14167, 14167, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 3487, 3487, 11679, 28063, 28063, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 1391, 1391, 1391, 17775, 50543, 0},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 415, 1439, 1439, 5535, 13727, 30111, 30111, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 3923, 3923, 12115, 12115, 44883, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 2479, 2479, 10671, 27055, 59823, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 819, 9011, 25395, 58163, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 2479, 6575, 14767, 31151, 63919, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 455, 455, 8647, 8647, 41415, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 431, 431, 8623, 25007, 57775, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 4731, 4731, 4731, 4731, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 7599, 7599, 7599, 7599, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 1947, 1947, 1947, 18331, 18331, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 1455, 3503, 7599, 15791, 32175, 64943, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 3799, 3799, 11991, 28375, 61143, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 2991, 11183, 27567, 60335, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 7443, 15635, 32019, 32019, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 7087, 7087, 7087, 7087, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 939, 939, 9131, 25515, 58283, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 1967, 1967, 10159, 26543, 59311, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 5707, 5707, 5707, 38475, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 4015, 8111, 8111, 8111, 8111, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 443, 4539, 4539, 20923, 20923, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 3247, 7343, 15535, 31919, 64687, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 3735, 3735, 3735, 3735, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 3247, 3247, 11439, 27823, 60591, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 2403, 6499, 6499, 22883, 22883, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 1199, 1199, 1199, 1199, 1199, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 6759, 6759, 6759, 39527, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 2223, 10415, 26799, 59567, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 1907, 6003, 6003, 22387, 22387, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 2223, 6319, 6319, 6319, 6319, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 4555, 12747, 12747, 12747, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 175, 175, 175, 175, 175, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 1399, 5495, 13687, 13687, 46455, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 1711, 1711, 1711, 1711, 1711, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 1607, 3655, 7751, 15943, 32327, 32327, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 3759, 7855, 16047, 32431, 65199, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 2743, 2743, 2743, 2743, 0},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 687, 4783, 12975, 29359, 62127, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 879, 879, 17263, 50031, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 303, 8495, 8495, 41263, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 2811, 6907, 15099, 31483, 64251, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 4399, 4399, 20783, 20783, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 2115, 10307, 10307, 10307, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 3375, 3375, 11567, 11567, 44335, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 1443, 9635, 26019, 26019, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 1583, 5679, 5679, 22063, 22063, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 3123, 3123, 11315, 27699, 60467, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 1583, 1583, 9775, 9775, 42543, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 6795, 6795, 23179, 55947, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 1583, 3631, 7727, 7727, 24111, 24111, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 7547, 23931, 56699, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 559, 559, 16943, 16943, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 471, 4567, 4567, 20951, 53719, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 2607, 6703, 14895, 14895, 47663, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 1319, 1319, 1319, 1319, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 3119, 11311, 11311, 44079, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 4579, 4579, 4579, 37347, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 2095, 10287, 10287, 43055, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 4083, 8179, 8179, 8179, 8179, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 6191, 14383, 14383, 47151, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 263, 263, 8455, 24839, 57607, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 47, 47, 47, 16431, 16431, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 1527, 5623, 5623, 22007, 54775, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 47, 4143, 12335, 12335, 45103, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 4047, 12239, 28623, 61391, 0},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 47, 4143, 4143, 20527, 20527, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 3075, 7171, 7171, 23555, 56323, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 1263, 5359, 5359, 5359, 38127, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 1323, 1323, 5419, 5419, 5419, 5419, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 1263, 5359, 13551, 29935, 29935, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 2919, 7015, 7015, 23399, 56167, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 2287, 10479, 26863, 26863, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 203, 8395, 24779, 24779, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 239, 239, 239, 239, 33007, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 3663, 3663, 11855, 11855, 44623, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 3823, 3823, 12015, 28399, 28399, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 1275, 9467, 25851, 25851, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 3823, 3823, 3823, 3823, 36591, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 2999, 2999, 19383, 19383, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 2799, 6895, 6895, 6895, 39663, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 2131, 6227, 6227, 22611, 55379, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 2543, 10735, 27119, 27119, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 1163, 1163, 1163, 17547, 17547, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 2543, 2543, 2543, 35311, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 199, 8391, 24775, 57543, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 495, 4591, 12783, 29167, 29167, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 1079, 5175, 5175, 5175, 5175, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 495, 495, 8687, 25071, 25071, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 451, 4547, 12739, 29123, 61891, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 3567, 3567, 11759, 28143, 28143, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 1691, 5787, 5787, 5787, 5787, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 3567, 7663, 7663, 7663, 40431, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 3107, 7203, 15395, 15395, 48163, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 5615, 13807, 30191, 30191, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 807, 2855, 6951, 15143, 31527, 31527, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 1007, 5103, 5103, 5103, 37871, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 1371, 5467, 5467, 21851, 21851, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 1007, 5103, 13295, 29679, 29679, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 23, 4119, 4119, 4119, 4119, 0},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 4079, 8175, 16367, 32751, 32751, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 463, 4559, 4559, 4559, 4559, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 623, 623, 8815, 8815, 8815, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 803, 4899, 13091, 13091, 45859, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 623, 2671, 2671, 10863, 10863, 10863, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 3691, 7787, 15979, 32363, 65131, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 1135, 5231, 5231, 21615, 54383, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 7595, 15787, 32171, 32171, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 2159, 2159, 2159, 18543, 51311, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8199, 8199, 40967, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 4207, 4207, 20591, 53359, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 4027, 4027, 4027, 20411, 53179, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 111, 111, 4207, 12399, 12399, 12399, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 5367, 5367, 5367, 38135, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 4975, 4975, 21359, 54127, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 7643, 15835, 15835, 48603, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 879, 879, 9071, 9071, 9071, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 1891, 1891, 1891, 18275, 18275, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 2927, 2927, 11119, 11119, 11119, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 2603, 6699, 6699, 23083, 55851, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 3951, 8047, 8047, 24431, 57199, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 2691, 2691, 2691, 2691, 2691, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 2415, 2415, 10607, 10607, 10607, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 3083, 11275, 11275, 11275, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 4463, 4463, 20847, 53615, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 3067, 3067, 11259, 11259, 44027, 0},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 367, 4463, 12655, 12655, 12655, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 1207, 5303, 13495, 29879, 29879, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 3855, 12047, 12047, 12047, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 919, 5015, 13207, 13207, 45975, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 1807, 1807, 1807, 18191, 50959, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 1939, 6035, 6035, 6035, 6035, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 1295, 1295, 1295, 17679, 50447, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 2483, 2483, 2483, 2483, 35251, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 271, 4367, 12559, 12559, 12559, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 3355, 3355, 3355, 3355, 3355, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 2319, 2319, 10511, 10511, 10511, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 6311, 6311, 22695, 22695, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 6671, 14863, 14863, 14863, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 3635, 3635, 3635, 20019, 52787, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 4623, 12815, 12815, 12815, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 1915, 3963, 8059, 16251, 32635, 32635, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 4623, 4623, 21007, 53775, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 2103, 2103, 10295, 26679, 59447, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 3599, 3599, 3599, 19983, 52751, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 2715, 2715, 10907, 10907, 10907, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 15, 4111, 4111, 20495, 53263, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 3095, 11287, 27671, 60439, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 3087, 3087, 19471, 52239, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 7355, 15547, 15547, 15547, 0},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 7183, 15375, 15375, 15375, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 1539, 3587, 7683, 15875, 32259, 65027, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 1423, 1423, 1423, 1423, 34191, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 307, 307, 16691, 49459, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 399, 2447, 6543, 14735, 31119, 31119, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 3283, 11475, 11475, 44243, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 1935, 6031, 14223, 30607, 30607, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 427, 427, 16811, 16811, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 1935, 6031, 6031, 6031, 38799, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 2023, 2023, 2023, 18407, 51175, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 2959, 2959, 2959, 2959, 35727, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 5195, 13387, 13387, 13387, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 143, 4239, 12431, 28815, 28815, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 475, 475, 475, 475, 33243, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 2191, 2191, 2191, 2191, 34959, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 1579, 1579, 9771, 26155, 58923, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 1167, 5263, 5263, 5263, 38031, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 903, 903, 903, 33671, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 1167, 3215, 7311, 15503, 31887, 31887, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 1667, 5763, 13955, 13955, 13955, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 655, 2703, 2703, 10895, 27279, 27279, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 3143, 7239, 15431, 31815, 64583, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 3727, 11919, 28303, 28303, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 4951, 13143, 13143, 13143, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 3727, 7823, 16015, 32399, 32399, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 2211, 2211, 18595, 18595, 0},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 1679, 1679, 1679, 1679, 34447, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 2899, 11091, 27475, 60243, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 2639, 6735, 14927, 14927, 47695, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 2443, 2443, 10635, 10635, 10635, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 591, 591, 8783, 8783, 41551, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 2359, 2359, 10551, 10551, 43319, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 591, 4687, 12879, 12879, 45647, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 3267, 7363, 7363, 23747, 56515, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 7247, 7247, 23631, 23631, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 1783, 5879, 5879, 5879, 5879, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 3151, 11343, 11343, 44111, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 3279, 3279, 11471, 27855, 60623, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 5967, 14159, 14159, 46927, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 1683, 1683, 1683, 1683, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 847, 847, 4943, 13135, 13135, 45903, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 2179, 2179, 10371, 10371, 10371, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 5455, 13647, 13647, 46415, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 6323, 6323, 6323, 39091, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 335, 335, 8527, 8527, 41295, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 3415, 3415, 3415, 19799, 19799, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 2383, 2383, 18767, 18767, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 5459, 13651, 30035, 62803, 0},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 335, 2383, 6479, 14671, 14671, 47439, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 3051, 7147, 15339, 31723, 64491, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 207, 207, 207, 207, 207, 207, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 219, 4315, 4315, 20699, 53467, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 1231, 5327, 13519, 29903, 62671, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 1139, 1139, 9331, 25715, 25715, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 1231, 1231, 1231, 1231, 1231, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 715, 715, 17099, 49867, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 207, 1231, 1231, 1231, 9423, 25807, 58575, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 647, 647, 647, 647, 647, 17031, 49799, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 719, 719, 719, 719, 719, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 1787, 1787, 1787, 1787, 18171, 50939, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 7887, 16079, 32463, 65231, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 795, 4891, 4891, 4891, 37659, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 7887, 7887, 7887, 7887, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 599, 4695, 12887, 29271, 29271, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 3791, 3791, 3791, 3791, 3791, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 6563, 6563, 22947, 22947, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 1743, 5839, 14031, 30415, 63183, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 2643, 6739, 14931, 31315, 64083, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 1743, 1743, 1743, 9935, 26319, 59087, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 1703, 9895, 9895, 9895, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 1487, 1487, 1487, 1487, 1487, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 1675, 1675, 9867, 26251, 59019, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 2511, 2511, 2511, 2511, 2511, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 3539, 7635, 15827, 15827, 48595, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 2511, 6607, 14799, 31183, 63951, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 875, 4971, 4971, 4971, 37739, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 2511, 6607, 6607, 6607, 6607, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 295, 2343, 6439, 14631, 31015, 63783, 0},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 1999, 1999, 1999, 1999, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 171, 4267, 4267, 4267, 4267, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 6039, 6039, 22423, 22423, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 3795, 7891, 16083, 32467, 32467, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 1943, 1943, 18327, 18327, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 2599, 2599, 18983, 51751, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 1431, 5527, 5527, 21911, 54679, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 243, 8435, 24819, 57587, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 1431, 1431, 1431, 17815, 50583, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 3591, 3591, 11783, 11783, 11783, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 7831, 7831, 7831, 7831, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 5083, 5083, 21467, 54235, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 3735, 11927, 28311, 61079, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 2403, 2403, 10595, 10595, 43363, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 1687, 1687, 9879, 26263, 59031, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 5163, 13355, 13355, 46123, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 1175, 1175, 9367, 25751, 25751, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 523, 523, 523, 16907, 16907, 0},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 1175, 3223, 7319, 15511, 31895, 31895, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 6839, 15031, 31415, 64183, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 2327, 6423, 6423, 22807, 22807, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 1383, 1383, 5479, 5479, 21863, 21863, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 791, 791, 17175, 49943, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 2811, 2811, 2811, 2811, 2811, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 791, 791, 4887, 13079, 13079, 13079, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 6211, 6211, 22595, 55363, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 3863, 7959, 16151, 16151, 16151, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 3867, 7963, 7963, 24347, 24347, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 1047, 1047, 9239, 25623, 58391, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 3783, 11975, 28359, 28359, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 3095, 7191, 7191, 7191, 7191, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 2615, 6711, 6711, 6711, 39479, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 2203, 6299, 14491, 30875, 30875, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 23, 4119, 12311, 28695, 61463, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 547, 4643, 4643, 21027, 21027, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 6167, 14359, 30743, 63511, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 8043, 8043, 24427, 24427, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 23, 2071, 6167, 6167, 6167, 6167, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 1319, 5415, 13607, 29991, 62759, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 1559, 3607, 7703, 7703, 7703, 40471, 0},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 2583, 2583, 2583, 2583, 35351, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 4083, 4083, 12275, 28659, 61427, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 2775, 2775, 2775, 2775, 2775, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 1651, 5747, 13939, 13939, 46707, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 727, 727, 727, 727, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 1851, 5947, 5947, 22331, 55099, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 3287, 3287, 3287, 3287, 36055, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 1603, 1603, 1603, 17987, 50755, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 215, 8407, 24791, 24791, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 6359, 14551, 30935, 30935, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 1771, 1771, 9963, 26347, 26347, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 3031, 7127, 15319, 15319, 48087, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 1163, 1163, 5259, 13451, 13451, 46219, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 983, 983, 983, 17367, 17367, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 4987, 13179, 13179, 45947, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 983, 983, 9175, 9175, 41943, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 1079, 1079, 9271, 25655, 58423, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 2519, 6615, 14807, 14807, 14807, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 683, 683, 17067, 17067, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 471, 2519, 6615, 6615, 22999, 55767, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 1255, 5351, 13543, 29927, 62695, 0},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 5591, 13783, 13783, 13783, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 499, 4595, 12787, 29171, 61939, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 3159, 3159, 11351, 27735, 60503, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 1731, 3779, 3779, 3779, 3779, 3779, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 2135, 10327, 26711, 59479, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 211, 211, 8403, 24787, 24787, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 1623, 1623, 1623, 9815, 26199, 26199, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 3499, 3499, 3499, 3499, 36267, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 343, 4439, 4439, 20823, 20823, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 1891, 5987, 14179, 14179, 46947, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 1367, 1367, 9559, 9559, 42327, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 4043, 8139, 8139, 24523, 24523, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 3415, 7511, 7511, 23895, 23895, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 6203, 6203, 6203, 6203, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 2903, 6999, 6999, 23383, 56151, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 7179, 7179, 23563, 56331, 0},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 4951, 4951, 21335, 54103, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 2371, 2371, 18755, 51523, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 3383, 7479, 7479, 23863, 23863, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 1895, 5991, 5991, 22375, 55143, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 311, 4407, 12599, 12599, 45367, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 2675, 2675, 2675, 35443, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 311, 311, 311, 311, 16695, 16695, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 3275, 3275, 11467, 11467, 44235, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 1847, 1847, 1847, 18231, 50999, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 251, 2299, 2299, 10491, 10491, 43259, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 2871, 2871, 2871, 19255, 52023, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 6051, 14243, 14243, 47011, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 823, 823, 4919, 13111, 13111, 13111, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 1107, 5203, 5203, 5203, 5203, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 2187, 2187, 2187, 2187, 34955, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 55, 55, 55, 8247, 24631, 57399, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 3271, 11463, 27847, 60615, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 4663, 12855, 29239, 29239, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 19, 19, 8211, 8211, 40979, 0},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 1591, 1591, 1591, 34359, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 3259, 3259, 19643, 52411, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 4023, 12215, 12215, 44983, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 4403, 12595, 12595, 12595, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 1975, 4023, 8119, 16311, 16311, 49079, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 967, 5063, 5063, 21447, 54215, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 951, 951, 9143, 9143, 41911, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 619, 4715, 12907, 12907, 12907, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 951, 951, 951, 17335, 17335, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 2087, 2087, 18471, 18471, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 1463, 1463, 5559, 5559, 21943, 54711, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 3299, 3299, 3299, 19683, 19683, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 439, 439, 8631, 8631, 8631, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 1099, 1099, 1099, 1099, 17483, 50251, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 695, 2743, 2743, 10935, 27319, 60087, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 2915, 2915, 2915, 35683, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 3767, 7863, 7863, 7863, 7863, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 971, 9163, 25547, 25547, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 183, 4279, 4279, 4279, 37047, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 1715, 5811, 14003, 30387, 30387, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 6327, 6327, 6327, 39095, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 2043, 2043, 10235, 26619, 26619, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 183, 2231, 2231, 10423, 26807, 26807, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 1347, 5443, 13635, 30019, 62787, 0},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 3255, 11447, 27831, 27831, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 2899, 6995, 6995, 6995, 6995, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 2167, 6263, 6263, 6263, 6263, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 7803, 7803, 24187, 56955, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 1143, 9335, 25719, 58487, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 2971, 2971, 2971, 35739, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 1143, 1143, 5239, 5239, 5239, 5239, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 291, 291, 8483, 24867, 24867, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 3703, 3703, 11895, 28279, 28279, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 3315, 7411, 7411, 23795, 56563, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 1655, 3703, 7799, 7799, 7799, 40567, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 2635, 6731, 6731, 23115, 23115, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 1399, 3447, 3447, 11639, 11639, 44407, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 5779, 13971, 30355, 63123, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 375, 4471, 4471, 20855, 20855, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 7027, 7027, 7027, 39795, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 375, 375, 375, 16759, 16759, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 3463, 3463, 3463, 3463, 3463, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 6519, 14711, 14711, 47479, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 1911, 1911, 10103, 10103, 10103, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 2555, 6651, 14843, 31227, 63995, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 2935, 2935, 11127, 11127, 11127, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 1699, 1699, 9891, 9891, 42659, 0},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 887, 887, 887, 887, 17271, 50039, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 2471, 10663, 27047, 59815, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 1783, 3831, 3831, 3831, 3831, 3831, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 1139, 5235, 5235, 5235, 38003, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 4343, 12535, 28919, 28919, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 1971, 1971, 1971, 10163, 26547, 26547, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 247, 247, 247, 33015, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 12555, 12555, 45323, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 247, 8439, 24823, 24823, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 3399, 3399, 19783, 19783, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 2295, 2295, 2295, 2295, 35063, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 1091, 9283, 25667, 58435, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 1271, 5367, 13559, 29943, 29943, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 2467, 10659, 10659, 43427, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 1271, 3319, 7415, 7415, 7415, 40183, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 5799, 5799, 22183, 54951, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 3575, 3575, 3575, 19959, 52727, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 3603, 7699, 15891, 15891, 48659, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 503, 503, 503, 16887, 49655, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 1355, 5451, 5451, 5451, 38219, 0},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 503, 2551, 2551, 2551, 18935, 51703, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4099, 4099, 4099, 4099, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 455, 2503, 2503, 10695, 10695, 43463, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 3943, 3943, 12135, 12135, 12135, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 1479, 5575, 5575, 21959, 21959, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 5255, 13447, 13447, 46215, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 3527, 7623, 15815, 15815, 48583, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 4483, 12675, 12675, 45443, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 967, 3015, 3015, 11207, 11207, 11207, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 839, 2887, 2887, 2887, 19271, 52039, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 4039, 4039, 4039, 20423, 53191, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 1307, 1307, 1307, 34075, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 967, 1991, 1991, 1991, 1991, 18375, 51143, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 3155, 3155, 11347, 27731, 27731, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 199, 199, 199, 199, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 2083, 2083, 2083, 2083, 2083, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 2247, 2247, 2247, 2247, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 1387, 1387, 1387, 34155, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 1735, 1735, 1735, 1735, 34503, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 2067, 6163, 6163, 22547, 55315, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 1735, 5831, 5831, 5831, 38599, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 231, 4327, 12519, 28903, 61671, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 6855, 15047, 31431, 31431, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 1523, 5619, 13811, 13811, 46579, 0},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 711, 4807, 12999, 29383, 29383, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 5307, 13499, 13499, 46267, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 1863, 5959, 5959, 22343, 55111, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 2667, 2667, 2667, 19051, 19051, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 839, 1863, 1863, 5959, 14151, 14151, 14151, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 4135, 12327, 12327, 45095, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 327, 4423, 4423, 20807, 20807, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 1627, 3675, 3675, 11867, 11867, 11867, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 2375, 2375, 10567, 10567, 43335, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 2475, 2475, 2475, 18859, 51627, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 1351, 5447, 13639, 13639, 46407, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 1031, 5127, 5127, 21511, 21511, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 2631, 6727, 6727, 6727, 39495, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 3443, 7539, 15731, 32115, 64883, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 583, 583, 8775, 25159, 25159, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 3715, 7811, 16003, 16003, 48771, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 1095, 9287, 25671, 58439, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 3763, 3763, 3763, 3763, 3763, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 1095, 5191, 5191, 5191, 5191, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 2059, 6155, 6155, 6155, 38923, 0},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 71, 4167, 4167, 4167, 4167, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 2587, 2587, 2587, 18971, 18971, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 1159, 9351, 9351, 42119, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 5939, 5939, 22323, 22323, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 2183, 6279, 6279, 22663, 22663, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 6867, 15059, 15059, 15059, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 391, 2439, 2439, 2439, 2439, 2439, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 3687, 3687, 11879, 28263, 28263, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 2951, 2951, 11143, 27527, 27527, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 1547, 1547, 1547, 1547, 1547, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 903, 903, 9095, 25479, 25479, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 4931, 4931, 4931, 37699, 0},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 3975, 3975, 12167, 28551, 28551, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 1051, 5147, 5147, 21531, 54299, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 3591, 3591, 3591, 19975, 52743, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 6363, 6363, 22747, 22747, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 2567, 6663, 14855, 14855, 14855, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 3187, 3187, 11379, 27763, 60531, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 519, 519, 519, 16903, 49671, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 3971, 3971, 12163, 12163, 44931, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 3079, 7175, 15367, 15367, 48135, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 3139, 7235, 7235, 7235, 40003, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 6151, 14343, 14343, 47111, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 595, 4691, 12883, 29267, 29267, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 2055, 2055, 18439, 18439, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 3307, 7403, 15595, 15595, 48363, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 6919, 15111, 31495, 31495, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 2099, 6195, 6195, 22579, 22579, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 775, 4871, 13063, 29447, 29447, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 379, 2427, 2427, 10619, 27003, 27003, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 1799, 1799, 1799, 1799, 1799, 34567, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 1491, 5587, 13779, 13779, 13779, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 5383, 13575, 29959, 62727, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 1355, 3403, 3403, 11595, 27979, 60747, 0},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 5383, 5383, 5383, 5383, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 871, 2919, 7015, 15207, 15207, 15207, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 1315, 1315, 9507, 9507, 9507, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 4455, 12647, 12647, 45415, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 3659, 7755, 7755, 7755, 7755, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 2407, 2407, 2407, 18791, 18791, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 2491, 6587, 6587, 22971, 55739, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 2663, 6759, 14951, 31335, 31335, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 355, 4451, 4451, 20835, 53603, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 615, 615, 615, 33383, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 4755, 12947, 12947, 45715, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 1127, 5223, 13415, 29799, 62567, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 2075, 2075, 10267, 26651, 59419, 0},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 1127, 3175, 3175, 3175, 3175, 3175, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 4075, 4075, 20459, 20459, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 5607, 5607, 21991, 21991, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 1243, 9435, 25819, 25819, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 4583, 4583, 20967, 20967, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 1739, 5835, 14027, 30411, 30411, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 4071, 12263, 12263, 12263, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 1291, 5387, 13579, 29963, 62731, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 2279, 2279, 10471, 26855, 59623, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 1403, 5499, 5499, 21883, 21883, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 2279, 6375, 6375, 6375, 6375, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 1987, 1987, 1987, 10179, 26563, 26563, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 3303, 7399, 7399, 7399, 7399, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 2515, 2515, 2515, 2515, 2515, 0},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 3815, 7911, 7911, 7911, 40679, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 2035, 6131, 6131, 6131, 38899, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 2599, 10791, 10791, 10791, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 2779, 6875, 15067, 31451, 64219, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 1575, 1575, 5671, 5671, 22055, 54823, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 3899, 12091, 12091, 44859, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 1063, 5159, 5159, 21543, 21543, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 2331, 6427, 14619, 14619, 47387, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 3111, 3111, 11303, 11303, 44071, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 3819, 7915, 7915, 7915, 7915, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 1831, 1831, 10023, 26407, 26407, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 2499, 6595, 14787, 31171, 31171, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 3367, 7463, 7463, 7463, 7463, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 1043, 1043, 9235, 25619, 58387, 0},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 295, 295, 4391, 4391, 4391, 4391, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 3915, 3915, 3915, 20299, 20299, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 167, 167, 167, 16551, 16551, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 1331, 5427, 13619, 30003, 30003, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 167, 4263, 12455, 12455, 45223, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 907, 907, 907, 907, 907, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 1191, 1191, 1191, 17575, 17575, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 2851, 6947, 15139, 15139, 15139, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 3239, 7335, 15527, 15527, 48295, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 6355, 6355, 6355, 6355, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 1703, 1703, 18087, 50855, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 1283, 1283, 1283, 17667, 17667, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 3495, 7591, 15783, 32167, 64935, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 3219, 11411, 11411, 44179, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 3495, 3495, 3495, 3495, 3495, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 555, 4651, 4651, 21035, 21035, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 423, 423, 423, 423, 423, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 371, 371, 371, 16755, 49523, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 2471, 2471, 2471, 2471, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 59, 8251, 24635, 24635, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 423, 2471, 6567, 14759, 31143, 63911, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 643, 643, 643, 643, 33411, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 1959, 6055, 14247, 30631, 30631, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 1019, 1019, 9211, 9211, 9211, 0},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 2983, 7079, 15271, 31655, 31655, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 3235, 7331, 15523, 31907, 64675, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 1755, 1755, 9947, 9947, 9947, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 1419, 1419, 1419, 1419, 1419, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 1755, 3803, 7899, 7899, 24283, 24283, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 635, 635, 635, 635, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 3291, 7387, 15579, 31963, 64731, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 1115, 5211, 5211, 5211, 5211, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 3291, 3291, 3291, 3291, 3291, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 1763, 3811, 3811, 3811, 3811, 36579, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 2267, 2267, 18651, 18651, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 243, 243, 243, 243, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 5083, 13275, 13275, 13275, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 3035, 3035, 19419, 19419, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 5163, 5163, 21547, 21547, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 8155, 16347, 32731, 65499, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 1155, 1155, 1155, 1155, 1155, 0},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 7643, 7643, 24027, 24027, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 675, 2723, 6819, 15011, 31395, 31395, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 1115, 1115, 9307, 25691, 58459, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 1635, 1635, 1635, 18019, 18019, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 91, 91, 8283, 8283, 41051, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 2163, 2163, 2163, 18547, 18547, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 91, 2139, 2139, 10331, 10331, 10331, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 2363, 2363, 10555, 10555, 43323, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 603, 603, 2651, 6747, 14939, 31323, 31323, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 5539, 13731, 30115, 30115, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 2907, 2907, 11099, 11099, 11099, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 483, 483, 483, 483, 33251, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 859, 859, 9051, 9051, 41819, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 3243, 7339, 15531, 15531, 15531, 0},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 3931, 8027, 8027, 8027, 40795, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 2379, 2379, 2379, 18763, 18763, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 7067, 7067, 7067, 39835, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 1411, 5507, 5507, 5507, 5507, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 1435, 5531, 13723, 30107, 62875, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 1275, 5371, 13563, 29947, 29947, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 667, 2715, 6811, 15003, 15003, 15003, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 4987, 4987, 21371, 21371, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 3739, 7835, 16027, 32411, 32411, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 363, 363, 363, 8555, 8555, 8555, 0},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 155, 155, 155, 155, 8347, 24731, 57499, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 683, 8875, 8875, 41643, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 1819, 5915, 14107, 14107, 14107, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 4883, 13075, 29459, 29459, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 1051, 3099, 3099, 3099, 19483, 19483, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 6203, 14395, 30779, 63547, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 2587, 6683, 6683, 23067, 23067, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 2739, 2739, 10931, 10931, 43699, 0},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 539, 539, 539, 8731, 8731, 8731, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 2371, 10563, 10563, 10563, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 2683, 6779, 14971, 31355, 31355, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 6443, 14635, 14635, 14635, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 7803, 15995, 15995, 15995, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 2875, 2875, 2875, 2875, 2875, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 2171, 6267, 6267, 22651, 55419, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 1803, 3851, 3851, 3851, 20235, 53003, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 123, 4219, 4219, 20603, 20603, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 6723, 6723, 6723, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 3195, 3195, 11387, 27771, 27771, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 6051, 6051, 22435, 22435, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 5243, 5243, 5243, 5243, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 1107, 5203, 13395, 29779, 62547, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 1147, 9339, 25723, 58491, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 2795, 6891, 15083, 15083, 47851, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 891, 9083, 9083, 41851, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 35, 35, 4131, 4131, 4131, 36899, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 2939, 7035, 7035, 23419, 56187, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 979, 5075, 13267, 13267, 46035, 0},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 379, 2427, 2427, 2427, 2427, 35195, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 2891, 2891, 11083, 27467, 60235, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 763, 8955, 25339, 25339, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 3859, 3859, 3859, 20243, 20243, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 763, 763, 4859, 4859, 4859, 37627, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 4523, 4523, 20907, 20907, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 1787, 1787, 5883, 5883, 22267, 55035, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 955, 9147, 25531, 58299, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 5627, 5627, 22011, 54779, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 2915, 11107, 27491, 27491, 0},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 2043, 6139, 14331, 30715, 30715, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 1347, 5443, 5443, 5443, 5443, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 7995, 16187, 16187, 48955, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 723, 723, 8915, 8915, 41683, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 315, 315, 4411, 4411, 20795, 53563, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 4011, 4011, 20395, 53163, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 1339, 1339, 9531, 25915, 25915, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 3843, 7939, 16131, 32515, 65283, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 3643, 7739, 7739, 7739, 7739, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 2091, 2091, 10283, 26667, 26667, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 571, 4667, 4667, 21051, 53819, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 7027, 15219, 31603, 31603, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 571, 571, 8763, 8763, 8763, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 1483, 3531, 7627, 7627, 7627, 7627, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 2107, 2107, 2107, 2107, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 1699, 1699, 1699, 18083, 18083, 0},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 59, 4155, 12347, 28731, 28731, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 1363, 9555, 25939, 58707, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 1467, 1467, 1467, 1467, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 715, 4811, 4811, 21195, 53963, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 3515, 3515, 3515, 3515, 36283, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 6019, 14211, 14211, 14211, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 5051, 5051, 5051, 5051, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 1091, 1091, 1091, 1091, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 1979, 1979, 6075, 6075, 22459, 22459, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 2643, 2643, 10835, 27219, 59987, 0},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 7355, 7355, 23739, 56507, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 963, 963, 963, 17347, 50115, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 1419, 3467, 3467, 3467, 3467, 36235, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 1939, 3987, 8083, 16275, 32659, 32659, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 3979, 3979, 12171, 12171, 12171, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 435, 435, 8627, 25011, 57779, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 1931, 1931, 6027, 6027, 22411, 22411, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 579, 579, 8771, 25155, 25155, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 139, 139, 139, 139, 8331, 24715, 57483, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 1587, 1587, 9779, 9779, 42547, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 6795, 14987, 14987, 14987, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 995, 3043, 7139, 7139, 23523, 56291, 0},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 1675, 3723, 3723, 3723, 3723, 36491, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 843, 4939, 4939, 4939, 37707, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 2827, 6923, 15115, 31499, 31499, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 1235, 1235, 1235, 17619, 50387, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 3339, 7435, 7435, 7435, 40203, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 5347, 5347, 21731, 54499, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 2315, 6411, 6411, 22795, 55563, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 755, 2803, 6899, 6899, 23283, 23283, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 523, 2571, 2571, 10763, 10763, 10763, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 4243, 12435, 28819, 28819, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 523, 1547, 3595, 3595, 11787, 28171, 28171, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 3715, 7811, 7811, 24195, 24195, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 11, 11, 4107, 12299, 28683, 61451, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 3395, 11587, 27971, 27971, 0},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 1035, 5131, 13323, 13323, 46091, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 851, 851, 851, 33619, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 3275, 7371, 15563, 15563, 48331, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 1219, 5315, 13507, 13507, 46275, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 203, 203, 203, 32971, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 2339, 6435, 14627, 31011, 63779, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 4555, 4555, 20939, 53707, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 3427, 3427, 3427, 3427, 3427, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 2507, 2507, 10699, 10699, 43467, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 3731, 3731, 11923, 28307, 28307, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 1483, 1483, 1483, 9675, 26059, 26059, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 1483, 3531, 3531, 11723, 28107, 60875, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 131, 131, 16515, 16515, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 5067, 13259, 29643, 29643, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 4931, 13123, 29507, 29507, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 6091, 14283, 14283, 14283, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 3411, 7507, 7507, 7507, 40275, 0},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 1995, 1995, 18379, 51147, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 1003, 1003, 5099, 5099, 5099, 37867, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 1867, 1867, 10059, 10059, 10059, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 1571, 5667, 13859, 30243, 63011, 0},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 331, 4427, 12619, 12619, 12619, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 6315, 14507, 30891, 30891, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 299, 4395, 12587, 12587, 45355, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 2867, 2867, 2867, 2867, 35635, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 811, 811, 9003, 25387, 58155, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 2987, 2987, 2987, 2987, 35755, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 1835, 5931, 5931, 22315, 22315, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 771, 2819, 6915, 15107, 15107, 47875, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 1067, 1067, 1067, 9259, 9259, 42027, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 355, 355, 4451, 12643, 12643, 12643, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 43, 43, 43, 43, 8235, 24619, 57387, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 1907, 3955, 8051, 16243, 16243, 16243, 0},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 555, 4651, 12843, 12843, 45611, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 1003, 2027, 4075, 4075, 12267, 12267, 45035, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 1451, 1451, 1451, 9643, 26027, 58795, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 3667, 11859, 11859, 44627, 0},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 1707, 5803, 5803, 5803, 5803, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 1075, 1075, 1075, 1075, 1075, 33843, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 2155, 6251, 14443, 30827, 63595, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 915, 915, 17299, 17299, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 3179, 7275, 15467, 15467, 48235, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 3459, 11651, 28035, 28035, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 5483, 5483, 5483, 38251, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 2611, 6707, 6707, 6707, 39475, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 3435, 3435, 11627, 28011, 60779, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 2499, 6595, 6595, 6595, 39363, 0},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 2923, 2923, 2923, 2923, 2923, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 2547, 10739, 27123, 27123, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 235, 235, 4331, 4331, 4331, 37099, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 2835, 2835, 2835, 2835, 2835, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 235, 1259, 3307, 3307, 11499, 11499, 44267, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 1779, 1779, 9971, 26355, 26355, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 3563, 7659, 15851, 32235, 65003, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 691, 691, 4787, 4787, 21171, 53939, 0},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 491, 491, 16875, 49643, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 3923, 8019, 16211, 16211, 48979, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 3891, 7987, 16179, 16179, 16179, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 387, 8579, 8579, 41347, 0},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 3379, 7475, 7475, 7475, 7475, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 4003, 8099, 8099, 24483, 57251, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 1459, 1459, 5555, 5555, 21939, 21939, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 1827, 5923, 5923, 5923, 5923, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 1203, 1203, 1203, 17587, 17587, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 867, 867, 9059, 25443, 58211, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 7347, 15539, 15539, 15539, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 147, 147, 147, 32915, 0},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 691, 1715, 3763, 7859, 7859, 7859, 7859, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 1651, 3699, 7795, 7795, 24179, 56947, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 2771, 10963, 10963, 10963, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 3187, 7283, 15475, 31859, 64627, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 1267, 5363, 13555, 13555, 46323, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 883, 883, 2931, 2931, 2931, 2931, 35699, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 4227, 12419, 12419, 45187, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 1395, 5491, 5491, 5491, 38259, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 835, 835, 835, 835, 33603, 0},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 2419, 10611, 10611, 43379, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 3747, 3747, 3747, 20131, 52899, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 2291, 2291, 2291, 2291, 35059, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 403, 403, 4499, 4499, 4499, 37267, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 1523, 3571, 7667, 7667, 24051, 56819, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 3011, 3011, 19395, 19395, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 6643, 6643, 6643, 39411, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 1491, 1491, 9683, 9683, 9683, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 4083, 8179, 16371, 32755, 65523, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 1507, 1507, 5603, 13795, 13795, 13795, 0},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 2035, 2035, 2035, 2035, 34803, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 5651, 5651, 22035, 54803, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 2963, 2963, 2963, 19347, 52115, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 1315, 5411, 13603, 13603, 13603, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 5011, 13203, 13203, 45971, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 1747, 5843, 5843, 5843, 5843, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 1683, 9875, 26259, 59027, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 3203, 3203, 3203, 3203, 35971, 0},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 7315, 15507, 15507, 48275, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 339, 4435, 4435, 20819, 20819, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 7443, 7443, 7443, 40211, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 1635, 3683, 3683, 3683, 20067, 52835, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 2835, 6931, 15123, 31507, 64275, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 7763, 7763, 24147, 24147, 0},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 531, 4627, 4627, 4627, 37395, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 2531, 2531, 2531, 2531, 2531, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 4051, 8147, 16339, 32723, 32723, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 1059, 1059, 9251, 9251, 9251, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 2003, 2003, 2003, 2003, 2003, 0},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 467, 467, 467, 8659, 25043, 25043, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 6115, 6115, 6115, 6115, 0},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 1875, 1875, 5971, 14163, 14163, 14163, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 1187, 3235, 3235, 11427, 27811, 60579, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 2147, 10339, 10339, 43107, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 1315, 3363, 3363, 3363, 19747, 19747, 0},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 867, 2915, 7011, 7011, 7011, 39779, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 1859, 1859, 1859, 18243, 51011, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 739, 739, 739, 17123, 17123, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 7043, 15235, 31619, 64387, 0},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 227, 227, 227, 8419, 24803, 24803, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 1443, 1443, 1443, 34211, 0},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 3619, 7715, 15907, 32291, 32291, 0},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 515, 515, 515, 515, 8707, 8707, 8707, 0},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 2211, 10403, 10403, 43171, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 2371, 6467, 6467, 22851, 55619, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 707, 707, 8899, 8899, 8899, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 2627, 10819, 27203, 59971, 0},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 3523, 3523, 11715, 11715, 11715, 0},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 835, 2883, 6979, 15171, 31555, 64323, 0},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 1667, 1667, 5763, 5763, 22147, 54915, 0},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16385, 16385, 16385},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 4681, 4681, 4681, 37449, 37449},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16385, 49153, 114689},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 4915, 13107, 13107, 13107, 78643},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4097, 4097, 4097, 4097, 4097},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 1057, 1057, 33825, 33825},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4097, 4097, 20481, 53249, 53249},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 189, 4285, 4285, 20669, 53437, 118973},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4097, 12289, 12289, 12289, 77825},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 1807, 3855, 3855, 3855, 3855, 3855, 69391},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4097, 12289, 28673, 61441, 126977},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 195, 4291, 12483, 12483, 12483, 12483},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 2049, 2049, 2049, 2049},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 4161, 4161, 4161, 4161, 4161},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 2049, 10241, 10241, 43009, 43009},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 1285, 1285, 1285, 1285, 1285, 1285, 66821},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 6145, 6145, 22529, 22529, 22529},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 7721, 15913, 15913, 48681, 114217},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2049, 6145, 14337, 30721, 30721, 96257},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 2599, 10791, 27175, 59943, 125479},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 1025, 1025, 17409, 50177, 50177},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 1565, 1565, 1565, 9757, 9757, 42525, 42525},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 1025, 9217, 25601, 25601, 25601},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 4057, 4057, 12249, 28633, 28633, 28633},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 5121, 5121, 5121, 5121, 70657},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 991, 991, 5087, 13279, 29663, 29663, 95199},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 5121, 5121, 21505, 54273, 119809},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 3347, 3347, 11539, 11539, 44307, 109843},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 1025, 5121, 13313, 29697, 29697, 95233},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 5607, 5607, 5607, 38375, 38375},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 3073, 3073, 3073, 3073, 35841, 35841},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 405, 2453, 2453, 2453, 2453, 35221, 35221},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1025, 3073, 7169, 15361, 15361, 48129, 48129},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 933, 2981, 7077, 7077, 7077, 39845, 105381},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 513, 513, 16897, 16897, 82433},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 1687, 3735, 7831, 7831, 24215, 56983, 122519},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 513, 513, 16897, 49665, 49665},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 1949, 3997, 8093, 8093, 8093, 8093, 73629},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 513, 8705, 25089, 25089, 25089},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 1625, 3673, 3673, 3673, 20057, 52825, 52825},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 4609, 4609, 4609, 37377, 37377},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 629, 629, 4725, 12917, 29301, 62069, 127605},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 513, 4609, 12801, 29185, 61953, 61953},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 2477, 2477, 10669, 27053, 59821, 59821},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 2561, 10753, 10753, 43521, 109057},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 459, 459, 459, 459, 8651, 25035, 57803, 123339},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 6657, 6657, 6657, 6657},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 5473, 5473, 38241, 38241},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 6657, 6657, 39425, 104961},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 1595, 1595, 9787, 9787, 42555, 42555},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 6657, 23041, 55809, 55809},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 1533, 1533, 1533, 1533, 1533, 1533, 1533},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 513, 2561, 6657, 14849, 31233, 64001, 129537},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 1155, 1155, 1155, 17539, 50307, 115843},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 1537, 1537, 1537, 1537, 1537, 67073},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 127, 127, 127, 127, 16511, 49279, 114815},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 3585, 3585, 3585, 3585},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 4545, 4545, 20929, 20929, 86465},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 3585, 3585, 36353, 101889},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 27, 27, 27, 4123, 12315, 12315, 45083, 110619},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 3585, 19969, 19969, 85505},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 343, 343, 8535, 24919, 24919, 24919},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 3585, 11777, 28161, 28161, 28161},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 1689, 3737, 3737, 11929, 28313, 61081, 126617},
{1, 1, 1, 1, 1, 1, 1, 1, 1, 513, 1537, 3585, 7681, 15873, 15873, 15873, 15873},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 1265, 9457, 25841, 25841, 91377},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 257, 257, 16641, 49409, 114945},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 3229, 3229, 11421, 27805, 60573, 126109},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 4353, 4353, 4353, 4353, 4353},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 863, 4959, 13151, 13151, 45919, 111455},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 4353, 4353, 20737, 20737, 86273},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 1129, 3177, 7273, 15465, 15465, 48233, 48233},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 4353, 12545, 12545, 12545, 78081},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 14129, 30513, 63281, 128817},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 257, 4353, 12545, 12545, 45313, 45313},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 811, 2859, 6955, 6955, 23339, 23339, 88875},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 2305, 2305, 2305, 35073, 100609},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 789, 789, 789, 8981, 25365, 25365, 90901},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 6401, 22785, 22785, 22785},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 631, 631, 2679, 6775, 6775, 23159, 23159, 88695},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 14593, 30977, 30977, 96513},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 313, 313, 313, 313, 313, 313, 313},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 257, 2305, 6401, 14593, 30977, 63745, 63745},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 899, 2947, 2947, 2947, 19331, 52099, 52099},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 1281, 1281, 1281, 1281, 1281},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 3967, 8063, 16255, 16255, 16255, 81791},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 1281, 9473, 9473, 9473, 75009},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 5009, 5009, 21393, 54161, 119697},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 1281, 5377, 13569, 13569, 46337, 111873},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 1509, 3557, 3557, 11749, 28133, 60901, 126437},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 3329, 3329, 3329, 36097, 36097},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 3867, 7963, 16155, 32539, 32539, 98075},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 3329, 11521, 27905, 60673, 60673},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 5539, 13731, 13731, 46499, 112035},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 7425, 7425, 7425, 7425},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 159, 1183, 3231, 7327, 15519, 15519, 48287, 48287},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 7425, 23809, 23809, 89345},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 1193, 3241, 7337, 7337, 23721, 23721, 89257},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 257, 1281, 3329, 7425, 15617, 32001, 64769, 130305},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 1645, 5741, 13933, 13933, 46701, 46701},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 769, 17153, 17153, 82689},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 329, 329, 329, 4425, 4425, 20809, 20809, 86345},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 8961, 8961, 8961, 74497},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 529, 4625, 4625, 4625, 4625, 70161},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 8961, 8961, 41729, 41729},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 2699, 2699, 2699, 2699, 2699, 68235},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 769, 8961, 25345, 25345, 25345},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 3783, 3783, 3783, 20167, 20167, 85703},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 4865, 4865, 37633, 37633},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 3451, 3451, 3451, 3451, 3451},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 13057, 13057, 13057, 13057},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 15, 4111, 12303, 28687, 61455, 61455},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 769, 4865, 13057, 13057, 45825, 111361},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 5221, 13413, 13413, 46181, 111717},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 2817, 11009, 11009, 11009, 11009},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 1007, 5103, 5103, 21487, 21487, 87023},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 769, 2817, 6913, 15105, 15105, 47873, 47873},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 3947, 8043, 16235, 32619, 32619, 98155},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 5889, 14081, 14081, 14081, 79617},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 14001, 14001, 14001, 79537},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 1793, 5889, 14081, 14081, 46849, 46849},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 1195, 3243, 7339, 15531, 31915, 64683, 130219},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 3841, 3841, 3841, 3841},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 831, 1855, 3903, 3903, 3903, 3903, 3903, 69439},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 12033, 12033, 12033, 77569},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 721, 721, 721, 33489, 33489},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 3841, 12033, 28417, 28417, 28417},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 263, 4359, 12551, 12551, 12551, 78087},
{1, 1, 1, 1, 1, 1, 1, 1, 257, 769, 1793, 3841, 7937, 7937, 24321, 24321, 24321},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 503, 1527, 1527, 1527, 1527, 1527, 1527, 67063},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 129, 129, 16513, 49281, 114817},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 731, 731, 8923, 8923, 41691, 41691},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 129, 8321, 24705, 57473, 57473},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 1349, 5445, 5445, 5445, 5445, 5445},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 129, 8321, 8321, 8321, 8321},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 857, 2905, 2905, 2905, 2905, 35673, 101209},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 129, 8321, 8321, 41089, 106625},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 99, 99, 2147, 6243, 6243, 6243, 39011, 104547},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 4225, 4225, 4225, 36993, 102529},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 2963, 7059, 15251, 31635, 64403, 64403},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 129, 4225, 12417, 12417, 45185, 45185},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 1197, 3245, 7341, 15533, 31917, 64685, 64685},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 2177, 18561, 18561, 84097},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 703, 1727, 3775, 3775, 3775, 20159, 52927, 52927},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 10369, 26753, 59521, 125057},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 203, 4299, 12491, 12491, 45259, 110795},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 2177, 10369, 10369, 43137, 43137},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 1741, 1741, 1741, 1741, 18125, 50893, 116429},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 6273, 6273, 22657, 22657, 22657},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 4193, 4193, 4193, 36961, 102497},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 6273, 6273, 22657, 55425, 120961},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 1851, 5947, 14139, 30523, 63291, 128827},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 129, 2177, 6273, 14465, 30849, 63617, 63617},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 1829, 1829, 5925, 5925, 5925, 38693, 38693},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 1153, 1153, 17537, 50305, 50305},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 469, 2517, 6613, 6613, 22997, 55765, 55765},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 1153, 1153, 1153, 33921, 99457},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 1459, 1459, 1459, 9651, 26035, 26035, 26035},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 1153, 9345, 9345, 42113, 42113},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 2573, 10765, 27149, 27149, 92685},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 5249, 5249, 5249, 5249, 70785},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 951, 951, 2999, 7095, 7095, 7095, 39863, 105399},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 1153, 5249, 13441, 13441, 13441, 13441},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 2041, 2041, 2041, 10233, 10233, 43001, 108537},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 3201, 3201, 19585, 19585, 19585},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 5313, 21697, 21697, 21697},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 3201, 3201, 3201, 35969, 35969},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 1629, 1629, 9821, 26205, 26205, 91741},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 7297, 15489, 31873, 64641, 130177},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 1771, 1771, 1771, 1771, 18155, 18155, 18155},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 129, 1153, 3201, 7297, 15489, 15489, 15489, 81025},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 1191, 1191, 5287, 13479, 29863, 29863, 95399},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 641, 8833, 8833, 8833, 74369},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 4295, 12487, 12487, 12487, 78023},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 641, 8833, 8833, 41601, 41601},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 909, 5005, 5005, 21389, 21389, 86925},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 4737, 4737, 21121, 53889, 119425},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 891, 4987, 4987, 4987, 37755, 103291},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 4737, 12929, 29313, 62081, 62081},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 613, 613, 4709, 4709, 21093, 53861, 119397},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 641, 4737, 12929, 12929, 45697, 111233},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 451, 451, 8643, 8643, 8643, 74179},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 6785, 23169, 23169, 88705},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 287, 1311, 3359, 7455, 15647, 32031, 32031, 97567},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 6785, 23169, 55937, 55937},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 565, 8757, 8757, 41525, 41525},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 641, 2689, 6785, 6785, 6785, 39553, 105089},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 4051, 4051, 4051, 20435, 20435, 85971},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 1665, 9857, 26241, 26241, 91777},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 559, 559, 8751, 25135, 25135, 90671},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 5761, 5761, 22145, 54913, 54913},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 1781, 3829, 7925, 16117, 32501, 32501, 32501},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 1665, 5761, 13953, 13953, 13953, 79489},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 1255, 1255, 5351, 5351, 21735, 54503, 120039},
{1, 1, 1, 1, 1, 1, 1, 129, 129, 641, 1665, 3713, 7809, 7809, 7809, 40577, 40577},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 381, 381, 2429, 2429, 10621, 10621, 43389, 43389},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 385, 385, 16769, 49537, 115073},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 853, 853, 4949, 13141, 13141, 13141, 78677},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 385, 8577, 8577, 41345, 106881},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 141, 141, 141, 141, 8333, 8333, 41101, 41101},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 4481, 4481, 20865, 20865, 86401},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 545, 545, 545, 33313, 33313},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 385, 4481, 12673, 29057, 29057, 29057},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 271, 271, 4367, 12559, 28943, 61711, 61711},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 2433, 2433, 18817, 51585, 51585},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 411, 2459, 2459, 2459, 2459, 2459, 67995},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 2433, 2433, 2433, 2433, 2433},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 215, 215, 215, 16599, 16599, 16599},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 385, 2433, 2433, 10625, 10625, 10625, 76161},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 2329, 2329, 2329, 18713, 51481, 51481},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 1409, 1409, 1409, 34177, 99713},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 16413, 16413, 81949},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 1409, 5505, 5505, 21889, 21889, 21889},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 3551, 3551, 3551, 3551, 36319, 36319},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 3457, 11649, 28033, 60801, 60801},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 6219, 6219, 22603, 55371, 55371},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 3457, 11649, 11649, 11649, 11649},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 4103, 12295, 28679, 28679, 28679},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 7553, 23937, 23937, 89473},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 4833, 4833, 21217, 53985, 119521},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 15745, 15745, 15745, 81281},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 1465, 1465, 1465, 9657, 26041, 58809, 124345},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 385, 1409, 3457, 7553, 15745, 15745, 48513, 48513},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 1283, 3331, 7427, 7427, 7427, 7427, 72963},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 897, 897, 17281, 50049, 50049},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 1499, 3547, 3547, 11739, 28123, 28123, 28123},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 4993, 4993, 4993, 37761, 37761},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 1171, 5267, 13459, 29843, 62611, 62611},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 897, 4993, 13185, 29569, 29569, 95105},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 12849, 29233, 62001, 127537},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 2945, 2945, 2945, 68481},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 1289, 5385, 5385, 21769, 54537, 54537},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 2945, 2945, 35713, 35713},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 371, 2419, 6515, 6515, 6515, 39283, 104819},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 11137, 27521, 27521, 93057},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 1617, 1617, 18001, 18001, 18001},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 2945, 11137, 11137, 11137, 11137},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 3975, 3975, 12167, 12167, 44935, 110471},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 897, 2945, 7041, 7041, 7041, 39809, 105345},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 1021, 1021, 1021, 9213, 25597, 58365, 123901},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 1921, 1921, 18305, 18305, 18305},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 1663, 3711, 7807, 15999, 15999, 15999, 15999},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 1921, 1921, 18305, 51073, 116609},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 2773, 2773, 10965, 27349, 60117, 60117},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 1921, 10113, 26497, 59265, 59265},
{1, 3, 3, 11, 11, 11, 11, 11, 11, 11, 1035, 3083, 7179, 15371, 31755, 64523, 130059},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 6017, 6017, 6017, 38785, 104321},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 3901, 3901, 3901, 36669, 102205},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 1921, 6017, 14209, 30593, 63361, 128897},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 229, 229, 2277, 6373, 14565, 14565, 47333, 47333},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 8065, 8065, 8065, 8065, 73601},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 2473, 6569, 6569, 6569, 6569, 72105},
{1, 1, 1, 1, 1, 1, 1, 129, 385, 897, 1921, 3969, 8065, 16257, 16257, 16257, 16257},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 2983, 2983, 2983, 19367, 19367, 19367},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 4161, 4161, 20545, 20545, 86081},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 919, 919, 9111, 25495, 25495, 91031},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 4161, 4161, 20545, 53313, 53313},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 1693, 1693, 1693, 18077, 50845, 116381},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 65, 8257, 8257, 41025, 106561},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 6443, 14635, 31019, 63787, 129323},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 65, 65, 8257, 24641, 57409, 57409},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 173, 4269, 12461, 12461, 12461, 77997},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 14401, 14401, 14401, 14401},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 2385, 2385, 18769, 18769, 18769},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 6209, 14401, 14401, 47169, 112705},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 3275, 3275, 3275, 3275, 36043, 36043},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 65, 2113, 2113, 10305, 10305, 43073, 43073},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 2853, 6949, 6949, 23333, 23333, 23333},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 5185, 13377, 13377, 13377, 13377},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 6545, 22929, 55697, 121233},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 1089, 9281, 25665, 25665, 25665},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 3065, 3065, 11257, 11257, 44025, 44025},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 1089, 1089, 9281, 25665, 58433, 123969},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 2627, 6723, 6723, 23107, 55875, 121411},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 15425, 15425, 15425, 80961},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 3695, 3695, 11887, 28271, 61039, 61039},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 15425, 15425, 48193, 48193},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 1413, 1413, 1413, 17797, 50565, 50565},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 7233, 15425, 31809, 31809, 31809},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 1945, 1945, 1945, 10137, 10137, 42905, 108441},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 3137, 3137, 3137, 3137, 68673},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 3743, 7839, 16031, 16031, 48799, 48799},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 3137, 11329, 11329, 44097, 109633},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 2795, 6891, 15083, 31467, 31467, 97003},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 65, 1089, 3137, 3137, 11329, 27713, 60481, 60481},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 3181, 7277, 7277, 7277, 40045, 40045},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 4673, 4673, 37441, 37441},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 3157, 3157, 3157, 19541, 52309, 117845},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 12865, 29249, 29249, 94785},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 1223, 3271, 3271, 3271, 19655, 52423, 117959},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 4673, 12865, 29249, 62017, 62017},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 1933, 3981, 8077, 8077, 8077, 40845, 40845},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 577, 577, 16961, 49729, 49729},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 2493, 2493, 2493, 2493, 2493, 68029},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 577, 577, 8769, 8769, 8769, 74305},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 527, 4623, 12815, 29199, 61967, 61967},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 6721, 6721, 6721, 6721, 6721},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 6465, 6465, 6465, 6465, 72001},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 6721, 14913, 14913, 47681, 47681},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 5, 1029, 3077, 7173, 7173, 7173, 39941, 39941},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 2625, 2625, 19009, 19009, 19009},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 1833, 5929, 14121, 30505, 63273, 63273},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 2625, 10817, 10817, 10817, 10817},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 3185, 11377, 11377, 44145, 109681},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 577, 2625, 2625, 10817, 27201, 27201, 92737},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 807, 1831, 1831, 5927, 5927, 22311, 22311, 22311},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 1601, 5697, 5697, 5697, 38465, 104001},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 347, 2395, 6491, 14683, 14683, 47451, 47451},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 1601, 1601, 1601, 1601, 1601, 67137},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 1759, 3807, 3807, 3807, 3807, 36575, 102111},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 3649, 3649, 3649, 3649, 3649},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 7649, 7649, 24033, 56801, 56801},
{1, 1, 1, 1, 1, 1, 65, 65, 65, 577, 1601, 3649, 3649, 3649, 3649, 36417, 101953},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 3259, 3259, 11451, 27835, 60603, 126139},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 321, 4417, 4417, 4417, 4417, 4417},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 511, 1535, 3583, 7679, 15871, 32255, 65023, 130559},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 6465, 14657, 14657, 14657, 14657},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 1775, 3823, 3823, 12015, 12015, 44783, 44783},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 2369, 2369, 35137, 100673},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 7477, 7477, 23861, 23861, 23861},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 2369, 18753, 18753, 84289},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 41, 1065, 1065, 5161, 13353, 13353, 13353, 78889},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 2369, 18753, 51521, 51521},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 7379, 15571, 31955, 31955, 97491},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 321, 2369, 2369, 10561, 26945, 26945, 26945},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 2087, 2087, 10279, 26663, 26663, 92199},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 1345, 5441, 13633, 30017, 30017, 95553},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 1497, 1497, 1497, 9689, 26073, 58841, 58841},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 1345, 1345, 9537, 9537, 42305, 42305},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 4523, 4523, 4523, 37291, 37291},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 7489, 7489, 7489, 7489},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 575, 4671, 12863, 29247, 62015, 127551},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 7489, 23873, 23873, 89409},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 2185, 6281, 14473, 30857, 63625, 63625},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 7489, 15681, 15681, 15681, 81217},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 3025, 3025, 3025, 35793, 35793},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 3393, 3393, 3393, 36161, 36161},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 955, 955, 9147, 9147, 9147, 74683},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 321, 1345, 3393, 3393, 3393, 19777, 19777, 19777},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 2295, 6391, 14583, 14583, 47351, 112887},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 4929, 4929, 4929, 37697, 37697},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 475, 4571, 4571, 20955, 20955, 86491},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 4929, 4929, 21313, 54081, 119617},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 1437, 1437, 5533, 13725, 13725, 13725, 79261},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 833, 833, 33601, 99137},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 117, 117, 2165, 6261, 6261, 22645, 22645, 88181},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 9025, 9025, 9025, 74561},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 3633, 7729, 15921, 32305, 65073, 130609},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 9025, 9025, 41793, 41793},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 1579, 1579, 5675, 13867, 13867, 13867, 13867},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 833, 833, 9025, 25409, 25409, 25409},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 2151, 2151, 2151, 18535, 51303, 116839},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 6977, 6977, 6977, 39745, 105281},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 533, 2581, 6677, 14869, 31253, 64021, 129557},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 6977, 15169, 31553, 64321, 129857},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 2509, 6605, 14797, 31181, 63949, 129485},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 833, 2881, 2881, 11073, 27457, 27457, 92993},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 57, 57, 2105, 2105, 2105, 18489, 18489, 18489},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 5953, 5953, 5953, 5953, 5953},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 639, 639, 639, 639, 639, 17023, 49791, 115327},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 1857, 1857, 1857, 1857, 67393},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 4001, 4001, 20385, 53153, 118689},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 1857, 1857, 1857, 1857, 34625, 34625},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 2043, 2043, 2043, 2043, 18427, 18427, 83963},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 8001, 8001, 24385, 24385, 24385},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 855, 855, 9047, 25431, 58199, 58199},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 3905, 3905, 20289, 20289, 85825},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 1449, 5545, 5545, 5545, 5545, 5545},
{1, 1, 1, 1, 1, 1, 65, 65, 321, 833, 1857, 3905, 3905, 12097, 28481, 28481, 28481},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 1959, 1959, 6055, 14247, 14247, 47015, 47015},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 193, 193, 193, 16577, 49345, 114881},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 3707, 7803, 15995, 32379, 65147, 130683},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 193, 193, 8385, 8385, 41153, 106689},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 1219, 3267, 3267, 3267, 3267, 3267, 3267},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 6337, 6337, 22721, 55489, 121025},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 923, 2971, 2971, 11163, 11163, 43931, 109467},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 2241, 2241, 18625, 51393, 51393},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 821, 2869, 6965, 15157, 15157, 15157, 15157},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 2241, 10433, 26817, 26817, 26817},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 2417, 10609, 10609, 43377, 108913},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 193, 2241, 2241, 10433, 26817, 59585, 125121},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 1131, 3179, 3179, 3179, 3179, 35947, 101483},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 5313, 5313, 5313, 38081, 38081},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 541, 541, 2589, 2589, 10781, 27165, 27165, 92701},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 1217, 1217, 9409, 25793, 58561, 124097},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 1963, 4011, 4011, 4011, 4011, 4011, 69547},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 3265, 19649, 19649, 19649},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 6369, 22753, 55521, 121057},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 3265, 19649, 52417, 117953},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 3515, 7611, 15803, 15803, 48571, 48571},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 193, 1217, 3265, 3265, 3265, 3265, 36033, 36033},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 4221, 12413, 28797, 28797, 28797},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 4801, 21185, 53953, 119489},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 4059, 4059, 20443, 53211, 53211},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 4801, 4801, 4801, 70337},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 663, 663, 663, 663, 8855, 8855, 8855, 74391},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 4801, 12993, 29377, 62145, 62145},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 1093, 3141, 3141, 3141, 3141, 35909, 101445},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 705, 705, 705, 705, 33473, 99009},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 1683, 5779, 5779, 22163, 54931, 54931},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 6849, 6849, 23233, 56001, 56001},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 7189, 7189, 7189, 39957, 105493},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 6849, 15041, 15041, 47809, 47809},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 4045, 8141, 8141, 8141, 8141, 8141},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 2753, 2753, 2753, 2753, 68289},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 6519, 6519, 6519, 39287, 104823},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 705, 2753, 2753, 10945, 27329, 60097, 60097},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 549, 1573, 3621, 3621, 3621, 3621, 3621, 69157},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 5825, 5825, 5825, 38593, 104129},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 2227, 2227, 2227, 18611, 18611, 18611},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 5825, 14017, 14017, 14017, 79553},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 583, 583, 583, 4679, 4679, 21063, 21063, 86599},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 1729, 1729, 1729, 1729, 67265},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 695, 1719, 1719, 1719, 9911, 9911, 9911, 75447},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 1729, 1729, 1729, 1729, 34497, 34497},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 1341, 1341, 9533, 9533, 42301, 107837},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 7873, 16065, 32449, 32449, 97985},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 3951, 3951, 12143, 28527, 61295, 61295},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 7873, 16065, 16065, 48833, 114369},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 675, 1699, 1699, 1699, 1699, 1699, 34467, 34467},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 3777, 3777, 20161, 20161, 85697},
{1, 3, 7, 15, 31, 31, 31, 159, 415, 927, 1951, 3999, 8095, 16287, 16287, 49055, 114591},
{1, 1, 1, 1, 1, 1, 65, 193, 193, 705, 1729, 3777, 3777, 3777, 20161, 52929, 52929},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 693, 693, 693, 8885, 25269, 58037, 123573},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 4545, 4545, 4545, 4545, 4545},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 1431, 3479, 7575, 7575, 7575, 7575, 73111},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 4545, 12737, 29121, 61889, 127425},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 1861, 3909, 8005, 16197, 16197, 48965, 48965},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 449, 449, 8641, 8641, 41409, 106945},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 5805, 5805, 22189, 54957, 54957},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 6593, 6593, 22977, 22977, 22977},
{1, 3, 7, 15, 31, 63, 63, 191, 191, 191, 1215, 3263, 3263, 3263, 19647, 52415, 52415},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 6593, 6593, 6593, 39361, 39361},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 1139, 5235, 13427, 13427, 46195, 111731},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 6593, 14785, 14785, 47553, 113089},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 3277, 3277, 11469, 27853, 60621, 126157},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 2497, 10689, 10689, 10689, 76225},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 3385, 3385, 3385, 3385, 3385, 68921},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 449, 2497, 2497, 10689, 10689, 43457, 43457},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 899, 1923, 1923, 6019, 14211, 30595, 63363, 63363},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 5569, 5569, 5569, 5569, 71105},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 7369, 15561, 31945, 31945, 97481},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 5569, 13761, 30145, 62913, 62913},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 267, 4363, 4363, 4363, 37131, 37131},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 5569, 13761, 13761, 13761, 13761},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 3399, 11591, 27975, 27975, 27975},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 1473, 1473, 17857, 50625, 50625},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 763, 1787, 1787, 5883, 5883, 5883, 5883, 5883},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 1473, 1473, 9665, 26049, 58817, 124353},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 485, 485, 8677, 8677, 8677, 74213},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 7617, 15809, 15809, 48577, 48577},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 419, 2467, 2467, 2467, 2467, 35235, 100771},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 3521, 3521, 3521, 69057},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 169, 169, 169, 4265, 4265, 20649, 20649, 20649},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 449, 1473, 3521, 3521, 11713, 11713, 11713, 11713},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 1703, 5799, 13991, 30375, 63143, 128679},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 5057, 5057, 5057, 37825, 37825},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 65587},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 961, 961, 961, 961, 961},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 1591, 1591, 17975, 17975, 83511},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 961, 9153, 25537, 25537, 25537},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 1039, 3087, 3087, 3087, 3087, 3087, 68623},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 961, 961, 9153, 9153, 9153, 74689},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 3193, 3193, 3193, 35961, 101497},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 3009, 7105, 15297, 31681, 64449, 129985},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 2565, 6661, 14853, 31237, 64005, 64005},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 3009, 3009, 3009, 3009, 35777, 35777},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 3539, 3539, 11731, 28115, 28115, 93651},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 961, 3009, 3009, 11201, 27585, 27585, 93121},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 2673, 10865, 10865, 43633, 109169},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 1985, 6081, 6081, 22465, 55233, 55233},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 1883, 1883, 10075, 10075, 10075, 75611},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 1985, 6081, 14273, 30657, 30657, 30657},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 47, 47, 8239, 24623, 24623, 90159},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 1985, 1985, 1985, 1985, 1985, 67521},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 489, 4585, 4585, 4585, 37353, 37353},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 8129, 8129, 8129, 8129, 73665},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 393, 1417, 3465, 7561, 15753, 15753, 48521, 48521},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 8129, 16321, 16321, 16321, 16321},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 3335, 3335, 3335, 19719, 52487, 118023},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 8129, 16321, 16321, 49089, 114625},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 1357, 1357, 5453, 5453, 21837, 54605, 120141},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 4033, 4033, 4033, 36801, 102337},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 893, 893, 893, 893, 893, 33661, 33661},
{1, 1, 1, 1, 1, 1, 65, 193, 449, 961, 1985, 4033, 4033, 12225, 28609, 28609, 28609},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 975, 975, 975, 17359, 50127, 115663},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 1057, 17441, 17441, 17441},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 1693, 3741, 7837, 7837, 24221, 24221, 24221},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 9249, 9249, 42017, 107553},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 431, 431, 2479, 6575, 6575, 22959, 55727, 55727},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 1057, 9249, 9249, 9249, 9249},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 325, 325, 325, 325, 16709, 16709, 82245},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 5153, 5153, 21537, 54305, 54305},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 3689, 3689, 11881, 11881, 11881, 11881},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 5153, 13345, 13345, 46113, 46113},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 1329, 9521, 25905, 58673, 124209},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 5153, 13345, 13345, 13345, 78881},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 299, 299, 299, 299, 33067, 98603},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 1057, 5153, 13345, 29729, 62497, 128033},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 3943, 3943, 3943, 3943, 3943, 69479},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 3105, 3105, 3105, 3105, 3105},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 277, 277, 4373, 4373, 20757, 20757, 20757},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 3105, 3105, 19489, 52257, 52257},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 521, 521, 521, 521, 521, 521, 521},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 3105, 3105, 19489, 19489, 85025},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 627, 4723, 4723, 21107, 53875, 119411},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 7201, 7201, 23585, 56353, 121889},
{1, 3, 7, 7, 23, 55, 119, 119, 119, 119, 119, 119, 119, 8311, 8311, 8311, 8311},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 1057, 3105, 7201, 15393, 31777, 31777, 97313},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 387, 387, 4483, 4483, 4483, 37251, 37251},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 32801, 98337},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 383, 1407, 1407, 1407, 1407, 17791, 50559, 50559},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 16417, 16417, 81953},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 435, 435, 435, 8627, 8627, 8627, 8627},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 2081, 2081, 2081, 67617},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 1307, 9499, 9499, 42267, 107803},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 2081, 10273, 10273, 10273, 10273},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 7557, 7557, 23941, 23941, 89477},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 6177, 6177, 6177, 38945, 104481},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 1695, 1695, 18079, 18079, 83615},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 33, 33, 2081, 6177, 6177, 22561, 55329, 55329},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 1705, 3753, 3753, 3753, 20137, 52905, 118441},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 1569, 1569, 1569, 34337, 99873},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 6911, 15103, 31487, 64255, 64255},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 1569, 1569, 1569, 1569, 1569},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 1109, 1109, 5205, 5205, 21589, 21589, 21589},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 1569, 9761, 9761, 42529, 42529},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 65553},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 5665, 5665, 22049, 22049, 22049},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 4541, 4541, 4541, 37309, 37309},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 1569, 5665, 13857, 13857, 46625, 112161},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 2575, 2575, 2575, 2575, 68111},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 3617, 3617, 20001, 52769, 118305},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 983, 3031, 7127, 15319, 31703, 31703, 97239},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 3617, 11809, 11809, 44577, 110113},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 495, 2543, 2543, 10735, 10735, 43503, 43503},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 1569, 3617, 7713, 7713, 24097, 56865, 56865},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 1833, 3881, 3881, 12073, 28457, 61225, 61225},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 545, 545, 16929, 49697, 115233},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 23, 1047, 1047, 1047, 1047, 17431, 50199, 50199},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 545, 8737, 8737, 8737, 8737},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 197, 2245, 6341, 6341, 6341, 6341, 71877},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 4641, 4641, 21025, 21025, 86561},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 2067, 6163, 14355, 30739, 63507, 129043},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 545, 4641, 12833, 12833, 12833, 78369},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 1707, 1707, 1707, 9899, 9899, 9899, 75435},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 2593, 10785, 27169, 59937, 125473},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 2823, 2823, 19207, 19207, 19207},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 2593, 10785, 27169, 27169, 27169},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 845, 2893, 2893, 11085, 11085, 43853, 109389},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 6689, 6689, 6689, 6689, 72225},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 187, 1211, 1211, 5307, 5307, 5307, 38075, 103611},
{1, 1, 1, 1, 1, 33, 33, 33, 33, 545, 545, 2593, 6689, 14881, 14881, 14881, 14881},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 677, 677, 2725, 6821, 6821, 6821, 39589, 105125},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 1313, 1313, 1313, 1313, 66849},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 853, 1877, 1877, 1877, 10069, 26453, 26453, 26453},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 5409, 5409, 21793, 54561, 54561},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 3895, 7991, 16183, 32567, 65335, 65335},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 5409, 13601, 13601, 46369, 46369},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 271, 1295, 1295, 5391, 13583, 29967, 62735, 62735},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 5409, 13601, 29985, 62753, 128289},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 377, 377, 4473, 4473, 20857, 53625, 53625},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 1313, 5409, 13601, 29985, 29985, 29985},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 707, 707, 2755, 2755, 10947, 27331, 27331, 27331},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 3361, 3361, 3361, 3361, 3361},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 411, 1435, 3483, 3483, 3483, 19867, 19867, 19867},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 3361, 11553, 11553, 11553, 77089},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 5893, 14085, 14085, 14085, 14085},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 3361, 11553, 27937, 27937, 27937},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 1827, 1827, 1827, 10019, 10019, 10019, 10019},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 7457, 7457, 7457, 40225, 40225},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 1567, 1567, 1567, 1567, 1567, 34335, 99871},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 1313, 3361, 7457, 15649, 15649, 15649, 15649},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 619, 2667, 2667, 10859, 27243, 27243, 27243},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 289, 8481, 8481, 8481, 74017},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 965, 3013, 3013, 11205, 11205, 11205, 11205},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 289, 8481, 24865, 24865, 24865},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 5347, 5347, 5347, 5347, 5347},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 289, 4385, 4385, 20769, 20769, 20769},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 1811, 1811, 5907, 14099, 30483, 63251, 128787},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 2337, 2337, 2337, 35105, 35105},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 575, 575, 2623, 2623, 2623, 2623, 2623, 2623},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 2337, 10529, 10529, 43297, 108833},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 5073, 5073, 5073, 37841, 37841},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 2337, 10529, 26913, 26913, 92449},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 6221, 6221, 22605, 22605, 22605},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 6433, 6433, 6433, 6433, 6433},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 955, 955, 3003, 7099, 7099, 23483, 23483, 89019},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 289, 289, 2337, 6433, 14625, 31009, 63777, 129313},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 441, 441, 441, 4537, 12729, 29113, 61881, 61881},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 1825, 10017, 10017, 42785, 42785},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 1711, 1711, 9903, 9903, 9903, 75439},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 1825, 10017, 26401, 59169, 124705},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 1113, 3161, 7257, 7257, 23641, 23641, 23641},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 1825, 5921, 14113, 30497, 63265, 63265},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 103, 103, 103, 4199, 12391, 12391, 12391, 12391},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 7969, 7969, 40737, 106273},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 1889, 1889, 1889, 34657, 34657},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 7969, 7969, 7969, 7969},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 3131, 7227, 15419, 31803, 31803, 31803},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 7969, 24353, 24353, 89889},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 1021, 2045, 2045, 6141, 14333, 14333, 47101, 112637},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 16161, 16161, 48929, 48929},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 335, 1359, 1359, 1359, 1359, 1359, 34127, 99663},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 1825, 3873, 7969, 16161, 16161, 16161, 81697},
{1, 1, 5, 5, 5, 37, 37, 37, 37, 37, 37, 37, 4133, 12325, 28709, 61477, 61477},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 4897, 4897, 21281, 21281, 86817},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 2877, 6973, 6973, 23357, 56125, 121661},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 801, 4897, 13089, 29473, 29473, 29473},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 1347, 3395, 3395, 11587, 11587, 44355, 44355},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 2849, 11041, 27425, 60193, 125729},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 1177, 3225, 7321, 15513, 31897, 31897, 97433},
{1, 1, 1, 1, 1, 33, 33, 33, 289, 801, 801, 2849, 6945, 15137, 31521, 31521, 97057},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 877, 1901, 1901, 5997, 14189, 30573, 63341, 63341},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 1185, 1185, 1185, 1185, 66721},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 1843, 1843, 5939, 14131, 30515, 30515, 96051},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 1185, 9377, 25761, 25761, 91297},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 395, 395, 395, 395, 395, 395, 33163, 98699},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 1185, 9377, 9377, 9377, 9377},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 653, 653, 4749, 4749, 4749, 4749, 70285},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 5281, 5281, 21665, 21665, 87201},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 1659, 1659, 1659, 1659, 1659, 34427, 99963},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 1185, 5281, 13473, 29857, 62625, 128161},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 2831, 2831, 2831, 2831, 2831, 68367},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 1185, 3233, 7329, 7329, 7329, 7329, 72865},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 2771, 6867, 6867, 6867, 6867, 72403},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 161, 8353, 8353, 8353, 73889},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 2787, 2787, 2787, 2787, 2787},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 4257, 4257, 20641, 53409, 118945},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 2015, 6111, 14303, 30687, 30687, 96223},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 161, 4257, 4257, 4257, 37025, 37025},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 745, 2793, 2793, 2793, 19177, 19177, 84713},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 2209, 2209, 2209, 2209, 67745},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 1267, 1267, 1267, 1267, 34035, 34035},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 2209, 10401, 26785, 26785, 92321},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 587, 587, 587, 587, 587, 587, 587},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 2209, 10401, 10401, 43169, 108705},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 519, 2567, 2567, 2567, 2567, 2567, 68103},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 6305, 6305, 22689, 55457, 55457},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 225, 225, 16609, 49377, 114913},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 161, 161, 2209, 6305, 14497, 14497, 14497, 80033},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 771, 1795, 1795, 1795, 1795, 18179, 18179, 83715},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 1697, 9889, 9889, 42657, 42657},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 6745, 6745, 23129, 55897, 121433},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 1697, 5793, 5793, 22177, 54945, 120481},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 95, 2143, 2143, 2143, 18527, 18527, 84063},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 3745, 3745, 3745, 36513, 36513},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 1801, 1801, 1801, 1801, 18185, 18185, 18185},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 3745, 11937, 28321, 61089, 61089},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 1105, 5201, 5201, 21585, 21585, 21585},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 3745, 11937, 11937, 44705, 110241},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 1415, 5511, 5511, 21895, 54663, 54663},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 7841, 7841, 7841, 40609, 106145},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 375, 375, 8567, 24951, 24951, 24951},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 7841, 16033, 16033, 48801, 48801},
{1, 1, 1, 9, 25, 57, 57, 57, 57, 569, 1593, 1593, 5689, 5689, 22073, 54841, 120377},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 1697, 3745, 7841, 16033, 16033, 16033, 81569},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 131, 131, 131, 131, 131, 32899, 98435},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 673, 673, 673, 33441, 33441},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 969, 1993, 1993, 1993, 10185, 10185, 42953, 42953},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 4769, 4769, 21153, 21153, 86689},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 507, 507, 507, 8699, 8699, 41467, 41467},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 673, 4769, 4769, 4769, 4769, 4769},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 317, 1341, 3389, 7485, 15677, 15677, 15677, 15677},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 2721, 10913, 27297, 60065, 125601},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 1903, 1903, 5999, 5999, 5999, 5999, 71535},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 2721, 10913, 10913, 43681, 43681},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 665, 665, 2713, 6809, 15001, 31385, 64153, 64153},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 6817, 6817, 6817, 39585, 39585},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 937, 2985, 2985, 2985, 2985, 35753, 101289},
{1, 1, 1, 1, 1, 33, 33, 161, 161, 673, 673, 2721, 6817, 15009, 15009, 15009, 15009},
{1, 1, 5, 13, 13, 45, 109, 109, 365, 365, 365, 365, 4461, 4461, 4461, 4461, 69997},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 1441, 1441, 1441, 1441, 66977},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 157, 2205, 6301, 14493, 14493, 47261, 112797},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 13729, 13729, 46497, 46497},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 359, 359, 359, 4455, 12647, 29031, 29031, 94567},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 1441, 5537, 13729, 13729, 13729, 79265},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 3757, 3757, 3757, 20141, 20141, 85677},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 3489, 3489, 19873, 19873, 85409},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 5909, 14101, 14101, 14101, 14101},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 3489, 3489, 3489, 3489, 3489},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 1139, 3187, 3187, 3187, 19571, 52339, 117875},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 3489, 11681, 28065, 60833, 126369},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 5969, 5969, 22353, 22353, 22353},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 1441, 3489, 7585, 7585, 23969, 23969, 23969},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 315, 1339, 3387, 3387, 11579, 11579, 11579, 77115},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 417, 8609, 24993, 24993, 24993},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 267, 2315, 2315, 10507, 26891, 59659, 59659},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 417, 8609, 8609, 8609, 74145},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 13, 13, 2061, 6157, 6157, 22541, 55309, 55309},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 4513, 4513, 4513, 4513, 70049},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 1597, 3645, 3645, 3645, 20029, 52797, 52797},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 417, 417, 417, 4513, 12705, 12705, 45473, 111009},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 1529, 5625, 13817, 13817, 13817, 79353},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 1953, 1953, 1953, 1953, 1953},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 2099, 6195, 14387, 30771, 30771, 96307},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 14241, 30625, 30625, 96161},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 101, 8293, 24677, 57445, 57445},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 14241, 14241, 47009, 112545},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 1145, 5241, 5241, 5241, 38009, 103545},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 1953, 6049, 14241, 14241, 14241, 14241},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 7107, 15299, 31683, 31683, 97219},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 4001, 4001, 4001, 36769, 36769},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 471, 1495, 1495, 1495, 1495, 1495, 1495, 67031},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 4001, 12193, 28577, 28577, 94113},
{1, 1, 5, 5, 5, 5, 5, 5, 5, 517, 517, 517, 517, 8709, 25093, 25093, 90629},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 8097, 8097, 8097, 8097},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 467, 1491, 1491, 5587, 5587, 5587, 5587, 71123},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 16289, 32673, 65441, 130977},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 4721, 12913, 12913, 45681, 111217},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 1953, 4001, 8097, 16289, 16289, 16289, 81825},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 7149, 7149, 23533, 56301, 56301},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 929, 929, 929, 929, 66465},
{1, 1, 5, 13, 29, 29, 29, 29, 285, 285, 285, 285, 285, 285, 285, 285, 285},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 5025, 5025, 37793, 103329},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 489, 2537, 2537, 2537, 2537, 35305, 35305},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 5025, 5025, 5025, 5025},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 1555, 1555, 1555, 9747, 26131, 58899, 124435},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 13217, 29601, 29601, 29601},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 6315, 14507, 14507, 47275, 47275},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 929, 5025, 13217, 13217, 45985, 45985},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 3815, 3815, 12007, 12007, 44775, 44775},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 2977, 11169, 11169, 43937, 43937},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 1287, 1287, 5383, 13575, 13575, 13575, 13575},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 7073, 7073, 23457, 23457, 23457},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 2747, 2747, 2747, 2747, 2747, 2747},
{1, 1, 1, 1, 1, 33, 33, 161, 417, 929, 929, 2977, 7073, 15265, 31649, 64417, 64417},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 3023, 7119, 15311, 15311, 15311, 15311},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 5217, 13409, 13409, 46177, 111713},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 2321, 2321, 2321, 67857},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 1121, 1121, 1121, 1121, 1121},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 2683, 6779, 14971, 14971, 47739, 47739},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 1121, 1121, 1121, 17505, 17505, 83041},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 189, 2237, 2237, 2237, 18621, 18621, 18621},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 7265, 23649, 56417, 56417},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 1751, 1751, 1751, 1751, 18135, 50903, 116439},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 7265, 23649, 23649, 89185},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 733, 4829, 4829, 21213, 21213, 21213},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 15457, 15457, 48225, 48225},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 1263, 1263, 5359, 5359, 21743, 21743, 87279},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 1121, 3169, 7265, 15457, 31841, 64609, 130145},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 1817, 1817, 5913, 5913, 22297, 22297, 87833},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 4193, 4193, 4193, 4193, 4193},
{1, 3, 3, 11, 27, 27, 91, 91, 91, 91, 1115, 3163, 3163, 11355, 11355, 44123, 44123},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 4193, 4193, 20577, 53345, 53345},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 2327, 6423, 14615, 30999, 30999, 30999},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 65633},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 1013, 5109, 13301, 13301, 46069, 111605},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 97, 97, 8289, 8289, 41057, 106593},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 3505, 11697, 11697, 11697, 77233},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 6241, 6241, 6241, 39009, 39009},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 63, 2111, 2111, 2111, 2111, 2111, 2111},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 6241, 14433, 30817, 30817, 96353},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 589, 589, 589, 4685, 12877, 29261, 29261, 29261},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 2145, 2145, 2145, 2145, 2145},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 443, 2491, 6587, 14779, 31163, 63931, 129467},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 2145, 2145, 18529, 51297, 51297},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 759, 759, 759, 759, 759, 17143, 49911, 49911},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 97, 97, 2145, 2145, 2145, 18529, 18529, 84065},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 1149, 1149, 1149, 9341, 9341, 9341, 9341},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 5729, 5729, 5729, 5729, 5729},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 3035, 3035, 3035, 3035, 35803, 101339},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 1633, 1633, 1633, 34401, 34401},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 5215, 13407, 13407, 46175, 46175},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 1633, 1633, 9825, 26209, 58977, 58977},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 4711, 12903, 12903, 45671, 45671},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 7777, 7777, 24161, 56929, 122465},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 777, 777, 2825, 2825, 2825, 19209, 19209, 84745},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 3681, 3681, 3681, 36449, 101985},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 3425, 3425, 3425, 36193, 36193},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 1633, 3681, 3681, 11873, 11873, 44641, 44641},
{1, 3, 7, 15, 15, 15, 79, 79, 335, 847, 1871, 1871, 1871, 1871, 1871, 34639, 100175},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 4705, 12897, 29281, 29281, 94817},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 1805, 1805, 1805, 9997, 26381, 59149, 59149},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 609, 609, 609, 609, 609},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 3579, 7675, 7675, 7675, 40443, 105979},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 609, 8801, 8801, 41569, 41569},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 143, 143, 2191, 2191, 2191, 18575, 18575, 84111},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 609, 609, 8801, 25185, 57953, 123489},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 761, 761, 2809, 6905, 15097, 31481, 64249, 64249},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 6753, 6753, 23137, 23137, 88673},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 861, 861, 2909, 2909, 11101, 27485, 60253, 125789},
{1, 1, 1, 1, 1, 33, 97, 97, 97, 609, 609, 2657, 2657, 2657, 19041, 51809, 117345},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 1961, 1961, 1961, 34729, 34729},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 5473, 21857, 54625, 120161},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 2455, 6551, 6551, 6551, 6551, 6551},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 13665, 13665, 46433, 111969},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 943, 2991, 7087, 7087, 23471, 56239, 56239},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 1377, 5473, 13665, 30049, 62817, 62817},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 345, 1369, 1369, 5465, 5465, 5465, 5465, 5465},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 7521, 15713, 15713, 48481, 48481},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 6993, 6993, 23377, 23377, 23377},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 7521, 15713, 15713, 15713, 81249},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 1739, 5835, 5835, 22219, 22219, 22219},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 3425, 11617, 11617, 44385, 109921},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 2127, 6223, 14415, 30799, 30799, 30799},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 1377, 3425, 3425, 11617, 11617, 11617, 11617},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 293, 293, 2341, 2341, 10533, 26917, 26917, 92453},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 4449, 4449, 4449, 37217, 102753},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 1919, 1919, 1919, 18303, 51071, 51071},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 4449, 4449, 20833, 20833, 86369},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 947, 947, 947, 947, 947, 947, 947, 947},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 4449, 12641, 29025, 61793, 127329},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 327, 2375, 2375, 10567, 26951, 26951, 92487},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 353, 353, 353, 16737, 16737, 16737},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 573, 573, 573, 573, 66109},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 2401, 6497, 14689, 14689, 47457, 112993},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 1135, 5231, 5231, 5231, 5231, 70767},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 2401, 6497, 14689, 31073, 63841, 63841},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 1433, 1433, 5529, 13721, 13721, 13721, 79257},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 353, 353, 2401, 2401, 10593, 10593, 43361, 43361},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 8177, 16369, 32753, 32753, 98289},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 5985, 14177, 14177, 14177, 79713},
{1, 3, 3, 11, 11, 11, 11, 139, 139, 651, 651, 651, 4747, 12939, 29323, 29323, 94859},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 5985, 14177, 30561, 63329, 128865},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 1735, 1735, 5831, 14023, 14023, 46791, 46791},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 1889, 1889, 18273, 51041, 116577},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 567, 567, 567, 567, 16951, 16951, 16951},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 1889, 1889, 10081, 26465, 59233, 59233},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 2169, 6265, 6265, 6265, 39033, 39033},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 8033, 8033, 24417, 24417, 24417},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 477, 477, 477, 8669, 8669, 41437, 41437},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 3937, 3937, 3937, 36705, 102241},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 6943, 15135, 31519, 31519, 97055},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 1889, 3937, 3937, 12129, 12129, 12129, 77665},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 1899, 1899, 1899, 1899, 1899, 1899, 67435},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 865, 4961, 4961, 4961, 4961, 70497},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 859, 859, 859, 9051, 25435, 25435, 25435},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 865, 4961, 13153, 13153, 13153, 13153},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 709, 4805, 12997, 12997, 45765, 111301},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 865, 865, 865, 17249, 17249, 82785},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 531, 531, 2579, 6675, 6675, 23059, 55827, 121363},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 7009, 7009, 23393, 23393, 88929},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 1011, 2035, 2035, 6131, 14323, 14323, 47091, 47091},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 2913, 2913, 35681, 35681},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 4065, 4065, 20449, 53217, 53217},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 11105, 11105, 43873, 109409},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 1999, 1999, 1999, 18383, 51151, 116687},
{1, 1, 1, 1, 1, 33, 97, 97, 353, 865, 865, 2913, 2913, 11105, 11105, 11105, 11105},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 165, 165, 4261, 12453, 12453, 12453, 77989},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 5345, 13537, 29921, 29921, 95457},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 3397, 3397, 3397, 3397, 36165, 101701},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 1249, 17633, 50401, 50401},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 1375, 1375, 5471, 13663, 13663, 46431, 111967},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 1249, 1249, 1249, 1249},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 915, 915, 915, 915, 915, 915, 33683, 33683},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 1249, 1249, 9441, 25825, 58593, 124129},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 2353, 10545, 26929, 59697, 125233},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 7393, 7393, 7393, 40161, 105697},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 3593, 3593, 3593, 3593, 3593, 69129},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 7393, 15585, 15585, 48353, 48353},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 135, 2183, 2183, 10375, 26759, 26759, 92295},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 1249, 3297, 3297, 11489, 11489, 44257, 109793},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 825, 1849, 3897, 7993, 7993, 7993, 40761, 106297},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 4321, 12513, 28897, 61665, 127201},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 3473, 3473, 19857, 52625, 118161},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 225, 225, 225, 225, 225, 65761},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 1085, 1085, 1085, 9277, 25661, 58429, 58429},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 6369, 6369, 39137, 39137},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 2135, 6231, 6231, 22615, 55383, 120919},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 6369, 6369, 6369, 71905},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 605, 1629, 3677, 7773, 15965, 32349, 65117, 65117},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 6369, 14561, 14561, 14561, 14561},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 931, 931, 5027, 5027, 21411, 54179, 119715},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 2273, 2273, 18657, 18657, 84193},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 949, 949, 949, 9141, 25525, 58293, 58293},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 2273, 2273, 2273, 2273, 2273},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 83, 83, 4179, 12371, 28755, 28755, 28755},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 225, 225, 2273, 2273, 10465, 10465, 10465, 76001},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 109, 2157, 2157, 2157, 18541, 51309, 51309},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 5857, 5857, 22241, 22241, 87777},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 85, 85, 2133, 6229, 6229, 6229, 38997, 38997},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 5857, 14049, 14049, 14049, 79585},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 909, 909, 2957, 2957, 2957, 19341, 52109, 52109},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 1761, 18145, 18145, 18145},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 891, 891, 2939, 2939, 11131, 27515, 60283, 125819},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 1761, 1761, 34529, 34529},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 3127, 7223, 15415, 15415, 15415, 15415},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 1761, 1761, 9953, 26337, 59105, 59105},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 1551, 1551, 5647, 13839, 30223, 62991, 62991},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 7905, 16097, 16097, 48865, 114401},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 537, 537, 537, 4633, 4633, 4633, 4633, 4633},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 7905, 16097, 16097, 16097, 16097},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 1059, 5155, 5155, 5155, 5155, 70691},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 1761, 3809, 3809, 3809, 3809, 3809, 3809},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 2003, 2003, 6099, 14291, 14291, 14291, 79827},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 4833, 13025, 29409, 62177, 62177},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 559, 559, 2607, 6703, 6703, 6703, 39471, 39471},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 737, 737, 737, 17121, 49889, 49889},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 2783, 2783, 2783, 35551, 101087},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 2785, 6881, 6881, 6881, 39649, 105185},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 3977, 3977, 12169, 12169, 12169, 12169},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 2785, 6881, 6881, 6881, 6881, 6881},
{1, 3, 3, 3, 19, 51, 115, 243, 499, 499, 499, 2547, 2547, 10739, 10739, 43507, 43507},
{1, 1, 1, 1, 1, 33, 97, 225, 225, 737, 737, 2785, 2785, 2785, 19169, 51937, 117473},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 2529, 2529, 18913, 51681, 51681},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 5601, 5601, 5601, 38369, 38369},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 1097, 3145, 3145, 3145, 3145, 3145, 68681},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 1505, 17889, 17889, 83425},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 1147, 1147, 1147, 9339, 9339, 9339, 74875},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 1505, 1505, 9697, 26081, 26081, 26081},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 6501, 14693, 31077, 31077, 96613},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 7649, 15841, 15841, 48609, 48609},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 281, 281, 4377, 4377, 20761, 53529, 53529},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 3553, 3553, 19937, 52705, 118241},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 543, 543, 2591, 6687, 14879, 31263, 31263, 31263},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 3553, 11745, 28129, 28129, 93665},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 619, 1643, 1643, 5739, 5739, 22123, 22123, 87659},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 1505, 3553, 3553, 11745, 11745, 11745, 11745},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 749, 749, 749, 749, 749, 749, 66285},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 481, 4577, 4577, 4577, 37345, 102881},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 1815, 1815, 1815, 1815, 1815, 1815},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 481, 4577, 12769, 29153, 61921, 127457},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 1327, 1327, 1327, 9519, 25903, 25903, 91439},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 481, 481, 8673, 8673, 41441, 106977},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 999, 999, 5095, 5095, 5095, 5095, 70631},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 6625, 6625, 23009, 23009, 23009},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 917, 1941, 1941, 6037, 14229, 30613, 30613, 96149},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 481, 481, 2529, 6625, 14817, 14817, 47585, 113121},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 2055, 2055, 2055, 34823, 100359},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 6113, 14305, 14305, 47073, 47073},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 89, 89, 89, 4185, 4185, 20569, 20569, 86105},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 2017, 2017, 2017, 2017, 67553},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 1171, 3219, 3219, 3219, 3219, 35987, 35987},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 2017, 2017, 10209, 26593, 59361, 59361},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 2609, 10801, 27185, 59953, 125489},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 8161, 8161, 24545, 24545, 24545},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 3605, 11797, 11797, 44565, 44565},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 8161, 16353, 32737, 65505, 65505},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 7761, 24145, 24145, 24145},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 2017, 4065, 8161, 16353, 32737, 32737, 98273},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 1995, 1995, 1995, 1995, 1995},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 5089, 5089, 21473, 21473, 21473},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 725, 725, 725, 4821, 13013, 29397, 29397, 94933},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 5089, 5089, 5089, 37857, 37857},
{1, 1, 1, 9, 9, 9, 73, 201, 457, 457, 1481, 3529, 3529, 11721, 11721, 11721, 11721},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 993, 993, 9185, 9185, 9185, 74721},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 323, 323, 323, 4419, 4419, 4419, 37187, 37187},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 7137, 23521, 23521, 89057},
{1, 3, 3, 11, 27, 27, 27, 27, 27, 539, 1563, 1563, 5659, 5659, 22043, 22043, 22043},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 7137, 15329, 31713, 64481, 130017},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 1391, 1391, 5487, 5487, 5487, 5487, 71023},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 3041, 3041, 19425, 19425, 19425},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 181, 4277, 4277, 20661, 53429, 53429},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 3041, 11233, 27617, 27617, 93153},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 491, 491, 4587, 12779, 29163, 61931, 127467},
{1, 1, 1, 1, 1, 33, 97, 225, 481, 993, 993, 3041, 3041, 11233, 11233, 44001, 109537},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 935, 935, 935, 5031, 13223, 13223, 45991, 111527},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 4369, 4369, 20753, 20753, 20753},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 919, 2967, 2967, 11159, 27543, 27543, 93079},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 273, 273, 273, 273, 273},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 351, 351, 2399, 6495, 14687, 14687, 47455, 112991},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 273, 8465, 8465, 8465, 74001},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 5425, 5425, 21809, 54577, 120113},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 273, 8465, 24849, 24849, 24849},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 3943, 8039, 16231, 32615, 65383, 65383},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 273, 273, 8465, 24849, 57617, 123153},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 173, 173, 2221, 6317, 6317, 6317, 39085, 104621},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 6417, 14609, 14609, 47377, 47377},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 1227, 1227, 1227, 1227, 1227, 1227},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 6417, 14609, 30993, 63761, 129297},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 717, 717, 8909, 8909, 41677, 41677},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 2321, 2321, 35089, 35089},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 827, 827, 827, 827, 17211, 17211, 17211},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 10513, 10513, 10513, 10513},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 2639, 2639, 2639, 2639, 35407, 100943},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 273, 2321, 2321, 10513, 10513, 43281, 108817},
{1, 1, 5, 5, 5, 37, 37, 37, 293, 805, 805, 805, 4901, 13093, 29477, 62245, 62245},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 5393, 5393, 21777, 21777, 87313},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 4809, 4809, 21193, 53961, 53961},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 5393, 13585, 29969, 62737, 128273},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 3597, 3597, 3597, 3597},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 1297, 1297, 17681, 50449, 115985},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 2109, 6205, 6205, 6205, 6205, 6205},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 1297, 9489, 9489, 9489, 9489},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 399, 1423, 1423, 1423, 1423, 17807, 17807, 83343},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 1297, 9489, 25873, 25873, 91409},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 1017, 1017, 1017, 1017, 1017, 1017, 33785, 33785},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 1297, 1297, 9489, 25873, 58641, 58641},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 579, 579, 4675, 4675, 21059, 21059, 86595},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 7441, 7441, 7441, 40209, 40209},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 5403, 5403, 21787, 21787, 87323},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 273, 1297, 3345, 3345, 11537, 11537, 44305, 44305},
{1, 3, 3, 11, 11, 43, 107, 235, 235, 747, 747, 747, 4843, 13035, 29419, 62187, 127723},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 4881, 4881, 4881, 4881, 4881},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 2815, 2815, 2815, 2815, 2815, 68351},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 4881, 4881, 21265, 21265, 86801},
{1, 1, 1, 9, 9, 9, 73, 73, 329, 841, 841, 841, 4937, 13129, 29513, 62281, 127817},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 4881, 13073, 13073, 13073, 78609},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 4113, 12305, 12305, 12305, 77841},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 785, 785, 17169, 49937, 115473},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 445, 445, 445, 445, 8637, 8637, 41405, 106941},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 785, 785, 8977, 25361, 58129, 58129},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 1475, 1475, 5571, 5571, 5571, 38339, 103875},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 2833, 2833, 2833, 35601, 101137},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 1589, 1589, 1589, 1589, 17973, 50741, 50741},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 2833, 11025, 11025, 43793, 43793},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 363, 1387, 1387, 5483, 5483, 21867, 21867, 87403},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 785, 2833, 2833, 11025, 27409, 60177, 125713},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 493, 1517, 3565, 3565, 3565, 3565, 3565, 3565},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 1809, 1809, 1809, 1809, 34577, 100113},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 757, 757, 2805, 6901, 6901, 6901, 6901, 6901},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 1809, 1809, 1809, 18193, 50961, 50961},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 19, 2067, 2067, 2067, 2067, 2067, 67603},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 1809, 1809, 10001, 26385, 26385, 26385},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 231, 231, 8423, 8423, 8423, 73959},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 7953, 7953, 7953, 7953, 7953},
{1, 3, 7, 15, 31, 63, 63, 63, 319, 319, 1343, 1343, 1343, 1343, 1343, 1343, 66879},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 7953, 7953, 24337, 24337, 89873},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 905, 5001, 5001, 5001, 5001, 70537},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 7953, 16145, 16145, 48913, 48913},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 843, 843, 843, 9035, 9035, 41803, 41803},
{1, 1, 1, 1, 17, 17, 17, 17, 273, 785, 1809, 3857, 7953, 16145, 32529, 32529, 32529},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 775, 775, 2823, 6919, 15111, 15111, 47879, 113415},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 4113, 4113, 20497, 53265, 53265},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 2355, 6451, 6451, 6451, 39219, 104755},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 16401, 16401, 16401},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 3895, 3895, 3895, 3895, 3895, 69431},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 6161, 6161, 22545, 22545, 22545},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 1239, 1239, 5335, 13527, 13527, 46295, 46295},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 6161, 14353, 14353, 47121, 112657},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 1797, 1797, 1797, 1797, 1797, 67333},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 17, 2065, 2065, 10257, 26641, 26641, 26641},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 39, 39, 39, 8231, 24615, 24615, 90151},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 5137, 5137, 21521, 54289, 119825},
{1, 1, 5, 13, 29, 29, 29, 29, 29, 29, 1053, 1053, 1053, 9245, 9245, 9245, 9245},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 5137, 13329, 29713, 62481, 62481},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 227, 1251, 1251, 1251, 9443, 25827, 58595, 58595},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 1041, 1041, 17425, 17425, 82961},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 3305, 7401, 15593, 31977, 64745, 64745},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 1041, 9233, 9233, 9233, 74769},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 6065, 6065, 6065, 6065, 71601},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 1041, 1041, 9233, 25617, 25617, 25617},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 999, 2023, 4071, 8167, 8167, 8167, 8167, 8167},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 7185, 7185, 23569, 23569, 89105},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 137, 137, 4233, 4233, 20617, 53385, 53385},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 7185, 15377, 31761, 64529, 130065},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 77, 2125, 2125, 10317, 26701, 26701, 92237},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 3089, 3089, 19473, 19473, 19473},
{1, 3, 7, 7, 23, 55, 119, 247, 247, 247, 247, 247, 4343, 12535, 12535, 45303, 110839},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 3089, 3089, 19473, 52241, 117777},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 3709, 7805, 15997, 15997, 15997, 81533},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 3089, 11281, 11281, 11281, 11281},
{1, 3, 7, 15, 15, 15, 79, 207, 207, 719, 719, 2767, 2767, 2767, 19151, 51919, 117455},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 17, 1041, 3089, 3089, 11281, 27665, 60433, 60433},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 2307, 2307, 10499, 10499, 43267, 108803},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 529, 4625, 4625, 4625, 37393, 37393},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 475, 475, 2523, 6619, 6619, 23003, 55771, 121307},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 529, 4625, 12817, 12817, 12817, 12817},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 1711, 1711, 5807, 5807, 22191, 54959, 54959},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 529, 529, 529, 16913, 49681, 49681},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 147, 147, 147, 147, 147, 16531, 16531, 16531},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 6673, 6673, 23057, 55825, 55825},
{1, 3, 3, 3, 19, 51, 115, 115, 371, 371, 1395, 3443, 3443, 11635, 11635, 11635, 77171},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 6673, 14865, 14865, 14865, 80401},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 593, 8785, 25169, 25169, 25169},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 6673, 14865, 31249, 31249, 31249},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 903, 2951, 7047, 7047, 23431, 23431, 88967},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 6673, 14865, 31249, 64017, 129553},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 461, 461, 461, 4557, 4557, 20941, 20941, 86477},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 529, 2577, 2577, 2577, 18961, 18961, 18961},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 3959, 3959, 12151, 28535, 61303, 126839},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 1553, 5649, 13841, 13841, 13841, 79377},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 4753, 12945, 29329, 62097, 127633},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 7697, 24081, 24081, 24081},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 855, 855, 2903, 2903, 11095, 27479, 60247, 60247},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 15889, 15889, 15889, 15889},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 367, 367, 2415, 6511, 6511, 6511, 6511, 72047},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 7697, 15889, 32273, 65041, 65041},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 163, 4259, 4259, 4259, 4259, 4259},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 3601, 3601, 3601, 36369, 101905},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 1205, 3253, 3253, 11445, 11445, 11445, 76981},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 3601, 3601, 19985, 19985, 85521},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 1449, 3497, 7593, 15785, 15785, 15785, 15785},
{1, 1, 1, 1, 17, 17, 17, 17, 17, 529, 1553, 3601, 3601, 3601, 19985, 52753, 52753},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 851, 851, 851, 4947, 13139, 13139, 45907, 45907},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 4497, 4497, 4497, 37265, 102801},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 5705, 13897, 13897, 46665, 112201},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 4497, 12689, 12689, 45457, 45457},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 1479, 1479, 1479, 1479, 34247, 34247},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 401, 401, 401, 401, 65937},
{1, 1, 5, 13, 29, 61, 61, 189, 189, 189, 1213, 1213, 5309, 13501, 13501, 46269, 46269},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 401, 401, 8593, 8593, 41361, 106897},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 889, 1913, 1913, 1913, 10105, 26489, 26489, 92025},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 14737, 31121, 63889, 63889},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 239, 239, 2287, 6383, 6383, 22767, 22767, 88303},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 6545, 14737, 31121, 31121, 96657},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 261, 261, 261, 261, 8453, 24837, 24837, 90373},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 401, 2449, 2449, 2449, 2449, 35217, 100753},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 553, 2601, 6697, 6697, 6697, 39465, 39465},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 5521, 5521, 5521, 38289, 38289},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 1303, 1303, 5399, 13591, 29975, 29975, 95511},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 5521, 13713, 13713, 13713, 13713},
{1, 3, 3, 3, 3, 35, 99, 227, 227, 739, 739, 2787, 6883, 15075, 31459, 64227, 64227},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 1425, 9617, 26001, 58769, 124305},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 4529, 4529, 4529, 70065},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 1425, 1425, 9617, 9617, 42385, 42385},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 487, 487, 487, 8679, 25063, 25063, 25063},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 7569, 7569, 23953, 56721, 56721},
{1, 3, 7, 15, 31, 63, 63, 63, 63, 63, 1087, 1087, 1087, 1087, 1087, 1087, 1087},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 7569, 7569, 23953, 23953, 89489},
{1, 1, 5, 5, 21, 21, 21, 149, 405, 405, 1429, 3477, 3477, 11669, 28053, 60821, 60821},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 7569, 7569, 7569, 7569, 7569},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 1267, 5363, 13555, 29939, 29939, 29939},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 3473, 3473, 19857, 19857, 19857},
{1, 3, 3, 11, 27, 59, 59, 187, 443, 443, 1467, 1467, 5563, 13755, 13755, 13755, 13755},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 401, 1425, 3473, 3473, 11665, 11665, 44433, 109969},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 1977, 1977, 1977, 1977, 18361, 18361, 83897},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 5009, 5009, 5009, 5009, 70545},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 925, 925, 2973, 7069, 15261, 31645, 31645, 31645},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 5009, 13201, 13201, 45969, 111505},
{1, 1, 1, 9, 25, 25, 89, 89, 89, 601, 601, 2649, 2649, 10841, 27225, 59993, 125529},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 913, 913, 17297, 17297, 82833},
{1, 1, 5, 5, 21, 53, 117, 117, 117, 629, 1653, 1653, 5749, 5749, 5749, 38517, 104053},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 913, 913, 913, 913, 913, 913},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 1683, 3731, 7827, 7827, 24211, 24211, 24211},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 2961, 7057, 7057, 23441, 56209, 56209},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 959, 959, 3007, 7103, 15295, 15295, 15295, 15295},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 913, 2961, 2961, 2961, 19345, 19345, 19345},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 571, 571, 4667, 4667, 4667, 4667, 70203},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 6033, 6033, 6033, 6033, 6033},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 179, 179, 179, 179, 16563, 49331, 49331},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 1937, 6033, 14225, 14225, 14225, 79761},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 2829, 6925, 6925, 6925, 6925, 6925},
{1, 1, 1, 1, 17, 17, 17, 145, 401, 913, 1937, 3985, 8081, 8081, 8081, 40849, 40849},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 1367, 1367, 5463, 5463, 5463, 38231, 38231},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 4241, 4241, 20625, 20625, 20625},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 219, 2267, 2267, 2267, 2267, 35035, 35035},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 4241, 12433, 28817, 61585, 61585},
{1, 3, 7, 15, 15, 47, 47, 175, 431, 943, 1967, 1967, 6063, 6063, 22447, 55215, 55215},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 4241, 12433, 12433, 12433, 12433},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 611, 4707, 12899, 12899, 12899, 78435},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 145, 145, 145, 145, 32913, 98449},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 105, 105, 2153, 6249, 6249, 6249, 39017, 104553},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 6289, 6289, 22673, 22673, 88209},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 789, 1813, 1813, 1813, 1813, 1813, 1813, 67349},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 6289, 14481, 30865, 30865, 30865},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 715, 2763, 6859, 6859, 6859, 39627, 105163},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 6289, 14481, 14481, 14481, 80017},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 1229, 1229, 1229, 1229, 17613, 17613, 83149},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 2193, 2193, 2193, 2193, 67729},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 765, 765, 765, 4861, 4861, 4861, 37629, 103165},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 145, 2193, 2193, 10385, 10385, 43153, 108689},
{1, 1, 1, 9, 25, 57, 57, 57, 313, 313, 1337, 1337, 1337, 9529, 9529, 9529, 75065},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 9361, 25745, 58513, 58513},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 911, 2959, 7055, 15247, 15247, 48015, 48015},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 1169, 1169, 9361, 9361, 42129, 107665},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 1529, 1529, 1529, 1529, 1529, 67065},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 7313, 7313, 40081, 40081},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 599, 599, 2647, 2647, 10839, 10839, 43607, 43607},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 7313, 7313, 7313, 72849},
{1, 1, 5, 13, 29, 29, 93, 93, 93, 93, 1117, 1117, 1117, 9309, 25693, 58461, 123997},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 15505, 31889, 31889, 97425},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 2949, 2949, 2949, 2949, 2949, 2949},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 7313, 15505, 15505, 48273, 113809},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 409, 409, 2457, 2457, 2457, 2457, 2457, 2457},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 3217, 3217, 3217, 3217, 3217},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 595, 595, 595, 8787, 8787, 41555, 41555},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 145, 1169, 3217, 3217, 11409, 11409, 44177, 44177},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 1703, 3751, 7847, 16039, 32423, 65191, 130727},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 4753, 4753, 21137, 21137, 86673},
{1, 1, 5, 5, 21, 21, 85, 85, 85, 597, 597, 597, 597, 597, 597, 597, 66133},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 4753, 12945, 12945, 45713, 45713},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 711, 711, 2759, 6855, 15047, 15047, 47815, 113351},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 657, 657, 657, 657, 66193},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 1981, 1981, 1981, 1981, 18365, 18365, 18365},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 657, 8849, 25233, 25233, 90769},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 101, 101, 4197, 4197, 20581, 53349, 118885},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 657, 657, 8849, 8849, 8849, 8849},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 963, 963, 3011, 3011, 3011, 3011, 35779, 101315},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 6801, 14993, 14993, 14993, 14993},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 1571, 1571, 1571, 1571, 17955, 50723, 116259},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 2705, 10897, 10897, 43665, 43665},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 295, 295, 295, 8487, 8487, 8487, 8487},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 657, 2705, 2705, 10897, 10897, 10897, 76433},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 1005, 3053, 3053, 11245, 27629, 60397, 125933},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 5777, 5777, 5777, 38545, 38545},
{1, 3, 7, 7, 23, 23, 23, 23, 23, 535, 535, 2583, 2583, 2583, 18967, 18967, 84503},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 5777, 13969, 30353, 63121, 63121},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 47, 2095, 2095, 10287, 26671, 26671, 92207},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 1681, 9873, 26257, 59025, 124561},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 4785, 4785, 4785, 4785, 70321},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 1681, 1681, 9873, 26257, 26257, 26257},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 171, 171, 2219, 2219, 2219, 18603, 18603, 18603},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 3729, 3729, 20113, 20113, 20113},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 699, 2747, 6843, 15035, 31419, 64187, 64187},
{1, 1, 1, 1, 17, 17, 17, 145, 145, 657, 1681, 3729, 3729, 11921, 11921, 11921, 11921},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2051, 6147, 14339, 14339, 47107, 47107},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 337, 4433, 12625, 29009, 61777, 61777},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 3941, 3941, 12133, 12133, 12133, 12133},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 337, 4433, 12625, 12625, 45393, 110929},
{1, 3, 3, 3, 3, 3, 67, 195, 195, 195, 195, 2243, 6339, 14531, 14531, 47299, 47299},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 2385, 2385, 18769, 51537, 117073},
{1, 3, 3, 11, 27, 27, 27, 155, 411, 923, 1947, 3995, 8091, 8091, 8091, 8091, 8091},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 6481, 22865, 22865, 88401},
{1, 3, 7, 15, 31, 31, 31, 31, 31, 31, 1055, 1055, 5151, 13343, 29727, 29727, 29727},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 6481, 22865, 55633, 55633},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 821, 1845, 3893, 7989, 7989, 24373, 24373, 24373},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 14673, 31057, 31057, 31057},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 3441, 3441, 3441, 36209, 101745},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 14673, 31057, 63825, 129361},
{1, 3, 3, 11, 11, 43, 107, 107, 107, 107, 107, 2155, 6251, 14443, 14443, 14443, 14443},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 337, 2385, 6481, 14673, 14673, 47441, 47441},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 237, 1261, 1261, 5357, 5357, 21741, 54509, 120045},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 1361, 1361, 1361, 66897},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 279, 279, 2327, 2327, 2327, 2327, 35095, 100631},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 9553, 25937, 25937, 91473},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 815, 815, 2863, 2863, 11055, 27439, 27439, 92975},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 1361, 9553, 9553, 9553, 9553},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 985, 2009, 2009, 2009, 2009, 18393, 18393, 18393},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 5457, 5457, 5457, 5457, 5457},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 1769, 5865, 14057, 30441, 30441, 30441},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 5457, 5457, 5457, 38225, 103761},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 1299, 1299, 1299, 9491, 9491, 9491, 75027},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 1361, 5457, 13649, 30033, 62801, 128337},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 939, 939, 2987, 7083, 15275, 15275, 48043, 48043},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 337, 1361, 3409, 3409, 3409, 3409, 3409, 3409},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 649, 649, 2697, 6793, 6793, 23177, 23177, 23177},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 849, 9041, 25425, 58193, 58193},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 69, 69, 2117, 2117, 10309, 26693, 59461, 124997},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 4945, 4945, 21329, 21329, 86865},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 1119, 1119, 1119, 17503, 17503, 83039},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 4945, 4945, 4945, 37713, 103249},
{1, 3, 3, 3, 19, 19, 19, 147, 147, 659, 659, 659, 659, 8851, 25235, 25235, 25235},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 4945, 13137, 13137, 13137, 78673},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 615, 615, 615, 615, 16999, 16999, 82535},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 849, 4945, 13137, 13137, 45905, 45905},
{1, 1, 5, 13, 13, 45, 45, 173, 429, 429, 429, 429, 429, 429, 16813, 16813, 16813},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 2897, 2897, 19281, 52049, 52049},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 21, 2069, 6165, 14357, 30741, 63509, 129045},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 849, 2897, 6993, 6993, 23377, 56145, 121681},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 571, 1595, 3643, 3643, 11835, 11835, 11835, 11835},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 1873, 1873, 1873, 34641, 100177},
{1, 3, 3, 3, 19, 51, 51, 179, 179, 179, 1203, 3251, 7347, 15539, 31923, 64691, 64691},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 1873, 5969, 14161, 14161, 46929, 112465},
{1, 3, 3, 3, 3, 3, 67, 67, 323, 835, 1859, 3907, 8003, 16195, 32579, 32579, 32579},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 3921, 12113, 28497, 28497, 94033},
{1, 3, 7, 15, 15, 47, 111, 111, 367, 879, 879, 2927, 7023, 7023, 7023, 7023, 72559},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 8017, 8017, 8017, 8017, 8017},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 1961, 6057, 14249, 14249, 47017, 47017},
{1, 1, 1, 1, 17, 17, 81, 81, 337, 849, 1873, 3921, 8017, 16209, 32593, 32593, 32593},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 3313, 3313, 19697, 19697, 85233},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 81, 81, 16465, 49233, 114769},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 219, 1243, 1243, 5339, 13531, 13531, 46299, 111835},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 65617},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 2455, 2455, 10647, 27031, 59799, 125335},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 81, 4177, 4177, 4177, 36945, 102481},
{1, 3, 3, 3, 19, 19, 19, 147, 403, 403, 1427, 3475, 3475, 11667, 28051, 28051, 28051},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 2129, 2129, 2129, 2129, 34897, 100433},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 115, 115, 115, 115, 115, 115, 115, 65651},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 81, 2129, 2129, 10321, 10321, 43089, 43089},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 205, 205, 2253, 2253, 2253, 2253, 35021, 35021},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 1105, 1105, 1105, 17489, 17489, 83025},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 1919, 1919, 6015, 14207, 14207, 14207, 79743},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 1105, 1105, 9297, 25681, 58449, 123985},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 1291, 1291, 9483, 9483, 9483, 75019},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 1105, 5201, 5201, 5201, 37969, 37969},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 573, 4669, 12861, 12861, 12861, 12861},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 7249, 7249, 23633, 56401, 56401},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 437, 1461, 1461, 5557, 13749, 13749, 46517, 112053},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 7249, 7249, 7249, 40017, 105553},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 595, 1619, 3667, 7763, 7763, 7763, 40531, 40531},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 7249, 15441, 15441, 15441, 80977},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 679, 679, 679, 679, 679, 679, 679, 66215},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 81, 1105, 3153, 7249, 15441, 15441, 48209, 48209},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 621, 1645, 3693, 7789, 7789, 7789, 7789, 7789},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 593, 593, 16977, 16977, 82513},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 2303, 2303, 2303, 2303, 2303, 67839},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 4689, 4689, 21073, 53841, 119377},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 1403, 1403, 1403, 1403, 34171, 34171},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 593, 4689, 12881, 29265, 29265, 94801},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 15, 15, 2063, 6159, 14351, 30735, 63503, 63503},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 2641, 10833, 10833, 10833, 10833},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 1049, 1049, 9241, 9241, 42009, 107545},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 2641, 10833, 10833, 43601, 109137},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 547, 547, 2595, 6691, 14883, 31267, 64035, 129571},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 6737, 6737, 23121, 23121, 88657},
{1, 3, 7, 15, 31, 31, 31, 31, 287, 799, 799, 2847, 2847, 2847, 2847, 35615, 35615},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 593, 2641, 6737, 14929, 14929, 14929, 80465},
{1, 3, 7, 7, 7, 39, 39, 39, 295, 295, 1319, 3367, 7463, 7463, 23847, 56615, 56615},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 1617, 9809, 26193, 26193, 91729},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 1071, 5167, 5167, 5167, 37935, 37935},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 1617, 9809, 26193, 58961, 58961},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 709, 709, 709, 709, 709, 709, 33477, 33477},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 1617, 9809, 9809, 42577, 108113},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 483, 483, 2531, 2531, 2531, 18915, 51683, 117219},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 5713, 22097, 22097, 87633},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 1247, 1247, 1247, 1247, 1247, 34015, 99551},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 1617, 5713, 5713, 5713, 5713, 5713},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 489, 1513, 1513, 5609, 13801, 13801, 46569, 112105},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 3665, 11857, 11857, 11857, 77393},
{1, 3, 7, 7, 7, 7, 7, 7, 263, 263, 263, 2311, 6407, 14599, 14599, 14599, 80135},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 3665, 11857, 11857, 44625, 44625},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 333, 333, 333, 4429, 12621, 12621, 45389, 45389},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 7761, 7761, 40529, 40529},
{1, 1, 5, 13, 29, 61, 125, 125, 381, 893, 1917, 1917, 1917, 10109, 26493, 59261, 124797},
{1, 1, 1, 1, 17, 17, 81, 81, 81, 593, 1617, 3665, 7761, 15953, 15953, 48721, 114257},
{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1027, 1027, 1027, 1027, 1027, 33795, 33795},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 465, 465, 16849, 49617, 115153},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 919, 1943, 1943, 6039, 6039, 6039, 38807, 104343},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 465, 465, 465, 16849, 16849, 16849},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 669, 669, 8861, 8861, 41629, 41629},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 2513, 2513, 18897, 51665, 51665},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 3593, 7689, 15881, 15881, 15881, 81417},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 2513, 10705, 10705, 10705, 76241},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 203, 2251, 6347, 14539, 14539, 14539, 80075},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 6609, 6609, 6609, 6609, 72145},
{1, 3, 3, 11, 27, 59, 59, 59, 315, 827, 1851, 3899, 7995, 16187, 32571, 32571, 98107},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 465, 2513, 6609, 14801, 31185, 31185, 96721},
{1, 3, 3, 3, 3, 3, 3, 131, 387, 387, 1411, 3459, 7555, 7555, 23939, 23939, 23939},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 1489, 1489, 17873, 17873, 83409},
{1, 3, 3, 3, 19, 51, 51, 179, 435, 435, 1459, 3507, 3507, 11699, 28083, 60851, 60851},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 1489, 9681, 26065, 26065, 26065},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 525, 525, 525, 16909, 49677, 115213},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 5585, 5585, 5585, 5585, 71121},
{1, 3, 3, 11, 27, 59, 123, 251, 251, 251, 1275, 3323, 7419, 15611, 15611, 15611, 15611},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 1489, 5585, 13777, 30161, 30161, 95697},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 579, 1603, 3651, 3651, 11843, 28227, 28227, 93763},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 3537, 11729, 11729, 11729, 11729},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 389, 389, 389, 8581, 8581, 41349, 41349},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 465, 1489, 3537, 7633, 15825, 15825, 48593, 48593},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 2545, 2545, 18929, 18929, 84465},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 977, 977, 17361, 17361, 82897},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 563, 2611, 2611, 10803, 10803, 43571, 109107},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 977, 9169, 25553, 58321, 123857},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 2247, 6343, 14535, 14535, 14535, 80071},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 5073, 5073, 21457, 54225, 119761},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 55, 1079, 3127, 3127, 3127, 19511, 52279, 117815},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 977, 5073, 13265, 29649, 29649, 95185},
{1, 3, 3, 3, 3, 3, 67, 195, 451, 451, 451, 2499, 2499, 10691, 10691, 43459, 108995},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 3025, 3025, 3025, 3025, 68561},
{1, 3, 3, 11, 27, 27, 27, 155, 155, 667, 1691, 3739, 3739, 3739, 20123, 20123, 85659},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 3025, 3025, 19409, 19409, 19409},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 2013, 6109, 14301, 30685, 30685, 30685},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 3025, 11217, 11217, 43985, 109521},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 495, 1519, 1519, 1519, 9711, 9711, 42479, 42479},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 7121, 7121, 7121, 7121, 7121},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 2613, 2613, 2613, 2613, 2613, 2613},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 977, 3025, 7121, 7121, 23505, 56273, 56273},
{1, 1, 1, 9, 9, 41, 41, 41, 297, 809, 809, 809, 4905, 4905, 21289, 54057, 119593},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 2001, 10193, 26577, 59345, 59345},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 729, 729, 729, 729, 729, 66265},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 2001, 10193, 26577, 26577, 92113},
{1, 3, 3, 3, 3, 35, 99, 227, 483, 995, 2019, 2019, 6115, 6115, 22499, 55267, 120803},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 2001, 6097, 6097, 6097, 38865, 104401},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 735, 735, 2783, 6879, 15071, 31455, 31455, 31455},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 4049, 12241, 12241, 12241, 77777},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 843, 1867, 3915, 8011, 8011, 8011, 40779, 106315},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 4049, 12241, 28625, 28625, 28625},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 1869, 5965, 5965, 22349, 22349, 87885},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 8145, 8145, 24529, 57297, 122833},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 1015, 1015, 5111, 13303, 29687, 29687, 95223},
{1, 1, 1, 1, 17, 17, 81, 209, 465, 977, 2001, 4049, 8145, 16337, 16337, 49105, 114641},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 463, 2511, 2511, 2511, 18895, 51663, 117199},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 209, 209, 8401, 8401, 8401, 73937},
{1, 3, 3, 11, 11, 11, 11, 139, 395, 907, 907, 907, 5003, 5003, 21387, 54155, 119691},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 209, 4305, 12497, 12497, 12497, 12497},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 357, 2405, 2405, 2405, 18789, 18789, 18789},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 2257, 2257, 18641, 51409, 116945},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 215, 215, 2263, 2263, 2263, 18647, 18647, 18647},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 2257, 10449, 10449, 43217, 108753},
{1, 3, 7, 15, 15, 47, 111, 239, 239, 751, 751, 2799, 6895, 6895, 23279, 23279, 88815},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 6353, 6353, 22737, 22737, 88273},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 211, 2259, 2259, 2259, 18643, 51411, 116947},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 209, 2257, 6353, 14545, 30929, 63697, 129233},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 39, 1063, 3111, 7207, 7207, 7207, 39975, 105511},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 1233, 9425, 9425, 9425, 9425},
{1, 1, 5, 5, 5, 5, 69, 197, 453, 965, 1989, 1989, 6085, 6085, 22469, 55237, 120773},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 5329, 5329, 5329, 38097, 103633},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 479, 1503, 1503, 1503, 1503, 1503, 34271, 34271},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 1233, 5329, 13521, 13521, 46289, 46289},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 7089, 7089, 7089, 7089, 72625},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 3281, 3281, 19665, 52433, 52433},
{1, 1, 1, 9, 9, 9, 9, 137, 137, 137, 1161, 3209, 7305, 7305, 23689, 56457, 121993},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 3281, 11473, 27857, 60625, 126161},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2055, 6151, 14343, 30727, 30727, 30727},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 7377, 7377, 23761, 23761, 23761},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 637, 637, 4733, 12925, 29309, 62077, 62077},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 209, 1233, 3281, 7377, 15569, 15569, 15569, 15569},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 1445, 1445, 5541, 5541, 21925, 21925, 87461},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 721, 721, 17105, 17105, 17105},
{1, 1, 5, 13, 29, 29, 29, 157, 413, 413, 413, 413, 4509, 4509, 20893, 20893, 20893},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 721, 8913, 8913, 8913, 8913},
{1, 1, 5, 5, 5, 5, 69, 69, 69, 581, 1605, 3653, 3653, 3653, 3653, 36421, 101957},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 721, 8913, 25297, 25297, 90833},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 3939, 8035, 8035, 8035, 8035, 8035},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 13009, 13009, 45777, 45777},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 6705, 6705, 23089, 55857, 121393},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 721, 4817, 13009, 13009, 13009, 78545},
{1, 3, 3, 11, 11, 43, 43, 43, 43, 555, 555, 555, 555, 555, 555, 33323, 98859},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 2769, 2769, 2769, 2769, 2769},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 533, 1557, 3605, 7701, 7701, 7701, 40469, 106005},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 2769, 10961, 10961, 10961, 76497},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 1995, 1995, 6091, 14283, 30667, 63435, 63435},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 721, 2769, 6865, 15057, 31441, 31441, 96977},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 643, 4739, 4739, 21123, 21123, 86659},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 5841, 5841, 5841, 71377},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 1019, 5115, 13307, 29691, 62459, 62459},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 5841, 22225, 54993, 120529},
{1, 3, 7, 7, 23, 55, 55, 183, 183, 183, 1207, 3255, 3255, 11447, 11447, 44215, 109751},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 14033, 14033, 46801, 112337},
{1, 3, 7, 15, 15, 15, 15, 143, 143, 655, 1679, 1679, 1679, 1679, 18063, 18063, 83599},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 1745, 5841, 14033, 30417, 63185, 63185},
{1, 1, 1, 9, 25, 57, 121, 249, 249, 249, 1273, 3321, 3321, 3321, 19705, 19705, 85241},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 3793, 11985, 28369, 61137, 61137},
{1, 1, 1, 9, 25, 25, 25, 153, 153, 153, 153, 153, 153, 153, 16537, 16537, 16537},
{1, 1, 1, 1, 17, 17, 81, 209, 209, 721, 1745, 3793, 7889, 7889, 24273, 57041, 57041},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 425, 425, 425, 4521, 12713, 12713, 12713, 78249},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 5425, 13617, 30001, 62769, 62769},
{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 4095, 4095, 4095, 4095, 4095},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 5425, 13617, 30001, 30001, 95537},
{1, 1, 5, 5, 21, 21, 85, 85, 341, 341, 1365, 1365, 1365, 9557, 25941, 25941, 25941},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 5425, 13617, 13617, 13617, 13617},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 819, 819, 819, 819, 819, 17203, 49971, 115507},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 5425, 5425, 5425, 5425, 70961},
{1, 1, 5, 13, 13, 13, 13, 141, 141, 653, 1677, 1677, 5773, 13965, 30349, 30349, 30349},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 1329, 9521, 25905, 25905, 25905},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 635, 635, 635, 4731, 12923, 12923, 12923, 12923},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 1329, 9521, 9521, 42289, 42289},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 311, 1335, 1335, 5431, 13623, 30007, 30007, 30007},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 1329, 1329, 1329, 17713, 17713, 83249},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 869, 1893, 1893, 5989, 14181, 14181, 46949, 112485},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 7473, 15665, 15665, 15665, 81201},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 733, 733, 2781, 6877, 15069, 31453, 64221, 64221},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 11569, 11569, 44337, 109873},
{1, 1, 1, 9, 9, 41, 41, 41, 41, 553, 1577, 3625, 3625, 3625, 3625, 36393, 101929},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 11569, 11569, 11569, 11569},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 1747, 3795, 3795, 11987, 11987, 44755, 110291},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 3377, 19761, 52529, 118065},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 5489, 5489, 5489, 38257, 103793},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 1329, 3377, 3377, 3377, 3377, 36145, 36145},
{1, 3, 7, 7, 7, 39, 39, 39, 39, 551, 551, 2599, 6695, 6695, 6695, 6695, 6695},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 305, 8497, 24881, 24881, 90417},
{1, 1, 5, 5, 21, 53, 117, 245, 501, 1013, 1013, 3061, 7157, 7157, 7157, 7157, 72693},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 305, 8497, 8497, 41265, 106801},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 745, 1769, 3817, 3817, 12009, 28393, 28393, 28393},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 305, 305, 305, 305, 33073, 33073},
{1, 3, 7, 7, 7, 39, 103, 231, 487, 487, 1511, 1511, 1511, 9703, 26087, 26087, 91623},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 6449, 14641, 14641, 14641, 14641},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 243, 243, 4339, 12531, 12531, 12531, 12531},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 6449, 6449, 22833, 22833, 22833},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 587, 1611, 1611, 5707, 13899, 13899, 46667, 112203},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 6449, 6449, 6449, 39217, 39217},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 519, 1543, 3591, 7687, 15879, 32263, 65031, 130567},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 305, 305, 2353, 2353, 2353, 2353, 35121, 100657},
{1, 1, 1, 9, 25, 57, 57, 185, 441, 953, 953, 953, 5049, 5049, 21433, 21433, 21433},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 14129, 30513, 30513, 30513},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 987, 987, 987, 987, 987, 987, 66523},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 5937, 5937, 22321, 55089, 55089},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 1199, 3247, 3247, 11439, 11439, 11439, 76975},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 1841, 1841, 10033, 26417, 59185, 59185},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 95, 1119, 3167, 7263, 15455, 15455, 48223, 48223},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 1841, 3889, 3889, 3889, 3889, 3889, 3889},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 131, 1155, 1155, 5251, 13443, 13443, 13443, 78979},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 4913, 13105, 29489, 29489, 95025},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 1237, 3285, 7381, 15573, 15573, 48341, 113877},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 817, 9009, 25393, 25393, 25393},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 507, 1531, 1531, 5627, 5627, 5627, 5627, 71163},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 817, 817, 817, 17201, 17201, 82737},
{1, 1, 5, 5, 5, 37, 101, 229, 229, 741, 1765, 3813, 3813, 12005, 28389, 61157, 126693},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 6961, 15153, 15153, 47921, 47921},
{1, 3, 7, 7, 23, 23, 87, 87, 343, 343, 343, 343, 4439, 4439, 4439, 37207, 102743},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 11057, 27441, 27441, 92977},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 693, 1717, 3765, 7861, 7861, 7861, 7861, 7861},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 11057, 11057, 43825, 109361},
{1, 1, 1, 9, 9, 41, 41, 169, 425, 937, 1961, 4009, 4009, 12201, 12201, 44969, 44969},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 11057, 11057, 11057, 11057},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 339, 2387, 2387, 10579, 26963, 59731, 59731},
{1, 1, 1, 1, 17, 49, 49, 49, 305, 817, 817, 2865, 2865, 2865, 2865, 35633, 35633},
{1, 3, 7, 7, 7, 39, 39, 167, 423, 423, 1447, 1447, 1447, 1447, 17831, 50599, 116135},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 5169, 13361, 13361, 46129, 46129},
{1, 3, 7, 7, 23, 23, 23, 151, 407, 407, 407, 407, 4503, 4503, 4503, 4503, 4503},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 5169, 13361, 13361, 13361, 78897},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 157, 1181, 3229, 7325, 7325, 23709, 56477, 56477},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 5169, 5169, 21553, 21553, 87089},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 837, 837, 837, 837, 837, 17221, 17221, 82757},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 1073, 1073, 9265, 25649, 58417, 58417},
{1, 3, 7, 15, 31, 31, 95, 95, 351, 863, 863, 863, 863, 863, 17247, 17247, 17247},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 7217, 7217, 23601, 23601, 23601},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 715, 1739, 3787, 7883, 7883, 24267, 57035, 57035},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 1073, 3121, 3121, 3121, 19505, 52273, 52273},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 79, 79, 4175, 12367, 28751, 28751, 28751},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 4145, 12337, 12337, 45105, 110641},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 201, 201, 201, 201, 16585, 16585, 16585},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 4145, 4145, 20529, 20529, 20529},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 267, 1291, 3339, 7435, 7435, 23819, 23819, 89355},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 8241, 8241, 8241, 73777},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 573, 573, 2621, 2621, 10813, 10813, 43581, 109117},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 49, 16433, 49201, 49201},
{1, 3, 7, 15, 15, 15, 15, 143, 399, 911, 1935, 3983, 8079, 16271, 16271, 49039, 49039},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 67, 2115, 2115, 2115, 2115, 2115, 67651},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 14385, 30769, 30769, 30769},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 1819, 3867, 3867, 3867, 3867, 36635, 102171},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 6193, 22577, 55345, 55345},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 111, 1135, 3183, 7279, 7279, 7279, 7279, 72815},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 6193, 6193, 6193, 6193, 6193},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 419, 1443, 1443, 1443, 1443, 17827, 17827, 83363},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 49, 49, 2097, 2097, 2097, 18481, 51249, 116785},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 6129, 6129, 22513, 22513, 88049},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 5681, 13873, 30257, 63025, 63025},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 255, 255, 255, 4351, 12543, 28927, 61695, 61695},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 5681, 5681, 5681, 5681, 71217},
{1, 1, 5, 13, 13, 13, 13, 141, 397, 397, 1421, 1421, 1421, 1421, 1421, 34189, 99725},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 1585, 9777, 26161, 26161, 26161},
{1, 3, 3, 11, 27, 59, 123, 123, 379, 379, 1403, 3451, 7547, 15739, 32123, 64891, 64891},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 1585, 9777, 9777, 9777, 75313},
{1, 1, 5, 13, 29, 61, 61, 189, 445, 957, 957, 957, 5053, 5053, 5053, 5053, 5053},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 1585, 1585, 17969, 17969, 83505},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 101, 1125, 1125, 1125, 1125, 1125, 33893, 33893},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 1585, 1585, 1585, 1585, 34353, 99889},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 121, 121, 4217, 12409, 12409, 45177, 45177},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 3633, 7729, 7729, 24113, 56881, 56881},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 1007, 1007, 1007, 9199, 9199, 41967, 41967},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 3633, 7729, 7729, 7729, 40497, 106033},
{1, 1, 1, 9, 25, 25, 25, 25, 25, 25, 1049, 3097, 7193, 15385, 15385, 48153, 113689},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 1585, 3633, 3633, 3633, 3633, 3633, 69169},
{1, 1, 5, 13, 13, 45, 109, 237, 493, 1005, 2029, 4077, 8173, 16365, 16365, 49133, 114669},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 4657, 4657, 21041, 53809, 53809},
{1, 3, 7, 15, 15, 47, 47, 47, 47, 47, 1071, 3119, 3119, 11311, 27695, 27695, 93231},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 561, 561, 8753, 25137, 25137, 90673},
{1, 1, 5, 5, 21, 53, 117, 245, 245, 245, 245, 2293, 2293, 10485, 10485, 10485, 76021},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 6705, 6705, 23089, 23089, 23089},
{1, 3, 3, 11, 11, 11, 75, 75, 331, 331, 331, 2379, 6475, 14667, 31051, 31051, 31051},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 2609, 10801, 27185, 27185, 27185},
{1, 3, 3, 11, 27, 59, 59, 187, 187, 699, 1723, 3771, 7867, 16059, 16059, 48827, 114363},
{1, 1, 1, 1, 17, 49, 49, 49, 49, 561, 561, 2609, 2609, 2609, 18993, 51761, 51761},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 1999, 4047, 4047, 4047, 20431, 53199, 118735},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 13745, 13745, 46513, 46513},
{1, 3, 3, 11, 27, 27, 91, 219, 219, 731, 731, 731, 4827, 4827, 21211, 21211, 21211},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 13745, 30129, 62897, 128433},
{1, 1, 5, 13, 29, 29, 29, 157, 157, 669, 669, 2717, 6813, 15005, 15005, 15005, 80541},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 1457, 5553, 5553, 5553, 38321, 103857},
{1, 1, 5, 5, 5, 5, 69, 69, 325, 325, 1349, 1349, 1349, 9541, 9541, 9541, 75077},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 7601, 15793, 15793, 48561, 114097},
{1, 1, 5, 5, 21, 21, 21, 21, 277, 277, 1301, 1301, 5397, 13589, 13589, 13589, 13589},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 7601, 15793, 32177, 32177, 97713},
{1, 1, 1, 9, 9, 9, 9, 9, 9, 521, 1545, 1545, 1545, 9737, 9737, 9737, 75273},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 1457, 3505, 3505, 3505, 3505, 3505, 3505},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 1615, 3663, 3663, 3663, 3663, 36431, 101967},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 4529, 4529, 37297, 37297},
{1, 3, 3, 11, 11, 11, 11, 11, 267, 779, 779, 779, 779, 779, 17163, 49931, 49931},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 4529, 4529, 20913, 53681, 119217},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 525, 2573, 6669, 6669, 23053, 23053, 23053},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 433, 433, 433, 433, 33201, 98737},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 997, 3045, 7141, 15333, 15333, 48101, 48101},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 6577, 14769, 14769, 47537, 47537},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 283, 283, 4379, 4379, 4379, 4379, 4379},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 6577, 14769, 31153, 31153, 31153},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 87, 87, 4183, 4183, 20567, 53335, 118871},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 6577, 6577, 22961, 22961, 88497},
{1, 1, 1, 9, 25, 25, 25, 153, 409, 921, 921, 2969, 7065, 7065, 7065, 39833, 39833},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 433, 433, 2481, 2481, 10673, 27057, 27057, 92593},
{1, 1, 1, 9, 9, 41, 41, 169, 169, 681, 681, 2729, 2729, 10921, 27305, 60073, 60073},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 1969, 6065, 6065, 22449, 22449, 22449},
{1, 3, 7, 7, 7, 7, 71, 199, 199, 199, 199, 199, 199, 199, 16583, 49351, 49351},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 8113, 16305, 32689, 32689, 32689},
{1, 3, 7, 7, 23, 23, 87, 215, 471, 983, 2007, 4055, 4055, 4055, 4055, 36823, 102359},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 8113, 16305, 32689, 65457, 130993},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 989, 2013, 4061, 4061, 12253, 28637, 61405, 126941},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 8113, 8113, 24497, 57265, 57265},
{1, 3, 3, 3, 3, 35, 35, 35, 35, 35, 1059, 3107, 7203, 7203, 7203, 39971, 105507},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 1969, 4017, 4017, 12209, 12209, 44977, 110513},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 565, 565, 565, 4661, 4661, 4661, 37429, 102965},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 5041, 13233, 13233, 46001, 46001},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 1371, 1371, 5467, 13659, 30043, 30043, 95579},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 5041, 5041, 5041, 37809, 103345},
{1, 1, 5, 5, 5, 5, 69, 197, 197, 197, 1221, 3269, 7365, 15557, 31941, 31941, 97477},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 5041, 5041, 21425, 21425, 86961},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 729, 729, 2777, 6873, 6873, 6873, 6873, 72409},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 945, 9137, 25521, 58289, 58289},
{1, 3, 3, 3, 19, 19, 19, 19, 19, 19, 1043, 3091, 3091, 3091, 19475, 19475, 85011},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 945, 945, 945, 945, 33713, 33713},
{1, 3, 3, 11, 11, 43, 43, 171, 171, 683, 683, 683, 4779, 4779, 4779, 37547, 37547},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 7089, 15281, 31665, 31665, 97201},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 1929, 1929, 1929, 1929, 1929, 1929, 1929},
{1, 1, 1, 1, 17, 49, 49, 177, 433, 945, 945, 2993, 7089, 7089, 23473, 56241, 121777},
{1, 1, 5, 13, 13, 13, 77, 77, 333, 845, 1869, 3917, 3917, 3917, 20301, 53069, 53069},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 5297, 13489, 29873, 62641, 62641},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 1331, 3379, 7475, 7475, 23859, 56627, 122163},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 1201, 1201, 1201, 17585, 17585, 83121},
{1, 1, 1, 9, 25, 57, 121, 121, 377, 377, 1401, 1401, 5497, 13689, 30073, 62841, 128377},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 7345, 15537, 31921, 64689, 130225},
{1, 1, 5, 13, 29, 29, 93, 221, 221, 221, 1245, 3293, 7389, 7389, 7389, 7389, 72925},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 7345, 7345, 23729, 56497, 56497},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 803, 803, 803, 4899, 4899, 4899, 37667, 37667},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 1201, 3249, 3249, 3249, 3249, 3249, 68785},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 4977, 4977, 4977, 37745, 103281},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 4273, 12465, 28849, 28849, 28849},
{1, 3, 7, 7, 23, 23, 23, 23, 279, 791, 1815, 3863, 3863, 3863, 3863, 3863, 3863},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 4273, 4273, 20657, 20657, 86193},
{1, 1, 1, 9, 25, 25, 89, 217, 473, 473, 473, 2521, 6617, 6617, 23001, 55769, 121305},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 177, 8369, 24753, 24753, 90289},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 233, 2281, 2281, 10473, 26857, 59625, 125161},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 177, 177, 8369, 24753, 57521, 57521},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 787, 787, 787, 787, 787, 17171, 17171, 82707},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 6321, 14513, 30897, 63665, 63665},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 755, 1779, 3827, 3827, 12019, 12019, 12019, 12019},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 6321, 6321, 6321, 39089, 39089},
{1, 3, 3, 11, 11, 11, 75, 75, 75, 75, 75, 2123, 2123, 10315, 10315, 10315, 10315},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 177, 177, 2225, 6321, 6321, 22705, 55473, 121009},
{1, 1, 5, 13, 13, 13, 77, 77, 77, 77, 1101, 3149, 7245, 15437, 15437, 15437, 80973},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 14001, 30385, 30385, 30385},
{1, 3, 7, 7, 23, 23, 23, 151, 151, 151, 151, 151, 4247, 4247, 20631, 20631, 20631},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 5809, 5809, 5809, 5809},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 687, 687, 687, 4783, 4783, 21167, 53935, 53935},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 1713, 5809, 5809, 22193, 54961, 54961},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 867, 1891, 1891, 1891, 10083, 26467, 26467, 26467},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 7857, 16049, 16049, 16049, 16049},
{1, 3, 7, 15, 31, 63, 63, 191, 447, 447, 447, 447, 447, 447, 16831, 49599, 115135},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 7857, 16049, 32433, 32433, 97969},
{1, 1, 1, 9, 9, 9, 9, 9, 265, 265, 1289, 1289, 1289, 9481, 25865, 58633, 58633},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 7857, 7857, 24241, 24241, 24241},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 903, 1927, 3975, 8071, 8071, 24455, 24455, 24455},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 3761, 11953, 11953, 44721, 44721},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 59, 2107, 2107, 2107, 18491, 51259, 116795},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 1713, 3761, 3761, 3761, 20145, 52913, 52913},
{1, 3, 3, 3, 3, 3, 3, 131, 131, 643, 643, 2691, 2691, 10883, 10883, 10883, 76419},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 4785, 4785, 21169, 21169, 21169},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 71, 71, 71, 8263, 8263, 8263, 8263},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 4785, 4785, 21169, 53937, 119473},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 269, 269, 2317, 2317, 10509, 10509, 43277, 108813},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 689, 8881, 8881, 41649, 41649},
{1, 3, 3, 11, 27, 59, 123, 251, 507, 1019, 1019, 3067, 3067, 3067, 3067, 35835, 35835},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 689, 689, 8881, 25265, 58033, 123569},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 1853, 3901, 7997, 16189, 16189, 48957, 48957},
{1, 1, 1, 1, 17, 49, 49, 177, 177, 689, 689, 2737, 2737, 10929, 10929, 43697, 109233},
{1, 1, 5, 5, 21, 53, 53, 181, 181, 181, 181, 2229, 6325, 14517, 30901, 30901, 30901},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 1393, 1393, 17777, 50545, 116081},
{1, 1, 1, 9, 25, 25, 89, 89, 345, 857, 1881, 1881, 5977, 14169, 14169, 46937, 46937},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 1393, 5489, 5489, 5489, 5489, 5489},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 2347, 2347, 2347, 2347, 2347, 67883},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 3441, 11633, 28017, 28017, 28017},
{1, 3, 3, 3, 19, 51, 115, 115, 115, 627, 627, 2675, 6771, 6771, 23155, 23155, 88691},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 3441, 3441, 19825, 19825, 85361},
{1, 1, 5, 13, 13, 13, 77, 205, 205, 717, 717, 2765, 6861, 15053, 15053, 15053, 80589},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 1393, 3441, 7537, 15729, 32113, 32113, 97649},
{1, 1, 5, 13, 29, 61, 125, 253, 253, 253, 1277, 3325, 3325, 11517, 27901, 60669, 126205},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 369, 8561, 8561, 8561, 74097},
{1, 1, 5, 5, 21, 21, 85, 213, 469, 469, 1493, 1493, 1493, 9685, 9685, 9685, 75221},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 4465, 12657, 29041, 29041, 94577},
{1, 1, 5, 13, 29, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 32829, 98365},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 369, 4465, 4465, 4465, 4465, 70001},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 2021, 6117, 14309, 30693, 30693, 30693},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 2417, 2417, 18801, 18801, 18801},
{1, 3, 3, 3, 3, 35, 35, 163, 419, 931, 1955, 1955, 1955, 10147, 26531, 26531, 92067},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 6513, 14705, 14705, 14705, 80241},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 1973, 1973, 1973, 1973, 1973, 34741, 34741},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 369, 369, 2417, 6513, 6513, 22897, 55665, 55665},
{1, 3, 7, 7, 7, 39, 39, 167, 167, 167, 167, 2215, 6311, 14503, 30887, 30887, 30887},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 1905, 10097, 10097, 42865, 42865},
{1, 3, 7, 15, 31, 63, 127, 255, 255, 767, 767, 767, 4863, 13055, 29439, 62207, 62207},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 6001, 6001, 6001, 6001, 71537},
{1, 1, 5, 5, 5, 37, 101, 101, 101, 613, 1637, 3685, 3685, 11877, 11877, 11877, 11877},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 1905, 6001, 6001, 22385, 55153, 120689},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 633, 633, 2681, 6777, 14969, 14969, 14969, 14969},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 1905, 3953, 8049, 16241, 32625, 32625, 32625},
{1, 3, 3, 3, 19, 19, 83, 211, 467, 979, 979, 979, 979, 979, 979, 33747, 99283},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 881, 9073, 9073, 9073, 9073},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 347, 347, 2395, 2395, 2395, 18779, 18779, 18779},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 4977, 13169, 29553, 62321, 127857},
{1, 1, 1, 9, 9, 41, 105, 233, 489, 1001, 2025, 2025, 2025, 10217, 10217, 10217, 75753},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 881, 4977, 4977, 21361, 54129, 54129},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 231, 231, 2279, 6375, 6375, 22759, 55527, 55527},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 2929, 11121, 27505, 60273, 125809},
{1, 1, 1, 9, 9, 9, 9, 137, 393, 905, 905, 2953, 2953, 2953, 2953, 2953, 68489},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 7025, 15217, 31601, 64369, 64369},
{1, 3, 7, 7, 23, 55, 119, 247, 503, 1015, 2039, 2039, 6135, 14327, 30711, 30711, 30711},
{1, 1, 1, 1, 17, 49, 113, 113, 369, 881, 881, 2929, 7025, 7025, 7025, 39793, 39793},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 463, 1487, 3535, 3535, 3535, 19919, 52687, 118223},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 1137, 9329, 25713, 25713, 25713},
{1, 3, 3, 3, 19, 51, 51, 51, 307, 307, 307, 307, 307, 8499, 24883, 57651, 123187},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 13425, 13425, 13425, 13425},
{1, 3, 3, 11, 27, 59, 123, 123, 123, 123, 123, 123, 4219, 4219, 4219, 36987, 36987},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 13425, 29809, 62577, 62577},
{1, 3, 7, 7, 23, 55, 55, 55, 311, 823, 1847, 1847, 5943, 14135, 30519, 63287, 63287},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 1137, 5233, 5233, 5233, 5233, 70769},
{1, 1, 5, 5, 5, 37, 101, 101, 357, 357, 1381, 3429, 7525, 7525, 7525, 7525, 73061},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 3185, 3185, 3185, 3185, 68721},
{1, 1, 5, 5, 5, 5, 5, 5, 261, 773, 1797, 3845, 7941, 7941, 7941, 40709, 40709},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 3185, 3185, 19569, 52337, 117873},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 281, 1305, 1305, 5401, 13593, 29977, 62745, 128281},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 15473, 15473, 15473, 81009},
{1, 1, 5, 5, 21, 53, 53, 53, 309, 309, 1333, 3381, 3381, 11573, 27957, 27957, 93493},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 15473, 31857, 31857, 31857},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 211, 1235, 3283, 3283, 3283, 3283, 36051, 101587},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 1137, 3185, 7281, 7281, 23665, 23665, 89201},
{1, 1, 5, 13, 13, 45, 109, 237, 237, 749, 1773, 1773, 1773, 9965, 26349, 26349, 26349},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 113, 113, 113, 32881, 32881},
{1, 3, 7, 15, 15, 47, 47, 47, 303, 303, 303, 303, 4399, 4399, 4399, 37167, 37167},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 4209, 12401, 28785, 61553, 127089},
{1, 1, 1, 9, 9, 41, 105, 233, 233, 233, 1257, 1257, 1257, 9449, 25833, 58601, 58601},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 113, 4209, 4209, 4209, 4209, 4209},
{1, 3, 3, 11, 11, 43, 43, 171, 427, 427, 427, 427, 427, 8619, 25003, 25003, 25003},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 2161, 2161, 18545, 51313, 51313},
{1, 3, 7, 7, 7, 7, 7, 7, 7, 7, 1031, 3079, 7175, 15367, 31751, 31751, 97287},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 6257, 14449, 30833, 30833, 96369},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 637, 1661, 1661, 1661, 9853, 9853, 42621, 42621},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 6257, 6257, 6257, 6257, 71793},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 421, 421, 421, 421, 421, 421, 421, 421},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 113, 113, 2161, 6257, 6257, 22641, 22641, 22641},
{1, 3, 3, 3, 3, 3, 3, 3, 259, 259, 259, 259, 4355, 4355, 20739, 53507, 119043},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 5745, 13937, 13937, 46705, 46705},
{1, 3, 7, 15, 31, 31, 95, 95, 95, 607, 1631, 3679, 7775, 15967, 15967, 48735, 48735},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 1649, 5745, 13937, 30321, 63089, 128625},
{1, 1, 1, 9, 9, 41, 105, 105, 361, 361, 1385, 1385, 1385, 1385, 17769, 50537, 116073},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 3697, 3697, 3697, 3697, 3697},
{1, 3, 3, 11, 11, 11, 75, 203, 459, 971, 971, 971, 5067, 13259, 13259, 46027, 111563},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 7793, 15985, 15985, 15985, 15985},
{1, 3, 3, 11, 27, 59, 59, 59, 59, 59, 1083, 1083, 5179, 13371, 29755, 62523, 62523},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 1649, 3697, 7793, 15985, 32369, 65137, 65137},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 887, 1911, 1911, 6007, 6007, 6007, 6007, 6007},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 625, 625, 17009, 49777, 49777},
{1, 3, 7, 7, 7, 7, 71, 71, 71, 71, 1095, 3143, 7239, 7239, 23623, 56391, 56391},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 625, 4721, 12913, 29297, 29297, 94833},
{1, 1, 5, 13, 29, 61, 61, 61, 317, 829, 829, 829, 4925, 13117, 29501, 29501, 95037},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 2673, 10865, 27249, 27249, 92785},
{1, 1, 5, 13, 29, 29, 93, 93, 349, 349, 349, 2397, 2397, 10589, 26973, 26973, 92509},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 2673, 2673, 19057, 19057, 19057},
{1, 3, 3, 3, 3, 35, 35, 163, 163, 163, 163, 2211, 2211, 10403, 26787, 26787, 26787},
{1, 1, 1, 1, 17, 49, 113, 113, 113, 625, 625, 2673, 6769, 6769, 6769, 6769, 6769},
{1, 3, 3, 11, 11, 43, 107, 235, 491, 491, 1515, 1515, 1515, 1515, 17899, 17899, 17899},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 1521, 1521, 1521, 1521, 1521, 1521},
{1, 3, 7, 7, 7, 7, 71, 199, 455, 455, 1479, 3527, 7623, 15815, 32199, 32199, 97735},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 1521, 5617, 5617, 22001, 22001, 22001},
{1, 3, 7, 15, 15, 15, 15, 15, 271, 783, 783, 783, 783, 783, 783, 783, 66319},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 3569, 11761, 11761, 11761, 11761},
{1, 3, 7, 7, 23, 23, 87, 215, 215, 727, 727, 727, 4823, 13015, 13015, 13015, 78551},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 3569, 3569, 3569, 3569, 69105},
{1, 1, 1, 9, 25, 25, 25, 25, 281, 793, 793, 793, 4889, 13081, 29465, 29465, 29465},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 3569, 3569, 3569, 36337, 36337},
{1, 3, 3, 3, 3, 35, 35, 35, 291, 291, 291, 291, 4387, 12579, 12579, 45347, 45347},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 1521, 3569, 7665, 15857, 15857, 48625, 48625},
{1, 3, 3, 3, 19, 19, 83, 211, 211, 723, 723, 723, 4819, 4819, 4819, 37587, 103123},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 4593, 12785, 29169, 29169, 29169},
{1, 3, 7, 15, 31, 31, 95, 223, 479, 991, 2015, 4063, 8159, 16351, 32735, 32735, 98271},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 497, 4593, 12785, 12785, 45553, 45553},
{1, 3, 3, 3, 19, 19, 19, 19, 275, 275, 275, 275, 275, 8467, 24851, 24851, 90387},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 2545, 10737, 10737, 43505, 43505},
{1, 3, 3, 3, 19, 51, 115, 243, 243, 243, 1267, 3315, 3315, 3315, 3315, 3315, 3315},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 6641, 14833, 14833, 47601, 113137},
{1, 1, 5, 13, 29, 61, 125, 125, 125, 125, 125, 125, 125, 125, 16509, 16509, 82045},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 497, 497, 2545, 6641, 6641, 23025, 55793, 121329},
{1, 1, 5, 5, 5, 37, 37, 165, 421, 933, 1957, 1957, 1957, 10149, 26533, 26533, 26533},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 2033, 10225, 26609, 59377, 59377},
{1, 3, 3, 11, 27, 27, 91, 219, 475, 987, 2011, 4059, 8155, 16347, 16347, 16347, 16347},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 2033, 2033, 18417, 18417, 18417},
{1, 3, 7, 15, 15, 47, 47, 175, 175, 175, 175, 175, 4271, 4271, 20655, 53423, 53423},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 2033, 2033, 2033, 34801, 34801},
{1, 3, 3, 3, 3, 35, 99, 99, 355, 355, 1379, 1379, 1379, 1379, 17763, 17763, 17763},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 2033, 6129, 6129, 6129, 6129, 6129},
{1, 3, 7, 7, 7, 39, 103, 103, 103, 615, 1639, 1639, 1639, 1639, 18023, 18023, 18023},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 12273, 28657, 61425, 126961},
{1, 1, 5, 5, 21, 21, 21, 21, 21, 21, 1045, 3093, 3093, 11285, 11285, 44053, 44053},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 4081, 4081, 4081, 4081},
{1, 3, 7, 7, 7, 7, 7, 135, 391, 391, 1415, 3463, 7559, 7559, 23943, 56711, 56711},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 4081, 4081, 4081, 36849, 102385},
{1, 1, 5, 13, 13, 13, 77, 205, 461, 973, 1997, 4045, 4045, 12237, 12237, 12237, 77773},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 8177, 16369, 16369, 16369, 16369},
{1, 3, 7, 7, 23, 55, 119, 119, 375, 375, 375, 2423, 2423, 10615, 26999, 26999, 26999},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 2033, 4081, 8177, 16369, 16369, 49137, 114673},
{1, 1, 5, 13, 29, 61, 125, 253, 509, 509, 509, 2557, 6653, 14845, 31229, 63997, 63997},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 9201, 25585, 25585, 25585},
{1, 3, 7, 15, 31, 63, 127, 127, 127, 127, 1151, 3199, 3199, 3199, 19583, 52351, 117887},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 9201, 25585, 58353, 123889},
{1, 1, 5, 5, 21, 21, 85, 213, 213, 213, 213, 213, 4309, 12501, 28885, 28885, 94421},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 1009, 1009, 1009, 1009, 33777, 99313},
{1, 1, 5, 13, 13, 13, 13, 13, 269, 781, 781, 781, 781, 781, 781, 33549, 99085},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 3057, 3057, 19441, 52209, 117745},
{1, 1, 5, 5, 5, 5, 5, 133, 133, 133, 133, 133, 133, 8325, 8325, 41093, 41093},
{1, 1, 1, 1, 17, 49, 113, 241, 497, 1009, 1009, 3057, 7153, 15345, 15345, 48113, 48113},
{1, 3, 3, 3, 19, 19, 83, 83, 339, 339, 1363, 1363, 5459, 5459, 21843, 54611, 54611},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 1265, 1265, 1265, 34033, 34033},
{1, 3, 3, 3, 3, 35, 99, 99, 99, 611, 611, 2659, 2659, 2659, 19043, 19043, 84579},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 5361, 5361, 21745, 54513, 54513},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 811, 1835, 1835, 5931, 5931, 5931, 38699, 38699},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 1265, 5361, 5361, 5361, 38129, 103665},
{1, 1, 5, 13, 13, 45, 45, 173, 173, 685, 1709, 1709, 1709, 9901, 26285, 59053, 124589},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 1265, 3313, 7409, 7409, 23793, 23793, 23793},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 79, 1103, 3151, 3151, 3151, 3151, 35919, 101455},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 241, 8433, 24817, 24817, 24817},
{1, 3, 7, 15, 31, 63, 127, 127, 383, 895, 895, 895, 4991, 13183, 13183, 13183, 78719},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 241, 8433, 8433, 8433, 73969},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 201, 1225, 3273, 3273, 3273, 19657, 19657, 85193},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241},
{1, 3, 7, 7, 7, 7, 71, 71, 327, 327, 1351, 3399, 7495, 7495, 7495, 40263, 105799},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 4337, 12529, 12529, 12529, 12529},
{1, 3, 7, 7, 23, 55, 55, 183, 439, 439, 439, 2487, 2487, 10679, 27063, 59831, 59831},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 4337, 4337, 20721, 53489, 119025},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 485, 485, 485, 4581, 4581, 4581, 4581, 4581},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 4337, 4337, 4337, 4337, 69873},
{1, 1, 1, 9, 25, 57, 121, 249, 505, 505, 1529, 3577, 7673, 7673, 7673, 7673, 73209},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 241, 4337, 4337, 4337, 37105, 37105},
{1, 3, 3, 3, 3, 3, 67, 67, 67, 67, 1091, 1091, 5187, 13379, 13379, 13379, 78915},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 10481, 26865, 59633, 59633},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 795, 795, 795, 4891, 13083, 13083, 45851, 45851},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 241, 241, 2289, 2289, 2289, 18673, 51441, 116977},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 901, 901, 901, 4997, 4997, 4997, 37765, 103301},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 1777, 9969, 9969, 42737, 42737},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 51, 51, 51, 4147, 12339, 28723, 61491, 127027},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 14065, 14065, 14065, 14065},
{1, 3, 7, 7, 23, 55, 55, 55, 55, 567, 1591, 1591, 5687, 13879, 13879, 46647, 46647},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 1777, 5873, 5873, 5873, 5873, 71409},
{1, 1, 1, 9, 25, 57, 121, 121, 121, 121, 1145, 3193, 7289, 15481, 15481, 48249, 113785},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 3825, 12017, 12017, 44785, 110321},
{1, 1, 5, 13, 29, 29, 93, 221, 477, 477, 1501, 1501, 1501, 1501, 17885, 50653, 116189},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 3825, 3825, 20209, 20209, 20209},
{1, 3, 7, 15, 15, 47, 111, 239, 495, 1007, 2031, 4079, 8175, 8175, 24559, 24559, 90095},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 7921, 16113, 32497, 65265, 130801},
{1, 1, 5, 5, 21, 53, 53, 53, 53, 53, 53, 2101, 6197, 14389, 14389, 14389, 79925},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 1777, 3825, 7921, 7921, 24305, 57073, 57073},
{1, 3, 3, 11, 11, 43, 107, 107, 363, 875, 875, 875, 4971, 13163, 13163, 45931, 45931},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 8945, 25329, 58097, 58097},
{1, 3, 3, 11, 27, 27, 91, 91, 347, 859, 1883, 1883, 5979, 5979, 22363, 55131, 120667},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 753, 753, 753, 753, 66289},
{1, 1, 1, 9, 25, 25, 89, 217, 217, 217, 217, 217, 4313, 4313, 4313, 37081, 102617},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 4849, 13041, 29425, 29425, 29425},
{1, 3, 7, 15, 31, 31, 95, 223, 223, 223, 223, 223, 223, 223, 223, 32991, 98527},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 4849, 4849, 4849, 4849, 4849},
{1, 3, 7, 7, 7, 39, 103, 231, 231, 743, 1767, 1767, 1767, 9959, 9959, 42727, 42727},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 753, 4849, 4849, 4849, 37617, 103153},
{1, 1, 5, 13, 13, 45, 45, 45, 301, 813, 1837, 3885, 7981, 7981, 24365, 57133, 122669},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 2801, 6897, 6897, 23281, 23281, 23281},
{1, 3, 7, 15, 15, 15, 79, 207, 463, 975, 975, 975, 5071, 13263, 13263, 13263, 13263},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 2801, 6897, 6897, 23281, 56049, 121585},
{1, 1, 5, 5, 5, 37, 37, 165, 165, 165, 1189, 1189, 5285, 5285, 21669, 21669, 87205},
{1, 1, 1, 1, 17, 49, 113, 241, 241, 753, 753, 2801, 6897, 6897, 6897, 6897, 72433},
{1, 1, 1, 9, 25, 57, 57, 185, 185, 185, 1209, 3257, 7353, 7353, 7353, 40121, 105657},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 585, 585, 16969, 49737, 49737},
{1, 1, 1, 9, 9, 41, 105, 105, 105, 617, 1641, 3689, 7785, 15977, 32361, 32361, 32361},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 585, 8777, 8777, 8777, 74313},
{1, 3, 3, 11, 11, 43, 43, 43, 299, 299, 299, 299, 4395, 4395, 4395, 37163, 37163},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 585, 585, 8777, 25161, 57929, 123465},
{1, 3, 7, 7, 7, 39, 103, 103, 359, 871, 1895, 3943, 8039, 8039, 8039, 8039, 73575},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 6729, 14921, 14921, 14921, 80457},
{1, 3, 3, 11, 11, 11, 75, 203, 203, 203, 1227, 1227, 1227, 9419, 25803, 58571, 124107},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 6729, 14921, 31305, 64073, 129609},
{1, 3, 7, 7, 7, 7, 7, 135, 135, 135, 1159, 1159, 1159, 1159, 1159, 33927, 99463},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 585, 2633, 2633, 10825, 10825, 43593, 109129},
{1, 3, 7, 15, 15, 15, 79, 79, 79, 591, 591, 2639, 2639, 10831, 27215, 27215, 27215},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 5705, 5705, 22089, 54857, 120393},
{1, 1, 1, 9, 9, 9, 73, 201, 201, 713, 713, 713, 4809, 13001, 13001, 45769, 45769},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 5705, 13897, 30281, 30281, 95817},
{1, 1, 5, 13, 13, 13, 13, 13, 13, 525, 1549, 3597, 3597, 11789, 28173, 28173, 28173},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 1609, 1609, 9801, 9801, 9801, 75337},
{1, 1, 5, 5, 5, 37, 101, 229, 485, 997, 2021, 4069, 4069, 4069, 4069, 36837, 102373},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 7753, 7753, 7753, 7753},
{1, 3, 3, 11, 27, 27, 27, 27, 283, 283, 1307, 1307, 5403, 13595, 13595, 46363, 46363},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 7753, 24137, 56905, 56905},
{1, 3, 7, 7, 23, 23, 87, 87, 87, 87, 1111, 1111, 5207, 13399, 13399, 13399, 78935},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 15945, 15945, 48713, 48713},
{1, 3, 7, 15, 15, 47, 111, 111, 111, 623, 1647, 1647, 1647, 1647, 1647, 1647, 67183},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 7753, 15945, 15945, 15945, 81481},
{1, 1, 5, 5, 5, 5, 5, 133, 389, 389, 1413, 3461, 3461, 3461, 3461, 3461, 3461},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 3657, 3657, 36425, 36425},
{1, 3, 7, 15, 31, 31, 31, 159, 159, 671, 1695, 1695, 5791, 5791, 22175, 22175, 87711},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 3657, 3657, 3657, 69193},
{1, 1, 5, 5, 21, 53, 53, 181, 437, 949, 1973, 4021, 8117, 16309, 32693, 32693, 98229},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 3657, 20041, 20041, 20041},
{1, 3, 3, 3, 19, 19, 83, 83, 83, 83, 1107, 3155, 7251, 7251, 23635, 23635, 89171},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 585, 1609, 3657, 3657, 11849, 28233, 28233, 93769},
{1, 1, 5, 13, 13, 45, 109, 109, 109, 109, 1133, 1133, 5229, 5229, 21613, 21613, 21613},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 4169, 4169, 20553, 53321, 118857},
{1, 3, 3, 3, 19, 51, 51, 51, 51, 563, 1587, 1587, 5683, 13875, 30259, 30259, 30259},
{1, 1, 1, 9, 9, 9, 73, 73, 73, 73, 73, 73, 73, 8265, 8265, 8265, 73801},
{1, 3, 7, 15, 15, 15, 15, 15, 15, 527, 527, 2575, 6671, 6671, 6671, 6671, 72207},
{1, 1, 1, 9