% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archive_data.R
\name{get_archive_data}
\alias{get_archive_data}
\title{Download and Extract Archive Files}
\usage{
get_archive_data(url, target_dir, force = FALSE, confirmed = FALSE)
}
\arguments{
\item{url}{Character string. Full URL to the compressed archive file.}

\item{target_dir}{Character string. Directory where the archive contents
should be extracted.}

\item{force}{Logical. If TRUE, overwrites existing data in target directory.
Default is FALSE.}

\item{confirmed}{Logical. If TRUE, skips permission confirmation prompt.
Useful for reproducible workflows. Default is FALSE.}
}
\value{
Invisible NULL. Called for side effects:
\itemize{
\item Downloads archive file
\item Creates target directory if needed
\item Extracts archive contents
\item Cleans up temporary files
}
}
\description{
Downloads compressed archive files from a URL and extracts their contents to a
specified directory. Supports multiple archive formats and handles permission
confirmation.
}
\details{
Supported archive formats:
\itemize{
\item ZIP (.zip)
\item Gzip (.gz)
\item Tar (.tar)
\item Compressed tar (.tgz)
}

The function includes safety features:
\itemize{
\item Permission confirmation for data usage
\item Directory existence checks
\item Archive format validation
\item Automatic file cleanup
}
}
\examples{
\dontrun{
data_dir <- file.path(tempdir(), "data")
url <-
  "https://raw.githubusercontent.com/qtalr/qtkit/main/inst/extdata/test_data.zip"
get_archive_data(
  url = url,
  target_dir = data_dir,
  confirmed = TRUE
)
}
}
