% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotPXG.R
\name{iplotPXG}
\alias{iplotPXG}
\title{Interactive phenotype x genotype plot}
\usage{
iplotPXG(
  cross,
  marker,
  pheno.col = 1,
  chartOpts = NULL,
  fillgenoArgs = NULL,
  digits = 5
)
}
\arguments{
\item{cross}{Object of class `"cross"`, see
[qtl::read.cross()].}

\item{marker}{Character string with marker name.}

\item{pheno.col}{Phenotype column in cross object.}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{fillgenoArgs}{List of named arguments to pass to
[qtl::fill.geno()], if needed.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class `htmlwidget` that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of phenotypes vs genotypes at a marker.
}
\details{
The function [qtl::fill.geno()] is used to
impute missing genotypes, with arguments passed as a list, for
example `fillgenoArgs=list(method="argmax", error.prob=0.002,
map.function="c-f")`.

Individual IDs (viewable when hovering over a point) are taken from
the input `cross` object, using the [qtl::getid()]
function in R/qtl.

By default, points are colored blue and pink according to whether
the marker genotype is observed or inferred, respectively.
}
\examples{
library(qtl)
data(hyper)
marker <- sample(markernames(hyper), 1)
\donttest{
iplotPXG(hyper, marker)

# different colors
iplotPXG(hyper, marker, chartOpts=list(pointcolor=c("black", "gray")))}

}
\seealso{
[idotplot()], [iplot()], [iplotScanone()],
[iplotMap()]
}
\keyword{hplot}
