% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotMap.R
\name{iplotMap}
\alias{iplotMap}
\title{Interactive genetic map plot}
\usage{
iplotMap(map, chr = NULL, shift = FALSE, chartOpts = NULL, digits = 5)
}
\arguments{
\item{map}{Object of class \code{"map"}, a list with each component
being a vector of marker positions. You can also provide an object of
class \code{"cross"}, in which case the map is extracted with
\code{\link[qtl]{pull.map}}.}

\item{chr}{(Optional) Vector indicating the chromosomes to plot.}

\item{shift}{If TRUE, shift each chromsome so that the initial marker
is at position 0.}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of a genetic marker map.
}
\examples{
library(qtl)
data(hyper)
map <- pull.map(hyper)
\donttest{
iplotMap(map, shift=TRUE)}

}
\seealso{
\code{\link{iplotScanone}}, \code{\link{iplotPXG}}
}
\keyword{hplot}

