% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotRF.R
\name{iplotRF}
\alias{iplotRF}
\title{Interactive plot of recombination fractions}
\usage{
iplotRF(cross, chr = NULL, chartOpts = NULL, digits = 5)
}
\arguments{
\item{cross}{Object of class \code{"cross"}, see
\code{\link[qtl]{read.cross}}.}

\item{chr}{Optional vector indicating chromosomes to include. This
should be a vector of character strings referring to chromosomes by
name; numeric values are converted to strings.  Refer to
chromosomes with a preceding \code{-} to have all chromosomes but
those considered.  A logical (TRUE/FALSE) vector may also be used.}

\item{chartOpts}{A list of options for configuring the chart.  Each
element must be named using the corresponding option.}

\item{digits}{Round data to this number of significant digits
before passing to the chart function. (Use NULL to not round.)}
}
\value{
An object of class \code{htmlwidget} that will
intelligently print itself into HTML in a variety of contexts
including the R console, within R Markdown documents, and within
Shiny output bindings.
}
\description{
Creates an interactive graph of estimated recombination fractions and LOD scores for all pairs of markers.
}
\details{
The usual \code{height} and \code{width} options in
\code{chartOpts} are ignored in this plot. Instead, you may provide
\code{pixelPerCell} (number of pixels per cell in the heat map),
\code{chrGap} (gap in pixels between chromosomes in the heat map),
\code{cellHeight} (height in pixels of each cell in the
cross-tabulation), \code{cellWidth} (width in pixels of each cell
in the cross-tabulation), and \code{hbot} (height in pixels of the
lower panels showing cross-sections of the heat map)
}
\examples{
library(qtl)
data(fake.f2)
\dontshow{fake.f2 <- fake.f2[c(1,5,13),]}
fake.f2 <- est.rf(fake.f2)
\donttest{
iplotRF(fake.f2)}

}
\seealso{
\code{\link[qtl]{est.rf}}, \code{\link[qtl]{plotRF}}
}
\keyword{hplot}

