% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_qtl.R
\name{optimize_qtl}
\alias{optimize_qtl}
\alias{print.qtlpoly.optimize}
\title{Model optimization}
\usage{
optimize_qtl(
  data,
  offset.data = NULL,
  model,
  sig.bwd = 0.05,
  score.null = NULL,
  polygenes = FALSE,
  n.clusters = NULL,
  plot = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.optimize}(x, pheno.col = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{offset.data}{a data frame with the same dimensions of \code{data$pheno} containing offset variables; if \code{NULL} (default), no offset variables are considered.}

\item{model}{an object of class \code{qtlpoly.model} containing the QTL to be optimized.}

\item{sig.bwd}{the desired score-based \emph{p}-value threshold for backward elimination, e.g. 0.0001 (default).}

\item{score.null}{an object of class \code{qtlpoly.null} with results of score statistics from resampling.}

\item{polygenes}{if \code{TRUE} all QTL but the one being tested are treated as a single polygenic effect, if \code{FALSE} (default) all QTL effect variances have to estimated.}

\item{n.clusters}{number of parallel processes to spawn.}

\item{plot}{a suffix for the file's name containing plots of every QTL optimization round, e.g. "optimize" (default); if \code{NULL}, no file is produced.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.optimize} to be printed.}

\item{pheno.col}{a numeric vector with the phenotype columns to be printed; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.optimize} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{stat}{a vector containing values from score statistics.}
    \item{pval}{a vector containing \emph{p}-values from score statistics.}
    \item{qtls}{a data frame with information from the mapped QTL.}
}
\description{
Tests each QTL at a time and updates its position (if it changes) or drops the QTL (if non-significant).
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Build null model
  null.mod = null_model(data = data, pheno.col = 1,n.clusters = 1)

  # Perform forward search
  search.mod = search_qtl(data = data, model = null.mod,
w.size = 15, sig.fwd = 0.01, n.clusters = 1)

  # Optimize model
  optimize.mod = optimize_qtl(data = data, model = search.mod, sig.bwd = 0.0001, n.clusters = 1)
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
    
    Qu L, Guennel T, Marshall SL (2013) Linear score tests for variance components in linear mixed models and applications to genetic association studies. \emph{Biometrics} 69 (4): 883–92.

    Zou F, Fine JP, Hu J, Lin DY (2004) An efficient resampling method for assessing genome-wide statistical significance in mapping quantitative trait loci. \emph{Genetics} 168 (4): 2307-16. \doi{10.1534/genetics.104.031427}
}
\seealso{
\code{\link[qtlpoly]{read_data}}, \code{\link[qtlpoly]{null_model}}, \code{\link[qtlpoly]{search_qtl}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
