% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSOSS.r
\name{QUALYPSOSS.ANOVA.step1}
\alias{QUALYPSOSS.ANOVA.step1}
\title{QUALYPSOSS.ANOVA.step1}
\usage{
QUALYPSOSS.ANOVA.step1(lOpt, lDim, yMCMC, RK)
}
\arguments{
\item{lOpt}{list of options, returned by \code{\link{QUALYPSOSS.check.option}}}

\item{lDim}{list of dimensions}

\item{yMCMC}{array \code{nMCMC} x \code{nFull} of climate change responses}

\item{RK}{large object containing the reproducing kernels, returned by \code{\link{QUALYPSOSS.get.RK}}}
}
\value{
list containing diverse information aboutwith the following fields:
\itemize{
  \item \strong{g.MCMC}: Smooth effects \code{g}: array \code{n} x \code{nFull} x \code{K} where
  \code{nFull} is the number of possible combinations of predictors (discrete AND continuous),
  \item \strong{nu.MCMC}: Smooth effects \code{nu}, a list with matrices of eigen vectors
  \item \strong{lambda.MCMC}: Smoothing parameters: matrix \code{n} x \code{K},  
  \item \strong{deltaRV.MCMC}: Residual variance: vector of length \code{n},
  \item \strong{g.hat}: Smooth effects estimates: matrix \code{nFull} x \code{K} where
  \item \strong{nu.hat}: Smooth effects estimates: a list with estimates of eigen vectors,
  \item \strong{lambda.hat}: Smoothing parameters estimates: vector of length \code{K},  
  \item \strong{deltaRV.hat}: Residual variance estimate.
  \item \strong{logLK}: vector of log-likelihood values of the draws
  \item \strong{logPost}: vector of log-posterior values of the draws
  \item \strong{Schwarz}: Schwarz criteria
  \item \strong{BIC}: BIC criteria
  
}
}
\description{
SSANOVA decomposition of the ensemble of climate change responses using a Bayesian approach.
The different fields of the returned list contain \code{n} samples from the posterior distributions
of the different inferred quantities. In this first step, the residual errors are assumed iid
}
\author{
Guillaume Evin
}
