% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/collocations.R
\docType{methods}
\name{phrasetotoken}
\alias{phrasetotoken}
\alias{phrasetotoken,character,data.table-method}
\alias{phrasetotoken,character,dictionary-method}
\alias{phrasetotoken.corpus}
\title{convert phrases into single tokens}
\usage{
phrasetotoken(object, phrases, concatenator = "_")

\S4method{phrasetotoken}{character,dictionary}(object, phrases,
  concatenator = "_")

phrasetotoken.corpus(object, phrases, concatenator = "_")

\S4method{phrasetotoken}{character,data.table}(object, phrases,
  concatenator = "_")
}
\arguments{
\item{object}{source texts, a character or character vector}

\item{phrases}{a \code{\link{dictionary}} object that
contains some phrases, defined as multiple words delimited by whitespace,
up to 9 words long; or a quanteda collocation object created
by \code{\link{collocations}}}

\item{concatenator}{the concatenation character that will connect the words
making up the multi-word phrases.  The default \code{_} is highly
recommended since it will not be removed during normal cleaning and
tokenization (while nearly all other punctuation characters, at least those
in the POSIX class \code{[:punct:]}) will be removed.}
}
\value{
character or character vector of texts with phrases replaced by
  compound "words" joined by the concatenator
}
\description{
Replace multi-word phrases in text(s) with a compound version of the phrases
concatenated with  \code{concatenator} (by default, the "\code{_}" character) to
form a single token.  This prevents tokenization of the phrases during
subsequent processing by eliminating the whitespace delimiter.
}
\examples{
mytexts <- c("The new law included a capital gains tax, and an inheritance tax.",
             "New York City has raised a taxes: an income tax and a sales tax.")
mydict <- dictionary(list(tax=c("tax", "income tax", "capital gains tax", "inheritance tax")))
(cw <- phrasetotoken(mytexts, mydict))
dfm(cw, verbose=FALSE)

# when used as a dictionary for dfm creation
mydfm2 <- dfm(cw, dictionary=lapply(mydict, function(x) gsub(" ", "_", x)))
mydfm2
# to pick up "taxes" in the second text, set dictionary_regex=TRUE
mydfm3 <- dfm(cw, dictionary=lapply(mydict, phrasetotoken, mydict),
              dictionary_regex=TRUE)
mydfm3
## one more token counted for "tax" than before
}
\author{
Kenneth Benoit
}

