% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dfm-main.R
\name{sort.dfm}
\alias{sort.dfm}
\title{sort a dfm by one or more margins}
\usage{
\method{sort}{dfm}(x, decreasing = TRUE, margin = c("features", "docs",
  "both"), ...)
}
\arguments{
\item{x}{Document-feature matrix created by \code{\link{dfm}}}

\item{decreasing}{TRUE (default) if sort will be in descending order,
otherwise sort in increasing order}

\item{margin}{which margin to sort on \code{features} to sort by frequency of
features, \code{docs} to sort by total feature counts in documents, and
\code{both} to sort by both}

\item{...}{additional arguments passed to base method \code{sort.int}}
}
\value{
A sorted \link{dfm} matrix object
}
\description{
Sorts a \link{dfm} by frequency of total features, total features in
documents, or both
}
\examples{
dtm <- dfm(inaugCorpus)
dtm[1:10, 1:5]
dtm <- sort(dtm)
sort(dtm)[1:10, 1:5]
sort(dtm, TRUE, "both")[1:10, 1:5]  # note that the decreasing=TRUE argument
                                    # must be second, because of the order of the
                                    # formals in the generic method of sort()
}
\author{
Ken Benoit
}

