% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\alias{encoding.character}
\alias{encoding.corpus}
\alias{encoding.corpusSource}
\title{detect the encoding of texts}
\usage{
encoding(x, verbose = TRUE, ...)

\method{encoding}{character}(x, verbose = TRUE, ...)

\method{encoding}{corpus}(x, verbose = TRUE, ...)

\method{encoding}{corpusSource}(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{character vector, corpus, or corpusSource object whose texts'
encodings will be detected.}

\item{verbose}{if \code{FALSE}, do not print diagnostic report}

\item{...}{additional arguments passed to \link[stringi]{stri_enc_detect}}
}
\description{
Detect the encoding of texts in a character, \link{corpus}, or
\link{corpusSource-class} object and report on the most likely encoding.  Useful in
detecting the encoding of input texts, so that a source encoding can be
specified when (re)constructing a corpus using \code{\link{corpus}}.
}
\details{
Based on \link[stringi]{stri_enc_detect}, which is in turn based on the
ICU libraries.  See the ICU User Guide,
\url{http://userguide.icu-project.org/conversion/detection}.
}
\examples{
encoding(encodedTexts)
# show detected value for each text, versus known encoding
data.frame(labelled = names(encodedTexts), detected = encoding(encodedTexts)$all)

encoding(ukimmigTexts)
encoding(inaugCorpus)
encoding(ie2010Corpus)

\dontrun{# Russian text, Windows-1251
mytextfile <- textfile("http://www.kenbenoit.net/files/01_er_5.txt", cache = FALSE)
encoding(mytextfile)
}
}

