% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-weighting.R
\docType{methods}
\name{weight}
\alias{smoother}
\alias{weight}
\alias{weight,dfm-method}
\alias{weighting}
\alias{weighting,dfm-method}
\title{weight the feature frequencies in a dfm by various methods}
\usage{
weight(x, ...)

\S4method{weight}{dfm}(x, type = c("frequency", "relFreq", "relMaxFreq",
  "logFreq", "tfidf"), ...)

smoother(x, smoothing = 1)

weighting(object)

\S4method{weighting}{dfm}(object)
}
\arguments{
\item{x}{document-feature matrix created by \link{dfm}}

\item{...}{not currently used.  For finer grained control, consider calling \code{\link{tf}} or \code{\link{tfidf}} directly.}

\item{type}{The weighting function to aapply to the dfm. One of: 
\describe{
 \item{\code{"frequency"}}{integer feature count (default when a dfm is created)}
 \item{\code{"relFreq"}}{the proportion of the feature counts of total feature counts (aka relative frequency)}
 \item{\code{"relMaxFreq"}}{the proportion of the feature counts of the highest feature count in a document}
 \item{\code{"logFreq"}}{natural logarithm of the feature count}
 \item{\code{"tfidf"}}{Term-frequency * inverse document frequency. For a
  full explanation, see, for example, 
  \url{http://nlp.stanford.edu/IR-book/html/htmledition/term-frequency-and-weighting-1.html}.
   This implementation will not return negative values.  For finer-grained
  control, call \code{\link{tfidf}} directly}
  }}

\item{smoothing}{constant added to the dfm cells for smoothing, default is 1}

\item{object}{the dfm object for accessing the weighting setting}
}
\value{
The dfm with weighted values

\code{weighting} returns a character object describing the type of weighting applied to the dfm.
}
\description{
Returns a document by feature matrix with the feature frequencies weighted 
according to one of several common methods.
}
\details{
This converts a matrix from sparse to dense format, so may exceed memory
requirements depending on the size of your input matrix.

\code{weighting} queries (but cannot set) the weighting applied to the dfm.
}
\examples{
dtm <- dfm(inaugCorpus)
x <- apply(dtm, 1, function(tf) tf/max(tf))
topfeatures(dtm)
normDtm <- weight(dtm, "relFreq")
topfeatures(normDtm)
maxTfDtm <- weight(dtm, type="relMaxFreq")
topfeatures(maxTfDtm)
logTfDtm <- weight(dtm, type="logFreq")
topfeatures(logTfDtm)
tfidfDtm <- weight(dtm, type="tfidf")
topfeatures(tfidfDtm)

# combine these methods for more complex weightings, e.g. as in Section 6.4 of
# Introduction to Information Retrieval
head(logTfDtm <- weight(dtm, type="logFreq"))
head(tfidf(logTfDtm, normalize = FALSE))

\dontshow{
testdfm <- dfm(inaugTexts[1:5], verbose = FALSE)
for (w in c("frequency", "relFreq", "relMaxFreq", "logFreq", "tfidf")) {
    testw <- weight(testdfm, w)
    cat("\\n\\n=== weight() TEST for:", w, "; class:", class(testw), "\\n")
    head(testw)
}
}
}
\author{
Paul Nulty and Kenneth Benoit
}
\references{
Manning, Christopher D., Prabhakar Raghavan, and Hinrich Schutze.
  Introduction to information retrieval. Vol. 1. Cambridge: Cambridge 
  university press, 2008.
}
\seealso{
\code{\link{tfidf}}
}

