% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toLower.R
\name{toLower}
\alias{toLower}
\alias{toLower.character}
\alias{toLower.NULL}
\alias{toLower.tokenizedTexts}
\alias{toLower.tokens}
\alias{toUpper.tokens}
\alias{toLower.corpus}
\alias{toUpper}
\alias{toUpper.character}
\alias{toUpper.NULL}
\alias{toUpper.tokenizedTexts}
\alias{toUpper.corpus}
\title{Convert texts to lower (or upper) case}
\usage{
toLower(x, keep_acronyms = FALSE, ...)

\method{toLower}{character}(x, keep_acronyms = FALSE, ...)

\method{toLower}{NULL}(x, ...)

\method{toLower}{tokenizedTexts}(x, keep_acronyms = FALSE, ...)

\method{toLower}{tokens}(x, ...)

\method{toUpper}{tokens}(x, ...)

\method{toLower}{corpus}(x, ...)

toUpper(x, ...)

\method{toUpper}{character}(x, ...)

\method{toUpper}{NULL}(x, ...)

\method{toUpper}{tokenizedTexts}(x, ...)

\method{toUpper}{corpus}(x, ...)
}
\arguments{
\item{x}{texts to be lower-cased (or upper-cased)}

\item{keep_acronyms}{if \code{TRUE}, do not lowercase any all-uppercase words.
Only applies to \code{toLower}.}

\item{...}{additional arguments passed to \pkg{stringi} functions, (e.g. 
\code{\link{stri_trans_tolower}}), such as \code{locale}}
}
\value{
Texts tranformed into their lower- (or upper-)cased versions.  If \code{x} is a 
  character vector or a corpus, return a character vector.  If 
  \code{x} is a list of tokenized texts, then return a list of 
  tokenized texts.
}
\description{
Convert texts or tokens to lower (or upper) case
}
\examples{
\donttest{
test1 <- c(text1 = "England and France are members of NATO and UNESCO", 
           text2 = "NASA sent a rocket into space.")
toLower(test1)
toLower(test1, keep_acronyms = TRUE)

test2 <- tokenize(test1, remove_punct=TRUE)
toLower(test2)
toLower(test2, keep_acronyms = TRUE)
}
\donttest{
test1 <- c(text1 = "England and France are members of NATO and UNESCO", 
           text2 = "NASA sent a rocket into space.")
toUpper(test1)

test2 <- tokenize(test1, remove_punct = TRUE)
toUpper(test2)
}
}
\keyword{deprecated}
\keyword{internal}
