% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat_frequency.R
\name{textstat_frequency}
\alias{textstat_frequency}
\title{tabulate feature frequencies}
\usage{
textstat_frequency(x, n = NULL, groups = NULL)
}
\arguments{
\item{x}{a \link{dfm} object}

\item{n}{(optional) integer specifying the top \code{n} features to be returned,
within group if \code{groups} is specified}

\item{groups}{either: a character vector containing the names of document 
variables to be used for grouping; or a factor or object that can be 
coerced into a factor equal in length or rows to the number of documents. 
See \link{groups} for details.}
}
\value{
a data.frame containing the following variables:
\describe{
\item{\code{feature}}{(character) the feature}
\item{\code{frequency}}{count of the feature}
\item{\code{rank}}{rank of the feature, where 1 indicates the greatest
frequency}
\item{\code{docfreq}}{document frequency of the feature, as a count (the
number of documents in which this feature occurred at least once)}
\item{\code{docfreq}}{document frequency of the feature, as a count}
\item{\code{group}}{(only if \code{groups} is specified) the label of the group.
If the features have been grouped, then all counts, ranks, and document
frequencies are within group.  If groups is not specified, the \code{group}
column is omitted from the returned data.frame.}
}
}
\description{
Produces counts and document frequencies summaries of the features in a
\link{dfm}, optionally grouped by a \link{docvars} variable or other supplied
grouping variable.
}
\examples{
(dfm1 <- dfm(c("a a b b c d", "a d d d", "a a a")))
textstat_frequency(dfm1)
textstat_frequency(dfm1, groups = c("one", "two", "one"))

obamadfm <- dfm(data_corpus_inaugural[56:57], 
                remove_punct = TRUE, remove = stopwords("english"))
freq <- textstat_frequency(obamadfm)
head(freq, 10)
}
\keyword{plot}
