% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_nb.R
\name{predict.textmodel_nb}
\alias{predict.textmodel_nb}
\title{Prediction from a fitted textmodel_nb object}
\usage{
\method{predict}{textmodel_nb}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a fitted Naive Bayes textmodel}

\item{newdata}{dfm on which prediction should be made}

\item{...}{not used}
}
\value{
\code{predict.textmodel_nb} returns a list of two data frames, named
  \code{docs} and \code{words} corresponding to word- and document-level
  predicted quantities

\item{docs}{data frame with document-level predictive quantities:
  nb.predicted, ws.predicted, bs.predicted, PcGw, wordscore.doc,
  bayesscore.doc, posterior.diff, posterior.logdiff.  Note that the diff
  quantities are currently implemented only for two-class solutions.}

\item{words}{data-frame with word-level predictive quantities: 
wordscore.word, bayesscore.word}
}
\description{
\code{predict.textmodel_nb()} implements class predictions from a fitted
Naive Bayes model. using trained Naive Bayes examples
}
\examples{
# application to LBG (2003) example data
(nb <- textmodel_nb(data_dfm_lbgexample, c("A", "A", "B", "C", "C", NA)))
predict(nb)
}
\keyword{internal}
\keyword{textmodel}
