% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_sort.R
\name{dfm_sort}
\alias{dfm_sort}
\title{Sort a dfm by frequency of one or more margins}
\usage{
dfm_sort(x, decreasing = TRUE, margin = c("features", "documents", "both"))
}
\arguments{
\item{x}{Document-feature matrix created by \code{\link{dfm}}}

\item{decreasing}{logical; if \code{TRUE}, the sort will be in descending
order, otherwise sort in increasing order}

\item{margin}{which margin to sort on \code{features} to sort by frequency of
features, \code{documents} to sort by total feature counts in documents,
and \code{both} to sort by both}
}
\value{
A sorted \link{dfm} matrix object
}
\description{
Sorts a \link{dfm} by descending frequency of total features, total features
in documents, or both.
}
\examples{
dtm <- dfm(data_corpus_inaugural)
head(dtm)
head(dfm_sort(dtm))
head(dfm_sort(dtm, decreasing = FALSE, "both"))
}
\author{
Ken Benoit
}
