% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_network.R
\name{textplot_network}
\alias{textplot_network}
\alias{as.network.fcm}
\alias{as.igraph.fcm}
\title{Plot a network of feature co-occurrences}
\usage{
textplot_network(
  x,
  min_freq = 0.5,
  omit_isolated = TRUE,
  edge_color = "#1F78B4",
  edge_alpha = 0.5,
  edge_size = 2,
  vertex_color = "#4D4D4D",
  vertex_size = 2,
  vertex_labelcolor = NULL,
  vertex_labelfont = NULL,
  vertex_labelsize = 5,
  offset = NULL,
  ...
)

\method{as.network}{fcm}(x, min_freq = 0.5, omit_isolated = TRUE, ...)

\method{as.igraph}{fcm}(x, min_freq = 0.5, omit_isolated = TRUE, ...)
}
\arguments{
\item{x}{a \link{fcm} or \link{dfm}  object}

\item{min_freq}{a frequency count threshold or proportion for co-occurrence
frequencies of features to be included.}

\item{omit_isolated}{if \code{TRUE}, features do not occur more frequent than
\code{min_freq} will be omitted.}

\item{edge_color}{color of edges that connect vertices.}

\item{edge_alpha}{opacity of edges ranging from 0 to 1.0.}

\item{edge_size}{size of edges for most frequent co-occurrence The size of
other edges are determined proportionally to the 99th percentile frequency
instead of the maximum to reduce the impact of outliers.}

\item{vertex_color}{color of vertices.}

\item{vertex_size}{size of vertices}

\item{vertex_labelcolor}{color of texts. Defaults to the same as
\code{vertex_color}. If \code{NA} is given, texts are not rendered.}

\item{vertex_labelfont}{font-family of texts. Use default font if
\code{NULL}.}

\item{vertex_labelsize}{size of vertex labels in mm. Defaults to size 5. Supports
both integer values and vector values.}

\item{offset}{if \code{NULL}, the distance between vertices and texts are
determined automatically.}

\item{...}{additional arguments passed to \link[network]{network} or
\link[igraph]{graph_from_adjacency_matrix}.  Not used for \code{as.igraph}.}
}
\description{
Plot an \link{fcm} object as a network, where edges show co-occurrences of
features.
}
\details{
Currently the size of the network is limited to 1000, because of the
  computationally intensive nature of network formation for larger matrices.
  When the \link{fcm} is large, users should select features using
  \link{fcm_select}, set the threshold using \code{min_freq}, or implement
  own plotting function using \code{\link[=as.network.fcm]{as.network}}.
}
\examples{
set.seed(100)
toks <- corpus_subset(data_corpus_irishbudget2010) \%>\%
    tokens(remove_punct = TRUE) \%>\%
    tokens_tolower() \%>\%
    tokens_remove(pattern = stopwords("english"), padding = FALSE)
fcmat <- fcm(toks, context = "window", tri = FALSE)
feat <- names(topfeatures(fcmat, 30))
fcm_select(fcmat, pattern = feat) \%>\%
    textplot_network(min_freq = 0.5)
fcm_select(fcmat, pattern = feat) \%>\%
    textplot_network(min_freq = 0.8)
fcm_select(fcmat, pattern = feat) \%>\%
    textplot_network(min_freq = 0.8, vertex_labelcolor = rep(c('gray40', NA), 15))
fcm_select(fcmat, pattern = feat) \%>\%
    textplot_network(vertex_labelsize = 10)
fcm_30 <- fcm_select(fcmat, pattern = feat)
textplot_network(fcm_30, vertex_labelsize = rowSums(fcm_30)/min(rowSums(fcm_30)))
# Vector inputs to vertex_labelsize can be scaled if too small / large
textplot_network(fcm_30, vertex_labelsize = 1.5 * rowSums(fcm_30)/min(rowSums(fcm_30)))

# as.igraph
if (requireNamespace("igraph", quietly = TRUE)) {
    txt <- c("a a a b b c", "a a c e", "a c e f g")
    mat <- fcm(txt)
    as.igraph(mat, min_freq = 1, omit_isolated = FALSE)
}
}
\seealso{
\code{\link{fcm}}

\code{\link[network]{network}}

\code{\link[igraph]{graph_from_adjacency_matrix}}
}
\author{
Kohei Watanabe and Stefan Müller
}
\keyword{textplot}
