% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quanteda_options.R
\name{quanteda_options}
\alias{quanteda_options}
\title{Get or set package options for quanteda}
\usage{
quanteda_options(..., reset = FALSE, initialize = FALSE)
}
\arguments{
\item{...}{options to be set, as key-value pair, same as
\code{\link[=options]{options()}}. This may be a list of valid key-value pairs, useful
for setting a group of options at once (see examples).}

\item{reset}{logical; if \code{TRUE}, reset all \pkg{quanteda} options to
their default values}

\item{initialize}{logical; if \code{TRUE}, reset only the \pkg{quanteda}
options that are not already defined.  Used for setting initial values when
some have been defined previously, such as in \code{.Rprofile}.}
}
\value{
When called using a \code{key = value} pair (where \code{key} can be
a label or quoted character name)), the option is set and \code{TRUE} is
returned invisibly.

When called with no arguments, a named list of the package options is
returned.

When called with \code{reset = TRUE} as an argument, all arguments are
options are reset to their default values, and \code{TRUE} is returned
invisibly.
}
\description{
Get or set global options affecting functions across \pkg{quanteda}.
}
\details{
Currently available options are: \describe{
\item{\code{verbose}}{logical; if \code{TRUE} then use this as the default
for all functions with a \code{verbose} argument}
\item{\code{threads}}{integer; specifies the number of threads to use in
parallelized functions}
\item{\code{print_dfm_max_ndoc}}{integer; specifies the number of documents
to display when using the defaults for printing a dfm}
\item{\code{print_dfm_max_nfeat}}{integer; specifies the number of
features to display when using the defaults for printing a dfm}
\item{\code{base_docname}}{character; stem name for documents that are
unnamed when a corpus, tokens, or dfm are created or when a dfm is converted
from another object} \item{\code{base_featname}}{character; stem name for
features that are unnamed when they are added, for whatever reason, to a dfm
through an operation that adds features}
\item{\code{base_compname}}{character; stem name for components that are
created by matrix factorization}
\item{\code{language_stemmer}}{character; language option for \code{\link[=char_wordstem]{char_wordstem()}},
\code{\link[=tokens_wordstem]{tokens_wordstem()}}, and \code{\link[=dfm_wordstem]{dfm_wordstem()}}}
\item{\code{pattern_hashtag}, \code{pattern_username}}{character; regex patterns for
(social media) hashtags and usernames respectively, used to avoid segmenting
these in the default internal "word" tokenizer}
\item{\code{tokens_block_size}}{integer; specifies the
number of documents to be tokenized at a time in blocked tokenization.
When the number is large, tokenization becomes faster but also memory-intensive.}
\item{\code{tokens_locale}}{character; specify locale in stringi boundary detection in
tokenization and corpus reshaping. See \code{\link[stringi:stri_opts_brkiter]{stringi::stri_opts_brkiter()}}.}}
}
\examples{
(opt <- quanteda_options())
\donttest{
quanteda_options(verbose = TRUE)
quanteda_options("verbose" = FALSE)
quanteda_options("threads")
quanteda_options(print_dfm_max_ndoc = 50L)
# reset to defaults
quanteda_options(reset = TRUE)
# reset to saved options
quanteda_options(opt)
}
}
