% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizers.R
\name{tokenize_internal}
\alias{tokenize_internal}
\alias{tokenize}
\alias{tokenize_word}
\alias{tokenize_word1}
\alias{tokenize_character}
\alias{tokenize_sentence}
\alias{tokenize_fasterword}
\alias{tokenize_fastestword}
\title{quanteda tokenizers}
\usage{
tokenize_word(x, split_hyphens = FALSE, verbose = quanteda_options("verbose"))

tokenize_word1(x, split_hyphens = FALSE, verbose = quanteda_options("verbose"))

tokenize_character(x, ...)

tokenize_sentence(x, ..., verbose = FALSE)

tokenize_fasterword(x, ...)

tokenize_fastestword(x, ...)
}
\arguments{
\item{x}{(named) character; input texts}

\item{split_hyphens}{logical; if \code{FALSE}, do not split words that are
connected by hyphenation and hyphenation-like characters in between words,
e.g. \code{"self-aware"} becomes \code{c("self", "-", "aware")}}

\item{verbose}{if \code{TRUE}, print timing messages to the console}

\item{...}{used to pass arguments among the functions}
}
\value{
a list of characters corresponding to the (most conservative)
tokenization, including whitespace where applicable; except for
\code{tokenize_word1()}, which is a special tokenizer for Internet language that
includes URLs, #hashtags, @usernames, and email addresses.
}
\description{
Internal methods for tokenization providing default and legacy methods for
text segmentation.
}
\examples{
\dontrun{
txt <- c(doc1 = "Tweet https://quanteda.io using @quantedainit and #rstats.",
         doc2 = "The £1,000,000 question.",
         doc4 = "Line 1.\nLine2\n\nLine3.",
         doc5 = "?",
         doc6 = "Self-aware machines! \U0001f600")
tokenize_word(txt)
tokenize_word(txt, split_hyphens = TRUE)
tokenize_word2(txt, split_hyphens = FALSE)
tokenize_word2(txt, split_hyphens = TRUE)
tokenize_fasterword(txt)
tokenize_fastestword(txt)
tokenize_sentence(txt)
tokenize_character(txt[2])
}
}
\keyword{internal}
\keyword{tokens}
