% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_est.R
\name{mean_est}
\alias{mean_est}
\title{The Inverse Probability Weighted Estimator of the Marginal Mean Given a Specific Treatment Regime}
\usage{
mean_est(beta, x, a, y, prob)
}
\arguments{
\item{beta}{a vector indexing the treatment regime.
It indexes a linear treatment regime:  
\deqn{ d(x)= I\{\beta_0 + \beta_1 x_1 + ... + \beta_k x_k > 0\}.
}{ d(x)= I{\beta_0 + \beta_1*x_1 + ... + \beta_k*x_k > 0}.}}

\item{x}{a matrix of observed covariates from the sample. 
Notice that we assumed the class of treatment regimes is linear.
This is important that columns in \code{x} matches with \code{beta}.}

\item{a}{a vector of 0s and 1s, the observed treatments from a sample}

\item{y}{a vector, the observed responses from a sample}

\item{prob}{a vector, the propensity scores of getting treatment 1 in the samples}
}
\description{
Estimate the marginal mean of the response when the entire population
follows a treatment regime. This function implements the inverse probability weighted
estimator proposed by Baqun Zhang et. al..

This function supports the \code{\link{mestimate}} function.
}
\references{
Zhang, Baqun, et al. "A robust method for estimating optimal treatment regimes." 
Biometrics 68.4 (2012): 1010-1018.
}
