% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-logging.R
\name{quarto_log}
\alias{quarto_log}
\title{Log debug information to a configurable file}
\usage{
quarto_log(
  ...,
  file = NULL,
  append = TRUE,
  timestamp = TRUE,
  prefix = "DEBUG: "
)
}
\arguments{
\item{...}{Messages to log (will be concatenated)}

\item{file}{Path to log file. If NULL, uses \code{get_log_file()} to determine the file.
Default will be \code{./quarto-r-debug.log} if no configuration is found.}

\item{append}{Logical. Should the messages be appended to the file? Default TRUE.}

\item{timestamp}{Logical. Should a timestamp be added? Default TRUE.}

\item{prefix}{Character. Prefix to add before each log entry. Default "DEBUG: ".}
}
\value{
Invisibly returns TRUE if logging occurred, FALSE otherwise
}
\description{
This function logs messages to a file only when in debug mode to help diagnose
issues with Quarto vignettes in \strong{pkgdown} and other contexts.
}
\details{
Debug mode will be enabled automatically when debugging Github Actions workflows,
or when Quarto CLI's environment variable \code{QUARTO_LOG_LEVEL} is set to \code{DEBUG}.
}
\section{Configuration}{


\strong{Enable debugging messages:}
\itemize{
\item Set \code{quarto.log.debug = TRUE} (or \code{R_QUARTO_LOG_DEBUG = TRUE} environment variable)
}

\strong{Change log file path:}
\itemize{
\item Set \code{quarto.log.file} to change the file path (or \code{R_QUARTO_LOG_FILE} environment variable)
\item Default will be \code{./quarto-r-debug.log}
}

\strong{Automatic debug mode:}
\itemize{
\item Debug mode will be on automatically when debugging Github Actions workflows
\item When Quarto CLI's environment variable \code{QUARTO_LOG_LEVEL} is set to \code{DEBUG}
}
}

\examples{
\dontrun{
# Set log file via environment variable
Sys.setenv(R_QUARTO_LOG_FILE = "~/quarto-debug.log")

# Or via option
options(quarto.log.file = "~/quarto-debug.log")

# Enable debug mode
options(quarto.log.debug = TRUE)

# Log some information
quarto_log("Starting process")
quarto_log("R_LIBS:", Sys.getenv("R_LIBS"))
quarto_log(".libPaths():", paste0(.libPaths(), collapse = ":"))
}
}
\keyword{internal}
