% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal_kernels.R
\name{k_exponential_power}
\alias{k_exponential_power}
\title{Dispersal kernels from exponential power family}
\usage{
k_exponential_power(x, par, N = 1, d = NCOL(x))
}
\arguments{
\item{x}{Numeric matrix of positions \eqn{x} relative to the seed source,
or vector of distances \eqn{\left\|{x}\right\|} to the seed source.}

\item{par}{Numeric vector with two elements representing the
log-transformed scale and shape parameters \eqn{a} and \eqn{b}.}

\item{N}{The multiplier \eqn{N}.}

\item{d}{The spatial dimension.}
}
\value{
Numeric vector of function values \eqn{k(x)} multiplied by \eqn{N}.
}
\description{
\code{k_exponential_power} computes the value, multiplied by \eqn{N}, of a
dispersal kernel from the exponential power family that includes, as
special cases, Gaussian kernels and kernels that follow an exponential
function of the distance.
}
\details{
The dispersal kernel, i.e. spatial probability density
of the location of a seed relative to its source, is here given by
\deqn{k(x)={b\Gamma (d/2) \over 2\pi ^{d/2}a^{d}\Gamma (d/b)}
   e^{-(\left\|{x}\right\|/a)^{b}},}
which corresponds to a probability density of the distance given by
\deqn{p(r)={b \over a^{d}\Gamma (d/b)}r^{d-1}e^{-(r/a)^{b}},}
where \eqn{d} is the spatial dimension, \eqn{\left\|{\,}\right\|}
denotes the Euclidean norm and the normalizing constants involve the
\link[base:gamma]{gamma} function; see Bateman (1947), Clark et al.
(1998), Austerlitz et al. (2004), Nathan et al. (2012) for the planar
case. This means the \eqn{b}th power of the distance has a
\link[stats:GammaDist]{gamma distribution} with shape parameter
\eqn{d/b} and scale parameter \eqn{a^{b}}.

The kernel has its maximum at zero and represents a rather flexible family
that includes, for \eqn{b=2} the classical Gaussian kernels and for
\eqn{b=1}, kernels decreasing exponentially with the distance. For
\eqn{b<1} the distance distribution is fat-tailed in the sense of Kot et
al. (1996). Such kernels have consequently been applied in a number of
theoretical studies that address dispersal (Ribbens et al. 1994, Bullock
et al. 2017).
}
\examples{
k_exponential_power(2:5, par=c(0,0), d=2)
}
\references{
Bateman, A. (1947). Contamination in seed crops: III. relation with
isolation distance. \emph{Heredity} \strong{1}, 303–336.
\doi{10.1038/hdy.1947.20}

Kot, M., Lewis, M.A., van den Driessche, P. (1996). Dispersal Data and the
Spread of Invading Organisms. \emph{Ecology} \strong{77(7)}, 2027–2042.
\doi{10.2307/2265698}

Ribbens, E., Silander Jr, J.A., Pacala, S.W. (1994). Seedling recruitment
in forests: calibrating models to predict patterns of tree seedling
dispersion. \emph{Ecology} \strong{75}, 1794–1806.
\doi{10.2307/1939638}

Clark, J.S., Macklin, E., Wood, L. (1998). Stages and spatial scales of
recruitment limitation in southern Appalachian forests. \emph{Ecological
Monographs} \strong{68}(2), 213–235.
\doi{10.2307/2657201}

Clark, J.S. (1998). Why trees migrate so fast: confronting theory with
dispersal biology and the paleorecord. \emph{The American Naturalist}
\strong{152}(2), 204–224.
\doi{10.1086/286162}

Austerlitz, F., Dick, C.W., Dutech, C., Klein, E.K., Oddou-Muratorio, S.,
Smouse, P.E., Sork, V.L. (2004). Using genetic markers to estimate the
pollen dispersal curve. \emph{Molecular Ecology} \strong{13}, 937–954.
\doi{10.1111/j.1365-294X.2004.02100.x}

Bullock, J. M., Mallada González, L., Tamme, R., Götzenberger, L., White,
S.M., Pärtel, M., Hooftman, D.A. (2017).  A synthesis of empirical plant
dispersal kernels. \emph{Journal of Ecology} \strong{105}, 6–19.
\doi{10.1111/1365-2745.12666}

Nathan, R., Klein, E., Robledo‐Arnuncio, J.J., Revilla, E. (2012).
Dispersal kernels: review, in Clobert, J., Baguette, M., Benton, T.G.,
Bullock, J.M. (eds.), \emph{Dispersal ecology and evolution}, 186–210.
\doi{10.1093/acprof:oso/9780199608898.003.0015}
}
