% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{centers}
\alias{centers}
\title{Centering and/or Standardizing Numeric Data}
\usage{
centers(data, vrb.nm, center = TRUE, scale = FALSE, suffix)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{center}{logical vector with length 1 specifying whether grand-mean
centering should be done.}

\item{scale}{logical vector with length 1 specifying whether grand-SD scaling
should be done.}

\item{suffix}{character vector with a single element specifying the string to
append to the end of the colnames of the return object. The default depends
on the \code{center} and \code{scale} arguments: 1)if \code{center} = TRUE
and \code{scale} = FALSE, then \code{suffix} = "_c", 2) if \code{center} =
FALSE and \code{scale} = TRUE, then \code{suffix} = "_s", 3) if
\code{center} = TRUE and \code{scale} = TRUE, then \code{suffix} = "_z", 4)
if \code{center} = FALSE and \code{scale} = FALSE, then \code{suffix} = "".}
}
\value{
data.frame of centered and/or standardized variables with colnames
  specified by \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{centers} centers and/or standardized data. It is an alternative to
\code{scale.default} that returns a data.frame rather than a numeric matrix.
}
\details{
\code{centers} first coerces \code{data[vrb.nm]} to a matrix in preparation
for the call to \code{scale.default}. If the coercion results in a
non-numeric matrix (e.g., any columns in \code{data[vrb.nm]} are character
vectors or factors), then an error is returned.
}
\examples{
centers(data = mtcars, vrb.nm = c("disp","hp","drat","wt","qsec"))
centers(data = mtcars, vrb.nm = c("disp","hp","drat","wt","qsec"),
   scale = TRUE)
centers(data = mtcars, vrb.nm = c("disp","hp","drat","wt","qsec"),
   center = FALSE, scale = TRUE)
centers(data = mtcars, vrb.nm = c("disp","hp","drat","wt","qsec"),
   scale = TRUE, suffix = "_std")
}
\seealso{
\code{\link{center}}
   \code{\link{centers_by}}
   \code{\link{center_by}}
   \code{\link{scale.default}}
}
